/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementCollector
extends RDFHandlerBase {
    private Collection<Statement> statements;
    private Map<String, String> namespaces;

    public StatementCollector() {
        this(new ArrayList<Statement>());
    }

    public StatementCollector(Collection<Statement> statements) {
        this(statements, new LinkedHashMap<String, String>());
    }

    public StatementCollector(Collection<Statement> statements, Map<String, String> namespaces) {
        this.statements = statements;
        this.namespaces = namespaces;
    }

    public void clear() {
        this.statements.clear();
    }

    public Collection<Statement> getStatements() {
        return this.statements;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        if (!this.namespaces.containsKey(prefix)) {
            this.namespaces.put(prefix, uri);
        }
    }

    @Override
    public void handleStatement(Statement st) {
        this.statements.add(st);
    }
}

