/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import org.openrdf.model.Value;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.ValueExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Var
extends QueryModelNodeBase
implements ValueExpr {
    private String name;
    private Value value;
    private boolean anonymous = false;

    public Var() {
    }

    public Var(String name) {
        this.setName(name);
    }

    public Var(String name, Value value) {
        this(name);
        this.setValue(value);
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    public boolean equals(Object other) {
        if (other instanceof Var) {
            return this.name.equals(((Var)other).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(super.getSignature());
        sb.append(" (name=").append(this.name);
        if (this.value != null) {
            sb.append(", value=").append(this.value.toString());
        }
        if (this.anonymous) {
            sb.append(", anonymous");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Var clone() {
        return (Var)super.clone();
    }
}

