/*
 * Copyright (c) 2006 Jean-François Wauthy (pollux@xfce.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>

#include <libxfprint/job.h>

void
job_free (Job * job)
{
  if (!job)
    return;

  g_free (job->name);
  g_free (job->user);
  g_free (job->creation_time);
  g_free (job->processing_time);
}

static void
jobs_free_foreach (Job * job, gpointer data)
{
  job_free (job);
}

void
jobs_free (GList * jobs)
{
  g_list_foreach (jobs, (GFunc) jobs_free_foreach, NULL);
  g_list_free (jobs);
}
