/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import org.openrdf.sail.rdbms.schema.BNodeTable;
import org.openrdf.sail.rdbms.schema.Batch;
import org.openrdf.sail.rdbms.schema.HashTable;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.openrdf.sail.rdbms.schema.LiteralTable;
import org.openrdf.sail.rdbms.schema.NamespacesTable;
import org.openrdf.sail.rdbms.schema.RdbmsTable;
import org.openrdf.sail.rdbms.schema.TableFactory;
import org.openrdf.sail.rdbms.schema.TripleTable;
import org.openrdf.sail.rdbms.schema.URITable;
import org.openrdf.sail.rdbms.schema.ValueTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueTableFactory {
    private static final int VCS = 127;
    private static final int VCL = 255;
    public static final boolean INDEX_VALUES = false;
    protected static final String LANGUAGES = "LANGUAGES";
    protected static final String NAMESPACES = "NAMESPACE_PREFIXES";
    protected static final String RESOURCES = "RESOURCES";
    protected static final String BNODE_VALUES = "BNODE_VALUES";
    protected static final String URI_VALUES = "URI_VALUES";
    protected static final String LURI_VALUES = "LONG_URI_VALUES";
    protected static final String LBS = "LABEL_VALUES";
    protected static final String LLBS = "LONG_LABEL_VALUES";
    protected static final String LANGS = "LANGUAGE_VALUES";
    protected static final String DTS = "DATATYPE_VALUES";
    protected static final String NUM_VALUES = "NUMERIC_VALUES";
    protected static final String TIMES = "DATETIME_VALUES";
    protected static final String HASH_TABLE = "HASH_VALUES";
    private TableFactory factory;
    private IdSequence ids;
    private boolean sequenced;

    public ValueTableFactory(TableFactory factory) {
        this.factory = factory;
    }

    public void setIdSequence(IdSequence ids) {
        this.ids = ids;
    }

    public void setSequenced(boolean sequenced) {
        this.sequenced = sequenced;
    }

    public HashTable createHashTable(Connection conn, BlockingQueue<Batch> queue) throws SQLException {
        ValueTable table = this.newValueTable();
        table.setRdbmsTable(this.createTable(conn, HASH_TABLE));
        this.initValueTable(table, queue, -5, -1, true);
        HashTable hashTable = this.newHashtable(table);
        hashTable.init();
        return hashTable;
    }

    public NamespacesTable createNamespacesTable(Connection conn) {
        return new NamespacesTable(this.createTable(conn, NAMESPACES));
    }

    public BNodeTable createBNodeTable(Connection conn, BlockingQueue<Batch> queue) throws SQLException {
        ValueTable table = this.createValueTable(conn, queue, BNODE_VALUES, 12, 127);
        return new BNodeTable(table);
    }

    public URITable createURITable(Connection conn, BlockingQueue<Batch> queue) throws SQLException {
        ValueTable shorter = this.createValueTable(conn, queue, URI_VALUES, 12, 255);
        ValueTable longer = this.createValueTable(conn, queue, LURI_VALUES, -1);
        return new URITable(shorter, longer);
    }

    public LiteralTable createLiteralTable(Connection conn, BlockingQueue<Batch> queue) throws SQLException {
        ValueTable lbs = this.createValueTable(conn, queue, LBS, 12, 255);
        ValueTable llbs = this.createValueTable(conn, queue, LLBS, -1);
        ValueTable lgs = this.createValueTable(conn, queue, LANGS, 12, 127);
        ValueTable dt = this.createValueTable(conn, queue, DTS, 12, 255);
        ValueTable num = this.createValueTable(conn, queue, NUM_VALUES, 8);
        ValueTable dateTime = this.createValueTable(conn, queue, TIMES, -5);
        LiteralTable literals = new LiteralTable();
        literals.setLabelTable(lbs);
        literals.setLongLabelTable(llbs);
        literals.setLanguageTable(lgs);
        literals.setDatatypeTable(dt);
        literals.setNumericTable(num);
        literals.setDateTimeTable(dateTime);
        return literals;
    }

    public TripleTable createTripleTable(Connection conn, String tableName) {
        RdbmsTable table = this.createTable(conn, tableName);
        return new TripleTable(table);
    }

    protected RdbmsTable createTable(Connection conn, String name) {
        return this.factory.createTable(conn, name);
    }

    protected ValueTable createValueTable(Connection conn, BlockingQueue<Batch> queue, String name, int sqlType) throws SQLException {
        return this.createValueTable(conn, queue, name, sqlType, -1);
    }

    protected ValueTable createValueTable(Connection conn, BlockingQueue<Batch> queue, String name, int sqlType, int length) throws SQLException {
        ValueTable table = this.newValueTable();
        table.setRdbmsTable(this.createTable(conn, name));
        if (!this.sequenced) {
            table.setTemporaryTable(this.factory.createTemporaryTable(conn, "INSERT_" + name));
        }
        this.initValueTable(table, queue, sqlType, length, false);
        return table;
    }

    protected HashTable newHashtable(ValueTable table) {
        return new HashTable(table);
    }

    protected ValueTable newValueTable() {
        return new ValueTable();
    }

    private void initValueTable(ValueTable table, BlockingQueue<Batch> queue, int sqlType, int length, boolean indexValues) throws SQLException {
        table.setQueue(queue);
        table.setSqlType(sqlType);
        table.setIdType(this.ids.getJdbcIdType());
        table.setLength(length);
        table.setIndexingValues(indexValues);
        table.initialize();
    }
}

