/* This file is generated by python scripts. Don't edit this file directly.
 */

#ifndef ZHUYIN_TABLE_H
#define ZHUYIN_TABLE_H

namespace pinyin{

const zhuyin_symbol_item_t chewing_standard_symbols[] = {
{','  , "ㄝ"},
{'-'  , "ㄦ"},
{'.'  , "ㄡ"},
{'/'  , "ㄥ"},
{'0'  , "ㄢ"},
{'1'  , "ㄅ"},
{'2'  , "ㄉ"},
{'5'  , "ㄓ"},
{'8'  , "ㄚ"},
{'9'  , "ㄞ"},
{';'  , "ㄤ"},
{'a'  , "ㄇ"},
{'b'  , "ㄖ"},
{'c'  , "ㄏ"},
{'d'  , "ㄎ"},
{'e'  , "ㄍ"},
{'f'  , "ㄑ"},
{'g'  , "ㄕ"},
{'h'  , "ㄘ"},
{'i'  , "ㄛ"},
{'j'  , "ㄨ"},
{'k'  , "ㄜ"},
{'l'  , "ㄠ"},
{'m'  , "ㄩ"},
{'n'  , "ㄙ"},
{'o'  , "ㄟ"},
{'p'  , "ㄣ"},
{'q'  , "ㄆ"},
{'r'  , "ㄐ"},
{'s'  , "ㄋ"},
{'t'  , "ㄔ"},
{'u'  , "ㄧ"},
{'v'  , "ㄒ"},
{'w'  , "ㄊ"},
{'x'  , "ㄌ"},
{'y'  , "ㄗ"},
{'z'  , "ㄈ"},
{'\0', NULL}
};

const zhuyin_tone_item_t chewing_standard_tones[] = {
{' '  , 1},
{'3'  , 3},
{'4'  , 4},
{'6'  , 2},
{'7'  , 5},
{'\0', 0}
};

const zhuyin_symbol_item_t chewing_ginyieh_symbols[] = {
{'\'' , "ㄥ"},
{','  , "ㄚ"},
{'-'  , "ㄣ"},
{'.'  , "ㄞ"},
{'/'  , "ㄢ"},
{'0'  , "ㄟ"},
{'2'  , "ㄅ"},
{'3'  , "ㄉ"},
{'6'  , "ㄓ"},
{'8'  , "ㄧ"},
{'9'  , "ㄛ"},
{';'  , "ㄡ"},
{'='  , "ㄦ"},
{'['  , "ㄤ"},
{'b'  , "ㄒ"},
{'c'  , "ㄌ"},
{'d'  , "ㄋ"},
{'e'  , "ㄊ"},
{'f'  , "ㄎ"},
{'g'  , "ㄑ"},
{'h'  , "ㄕ"},
{'i'  , "ㄨ"},
{'j'  , "ㄘ"},
{'k'  , "ㄩ"},
{'l'  , "ㄝ"},
{'m'  , "ㄙ"},
{'n'  , "ㄖ"},
{'o'  , "ㄜ"},
{'p'  , "ㄠ"},
{'r'  , "ㄍ"},
{'s'  , "ㄇ"},
{'t'  , "ㄐ"},
{'u'  , "ㄗ"},
{'v'  , "ㄏ"},
{'w'  , "ㄆ"},
{'x'  , "ㄈ"},
{'y'  , "ㄔ"},
{'\0', NULL}
};

const zhuyin_tone_item_t chewing_ginyieh_tones[] = {
{' '  , 1},
{'1'  , 5},
{'a'  , 3},
{'q'  , 2},
{'z'  , 4},
{'\0', 0}
};

const zhuyin_symbol_item_t chewing_eten_symbols[] = {
{'\'' , "ㄘ"},
{','  , "ㄓ"},
{'-'  , "ㄥ"},
{'.'  , "ㄔ"},
{'/'  , "ㄕ"},
{'0'  , "ㄤ"},
{'7'  , "ㄑ"},
{'8'  , "ㄢ"},
{'9'  , "ㄣ"},
{';'  , "ㄗ"},
{'='  , "ㄦ"},
{'a'  , "ㄚ"},
{'b'  , "ㄅ"},
{'c'  , "ㄒ"},
{'d'  , "ㄉ"},
{'e'  , "ㄧ"},
{'f'  , "ㄈ"},
{'g'  , "ㄐ"},
{'h'  , "ㄏ"},
{'i'  , "ㄞ"},
{'j'  , "ㄖ"},
{'k'  , "ㄎ"},
{'l'  , "ㄌ"},
{'m'  , "ㄇ"},
{'n'  , "ㄋ"},
{'o'  , "ㄛ"},
{'p'  , "ㄆ"},
{'q'  , "ㄟ"},
{'r'  , "ㄜ"},
{'s'  , "ㄙ"},
{'t'  , "ㄊ"},
{'u'  , "ㄩ"},
{'v'  , "ㄍ"},
{'w'  , "ㄝ"},
{'x'  , "ㄨ"},
{'y'  , "ㄡ"},
{'z'  , "ㄠ"},
{'\0', NULL}
};

const zhuyin_tone_item_t chewing_eten_tones[] = {
{' '  , 1},
{'1'  , 5},
{'2'  , 2},
{'3'  , 3},
{'4'  , 4},
{'\0', 0}
};

const zhuyin_symbol_item_t chewing_ibm_symbols[] = {
{'-'  , "ㄏ"},
{'0'  , "ㄎ"},
{'1'  , "ㄅ"},
{'2'  , "ㄆ"},
{'3'  , "ㄇ"},
{'4'  , "ㄈ"},
{'5'  , "ㄉ"},
{'6'  , "ㄊ"},
{'7'  , "ㄋ"},
{'8'  , "ㄌ"},
{'9'  , "ㄍ"},
{';'  , "ㄠ"},
{'a'  , "ㄧ"},
{'b'  , "ㄥ"},
{'c'  , "ㄣ"},
{'d'  , "ㄩ"},
{'e'  , "ㄒ"},
{'f'  , "ㄚ"},
{'g'  , "ㄛ"},
{'h'  , "ㄜ"},
{'i'  , "ㄗ"},
{'j'  , "ㄝ"},
{'k'  , "ㄞ"},
{'l'  , "ㄟ"},
{'n'  , "ㄦ"},
{'o'  , "ㄘ"},
{'p'  , "ㄙ"},
{'q'  , "ㄐ"},
{'r'  , "ㄓ"},
{'s'  , "ㄨ"},
{'t'  , "ㄔ"},
{'u'  , "ㄖ"},
{'v'  , "ㄤ"},
{'w'  , "ㄑ"},
{'x'  , "ㄢ"},
{'y'  , "ㄕ"},
{'z'  , "ㄡ"},
{'\0', NULL}
};

const zhuyin_tone_item_t chewing_ibm_tones[] = {
{' '  , 1},
{','  , 3},
{'.'  , 4},
{'/'  , 5},
{'m'  , 2},
{'\0', 0}
};

const zhuyin_symbol_item_t chewing_hsu_initials[] = {
{'a'  , "ㄘ"},
{'b'  , "ㄅ"},
{'c'  , "ㄒ"},
{'c'  , "ㄕ"},
{'d'  , "ㄉ"},
{'f'  , "ㄈ"},
{'g'  , "ㄍ"},
{'h'  , "ㄏ"},
{'j'  , "ㄐ"},
{'j'  , "ㄓ"},
{'k'  , "ㄎ"},
{'l'  , "ㄌ"},
{'m'  , "ㄇ"},
{'n'  , "ㄋ"},
{'p'  , "ㄆ"},
{'r'  , "ㄖ"},
{'s'  , "ㄙ"},
{'t'  , "ㄊ"},
{'v'  , "ㄑ"},
{'v'  , "ㄔ"},
{'z'  , "ㄗ"},
{'\0', NULL}
};

const zhuyin_symbol_item_t chewing_hsu_middles[] = {
{'e'  , "ㄧ"},
{'u'  , "ㄩ"},
{'x'  , "ㄨ"},
{'\0', NULL}
};

const zhuyin_symbol_item_t chewing_hsu_finals[] = {
{'a'  , "ㄟ"},
{'e'  , "ㄝ"},
{'g'  , "ㄜ"},
{'h'  , "ㄛ"},
{'i'  , "ㄞ"},
{'k'  , "ㄤ"},
{'l'  , "ㄥ"},
{'l'  , "ㄦ"},
{'m'  , "ㄢ"},
{'n'  , "ㄣ"},
{'o'  , "ㄡ"},
{'w'  , "ㄠ"},
{'y'  , "ㄚ"},
{'\0', NULL}
};

const zhuyin_tone_item_t chewing_hsu_tones[] = {
{' '  , 1},
{'d'  , 2},
{'f'  , 3},
{'j'  , 4},
{'s'  , 5},
{'\0', 0}
};

const zhuyin_symbol_item_t chewing_eten26_initials[] = {
{'b'  , "ㄅ"},
{'c'  , "ㄒ"},
{'c'  , "ㄕ"},
{'d'  , "ㄉ"},
{'f'  , "ㄈ"},
{'g'  , "ㄐ"},
{'g'  , "ㄓ"},
{'h'  , "ㄏ"},
{'j'  , "ㄖ"},
{'k'  , "ㄎ"},
{'l'  , "ㄌ"},
{'m'  , "ㄇ"},
{'n'  , "ㄋ"},
{'p'  , "ㄆ"},
{'q'  , "ㄗ"},
{'s'  , "ㄙ"},
{'t'  , "ㄊ"},
{'v'  , "ㄍ"},
{'v'  , "ㄑ"},
{'w'  , "ㄘ"},
{'y'  , "ㄔ"},
{'\0', NULL}
};

const zhuyin_symbol_item_t chewing_eten26_middles[] = {
{'e'  , "ㄧ"},
{'u'  , "ㄩ"},
{'x'  , "ㄨ"},
{'\0', NULL}
};

const zhuyin_symbol_item_t chewing_eten26_finals[] = {
{'a'  , "ㄚ"},
{'h'  , "ㄦ"},
{'i'  , "ㄞ"},
{'l'  , "ㄥ"},
{'m'  , "ㄢ"},
{'n'  , "ㄣ"},
{'o'  , "ㄛ"},
{'p'  , "ㄡ"},
{'q'  , "ㄟ"},
{'r'  , "ㄜ"},
{'t'  , "ㄤ"},
{'w'  , "ㄝ"},
{'z'  , "ㄠ"},
{'\0', NULL}
};

const zhuyin_tone_item_t chewing_eten26_tones[] = {
{' '  , 1},
{'d'  , 5},
{'f'  , 2},
{'j'  , 3},
{'k'  , 4},
{'\0', 0}
};

const zhuyin_symbol_item_t chewing_standard_dvorak_symbols[] = {
{'\'' , "ㄆ"},
{','  , "ㄊ"},
{'.'  , "ㄍ"},
{'0'  , "ㄢ"},
{'1'  , "ㄅ"},
{'2'  , "ㄉ"},
{'5'  , "ㄓ"},
{'8'  , "ㄚ"},
{'9'  , "ㄞ"},
{';'  , "ㄈ"},
{'['  , "ㄦ"},
{'a'  , "ㄇ"},
{'b'  , "ㄙ"},
{'c'  , "ㄛ"},
{'d'  , "ㄘ"},
{'e'  , "ㄎ"},
{'f'  , "ㄗ"},
{'g'  , "ㄧ"},
{'h'  , "ㄨ"},
{'i'  , "ㄕ"},
{'j'  , "ㄏ"},
{'k'  , "ㄒ"},
{'l'  , "ㄣ"},
{'m'  , "ㄩ"},
{'n'  , "ㄠ"},
{'o'  , "ㄋ"},
{'p'  , "ㄐ"},
{'q'  , "ㄌ"},
{'r'  , "ㄟ"},
{'s'  , "ㄤ"},
{'t'  , "ㄜ"},
{'u'  , "ㄑ"},
{'v'  , "ㄡ"},
{'w'  , "ㄝ"},
{'x'  , "ㄖ"},
{'y'  , "ㄔ"},
{'z'  , "ㄥ"},
{'\0', NULL}
};

const zhuyin_tone_item_t chewing_standard_dvorak_tones[] = {
{' '  , 1},
{'3'  , 3},
{'4'  , 4},
{'6'  , 2},
{'7'  , 5},
{'\0', 0}
};

const zhuyin_symbol_item_t chewing_hsu_dvorak_initials[] = {
{'a'  , "ㄘ"},
{'b'  , "ㄅ"},
{'c'  , "ㄒ"},
{'c'  , "ㄕ"},
{'d'  , "ㄉ"},
{'f'  , "ㄈ"},
{'g'  , "ㄍ"},
{'h'  , "ㄏ"},
{'j'  , "ㄐ"},
{'j'  , "ㄓ"},
{'k'  , "ㄎ"},
{'l'  , "ㄌ"},
{'m'  , "ㄇ"},
{'n'  , "ㄋ"},
{'p'  , "ㄆ"},
{'r'  , "ㄖ"},
{'s'  , "ㄙ"},
{'t'  , "ㄊ"},
{'v'  , "ㄑ"},
{'v'  , "ㄔ"},
{'z'  , "ㄗ"},
{'\0', NULL}
};

const zhuyin_symbol_item_t chewing_hsu_dvorak_middles[] = {
{'e'  , "ㄧ"},
{'u'  , "ㄩ"},
{'x'  , "ㄨ"},
{'\0', NULL}
};

const zhuyin_symbol_item_t chewing_hsu_dvorak_finals[] = {
{'a'  , "ㄟ"},
{'e'  , "ㄝ"},
{'g'  , "ㄜ"},
{'h'  , "ㄛ"},
{'i'  , "ㄞ"},
{'k'  , "ㄤ"},
{'l'  , "ㄥ"},
{'l'  , "ㄦ"},
{'m'  , "ㄢ"},
{'n'  , "ㄣ"},
{'o'  , "ㄡ"},
{'w'  , "ㄠ"},
{'y'  , "ㄚ"},
{'\0', NULL}
};

const zhuyin_tone_item_t chewing_hsu_dvorak_tones[] = {
{' '  , 1},
{'d'  , 2},
{'f'  , 3},
{'j'  , 4},
{'s'  , 5},
{'\0', 0}
};

const zhuyin_symbol_item_t chewing_dachen_cp26_initials[] = {
{'a'  , "ㄇ"},
{'b'  , "ㄖ"},
{'c'  , "ㄏ"},
{'d'  , "ㄎ"},
{'e'  , "ㄍ"},
{'f'  , "ㄑ"},
{'g'  , "ㄕ"},
{'h'  , "ㄘ"},
{'n'  , "ㄙ"},
{'q'  , "ㄅ"},
{'q'  , "ㄆ"},
{'r'  , "ㄐ"},
{'s'  , "ㄋ"},
{'t'  , "ㄓ"},
{'t'  , "ㄔ"},
{'v'  , "ㄒ"},
{'w'  , "ㄉ"},
{'w'  , "ㄊ"},
{'x'  , "ㄌ"},
{'y'  , "ㄗ"},
{'z'  , "ㄈ"},
{'\0', NULL}
};

const zhuyin_symbol_item_t chewing_dachen_cp26_middles[] = {
{'j'  , "ㄨ"},
{'m'  , "ㄩ"},
{'u'  , "ㄧ"},
{'\0', NULL}
};

const zhuyin_symbol_item_t chewing_dachen_cp26_finals[] = {
{'b'  , "ㄝ"},
{'i'  , "ㄛ"},
{'i'  , "ㄞ"},
{'k'  , "ㄜ"},
{'l'  , "ㄠ"},
{'l'  , "ㄤ"},
{'m'  , "ㄡ"},
{'n'  , "ㄥ"},
{'o'  , "ㄟ"},
{'o'  , "ㄢ"},
{'p'  , "ㄣ"},
{'p'  , "ㄦ"},
{'u'  , "ㄚ"},
{'\0', NULL}
};

const zhuyin_tone_item_t chewing_dachen_cp26_tones[] = {
{' '  , 1},
{'d'  , 4},
{'e'  , 2},
{'r'  , 3},
{'y'  , 5},
{'\0', 0}
};

const bool valid_zhuyin_table[CHEWING_NUMBER_OF_INITIALS *
                              CHEWING_NUMBER_OF_MIDDLES *
                              CHEWING_NUMBER_OF_FINALS *
                              CHEWING_NUMBER_OF_TONES] = {
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_ZERO_MIDDLE, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄞ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄜ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄟ */
TRUE,
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ㄣ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄥ */
TRUE,
TRUE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄦ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄫ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_ZERO_MIDDLE, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZERO_INITIAL, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄅ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄅㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄅㄞ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄅㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄅㄤ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄅㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_ZERO_MIDDLE, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄅㄟ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
/* ㄅㄣ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄅㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄅㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_B, CHEWING_ZERO_MIDDLE, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_ZERO_MIDDLE, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄅㄧㄣ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄅㄧㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄅㄧ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄅㄧㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄅㄧㄠ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄅㄧㄝ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄅㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_B, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄘ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄘㄚ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄘㄞ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄘㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄘㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄘㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄘㄜ */
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_ZERO_MIDDLE, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄘㄣ */
TRUE,
TRUE,
TRUE,
FALSE,
FALSE,
FALSE,
/* ㄘㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄘㄨㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄘㄡ */
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄘ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄘㄨ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄘㄨㄢ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄘㄨㄟ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄘㄨㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄘㄨㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_C, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄔ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄔㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄔㄞ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄔㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄔㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄔㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄔㄜ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_ZERO_MIDDLE, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄔㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄔㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄔㄨㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄔㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄔ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄔㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄔㄨㄚ */
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
/* ㄔㄨㄞ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄔㄨㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄔㄨㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄔㄨㄟ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ㄔㄨㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄔㄨㄛ */
TRUE,
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_CH, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄉㄞ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄉㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄉㄤ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
/* ㄉㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄉㄜ */
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
TRUE,
/* ChewingKey(CHEWING_D, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉㄟ */
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
FALSE,
/* ㄉㄣ */
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ㄉㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉㄨㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄉㄡ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄉㄧㄣ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉㄧㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄉㄧ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄉㄧㄚ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉㄧㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉㄧㄠ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄉㄧㄝ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_D, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉㄧㄡ */
TRUE,
TRUE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_D, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉㄨㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉㄨㄟ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄉㄨㄣ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄉㄨㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_D, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_D, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄈ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄈㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_ZERO_MIDDLE, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄈㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄈㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_F, CHEWING_ZERO_MIDDLE, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄈㄜ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄈㄟ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄈㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄈㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄈㄛ */
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_ZERO_MIDDLE, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄈㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄈㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_F, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄏ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄏㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ㄏㄞ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄏㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄏㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄏㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄏㄜ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄏㄟ */
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
/* ㄏㄣ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄏㄥ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_H, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄏㄨㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄏㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_H, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄏㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄏㄨㄚ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ㄏㄨㄞ */
TRUE,
FALSE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ㄏㄨㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄏㄨㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_H, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄏㄨㄟ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄏㄨㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄏㄨㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_H, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_H, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄍ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄍㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄍㄞ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄍㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄍㄤ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄍㄠ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄍㄜ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_G, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄍㄟ */
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
FALSE,
/* ㄍㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄍㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄍㄨㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
/* ㄍㄡ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄍㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄍㄨㄚ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄍㄨㄞ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄍㄨㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄍㄨㄤ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄍㄨㄟ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄍㄨㄣ */
TRUE,
FALSE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄍㄨㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_G, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_G, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄎ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄎㄚ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄎㄞ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄎㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄎㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄎㄠ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄎㄜ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄎㄟ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄎㄣ */
TRUE,
FALSE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄎㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄎㄨㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄎㄡ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄎㄨ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄎㄨㄚ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄎㄨㄞ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄎㄨㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
/* ㄎㄨㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄎㄨㄟ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄎㄨㄣ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄎㄨㄛ */
TRUE,
FALSE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_K, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄐ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_ZERO_MIDDLE, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄐㄧㄣ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄐㄧㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄐㄧ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄐㄧㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_J, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄐㄧㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄐㄧㄤ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄐㄧㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄐㄧㄝ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_J, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄐㄩㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄐㄧㄡ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_J, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄐㄩ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄐㄩㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄐㄩㄝ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄐㄩㄣ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_J, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄇ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄇㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄇㄞ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄇㄢ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄇㄤ */
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ㄇㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄇㄜ */
TRUE,
FALSE,
FALSE,
FALSE,
FALSE,
TRUE,
/* ChewingKey(CHEWING_M, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄇㄟ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄇㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄇㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄇㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_M, CHEWING_ZERO_MIDDLE, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄇㄡ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄇㄧㄣ */
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ㄇㄧㄥ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄇㄧ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄇㄧㄢ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄇㄧㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄇㄧㄝ */
TRUE,
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄇㄧㄡ */
TRUE,
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄇㄨ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_M, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋㄚ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄋㄞ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄋㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄋㄤ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄋㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄋㄜ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_N, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋㄟ */
TRUE,
FALSE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄋㄣ */
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ㄋㄥ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋㄨㄥ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄋㄡ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄋㄧㄣ */
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ㄋㄧㄥ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄋㄧ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄋㄧㄚ */
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋㄧㄢ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄋㄧㄤ */
TRUE,
FALSE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ㄋㄧㄠ */
TRUE,
FALSE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄋㄧㄝ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋㄧㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋㄨ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋㄨㄢ */
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋㄨㄣ */
TRUE,
FALSE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋㄨㄛ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋㄩ */
TRUE,
FALSE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄋㄩㄝ */
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_N, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄌㄞ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄌㄢ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄌㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄌㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄌㄜ */
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_L, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄟ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄌㄣ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄥ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄛ */
TRUE,
FALSE,
FALSE,
FALSE,
FALSE,
TRUE,
/* ㄌㄨㄥ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄌㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄌㄧㄣ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄌㄧㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄌㄧ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄌㄧㄚ */
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄧㄢ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄌㄧㄤ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄌㄧㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄌㄧㄝ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄧㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_L, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_L, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄨㄢ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄨㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄨㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄩ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄌㄩㄝ */
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_L, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄖ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_ZERO_MIDDLE, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_ZERO_MIDDLE, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄖㄢ */
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ㄖㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄖㄠ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄖㄜ */
TRUE,
FALSE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_ZERO_MIDDLE, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄖㄣ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄖㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄖㄨㄥ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄖㄡ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄖ */
TRUE,
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄖㄨ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄖㄨㄚ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄖㄨㄢ */
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄖㄨㄟ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄖㄨㄣ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄖㄨㄛ */
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_R, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄆ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄆㄚ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
/* ㄆㄞ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄆㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄆㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄆㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_ZERO_MIDDLE, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄆㄟ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄆㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄆㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄆㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_ZERO_MIDDLE, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄆㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ㄆㄧㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄆㄧㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄆㄧ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄆㄧㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄆㄧㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄆㄧㄝ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄆㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_P, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄑ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_ZERO_MIDDLE, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄑㄧㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄑㄧㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄑㄧ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄑㄧㄚ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄑㄧㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄑㄧㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄑㄧㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄑㄧㄝ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄑㄩㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ㄑㄧㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄑㄩ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_Q, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄑㄩㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄑㄩㄝ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄑㄩㄣ */
TRUE,
TRUE,
TRUE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Q, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄙ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄙㄚ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
/* ㄙㄞ */
TRUE,
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ㄙㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄙㄤ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄙㄠ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄙㄜ */
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_ZERO_MIDDLE, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄙㄣ */
TRUE,
TRUE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄙㄥ */
TRUE,
TRUE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄙㄨㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄙㄡ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄙ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄙㄨ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄙㄨㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄙㄨㄟ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄙㄨㄣ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄙㄨㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_S, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_S, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄕ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄕㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄕㄞ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄕㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄕㄤ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
/* ㄕㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄕㄜ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄕㄟ */
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
FALSE,
/* ㄕㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄕㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_ZERO_MIDDLE, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄕㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄕ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄕㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄕㄨㄚ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄕㄨㄞ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄕㄨㄢ */
TRUE,
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ㄕㄨㄤ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄕㄨㄟ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄕㄨㄣ */
TRUE,
FALSE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄕㄨㄛ */
TRUE,
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_SH, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄊ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄊㄚ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
/* ㄊㄞ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ㄊㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄊㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄊㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄊㄜ */
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_ZERO_MIDDLE, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_ZERO_MIDDLE, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄊㄥ */
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄊㄨㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄊㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_T, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄊㄧㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄊㄧ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄊㄧㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄊㄧㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄊㄧㄝ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄊㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄊㄨㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄊㄨㄟ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄊㄨㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄊㄨㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_T, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* PINYIN_W */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄨㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄨㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄨㄞ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄨㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄨㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄨㄟ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄨㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄨㄛ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_W, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄒ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_ZERO_MIDDLE, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄒㄧㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄒㄧㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄒㄧ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄒㄧㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄒㄧㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄒㄧㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄒㄧㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄒㄧㄝ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_X, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄒㄩㄥ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ㄒㄧㄡ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄒㄩ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄒㄩㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄒㄩㄝ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄒㄩㄣ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_X, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* PINYIN_Y */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_ZERO_MIDDLE, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄧㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄧㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄧ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄧㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄧㄞ */
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
FALSE,
/* ㄧㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄧㄤ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄧㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄧㄝ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(PINYIN_Y, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄧㄛ */
TRUE,
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
/* ㄩㄥ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄧㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄩ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄩㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄩㄝ */
TRUE,
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄩㄣ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(PINYIN_Y, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄗ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄗㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
FALSE,
/* ㄗㄞ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
/* ㄗㄢ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄗㄤ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄗㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄗㄜ */
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄗㄟ */
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
FALSE,
/* ㄗㄣ */
TRUE,
FALSE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄗㄥ */
TRUE,
TRUE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄗㄨㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄗㄡ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄗ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄗㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄗㄨㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄗㄨㄟ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄗㄨㄣ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄗㄨㄛ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_Z, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄓ */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄓㄚ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ㄓㄞ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄓㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄓㄤ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄓㄠ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄓㄜ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
/* ChewingKey(CHEWING_ZH, CHEWING_ZERO_MIDDLE, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄓㄟ */
TRUE,
FALSE,
FALSE,
FALSE,
TRUE,
FALSE,
/* ㄓㄣ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄓㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_ZERO_MIDDLE, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_ZERO_MIDDLE, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_ZERO_MIDDLE, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄓㄨㄥ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄓㄡ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_ZERO_MIDDLE, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_ZERO_MIDDLE, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄓ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_I, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄓㄨ */
TRUE,
TRUE,
TRUE,
TRUE,
TRUE,
FALSE,
/* ㄓㄨㄚ */
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
FALSE,
/* ㄓㄨㄞ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄓㄨㄢ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄓㄨㄤ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_U, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_U, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_U, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄓㄨㄟ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ㄓㄨㄣ */
TRUE,
TRUE,
FALSE,
TRUE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_U, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_U, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_U, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ㄓㄨㄛ */
TRUE,
TRUE,
TRUE,
FALSE,
TRUE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_U, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_U, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_U, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_U, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_ZERO_FINAL) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_A) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_AI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_AN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_ANG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_AO) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_E) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, INVALID_EA) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_EI) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_EN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_ENG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_ER) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_NG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_O) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, PINYIN_ONG) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, CHEWING_OU) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, PINYIN_IN) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
/* ChewingKey(CHEWING_ZH, CHEWING_V, PINYIN_ING) */
FALSE,
FALSE,
FALSE,
FALSE,
FALSE,
FALSE
};

static const char * chewing_tone_table[CHEWING_NUMBER_OF_TONES] = {
"",
" ",
"ˊ",
"ˇ",
"ˋ",
"˙"
};

};

#endif
