#!/bin/sh
# Copyright (C) 2002, 2005  Slackware Linux, Inc.
# Copyright 2005, 2006  Patrick J. Volkerding, Sebeka, Minnesota, USA
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Swap glibc on the fly.
#
# If we're on a running system we have to handle this _very_ carefully.  :-)
# The tricks involved here get trickier every time...

# OK, now we have to be sure of a few things.  First, you do have a 2.6
# kernel running, right?

if [ -r /proc/ksyms ]; then
  echo "FATAL: you need to be running a 2.6.x kernel in order to upgrade"
  echo "to this version of glibc."
  echo
  sleep 999
  exit 1
fi

# Next, stop using the /lib/ntpl libraries.  These are now obsolete and
# will break the installation if present:
if [ -d lib/tls ]; then
  mkdir -p lib/obsolete
  mv lib/tls lib/obsolete
fi
if [ -x sbin/ldconfig ]; then
  sbin/ldconfig -r .
fi

# Install NPTL glibc libraries:
if [ -x /sbin/ldconfig -a -d lib/incoming ]; then # swap on the fly
  # First create copies of the incoming libraries:
  ( cd lib/incoming
    for file in * ; do
      if [ ! -r ../${file}.incoming ]; then
        cp -a $file ../${file}.incoming
      fi
    done
  )
  # Then switch to them all at once:
  /sbin/ldconfig -l lib/*.incoming 2> /dev/null
  # Finally, rename them and clean up:
  ( cd lib
    for file in *.incoming ; do
      rm -f `basename $file .incoming`
      cp -a $file `basename $file .incoming`
      /sbin/ldconfig -l `basename $file .incoming`
      rm -f $file
    done
  )
else # no ldconfig?  Good, it's safe to just jam it on home (and make links below):
  ( cd lib/incoming
    for file in * ; do
      cp -a $file ..
    done
  )
fi
# Now, get rid of the temporary directory:
rm -rf lib/incoming
# Done installing NPTL glibc libraries.

# Handle config files:
config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/profile.d/glibc.csh.new
config etc/profile.d/glibc.sh.new
# Clearly you already decided this issue.  :-)
rm -f etc/profile.d/glibc.csh.new
rm -f etc/profile.d/glibc.sh.new

# In case there's no ldconfig, make the links manually:
if [ ! -x /sbin/ldconfig ]; then
( cd lib ; rm -rf libnss_nis.so.2 )
( cd lib ; ln -sf libnss_nis-2.11.1.so libnss_nis.so.2 )
( cd lib ; rm -rf libm.so.6 )
( cd lib ; ln -sf libm-2.11.1.so libm.so.6 )
( cd lib ; rm -rf libnss_files.so.2 )
( cd lib ; ln -sf libnss_files-2.11.1.so libnss_files.so.2 )
( cd lib ; rm -rf libresolv.so.2 )
( cd lib ; ln -sf libresolv-2.11.1.so libresolv.so.2 )
( cd lib ; rm -rf libnsl.so.1 )
( cd lib ; ln -sf libnsl-2.11.1.so libnsl.so.1 )
( cd lib ; rm -rf libutil.so.1 )
( cd lib ; ln -sf libutil-2.11.1.so libutil.so.1 )
( cd lib ; rm -rf libnss_compat.so.2 )
( cd lib ; ln -sf libnss_compat-2.11.1.so libnss_compat.so.2 )
( cd lib ; rm -rf libthread_db.so.1 )
( cd lib ; ln -sf libthread_db-1.0.so libthread_db.so.1 )
( cd lib ; rm -rf libnss_hesiod.so.2 )
( cd lib ; ln -sf libnss_hesiod-2.11.1.so libnss_hesiod.so.2 )
( cd lib ; rm -rf libanl.so.1 )
( cd lib ; ln -sf libanl-2.11.1.so libanl.so.1 )
( cd lib ; rm -rf libcrypt.so.1 )
( cd lib ; ln -sf libcrypt-2.11.1.so libcrypt.so.1 )
( cd lib ; rm -rf libBrokenLocale.so.1 )
( cd lib ; ln -sf libBrokenLocale-2.11.1.so libBrokenLocale.so.1 )
( cd lib ; rm -rf ld-linux.so.2 )
( cd lib ; ln -sf ld-2.11.1.so ld-linux.so.2 )
( cd lib ; rm -rf libdl.so.2 )
( cd lib ; ln -sf libdl-2.11.1.so libdl.so.2 )
( cd lib ; rm -rf libnss_dns.so.2 )
( cd lib ; ln -sf libnss_dns-2.11.1.so libnss_dns.so.2 )
( cd lib ; rm -rf libpthread.so.0 )
( cd lib ; ln -sf libpthread-2.11.1.so libpthread.so.0 )
( cd lib ; rm -rf libnss_nisplus.so.2 )
( cd lib ; ln -sf libnss_nisplus-2.11.1.so libnss_nisplus.so.2 )
( cd lib ; rm -rf libc.so.6 )
( cd lib ; ln -sf libc-2.11.1.so libc.so.6 )
( cd lib ; rm -rf librt.so.1 )
( cd lib ; ln -sf librt-2.11.1.so librt.so.1 )
fi
