/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ClassLoaderReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeVisibleClasses(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in ClassLoaderReference Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    public void executeVisibleClasses(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oId = this.idMan.readObjectId(bb);
        ClassLoader cl = (ClassLoader)oId.getObject();
        ArrayList loadRequests = VMVirtualMachine.getLoadRequests(cl);
        os.writeInt(loadRequests.size());
        for (Class clazz : loadRequests) {
            ReferenceTypeId refId = this.idMan.getReferenceTypeId(clazz);
            refId.writeTagged(os);
        }
    }
}

