/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.math;

import gnu.classpath.Pointer;

public final class GMP {
    private Pointer native_ptr;
    private int refCount = 1;

    public GMP() {
        this.natInitialize();
    }

    private synchronized void acquireRef() {
        ++this.refCount;
    }

    private synchronized void releaseRef() {
        --this.refCount;
        if (this.refCount == 0) {
            this.natFinalize();
            this.native_ptr = null;
        }
    }

    protected void finalize() {
        this.releaseRef();
    }

    public void fromByteArray(byte[] v) {
        this.acquireRef();
        this.natFromByteArray(v);
        this.releaseRef();
    }

    public void fromBI(GMP x) {
        this.acquireRef();
        x.acquireRef();
        this.natFromBI(x.native_ptr);
        x.releaseRef();
        this.releaseRef();
    }

    public void fromLong(long n) {
        this.acquireRef();
        this.natFromLong(n);
        this.releaseRef();
    }

    public int fromString(String s, int rdx) {
        this.acquireRef();
        int result = this.natFromString(s, rdx);
        this.releaseRef();
        return result;
    }

    public void fromSignedMagnitude(byte[] m, boolean isNegative) {
        this.acquireRef();
        this.natFromSignedMagnitude(m, isNegative);
        this.releaseRef();
    }

    public String toString(int b) {
        this.acquireRef();
        String result = this.natToString(b);
        this.releaseRef();
        return result;
    }

    public void toByteArray(byte[] r) {
        this.acquireRef();
        this.natToByteArray(r);
        this.releaseRef();
    }

    public double doubleValue() {
        this.acquireRef();
        double result = this.natDoubleValue();
        this.releaseRef();
        return result;
    }

    public int absIntValue() {
        this.acquireRef();
        int result = this.natAbsIntValue();
        this.releaseRef();
        return result;
    }

    public int compare(GMP x) {
        this.acquireRef();
        x.acquireRef();
        int result = this.natCompare(x.native_ptr);
        x.releaseRef();
        this.releaseRef();
        return result;
    }

    public void add(GMP x, GMP r) {
        this.acquireRef();
        x.acquireRef();
        r.acquireRef();
        this.natAdd(x.native_ptr, r.native_ptr);
        r.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void subtract(GMP x, GMP r) {
        this.acquireRef();
        x.acquireRef();
        r.acquireRef();
        this.natSubtract(x.native_ptr, r.native_ptr);
        r.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void multiply(GMP x, GMP r) {
        this.acquireRef();
        x.acquireRef();
        r.acquireRef();
        this.natMultiply(x.native_ptr, r.native_ptr);
        r.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void quotient(GMP x, GMP r) {
        this.acquireRef();
        x.acquireRef();
        r.acquireRef();
        this.natQuotient(x.native_ptr, r.native_ptr);
        r.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void remainder(GMP x, GMP r) {
        this.acquireRef();
        x.acquireRef();
        r.acquireRef();
        this.natRemainder(x.native_ptr, r.native_ptr);
        r.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void quotientAndRemainder(GMP x, GMP q, GMP r) {
        this.acquireRef();
        x.acquireRef();
        q.acquireRef();
        r.acquireRef();
        this.natQuotientAndRemainder(x.native_ptr, q.native_ptr, r.native_ptr);
        r.releaseRef();
        q.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void modulo(GMP x, GMP r) {
        this.acquireRef();
        x.acquireRef();
        r.acquireRef();
        this.natModulo(x.native_ptr, r.native_ptr);
        r.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void pow(int n, GMP r) {
        this.acquireRef();
        r.acquireRef();
        this.natPow(n, r.native_ptr);
        r.releaseRef();
        this.releaseRef();
    }

    public void modPow(GMP e, GMP m, GMP r) {
        this.acquireRef();
        e.acquireRef();
        m.acquireRef();
        r.acquireRef();
        this.natModPow(e.native_ptr, m.native_ptr, r.native_ptr);
        r.releaseRef();
        m.releaseRef();
        e.releaseRef();
        this.releaseRef();
    }

    public void modInverse(GMP m, GMP r) {
        this.acquireRef();
        m.acquireRef();
        r.acquireRef();
        this.natModInverse(m.native_ptr, r.native_ptr);
        r.releaseRef();
        m.releaseRef();
        this.releaseRef();
    }

    public void gcd(GMP x, GMP r) {
        this.acquireRef();
        x.acquireRef();
        r.acquireRef();
        this.natGCD(x.native_ptr, r.native_ptr);
        r.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void shiftLeft(int n, GMP r) {
        this.acquireRef();
        r.acquireRef();
        this.natShiftLeft(n, r.native_ptr);
        r.releaseRef();
        this.releaseRef();
    }

    public void shiftRight(int n, GMP r) {
        this.acquireRef();
        r.acquireRef();
        this.natShiftRight(n, r.native_ptr);
        r.releaseRef();
        this.releaseRef();
    }

    public void abs(GMP r) {
        this.acquireRef();
        r.acquireRef();
        this.natAbs(r.native_ptr);
        r.releaseRef();
        this.releaseRef();
    }

    public void negate(GMP r) {
        this.acquireRef();
        r.acquireRef();
        this.natNegate(r.native_ptr);
        r.releaseRef();
        this.releaseRef();
    }

    public int bitLength() {
        this.acquireRef();
        int result = this.natBitLength();
        this.releaseRef();
        return result;
    }

    public int bitCount() {
        this.acquireRef();
        int result = this.natSetBitCount();
        this.releaseRef();
        return result;
    }

    public void and(GMP x, GMP r) {
        this.acquireRef();
        x.acquireRef();
        r.acquireRef();
        this.natAnd(x.native_ptr, r.native_ptr);
        r.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void or(GMP x, GMP r) {
        this.acquireRef();
        x.acquireRef();
        r.acquireRef();
        this.natOr(x.native_ptr, r.native_ptr);
        r.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void xor(GMP x, GMP r) {
        this.acquireRef();
        x.acquireRef();
        r.acquireRef();
        this.natXor(x.native_ptr, r.native_ptr);
        r.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void andNot(GMP x, GMP r) {
        this.acquireRef();
        x.acquireRef();
        r.acquireRef();
        this.natAndNot(x.native_ptr, r.native_ptr);
        r.releaseRef();
        x.releaseRef();
        this.releaseRef();
    }

    public void not(GMP r) {
        this.acquireRef();
        r.acquireRef();
        this.natNot(r.native_ptr);
        r.releaseRef();
        this.releaseRef();
    }

    public void flipBit(int n, GMP r) {
        this.acquireRef();
        r.acquireRef();
        this.natFlipBit(n, r.native_ptr);
        r.releaseRef();
        this.releaseRef();
    }

    public int testBit(int n) {
        this.acquireRef();
        int result = this.natTestBit(n);
        this.releaseRef();
        return result;
    }

    public void setBit(int n, boolean setIt, GMP r) {
        this.acquireRef();
        r.acquireRef();
        this.natSetBit(n, setIt, r.native_ptr);
        r.releaseRef();
        this.releaseRef();
    }

    public int testPrimality(int certainty) {
        this.acquireRef();
        int result = this.natTestPrimality(certainty);
        this.releaseRef();
        return result;
    }

    public int lowestSetBit() {
        this.acquireRef();
        int result = this.natLowestSetBit();
        this.releaseRef();
        return result;
    }

    public static native void natInitializeLibrary();

    private native void natInitialize();

    private native void natFinalize();

    private native void natFromLong(long var1);

    private native void natFromBI(Pointer var1);

    private native void natFromByteArray(byte[] var1);

    private native int natFromString(String var1, int var2);

    private native void natFromSignedMagnitude(byte[] var1, boolean var2);

    private native String natToString(int var1);

    private native void natToByteArray(byte[] var1);

    private native int natAbsIntValue();

    private native double natDoubleValue();

    private native int natCompare(Pointer var1);

    private native void natAdd(Pointer var1, Pointer var2);

    private native void natSubtract(Pointer var1, Pointer var2);

    private native void natMultiply(Pointer var1, Pointer var2);

    private native void natQuotient(Pointer var1, Pointer var2);

    private native void natRemainder(Pointer var1, Pointer var2);

    private native void natQuotientAndRemainder(Pointer var1, Pointer var2, Pointer var3);

    private native void natModulo(Pointer var1, Pointer var2);

    private native void natPow(int var1, Pointer var2);

    private native void natModPow(Pointer var1, Pointer var2, Pointer var3);

    private native void natModInverse(Pointer var1, Pointer var2);

    private native void natGCD(Pointer var1, Pointer var2);

    private native int natTestPrimality(int var1);

    private native void natShiftLeft(int var1, Pointer var2);

    private native void natShiftRight(int var1, Pointer var2);

    private native int natLowestSetBit();

    private native void natAbs(Pointer var1);

    private native void natNegate(Pointer var1);

    private native int natBitLength();

    private native int natSetBitCount();

    private native void natXor(Pointer var1, Pointer var2);

    private native void natOr(Pointer var1, Pointer var2);

    private native void natAnd(Pointer var1, Pointer var2);

    private native void natAndNot(Pointer var1, Pointer var2);

    private native void natFlipBit(int var1, Pointer var2);

    private native int natTestBit(int var1);

    private native void natSetBit(int var1, boolean var2, Pointer var3);

    private native void natNot(Pointer var1);
}

