/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.lang.CPStringBuilder;
import gnu.java.net.protocol.http.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;

public class ChunkedInputStream
extends InputStream {
    Headers headers;
    private InputStream in;
    int size;
    int count;
    boolean meta;
    boolean eof;

    public ChunkedInputStream(InputStream in, Headers headers) {
        this.in = in;
        this.headers = headers;
        this.size = -1;
        this.count = 0;
        this.meta = true;
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int len = this.read(buf, 0, 1);
        if (len == -1) {
            return -1;
        }
        return 0xFF & buf[0];
    }

    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.meta) {
            int c;
            int last = 0;
            boolean seenSemi = false;
            CPStringBuilder buf = new CPStringBuilder();
            do {
                if ((c = this.in.read()) == 59) {
                    seenSemi = true;
                } else {
                    if (c == 10 && last == 13) {
                        try {
                            this.size = Integer.parseInt(buf.toString(), 16);
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            IOException ioe = new IOException("Bad chunk header");
                            ioe.initCause(nfe);
                            this.in.close();
                            throw ioe;
                        }
                    }
                    if (!seenSemi && c >= 48) {
                        buf.append((char)c);
                    }
                }
                last = c;
            } while (c != -1);
            this.count = 0;
            this.meta = false;
        }
        if (this.size == 0) {
            this.headers.parse(this.in);
            this.eof = true;
            return -1;
        }
        int canRead = Math.min(this.size - this.count, length);
        int len = this.in.read(buffer, offset, canRead);
        if (len == -1) {
            this.eof = true;
            return -1;
        }
        this.count += len;
        if (this.count == this.size) {
            int c1 = this.in.read();
            int c2 = this.in.read();
            if (c1 == -1 || c2 == -1) {
                this.eof = true;
                return -1;
            }
            if (c1 != 13 || c2 != 10) {
                throw new ProtocolException("expecting CRLF: " + c1 + "," + c2);
            }
            this.meta = true;
        }
        return len;
    }

    public int available() throws IOException {
        if (this.meta) {
            return 0;
        }
        return Math.min(this.in.available(), this.size - this.count);
    }

    public void close() throws IOException {
        this.in.close();
    }
}

