/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.NIOServerSocket;
import gnu.java.nio.NIOSocket;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

public final class ServerSocketChannelImpl
extends ServerSocketChannel {
    private NIOServerSocket serverSocket = new NIOServerSocket(this);
    private boolean connected;

    protected ServerSocketChannelImpl(SelectorProvider provider) throws IOException {
        super(provider);
        this.configureBlocking(true);
    }

    public int getNativeFD() {
        return this.serverSocket.getPlainSocketImpl().getNativeFD();
    }

    public void finalizer() {
        if (this.connected) {
            try {
                this.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void implCloseSelectableChannel() throws IOException {
        this.connected = false;
        this.serverSocket.close();
    }

    protected void implConfigureBlocking(boolean blocking) throws IOException {
        this.serverSocket.setSoTimeout(blocking ? 0 : 50);
    }

    public SocketChannel accept() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.serverSocket.isBound()) {
            throw new NotYetBoundException();
        }
        boolean completed = false;
        try {
            this.begin();
            this.serverSocket.getPlainSocketImpl().setInChannelOperation(true);
            NIOSocket socket = (NIOSocket)this.serverSocket.accept();
            completed = true;
            SocketChannel socketChannel = socket.getChannel();
            return socketChannel;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return null;
        }
        finally {
            this.serverSocket.getPlainSocketImpl().setInChannelOperation(false);
            this.end(completed);
        }
    }

    public ServerSocket socket() {
        return this.serverSocket;
    }
}

