/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.UnicastConnection;
import java.util.ArrayList;
import java.util.Arrays;

class ConnectionRunnerPool {
    private static int size = 5;
    private static int max_size = 10;
    static ArrayList freelist;
    private static ThreadGroup group;

    static {
        group = new ThreadGroup("pool");
        ConnectionRunner[] pools = new ConnectionRunner[size];
        int i = 0;
        while (i < pools.length) {
            pools[i] = new ConnectionRunner(group, Integer.toString(i));
            pools[i].setContextClassLoader(Thread.currentThread().getContextClassLoader());
            pools[i].start();
            ++i;
        }
        freelist = new ArrayList(Arrays.asList(pools));
    }

    ConnectionRunnerPool() {
    }

    public static void setSize(int size_) {
        size = size_;
    }

    public static void setMaxSize(int size) {
        max_size = size;
    }

    /*
     * Unable to fully structure code
     */
    private static synchronized ConnectionRunner getConnectionRunner() {
        block3: {
            if (ConnectionRunnerPool.freelist.size() != 0) break block3;
            if (ConnectionRunnerPool.size >= ConnectionRunnerPool.max_size) ** GOTO lbl12
            a = new ConnectionRunner(ConnectionRunnerPool.group, Integer.toString(++ConnectionRunnerPool.size));
            a.start();
            ConnectionRunnerPool.freelist.add(a);
            break block3;
lbl-1000:
            // 1 sources

            {
                try {
                    ConnectionRunnerPool.class.wait();
                    continue;
                }
                catch (InterruptedException v0) {}
lbl12:
                // 3 sources

                ** while (ConnectionRunnerPool.freelist.size() == 0)
            }
        }
        a = (ConnectionRunner)ConnectionRunnerPool.freelist.get(0);
        ConnectionRunnerPool.freelist.remove(a);
        return a;
    }

    public static void dispatchConnection(UnicastConnection conn) {
        ConnectionRunner r = ConnectionRunnerPool.getConnectionRunner();
        r.dispatch(conn);
    }

    public static void exit() {
        Thread[] list2 = new Thread[group.activeCount()];
        group.enumerate(list2);
        int i = 0;
        while (i < list2.length) {
            ((ConnectionRunner)list2[i]).exit();
            ++i;
        }
    }

    public static class ConnectionRunner
    extends Thread {
        private UnicastConnection conn;
        private volatile boolean exiting = false;

        public ConnectionRunner(ThreadGroup group, String id) {
            super(group, id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public synchronized void run() {
            while (!this.exiting) {
                if (this.conn == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.conn.run();
                this.conn = null;
                Class<ConnectionRunnerPool> clazz = ConnectionRunnerPool.class;
                // MONITORENTER : gnu.java.rmi.server.ConnectionRunnerPool.class
                freelist.add(this);
                if (freelist.size() == 1) {
                    ConnectionRunnerPool.class.notifyAll();
                }
                // MONITOREXIT : clazz
            }
        }

        public synchronized void dispatch(UnicastConnection conn) {
            this.conn = conn;
            this.notify();
        }

        void exit() {
            this.exiting = true;
            if (this.conn != null) {
                try {
                    this.join(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.interrupt();
        }
    }
}

