/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import gnu.javax.imageio.bmp.EncodeRGB1;
import gnu.javax.imageio.bmp.EncodeRGB16;
import gnu.javax.imageio.bmp.EncodeRGB24;
import gnu.javax.imageio.bmp.EncodeRGB32;
import gnu.javax.imageio.bmp.EncodeRGB4;
import gnu.javax.imageio.bmp.EncodeRGB8;
import gnu.javax.imageio.bmp.EncodeRLE4;
import gnu.javax.imageio.bmp.EncodeRLE8;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public abstract class BMPEncoder {
    public static BMPEncoder getEncoder(BMPFileHeader fh, BMPInfoHeader ih) {
        switch (ih.getCompression()) {
            case 0: {
                switch (ih.getBitCount()) {
                    case 32: {
                        return new EncodeRGB32(fh, ih);
                    }
                    case 24: {
                        return new EncodeRGB24(fh, ih);
                    }
                    case 16: {
                        return new EncodeRGB16(fh, ih);
                    }
                    case 8: {
                        return new EncodeRGB8(fh, ih);
                    }
                    case 4: {
                        return new EncodeRGB4(fh, ih);
                    }
                    case 1: {
                        return new EncodeRGB1(fh, ih);
                    }
                }
                return null;
            }
            case 2: {
                return new EncodeRLE4(fh, ih);
            }
            case 1: {
                return new EncodeRLE8(fh, ih);
            }
        }
        return null;
    }

    public abstract void encode(ImageOutputStream var1, IIOMetadata var2, IIOImage var3, ImageWriteParam var4) throws IOException;
}

