/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CipherSuiteList
implements Iterable<CipherSuite> {
    private final ByteBuffer buffer;
    private final ProtocolVersion version;
    private int modCount;

    public CipherSuiteList(ByteBuffer buffer) {
        this(buffer, ProtocolVersion.SSL_3);
    }

    public CipherSuiteList(ByteBuffer buffer, ProtocolVersion version) {
        this.version = version;
        this.buffer = buffer;
        this.modCount = 0;
    }

    public int size() {
        return (this.buffer.getShort(0) & 0xFFFF) >>> 1;
    }

    public CipherSuite get(int index) {
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("limit: " + size + "; requested: " + index);
        }
        return CipherSuite.forValue(this.buffer.getShort(2 + (index << 1))).resolve();
    }

    public void put(int index, CipherSuite suite) {
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("limit: " + size + "; requested: " + index);
        }
        this.buffer.position(2 + (index << 1));
        this.buffer.put(suite.id());
        ++this.modCount;
    }

    public void setSize(int newSize) {
        if (newSize < 0 || newSize > Short.MAX_VALUE) {
            throw new IllegalArgumentException("size must be between 0 and 32767");
        }
        if ((newSize << 1) + 2 > this.buffer.capacity()) {
            throw new IllegalArgumentException("limit: " + this.buffer.capacity() + "; requested: " + newSize);
        }
        this.buffer.putShort(0, (short)(newSize << 1));
        ++this.modCount;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("[");
        out.print(this.size());
        out.println("] {");
        Iterator it = new Iterator();
        while (it.hasNext()) {
            CipherSuite suite = it.next();
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  ");
            out.print(suite);
            if (it.hasNext()) {
                out.print(",");
            }
            out.println();
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("};");
        return str.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CipherSuiteList)) {
            return false;
        }
        CipherSuiteList that = (CipherSuiteList)o;
        if (this.size() != that.size()) {
            return false;
        }
        Iterator it1 = new Iterator();
        Iterator it2 = that.new Iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (it1.next().equals(it2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public java.util.Iterator<CipherSuite> iterator() {
        return new Iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements ListIterator<CipherSuite> {
        private final int modCount;
        private int index;

        Iterator() {
            this.modCount = CipherSuiteList.this.modCount;
            this.index = 0;
        }

        @Override
        public void add(CipherSuite cs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < CipherSuiteList.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public CipherSuite next() throws NoSuchElementException {
            if (this.modCount != CipherSuiteList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return CipherSuiteList.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            if (this.hasNext()) {
                return this.index + 1;
            }
            return -1;
        }

        @Override
        public CipherSuite previous() throws NoSuchElementException {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            if (this.modCount != CipherSuiteList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return CipherSuiteList.this.get(--this.index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(CipherSuite cs) {
            CipherSuiteList.this.put(this.index, cs);
        }
    }
}

