/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class ClientPSKParameters
extends ExchangeKeys
implements Builder,
Constructed {
    public ClientPSKParameters(ByteBuffer buffer) {
        super(buffer);
    }

    public ClientPSKParameters(String identity) {
        super(null);
        Charset utf8 = Charset.forName("UTF-8");
        ByteBuffer idBuf = utf8.encode(CharBuffer.wrap(identity));
        this.buffer = ByteBuffer.allocate(idBuf.remaining() + 2);
        this.buffer.putShort((short)idBuf.remaining());
        this.buffer.put(idBuf);
        this.buffer.rewind();
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String identity() {
        Charset utf8 = Charset.forName("UTF-8");
        return utf8.decode((ByteBuffer)this.buffer.duplicate().position(2).limit(this.length())).toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  identity = ");
        out.print(this.identity());
        out.println(";");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} ClientPSKParameters;");
        return str.toString();
    }
}

