/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.crypto.key.srp6.SRPKeyPairGenerator;
import gnu.javax.crypto.sasl.srp.PasswordFile;
import gnu.javax.crypto.sasl.srp.SRP;
import gnu.javax.net.ssl.SRPManagerParameters;
import gnu.javax.net.ssl.SRPTrustManager;
import gnu.javax.net.ssl.provider.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.util.HashMap;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public class SRPTrustManagerFactory
extends TrustManagerFactorySpi {
    private Manager current;

    protected TrustManager[] engineGetTrustManagers() {
        if (this.current == null) {
            throw new IllegalStateException("not initialized");
        }
        return new TrustManager[]{this.current};
    }

    protected void engineInit(KeyStore ks) {
        throw new IllegalArgumentException("only accepts SRPManagerParameters");
    }

    protected void engineInit(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            try {
                String srpConfig;
                String srpPasswd = Util.getSecurityProperty("jessie.srp.password.file");
                if (srpPasswd == null) {
                    this.current = new Manager(new PasswordFile());
                    return;
                }
                String srpPasswd2 = Util.getSecurityProperty("jessie.srp.password.file2");
                if (srpPasswd2 == null) {
                    srpPasswd2 = String.valueOf(srpPasswd) + "2";
                }
                if ((srpConfig = Util.getSecurityProperty("jessie.srp.config")) == null) {
                    srpConfig = String.valueOf(srpPasswd) + ".conf";
                }
                this.current = new Manager(new PasswordFile(srpPasswd, srpPasswd2, srpConfig));
                return;
            }
            catch (IOException ioe) {
                throw new InvalidAlgorithmParameterException("default initialization failed: " + ioe.toString());
            }
        }
        if (params instanceof SRPManagerParameters) {
            this.current = new Manager(((SRPManagerParameters)params).getPasswordFile());
            return;
        }
        throw new InvalidAlgorithmParameterException();
    }

    private class Manager
    implements SRPTrustManager {
        private final PasswordFile file;

        Manager(PasswordFile file) {
            this.file = file;
        }

        public boolean contains(String user) {
            try {
                return this.file.contains(user);
            }
            catch (IOException iOException) {
                return false;
            }
        }

        public KeyPair getKeyPair(String user) {
            try {
                if (this.file.contains(user)) {
                    SRP.instance("SHA");
                    String[] ent = this.file.lookup(user, "SHA");
                    String[] cnf = this.file.lookupConfig(ent[2]);
                    BigInteger v = new BigInteger(1, gnu.java.security.util.Util.fromBase64(ent[0]));
                    BigInteger N = new BigInteger(1, gnu.java.security.util.Util.fromBase64(cnf[0]));
                    BigInteger g = new BigInteger(1, gnu.java.security.util.Util.fromBase64(cnf[1]));
                    SRPKeyPairGenerator kpg = new SRPKeyPairGenerator();
                    HashMap<String, BigInteger> attr = new HashMap<String, BigInteger>();
                    attr.put("gnu.crypto.srp.N", N);
                    attr.put("gnu.crypto.srp.g", g);
                    attr.put("gnu.crypto.srp.v", v);
                    kpg.setup(attr);
                    return kpg.generate();
                }
            }
            catch (IOException iOException) {}
            return null;
        }

        public byte[] getSalt(String user) {
            try {
                if (this.file.contains(user)) {
                    return gnu.java.security.util.Util.fromBase64(this.file.lookup(user, "SHA")[1]);
                }
            }
            catch (IOException iOException) {}
            return null;
        }

        public BigInteger getVerifier(String user) {
            try {
                if (this.file.contains(user)) {
                    return new BigInteger(1, gnu.java.security.util.Util.fromBase64(this.file.lookup(user, "SHA")[0]));
                }
            }
            catch (IOException iOException) {}
            return null;
        }

        public PasswordFile getPasswordFile() {
            return this.file;
        }
    }
}

