/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp;

import gnu.classpath.SystemProperties;
import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.print.ipp.DocPrintJobImpl;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppRequest;
import gnu.javax.print.ipp.IppResponse;
import gnu.javax.print.ipp.IppUtilities;
import gnu.javax.print.ipp.attribute.DefaultValueAttribute;
import gnu.javax.print.ipp.attribute.RequestedAttributes;
import gnu.javax.print.ipp.attribute.defaults.CopiesDefault;
import gnu.javax.print.ipp.attribute.defaults.FinishingsDefault;
import gnu.javax.print.ipp.attribute.defaults.JobHoldUntilDefault;
import gnu.javax.print.ipp.attribute.defaults.JobPriorityDefault;
import gnu.javax.print.ipp.attribute.defaults.JobSheetsDefault;
import gnu.javax.print.ipp.attribute.defaults.MediaDefault;
import gnu.javax.print.ipp.attribute.defaults.MultipleDocumentHandlingDefault;
import gnu.javax.print.ipp.attribute.defaults.NumberUpDefault;
import gnu.javax.print.ipp.attribute.defaults.OrientationRequestedDefault;
import gnu.javax.print.ipp.attribute.defaults.PrintQualityDefault;
import gnu.javax.print.ipp.attribute.defaults.PrinterResolutionDefault;
import gnu.javax.print.ipp.attribute.defaults.SidesDefault;
import gnu.javax.print.ipp.attribute.printer.DocumentFormat;
import gnu.javax.print.ipp.attribute.supported.CompressionSupported;
import gnu.javax.print.ipp.attribute.supported.DocumentFormatSupported;
import gnu.javax.print.ipp.attribute.supported.FinishingsSupported;
import gnu.javax.print.ipp.attribute.supported.JobHoldUntilSupported;
import gnu.javax.print.ipp.attribute.supported.JobSheetsSupported;
import gnu.javax.print.ipp.attribute.supported.MediaSupported;
import gnu.javax.print.ipp.attribute.supported.MultipleDocumentHandlingSupported;
import gnu.javax.print.ipp.attribute.supported.OperationsSupported;
import gnu.javax.print.ipp.attribute.supported.OrientationRequestedSupported;
import gnu.javax.print.ipp.attribute.supported.PageRangesSupported;
import gnu.javax.print.ipp.attribute.supported.PrintQualitySupported;
import gnu.javax.print.ipp.attribute.supported.PrinterResolutionSupported;
import gnu.javax.print.ipp.attribute.supported.PrinterUriSupported;
import gnu.javax.print.ipp.attribute.supported.SidesSupported;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Compression;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobHoldUntil;
import javax.print.attribute.standard.JobImpressions;
import javax.print.attribute.standard.JobImpressionsSupported;
import javax.print.attribute.standard.JobKOctets;
import javax.print.attribute.standard.JobKOctetsSupported;
import javax.print.attribute.standard.JobMediaSheets;
import javax.print.attribute.standard.JobMediaSheetsSupported;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobPrioritySupported;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MultipleDocumentHandling;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.NumberUpSupported;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;

public class IppPrintService
implements PrintService {
    private Map printerAttr;
    private HashSet printServiceAttributeListener;
    private transient String user;
    private transient String passwd;
    private String name;
    private List flavors;
    private PrinterURI printerUri;
    private ArrayList printerUris;
    static final Logger logger = SystemLogger.SYSTEM;
    public static final RequestingUserName REQUESTING_USER_NAME;
    public static final JobName JOB_NAME;

    static {
        JOB_NAME = new JobName("Java Printing", null);
        REQUESTING_USER_NAME = new RequestingUserName(SystemProperties.getProperty("user.name", ""), null);
    }

    public IppPrintService(URI uri, String username, String password) throws IppException {
        this.printerUri = new PrinterURI(uri);
        this.user = username;
        this.passwd = password;
        this.printServiceAttributeListener = new HashSet();
        this.printerAttr = this.getPrinterAttributes();
        this.processResponse();
    }

    private Map getPrinterAttributes() throws IppException {
        IppResponse response = null;
        try {
            IppRequest request = new IppRequest(this.printerUri.getURI(), this.user, this.passwd);
            int operation = OperationsSupported.GET_PRINTER_ATTRIBUTES.getValue();
            request.setOperationID((short)operation);
            request.setOperationAttributeDefaults();
            request.addOperationAttribute(this.printerUri);
            response = request.send();
        }
        catch (IOException e) {
            throw new IppException("IOException in IPP request/response.", e);
        }
        return (Map)response.getPrinterAttributes().get(0);
    }

    private Set getPrinterAttributeSet(Class attributeClass) {
        return (Set)this.printerAttr.get(attributeClass);
    }

    private Attribute getPrinterDefaultAttribute(Class attributeClass) {
        Set set = (Set)this.printerAttr.get(attributeClass);
        return ((DefaultValueAttribute)set.toArray()[0]).getAssociatedAttribute();
    }

    private void processResponse() {
        PrinterName[] tmp = this.getPrinterAttributeSet(PrinterName.class).toArray(new PrinterName[1]);
        this.name = tmp[0].getValue();
        this.flavors = new ArrayList();
        Set flavorAttributes = this.getPrinterAttributeSet(DocumentFormatSupported.class);
        if (flavorAttributes != null) {
            Iterator it = flavorAttributes.iterator();
            while (it.hasNext()) {
                String mimeType = ((DocumentFormatSupported)it.next()).getValue();
                if (mimeType.equals("text/plain")) {
                    this.flavors.add(DocFlavor.CHAR_ARRAY.TEXT_PLAIN);
                    this.flavors.add(DocFlavor.READER.TEXT_PLAIN);
                    this.flavors.add(DocFlavor.STRING.TEXT_PLAIN);
                    mimeType = String.valueOf(mimeType) + "; charset=utf-8";
                } else if (mimeType.equals("text/html")) {
                    this.flavors.add(DocFlavor.CHAR_ARRAY.TEXT_HTML);
                    this.flavors.add(DocFlavor.READER.TEXT_HTML);
                    this.flavors.add(DocFlavor.STRING.TEXT_HTML);
                    mimeType = String.valueOf(mimeType) + "; charset=utf-8";
                }
                boolean changed = false;
                try {
                    Class[] clazzes = new Class[]{DocFlavor.BYTE_ARRAY.class, DocFlavor.INPUT_STREAM.class, DocFlavor.URL.class};
                    int j = 0;
                    while (j < clazzes.length) {
                        Field[] fields = clazzes[j].getDeclaredFields();
                        int i = 0;
                        while (i < fields.length) {
                            DocFlavor flavor;
                            if (fields[i].getType().equals(clazzes[j]) && (flavor = (DocFlavor)fields[i].get(null)).getMimeType().equals(mimeType)) {
                                changed = this.flavors.add(flavor);
                            }
                            ++i;
                        }
                        ++j;
                    }
                    if (changed) continue;
                    this.flavors.add(new DocFlavor(mimeType, "[B"));
                    this.flavors.add(new DocFlavor(mimeType, "java.io.InputStream"));
                    this.flavors.add(new DocFlavor(mimeType, "java.net.URL"));
                }
                catch (SecurityException securityException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        Set uris = this.getPrinterAttributeSet(PrinterUriSupported.class);
        this.printerUris = new ArrayList(uris.size());
        for (PrinterUriSupported uri : uris) {
            this.printerUris.add(new PrinterURI(uri.getURI()));
        }
    }

    public DocPrintJob createPrintJob() {
        return new DocPrintJobImpl(this, this.user, this.passwd);
    }

    public PrintServiceAttribute getAttribute(Class category) {
        if (category == null) {
            throw new NullPointerException("category may not be null");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException("category must be of type PrintServiceAttribute");
        }
        Set set = this.getPrinterAttributeSet(category);
        if (set != null && set.size() > 0) {
            return (PrintServiceAttribute)set.toArray()[0];
        }
        return null;
    }

    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet set = new HashPrintServiceAttributeSet();
        Iterator it = this.printerAttr.values().iterator();
        while (it.hasNext()) {
            for (Attribute attr : (Set)it.next()) {
                if (!(attr instanceof PrintServiceAttribute)) continue;
                set.add(attr);
            }
        }
        return AttributeSetUtilities.unmodifiableView(set);
    }

    public Object getDefaultAttributeValue(Class category) {
        if (category.equals(Fidelity.class)) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (category.equals(JobName.class)) {
            return JOB_NAME;
        }
        if (category.equals(RequestingUserName.class)) {
            return REQUESTING_USER_NAME;
        }
        if (category.equals(JobPriority.class) && this.printerAttr.containsKey(JobPriorityDefault.class)) {
            return this.getPrinterDefaultAttribute(JobPriorityDefault.class);
        }
        if (category.equals(JobHoldUntil.class) && this.printerAttr.containsKey(JobHoldUntilDefault.class)) {
            return this.getPrinterDefaultAttribute(JobHoldUntilDefault.class);
        }
        if (category.equals(JobSheets.class) && this.printerAttr.containsKey(JobSheetsDefault.class)) {
            return this.getPrinterDefaultAttribute(JobSheetsDefault.class);
        }
        if (category.equals(MultipleDocumentHandling.class) && this.printerAttr.containsKey(MultipleDocumentHandlingDefault.class)) {
            return this.getPrinterDefaultAttribute(MultipleDocumentHandlingDefault.class);
        }
        if (category.equals(Copies.class) && this.printerAttr.containsKey(CopiesDefault.class)) {
            return this.getPrinterDefaultAttribute(CopiesDefault.class);
        }
        if (category.equals(Finishings.class) && this.printerAttr.containsKey(FinishingsDefault.class)) {
            return this.getPrinterDefaultAttribute(FinishingsDefault.class);
        }
        if (category.equals(Sides.class) && this.printerAttr.containsKey(SidesDefault.class)) {
            return this.getPrinterDefaultAttribute(SidesDefault.class);
        }
        if (category.equals(NumberUp.class) && this.printerAttr.containsKey(NumberUpDefault.class)) {
            return this.getPrinterDefaultAttribute(NumberUpDefault.class);
        }
        if (category.equals(OrientationRequested.class) && this.printerAttr.containsKey(OrientationRequestedDefault.class)) {
            return this.getPrinterDefaultAttribute(OrientationRequestedDefault.class);
        }
        if (category.equals(Media.class) && this.printerAttr.containsKey(MediaDefault.class)) {
            return this.getPrinterDefaultAttribute(MediaDefault.class);
        }
        if (category.equals(PrinterResolution.class) && this.printerAttr.containsKey(PrinterResolutionDefault.class)) {
            return this.getPrinterDefaultAttribute(PrinterResolutionDefault.class);
        }
        if (category.equals(PrintQuality.class) && this.printerAttr.containsKey(PrintQualityDefault.class)) {
            return this.getPrinterDefaultAttribute(PrintQualityDefault.class);
        }
        if (category.equals(Compression.class) && this.printerAttr.containsKey(CompressionSupported.class)) {
            return Compression.NONE;
        }
        if (category.equals(PageRanges.class)) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public Class[] getSupportedAttributeCategories() {
        Set set;
        HashSet<Class> categories = new HashSet<Class>();
        if (this.printerAttr.containsKey(JobPrioritySupported.class)) {
            categories.add(JobPriority.class);
        }
        if (this.printerAttr.containsKey(JobHoldUntilSupported.class)) {
            categories.add(JobHoldUntil.class);
        }
        if (this.printerAttr.containsKey(JobSheetsSupported.class)) {
            categories.add(JobSheets.class);
        }
        if (this.printerAttr.containsKey(MultipleDocumentHandlingSupported.class)) {
            categories.add(MultipleDocumentHandling.class);
        }
        if (this.printerAttr.containsKey(CopiesSupported.class)) {
            categories.add(Copies.class);
        }
        if (this.printerAttr.containsKey(FinishingsSupported.class) && ((set = this.getPrinterAttributeSet(FinishingsSupported.class)).size() != 1 || !set.contains(FinishingsSupported.NONE))) {
            categories.add(Finishings.class);
        }
        if (this.printerAttr.containsKey(PageRangesSupported.class)) {
            categories.add(PageRanges.class);
        }
        if (this.printerAttr.containsKey(SidesSupported.class)) {
            categories.add(Sides.class);
        }
        if (this.printerAttr.containsKey(NumberUpSupported.class)) {
            categories.add(NumberUp.class);
        }
        if (this.printerAttr.containsKey(OrientationRequestedSupported.class)) {
            categories.add(OrientationRequested.class);
        }
        if (this.printerAttr.containsKey(MediaSupported.class)) {
            categories.add(Media.class);
        }
        if (this.printerAttr.containsKey(PrinterResolutionSupported.class)) {
            categories.add(PrinterResolution.class);
        }
        if (this.printerAttr.containsKey(PrintQualitySupported.class)) {
            categories.add(PrintQuality.class);
        }
        if (this.printerAttr.containsKey(CompressionSupported.class)) {
            categories.add(Compression.class);
        }
        if (this.printerAttr.containsKey(JobImpressionsSupported.class)) {
            categories.add(JobImpressions.class);
        }
        if (this.printerAttr.containsKey(JobKOctetsSupported.class)) {
            categories.add(JobKOctets.class);
        }
        if (this.printerAttr.containsKey(JobMediaSheetsSupported.class)) {
            categories.add(JobMediaSheets.class);
        }
        categories.add(Fidelity.class);
        categories.add(JobName.class);
        categories.add(RequestingUserName.class);
        return categories.toArray(new Class[categories.size()]);
    }

    public Object getSupportedAttributeValues(Class category, DocFlavor flavor, AttributeSet attributes) {
        if (category == null) {
            throw new NullPointerException("category may not be null");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException("category must be of type Attribute");
        }
        if (flavor != null && !this.isDocFlavorSupported(flavor)) {
            throw new IllegalArgumentException("flavor is not supported");
        }
        if (!this.isAttributeCategorySupported(category)) {
            return null;
        }
        if (category.equals(Fidelity.class)) {
            return new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
        }
        if (category.equals(JobName.class)) {
            return JOB_NAME;
        }
        if (category.equals(RequestingUserName.class)) {
            return REQUESTING_USER_NAME;
        }
        String categoryName = IppUtilities.getSupportedAttrName(category);
        IppResponse response = null;
        try {
            short status;
            IppRequest request = new IppRequest(this.printerUri.getURI(), this.user, this.passwd);
            request.setOperationID((short)OperationsSupported.GET_PRINTER_ATTRIBUTES.getValue());
            request.setOperationAttributeDefaults();
            request.addOperationAttribute(new RequestedAttributes(categoryName));
            request.addOperationAttribute(this.printerUri);
            if (flavor != null) {
                DocumentFormat f = DocumentFormat.createDocumentFormat(flavor);
                request.addOperationAttribute(f);
            }
            if ((status = (response = request.send()).getStatusCode()) != 0 && status != 1 && status != 2) {
                logger.log(Component.IPP, "Statuscode not OK - got:" + status);
            }
        }
        catch (IOException e) {
            logger.log((Level)Component.IPP, "IOException", e);
        }
        catch (IppException e) {
            logger.log((Level)Component.IPP, "IPPException", e);
        }
        return this.handleSupportedAttributeValuesResponse(response, category);
    }

    protected Object handleSupportedAttributeValuesResponse(IppResponse response, Class category) {
        List printerAtts = response.getPrinterAttributes();
        Map printerAttribute = (Map)printerAtts.get(0);
        Class suppCategory = IppUtilities.getSupportedCategory(category);
        Set attr = (Set)printerAttribute.get(suppCategory);
        if (suppCategory.equals(JobPrioritySupported.class)) {
            return attr.toArray(new JobPrioritySupported[1])[0];
        }
        if (suppCategory.equals(JobHoldUntilSupported.class)) {
            return new JobHoldUntil(new Date());
        }
        if (suppCategory.equals(JobSheetsSupported.class)) {
            return JobSheetsSupported.getAssociatedAttributeArray(attr);
        }
        if (suppCategory.equals(MultipleDocumentHandlingSupported.class)) {
            return MultipleDocumentHandlingSupported.getAssociatedAttributeArray(attr);
        }
        if (suppCategory.equals(CopiesSupported.class)) {
            return attr.toArray(new CopiesSupported[1])[0];
        }
        if (suppCategory.equals(FinishingsSupported.class)) {
            return FinishingsSupported.getAssociatedAttributeArray(attr);
        }
        if (suppCategory.equals(PageRangesSupported.class)) {
            return new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
        }
        if (suppCategory.equals(OrientationRequestedSupported.class)) {
            return OrientationRequestedSupported.getAssociatedAttributeArray(attr);
        }
        if (suppCategory.equals(MediaSupported.class)) {
            return MediaSupported.getAssociatedAttributeArray(attr);
        }
        if (suppCategory.equals(PrinterResolutionSupported.class)) {
            return PrinterResolutionSupported.getAssociatedAttributeArray(attr);
        }
        if (suppCategory.equals(PrintQualitySupported.class)) {
            return PrintQualitySupported.getAssociatedAttributeArray(attr);
        }
        if (suppCategory.equals(CompressionSupported.class)) {
            return CompressionSupported.getAssociatedAttributeArray(attr);
        }
        if (suppCategory.equals(NumberUpSupported.class)) {
            NumberUpSupported[] tmp = attr.toArray(new NumberUpSupported[attr.size()]);
            if (attr.size() == 1) {
                return tmp[0];
            }
            int[][] members = new int[attr.size()][2];
            int j = 0;
            while (j < attr.size()) {
                int value = tmp[j].getMembers()[0][0];
                members[j] = new int[]{value, value};
                ++j;
            }
            NumberUpSupported supported = new NumberUpSupported(members);
            return supported;
        }
        return null;
    }

    public DocFlavor[] getSupportedDocFlavors() {
        return this.flavors.toArray(new DocFlavor[this.flavors.size()]);
    }

    public AttributeSet getUnsupportedAttributes(DocFlavor flavor, AttributeSet attributes) {
        List unsupportedMaps;
        if (flavor != null && !this.isDocFlavorSupported(flavor)) {
            throw new IllegalArgumentException("flavor is not supported");
        }
        IppResponse response = null;
        try {
            short status;
            IppRequest request = new IppRequest(this.printerUri.getURI(), this.user, this.passwd);
            short operationId = (short)OperationsSupported.VALIDATE_JOB.getValue();
            request.setOperationID(operationId);
            request.setOperationAttributeDefaults();
            request.addOperationAttribute(this.printerUri);
            request.addOperationAttribute(Fidelity.FIDELITY_TRUE);
            if (attributes != null && attributes.size() > 0) {
                request.addAndFilterJobOperationAttributes(attributes);
                request.addAndFilterJobTemplateAttributes(attributes);
            }
            if (flavor != null) {
                DocumentFormat f = DocumentFormat.createDocumentFormat(flavor);
                request.addOperationAttribute(f);
            }
            if ((status = (response = request.send()).getStatusCode()) != 0 && status != 1 && status != 2) {
                logger.log(Component.IPP, "Statuscode not OK - got:" + status);
            }
        }
        catch (IOException e) {
            logger.log((Level)Component.IPP, "IOException", e);
        }
        catch (IppException e) {
            logger.log((Level)Component.IPP, "IPPException", e);
        }
        if ((unsupportedMaps = response.getUnsupportedAttributes()).size() == 0) {
            return null;
        }
        Map unsupportedAttr = (Map)unsupportedMaps.get(0);
        if (unsupportedAttr.size() == 0) {
            return null;
        }
        HashAttributeSet set = new HashAttributeSet();
        for (Set unsupported : unsupportedAttr.values()) {
            Iterator it2 = unsupported.iterator();
            while (it2.hasNext()) {
                set.add((Attribute)it2.next());
            }
        }
        return set;
    }

    public boolean isAttributeCategorySupported(Class category) {
        if (category == null) {
            throw new NullPointerException("category may not be null");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException("category must be of type Attribute");
        }
        return Arrays.asList(this.getSupportedAttributeCategories()).contains(category);
    }

    public boolean isAttributeValueSupported(Attribute attrval, DocFlavor flavor, AttributeSet attributes) {
        Object values = this.getSupportedAttributeValues((Class)attrval.getCategory(), flavor, attributes);
        if (values == null) {
            return false;
        }
        if (values.getClass().isArray()) {
            return Arrays.asList((Object[])values).contains(attrval);
        }
        if (values.getClass().equals(attrval.getCategory())) {
            return true;
        }
        if (values.getClass().equals(CopiesSupported.class)) {
            return ((CopiesSupported)values).contains((IntegerSyntax)((Object)attrval));
        }
        if (values.getClass().equals(NumberUpSupported.class)) {
            return ((NumberUpSupported)values).contains((IntegerSyntax)((Object)attrval));
        }
        if (values.getClass().equals(JobPrioritySupported.class)) {
            JobPriority priority = (JobPriority)attrval;
            JobPrioritySupported maxSupported = (JobPrioritySupported)values;
            if (priority.getValue() < maxSupported.getValue()) {
                return true;
            }
        }
        return false;
    }

    public boolean isDocFlavorSupported(DocFlavor flavor) {
        if (flavor == null) {
            throw new NullPointerException("DocFlavor may not be null.");
        }
        return this.flavors.contains(flavor);
    }

    public void addPrintServiceAttributeListener(PrintServiceAttributeListener listener) {
        this.printServiceAttributeListener.add(listener);
    }

    public void removePrintServiceAttributeListener(PrintServiceAttributeListener listener) {
        this.printServiceAttributeListener.remove(listener);
    }

    public String toString() {
        return "IppPrinter: " + this.getName();
    }

    public PrinterURI getPrinterURI() {
        return this.printerUri;
    }
}

