/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StreamSerializer {
    static final int SPACE = 32;
    static final int BANG = 33;
    static final int APOS = 39;
    static final int SLASH = 47;
    static final int BRA = 60;
    static final int KET = 62;
    static final int EQ = 61;
    static final Map HTML_BOOLEAN_ATTRIBUTES = new HashMap();
    static final HashSet HTML_URIS;
    protected final String encoding;
    final Charset charset;
    final CharsetEncoder encoder;
    final int mode;
    final LinkedList namespaces;
    protected String eol;
    Collection cdataSectionElements = Collections.EMPTY_SET;
    protected boolean discardDefaultContent;
    protected boolean xmlDeclaration = true;
    private boolean htmlEncoded;

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("nohref");
        HTML_BOOLEAN_ATTRIBUTES.put("area", set);
        set = new HashSet();
        set.add("ismap");
        HTML_BOOLEAN_ATTRIBUTES.put("img", set);
        set = new HashSet();
        set.add("declare");
        HTML_BOOLEAN_ATTRIBUTES.put("object", set);
        set = new HashSet();
        set.add("noshade");
        HTML_BOOLEAN_ATTRIBUTES.put("hr", set);
        set = new HashSet();
        set.add("compact");
        HTML_BOOLEAN_ATTRIBUTES.put("dl", set);
        HTML_BOOLEAN_ATTRIBUTES.put("ol", set);
        HTML_BOOLEAN_ATTRIBUTES.put("ul", set);
        HTML_BOOLEAN_ATTRIBUTES.put("dir", set);
        HTML_BOOLEAN_ATTRIBUTES.put("menu", set);
        set = new HashSet();
        set.add("checked");
        set.add("disabled");
        set.add("readonly");
        set.add("ismap");
        HTML_BOOLEAN_ATTRIBUTES.put("input", set);
        set = new HashSet();
        set.add("multiple");
        set.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("select", set);
        set = new HashSet();
        set.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("optgroup", set);
        set = new HashSet();
        set.add("selected");
        set.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("option", set);
        set = new HashSet();
        set.add("disabled");
        set.add("readonly");
        HTML_BOOLEAN_ATTRIBUTES.put("textarea", set);
        set = new HashSet();
        set.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("button", set);
        set = new HashSet();
        set.add("nowrap");
        HTML_BOOLEAN_ATTRIBUTES.put("th", set);
        HTML_BOOLEAN_ATTRIBUTES.put("td", set);
        set = new HashSet();
        set.add("noresize");
        HTML_BOOLEAN_ATTRIBUTES.put("frame", set);
        set = new HashSet();
        set.add("defer");
        HTML_BOOLEAN_ATTRIBUTES.put("script", set);
        HTML_URIS = new HashSet();
        HTML_URIS.add("http://www.w3.org/1999/xhtml");
    }

    public StreamSerializer() {
        this(0, null, null);
    }

    public StreamSerializer(String encoding) {
        this(0, encoding, null);
    }

    public StreamSerializer(int mode, String encoding, String eol) {
        this.mode = mode;
        if (encoding == null) {
            encoding = mode == 1 ? "ISO-8859-1" : "UTF-8";
        }
        this.encoding = encoding.intern();
        this.charset = Charset.forName(this.encoding);
        this.encoder = this.charset.newEncoder();
        this.eol = eol != null ? eol : System.getProperty("line.separator");
        this.namespaces = new LinkedList();
    }

    void setCdataSectionElements(Collection c) {
        this.cdataSectionElements = c;
    }

    public void serialize(Node node2, OutputStream out) throws IOException {
        this.serialize(node2, out, false);
    }

    void serialize(Node node2, OutputStream out, boolean convertToCdata) throws IOException {
        while (node2 != null) {
            Node next = node2.getNextSibling();
            this.doSerialize(node2, out, convertToCdata);
            node2 = next;
        }
    }

    private void doSerialize(Node node2, OutputStream out, boolean convertToCdata) throws IOException {
        if (out == null) {
            throw new NullPointerException("no output stream");
        }
        this.htmlEncoded = false;
        String uri = node2.getNamespaceURI();
        int nt = node2.getNodeType();
        if (convertToCdata && nt == 3) {
            nt = 4;
        }
        switch (nt) {
            case 2: {
                String prefix = node2.getPrefix();
                if ("http://www.w3.org/2000/xmlns/".equals(uri) || "xmlns".equals(prefix) || prefix != null && prefix.startsWith("xmlns:")) {
                    int ci;
                    String nsuri = node2.getNodeValue();
                    if (this.isDefined(nsuri, prefix)) break;
                    String name = node2.getLocalName();
                    if (name == null && (ci = (name = node2.getNodeName()).indexOf(58)) != -1) {
                        name = name.substring(ci + 1);
                    }
                    this.define(nsuri, name);
                } else if (uri != null && !this.isDefined(uri, prefix)) {
                    String nsname = (prefix = this.define(uri, prefix)) == null ? "xmlns" : "xmlns:" + prefix;
                    out.write(32);
                    out.write(this.encodeText(nsname));
                    out.write(61);
                    String nsvalue = "\"" + this.encode(uri, true, true) + "\"";
                    out.write(nsvalue.getBytes(this.encoding));
                }
                out.write(32);
                String a_nodeName = node2.getNodeName();
                out.write(this.encodeText(a_nodeName));
                String a_nodeValue = node2.getNodeValue();
                if (this.mode == 1 && a_nodeName.equals(a_nodeValue) && this.isHTMLBoolean((Attr)node2, a_nodeName)) break;
                out.write(61);
                String value = "\"" + this.encode(a_nodeValue, true, true) + "\"";
                out.write(this.encodeText(value));
                break;
            }
            case 1: {
                NamedNodeMap attrs;
                this.pushNamespaceContext();
                String value = node2.getNodeName();
                out.write(60);
                out.write(this.encodeText(value));
                String prefix = node2.getPrefix();
                if (uri != null && !this.isDefined(uri, prefix)) {
                    String nsname = (prefix = this.define(uri, prefix)) == null ? "xmlns" : "xmlns:" + prefix;
                    out.write(32);
                    out.write(this.encodeText(nsname));
                    out.write(61);
                    String nsvalue = "\"" + this.encode(uri, true, true) + "\"";
                    out.write(this.encodeText(nsvalue));
                }
                if ((attrs = node2.getAttributes()) != null) {
                    int len = attrs.getLength();
                    int i = 0;
                    while (i < len) {
                        Attr attr = (Attr)attrs.item(i);
                        if (!this.discardDefaultContent || attr.getSpecified()) {
                            this.serialize(attr, out, false);
                        }
                        ++i;
                    }
                }
                convertToCdata = this.cdataSectionElements.contains(value);
                Node children = node2.getFirstChild();
                if (children == null) {
                    out.write(47);
                    out.write(62);
                } else {
                    out.write(62);
                    this.serialize(children, out, convertToCdata);
                    out.write(60);
                    out.write(47);
                    out.write(this.encodeText(value));
                    out.write(62);
                }
                this.popNamespaceContext();
                break;
            }
            case 3: {
                String value = node2.getNodeValue();
                if (!"yes".equals(node2.getUserData("disable-output-escaping")) && this.mode != 2) {
                    value = this.encode(value, false, false);
                }
                out.write(this.encodeText(value));
                break;
            }
            case 4: {
                String value = node2.getNodeValue();
                int bbk = value.indexOf("]]>");
                while (bbk != -1) {
                    String head = value.substring(0, bbk + 2);
                    out.write(this.encodeText("<![CDATA[" + head + "]]>"));
                    value = value.substring(bbk + 2);
                    bbk = value.indexOf("]]>");
                }
                out.write(this.encodeText("<![CDATA[" + value + "]]>"));
                break;
            }
            case 8: {
                String value = "<!--" + node2.getNodeValue() + "-->";
                out.write(this.encodeText(value));
                Node cp = node2.getParentNode();
                if (cp == null || cp.getNodeType() != 9) break;
                out.write(this.encodeText(this.eol));
                break;
            }
            case 9: 
            case 11: {
                Node children;
                if (this.mode == 0) {
                    if ("UTF-16".equalsIgnoreCase(this.encoding)) {
                        out.write(254);
                        out.write(255);
                    }
                    if (!"yes".equals(node2.getUserData("omit-xml-declaration")) && this.xmlDeclaration) {
                        String version;
                        Document doc = node2 instanceof Document ? (Document)node2 : null;
                        String string = version = doc != null ? doc.getXmlVersion() : null;
                        if (version == null) {
                            version = (String)node2.getUserData("version");
                        }
                        if (version == null) {
                            version = "1.0";
                        }
                        out.write(60);
                        out.write(63);
                        out.write("xml version=\"".getBytes("US-ASCII"));
                        out.write(version.getBytes("US-ASCII"));
                        out.write(34);
                        if (!"UTF-8".equalsIgnoreCase(this.encoding)) {
                            out.write(" encoding=\"".getBytes("US-ASCII"));
                            out.write(this.encoding.getBytes("US-ASCII"));
                            out.write(34);
                        }
                        if (doc != null && doc.getXmlStandalone() || "yes".equals(node2.getUserData("standalone"))) {
                            out.write(" standalone=\"yes\"".getBytes("US-ASCII"));
                        }
                        out.write(63);
                        out.write(62);
                        out.write(this.encodeText(this.eol));
                    }
                } else if (this.mode == 1) {
                    String mediaType = (String)node2.getUserData("media-type");
                    if (mediaType == null) {
                        mediaType = "text/html";
                    }
                    String contentType = String.valueOf(mediaType) + "; charset=" + (this.encoding.indexOf(32) != -1 ? "\"" + this.encoding + "\"" : this.encoding);
                    Document doc = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
                    Node html = null;
                    Node ctx = node2.getFirstChild();
                    while (ctx != null) {
                        if (ctx.getNodeType() == 1 && this.isHTMLElement(ctx, "html")) {
                            html = ctx;
                            break;
                        }
                        ctx = ctx.getNextSibling();
                    }
                    if (html != null) {
                        Node head = null;
                        Node ctx2 = html.getFirstChild();
                        while (ctx2 != null) {
                            if (this.isHTMLElement(ctx2, "head")) {
                                head = ctx2;
                                break;
                            }
                            ctx2 = ctx2.getNextSibling();
                        }
                        if (head != null) {
                            Node meta = null;
                            Node metaContent = null;
                            Node ctx3 = head.getFirstChild();
                            while (ctx3 != null) {
                                if (this.isHTMLElement(ctx3, "meta")) {
                                    NamedNodeMap metaAttrs = ctx3.getAttributes();
                                    int len = metaAttrs.getLength();
                                    String httpEquiv = null;
                                    Node content = null;
                                    int i = 0;
                                    while (i < len) {
                                        Node attr = metaAttrs.item(i);
                                        String attrName = attr.getNodeName();
                                        if ("http-equiv".equalsIgnoreCase(attrName)) {
                                            httpEquiv = attr.getNodeValue();
                                        } else if ("content".equalsIgnoreCase(attrName)) {
                                            content = attr;
                                        }
                                        ++i;
                                    }
                                    if ("Content-Type".equalsIgnoreCase(httpEquiv)) {
                                        meta = ctx3;
                                        metaContent = content;
                                        break;
                                    }
                                }
                                ctx3 = ctx3.getNextSibling();
                            }
                            if (meta == null) {
                                meta = doc.createElement("meta");
                                Node first = head.getFirstChild();
                                if (first == null) {
                                    head.appendChild(meta);
                                } else {
                                    head.insertBefore(meta, first);
                                }
                                Attr metaHttpEquiv = doc.createAttribute("http-equiv");
                                meta.getAttributes().setNamedItem(metaHttpEquiv);
                                metaHttpEquiv.setNodeValue("Content-Type");
                            }
                            if (metaContent == null) {
                                metaContent = doc.createAttribute("content");
                                meta.getAttributes().setNamedItem(metaContent);
                            }
                            metaContent.setNodeValue(contentType);
                            this.htmlEncoded = true;
                        }
                    }
                }
                if ((children = node2.getFirstChild()) == null) break;
                this.serialize(children, out, convertToCdata);
                break;
            }
            case 10: {
                String internalSubset;
                String systemId;
                DocumentType doctype = (DocumentType)node2;
                out.write(60);
                out.write(33);
                out.write(this.encodeText("DOCTYPE "));
                String value = doctype.getNodeName();
                out.write(this.encodeText(value));
                String publicId = doctype.getPublicId();
                if (publicId != null) {
                    out.write(this.encodeText(" PUBLIC "));
                    out.write(39);
                    out.write(this.encodeText(publicId));
                    out.write(39);
                }
                if ((systemId = doctype.getSystemId()) != null) {
                    out.write(this.encodeText(" SYSTEM "));
                    out.write(39);
                    out.write(this.encodeText(systemId));
                    out.write(39);
                }
                if ((internalSubset = doctype.getInternalSubset()) != null) {
                    out.write(this.encodeText(internalSubset));
                }
                out.write(62);
                out.write(this.eol.getBytes(this.encoding));
                break;
            }
            case 5: {
                String value = "&" + node2.getNodeValue() + ";";
                out.write(this.encodeText(value));
                break;
            }
            case 7: {
                String value = "<?" + node2.getNodeName() + " " + node2.getNodeValue() + "?>";
                out.write(this.encodeText(value));
                Node pp = node2.getParentNode();
                if (pp == null || pp.getNodeType() != 9) break;
                out.write(this.encodeText(this.eol));
                break;
            }
            default: {
                System.err.println("Unhandled node type: " + nt);
            }
        }
    }

    boolean isHTMLElement(Node node2, String name) {
        if (node2.getNodeType() != 1) {
            return false;
        }
        String localName = node2.getLocalName();
        if (localName == null) {
            localName = node2.getNodeName();
        }
        if (!name.equalsIgnoreCase(localName)) {
            return false;
        }
        String uri = node2.getNamespaceURI();
        return uri == null || HTML_URIS.contains(uri);
    }

    boolean isDefined(String uri, String prefix) {
        if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
            return "xml".equals(prefix);
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            return "xmlns".equals(prefix);
        }
        if (prefix == null) {
            prefix = "";
        }
        for (Map ctx : this.namespaces) {
            String val = (String)ctx.get(uri);
            if (val == null || !val.equals(prefix)) continue;
            return true;
        }
        return false;
    }

    void pushNamespaceContext() {
        this.namespaces.addFirst(new HashMap());
    }

    String define(String uri, String prefix) {
        if (this.namespaces.isEmpty()) {
            return prefix;
        }
        HashMap ctx = (HashMap)this.namespaces.getFirst();
        while (ctx.containsValue(prefix)) {
            prefix = String.valueOf(prefix) + "_";
        }
        ctx.put(uri, prefix);
        return prefix;
    }

    void popNamespaceContext() {
        this.namespaces.removeFirst();
    }

    final byte[] encodeText(String text) throws IOException {
        int len;
        boolean htmlNeedingEncoding;
        this.encoder.reset();
        boolean bl = htmlNeedingEncoding = this.mode == 1 && !this.htmlEncoded;
        if (!this.encoder.canEncode(text) || htmlNeedingEncoding) {
            CPStringBuilder buf = new CPStringBuilder();
            len = text.length();
            int i = 0;
            while (i < len) {
                char c = text.charAt(i);
                if (!this.encoder.canEncode(c)) {
                    String hex = Integer.toHexString(c);
                    buf.append("&#x");
                    buf.append(hex);
                    buf.append(';');
                } else if (htmlNeedingEncoding) {
                    String entityName = StreamSerializer.getHTMLCharacterEntity(c);
                    if (entityName != null) {
                        buf.append('&');
                        buf.append(entityName);
                        buf.append(';');
                    } else {
                        buf.append(c);
                    }
                } else {
                    buf.append(c);
                }
                ++i;
            }
            text = buf.toString();
        }
        ByteBuffer encoded = this.encoder.encode(CharBuffer.wrap(text));
        len = encoded.limit() - encoded.position();
        if (encoded.hasArray()) {
            byte[] ret = encoded.array();
            if (ret.length > len) {
                byte[] ret2 = new byte[len];
                System.arraycopy(ret, 0, ret2, 0, len);
                ret = ret2;
            }
            return ret;
        }
        encoded.flip();
        byte[] ret = new byte[len];
        encoded.get(ret, 0, len);
        return ret;
    }

    String encode(String text, boolean encodeCtl, boolean inAttr) {
        int len = text.length();
        CPStringBuilder buf = null;
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '<') {
                if (buf == null) {
                    buf = new CPStringBuilder(text.substring(0, i));
                }
                buf.append("&lt;");
            } else if (c == '>') {
                if (buf == null) {
                    buf = new CPStringBuilder(text.substring(0, i));
                }
                buf.append("&gt;");
            } else if (c == '&') {
                if (this.mode == 1 && i + 1 < len && text.charAt(i + 1) == '{') {
                    if (buf != null) {
                        buf.append(c);
                    }
                } else {
                    if (buf == null) {
                        buf = new CPStringBuilder(text.substring(0, i));
                    }
                    buf.append("&amp;");
                }
            } else if (c == '\'' && inAttr) {
                if (buf == null) {
                    buf = new CPStringBuilder(text.substring(0, i));
                }
                if (this.mode == 1) {
                    buf.append("&#x27;");
                } else {
                    buf.append("&apos;");
                }
            } else if (c == '\"' && inAttr) {
                if (buf == null) {
                    buf = new CPStringBuilder(text.substring(0, i));
                }
                buf.append("&quot;");
            } else if (encodeCtl) {
                if (c < ' ') {
                    if (buf == null) {
                        buf = new CPStringBuilder(text.substring(0, i));
                    }
                    buf.append('&');
                    buf.append('#');
                    buf.append((int)c);
                    buf.append(';');
                } else if (buf != null) {
                    buf.append(c);
                }
            } else if (buf != null) {
                buf.append(c);
            }
            ++i;
        }
        return buf == null ? text : buf.toString();
    }

    String toString(Node node2) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.serialize(node2, out);
            return new String(out.toByteArray(), this.encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    boolean isHTMLBoolean(Attr attr, String attrName) {
        Collection attributes;
        attrName = attrName.toLowerCase();
        Element element = attr.getOwnerElement();
        String elementName = element.getLocalName();
        if (elementName == null) {
            elementName = element.getNodeName();
        }
        return (attributes = (Collection)HTML_BOOLEAN_ATTRIBUTES.get(elementName = elementName.toLowerCase())) != null && attributes.contains(attrName);
    }

    static String getHTMLCharacterEntity(char c) {
        switch (c) {
            case '\u00a0': {
                return "nbsp";
            }
            case '\u00a1': {
                return "iexcl";
            }
            case '\u00a2': {
                return "cent";
            }
            case '\u00a3': {
                return "pound";
            }
            case '\u00a4': {
                return "curren";
            }
            case '\u00a5': {
                return "yen";
            }
            case '\u00a6': {
                return "brvbar";
            }
            case '\u00a7': {
                return "sect";
            }
            case '\u00a8': {
                return "uml";
            }
            case '\u00a9': {
                return "copy";
            }
            case '\u00aa': {
                return "ordf";
            }
            case '\u00ab': {
                return "laquo";
            }
            case '\u00ac': {
                return "not";
            }
            case '\u00ad': {
                return "shy";
            }
            case '\u00ae': {
                return "reg";
            }
            case '\u00af': {
                return "macr";
            }
            case '\u00b0': {
                return "deg";
            }
            case '\u00b1': {
                return "plusmn";
            }
            case '\u00b2': {
                return "sup2";
            }
            case '\u00b3': {
                return "sup3";
            }
            case '\u00b4': {
                return "acute";
            }
            case '\u00b5': {
                return "micro";
            }
            case '\u00b6': {
                return "para";
            }
            case '\u00b7': {
                return "middot";
            }
            case '\u00b8': {
                return "cedil";
            }
            case '\u00b9': {
                return "sup1";
            }
            case '\u00ba': {
                return "ordm";
            }
            case '\u00bb': {
                return "raquo";
            }
            case '\u00bc': {
                return "frac14";
            }
            case '\u00bd': {
                return "frac12";
            }
            case '\u00be': {
                return "frac34";
            }
            case '\u00bf': {
                return "iquest";
            }
            case '\u00c0': {
                return "Agrave";
            }
            case '\u00c1': {
                return "Aacute";
            }
            case '\u00c2': {
                return "Acirc";
            }
            case '\u00c3': {
                return "Atilde";
            }
            case '\u00c4': {
                return "Auml";
            }
            case '\u00c5': {
                return "Aring";
            }
            case '\u00c6': {
                return "AElig";
            }
            case '\u00c7': {
                return "Ccedil";
            }
            case '\u00c8': {
                return "Egrave";
            }
            case '\u00c9': {
                return "Eacute";
            }
            case '\u00ca': {
                return "Ecirc";
            }
            case '\u00cb': {
                return "Euml";
            }
            case '\u00cc': {
                return "Igrave";
            }
            case '\u00cd': {
                return "Iacute";
            }
            case '\u00ce': {
                return "Icirc";
            }
            case '\u00cf': {
                return "Iuml";
            }
            case '\u00d0': {
                return "ETH";
            }
            case '\u00d1': {
                return "Ntilde";
            }
            case '\u00d2': {
                return "Ograve";
            }
            case '\u00d3': {
                return "Oacute";
            }
            case '\u00d4': {
                return "Ocirc";
            }
            case '\u00d5': {
                return "Otilde";
            }
            case '\u00d6': {
                return "Ouml";
            }
            case '\u00d7': {
                return "times";
            }
            case '\u00d8': {
                return "Oslash";
            }
            case '\u00d9': {
                return "Ugrave";
            }
            case '\u00da': {
                return "Uacute";
            }
            case '\u00db': {
                return "Ucirc";
            }
            case '\u00dc': {
                return "Uuml";
            }
            case '\u00dd': {
                return "Yacute";
            }
            case '\u00de': {
                return "THORN";
            }
            case '\u00df': {
                return "szlig";
            }
            case '\u00e0': {
                return "agrave";
            }
            case '\u00e1': {
                return "aacute";
            }
            case '\u00e2': {
                return "acirc";
            }
            case '\u00e3': {
                return "atilde";
            }
            case '\u00e4': {
                return "auml";
            }
            case '\u00e5': {
                return "aring";
            }
            case '\u00e6': {
                return "aelig";
            }
            case '\u00e7': {
                return "ccedil";
            }
            case '\u00e8': {
                return "egrave";
            }
            case '\u00e9': {
                return "eacute";
            }
            case '\u00ea': {
                return "ecirc";
            }
            case '\u00eb': {
                return "euml";
            }
            case '\u00ec': {
                return "igrave";
            }
            case '\u00ed': {
                return "iacute";
            }
            case '\u00ee': {
                return "icirc";
            }
            case '\u00ef': {
                return "iuml";
            }
            case '\u00f0': {
                return "eth";
            }
            case '\u00f1': {
                return "ntilde";
            }
            case '\u00f2': {
                return "ograve";
            }
            case '\u00f3': {
                return "oacute";
            }
            case '\u00f4': {
                return "ocirc";
            }
            case '\u00f5': {
                return "otilde";
            }
            case '\u00f6': {
                return "ouml";
            }
            case '\u00f7': {
                return "divide";
            }
            case '\u00f8': {
                return "oslash";
            }
            case '\u00f9': {
                return "ugrave";
            }
            case '\u00fa': {
                return "uacute";
            }
            case '\u00fb': {
                return "ucirc";
            }
            case '\u00fc': {
                return "uuml";
            }
            case '\u00fd': {
                return "yacute";
            }
            case '\u00fe': {
                return "thorn";
            }
            case '\u00ff': {
                return "yuml";
            }
        }
        return null;
    }
}

