/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ButtonPeer;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Button
extends Component
implements Serializable,
Accessible {
    private static final long serialVersionUID = -8774683716313001058L;
    String actionCommand;
    String label;
    private transient ActionListener action_listeners;
    private static transient long next_button_number;

    public Button() {
        this("");
    }

    public Button(String label) {
        this.label = label;
        this.actionCommand = label;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String label) {
        this.label = label;
        this.actionCommand = label;
        if (this.peer != null) {
            ButtonPeer bp = (ButtonPeer)this.peer;
            bp.setLabel(label);
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand == null ? this.label : actionCommand;
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, listener);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.action_listeners, ActionListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == ActionListener.class) {
            return this.getActionListeners();
        }
        return (EventListener[])Array.newInstance(listenerType, 0);
    }

    @Override
    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createButton(this);
        }
        super.addNotify();
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.action_listeners != null) {
            this.action_listeners.actionPerformed(event);
        }
    }

    @Override
    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 1001 && e.id >= 1001 && (this.action_listeners != null || (this.eventMask & 0x80L) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    @Override
    protected String paramString() {
        return String.valueOf(this.getName()) + "," + this.getX() + "," + this.getY() + "," + this.getWidth() + "x" + this.getHeight() + ",label=" + this.getLabel();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTButton();
        }
        return this.accessibleContext;
    }

    @Override
    String generateName() {
        return "button" + Button.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_button_number++;
    }

    protected class AccessibleAWTButton
    extends Component.AccessibleAWTComponent
    implements AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = -5932203980244017102L;

        protected AccessibleAWTButton() {
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int i) {
            if (i == 0) {
                return "click";
            }
            return null;
        }

        public boolean doAccessibleAction(int i) {
            if (i != 0) {
                return false;
            }
            Button.this.processActionEvent(new ActionEvent(this, 1001, Button.this.actionCommand));
            return true;
        }

        public String getAccessibleName() {
            return Button.this.label;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(0);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }
    }
}

