/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class PropertyChangeSupport
implements Serializable {
    private static final long serialVersionUID = 6401253773779951803L;
    private Hashtable children;
    private final Object source;
    private static final int propertyChangeSupportSerializedDataVersion = 2;
    private transient Vector listeners;

    public PropertyChangeSupport(Object source) {
        this.source = source;
        if (source == null) {
            throw new NullPointerException();
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            return;
        }
        if (l instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy p = (PropertyChangeListenerProxy)l;
            this.addPropertyChangeListener(p.propertyName, (PropertyChangeListener)p.getListener());
        } else {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.add(l);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (l instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy p = (PropertyChangeListenerProxy)l;
            this.removePropertyChangeListener(p.propertyName, (PropertyChangeListener)p.getListener());
        } else if (this.listeners != null) {
            this.listeners.remove(l);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList<PropertyChangeListenerProxy> list2 = new ArrayList<PropertyChangeListenerProxy>();
        if (this.listeners != null) {
            list2.addAll(this.listeners);
        }
        if (this.children != null) {
            int i = this.children.size();
            Iterator iter = this.children.entrySet().iterator();
            while (--i >= 0) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                Vector v = ((PropertyChangeSupport)e.getValue()).listeners;
                int j = v.size();
                while (--j >= 0) {
                    list2.add(new PropertyChangeListenerProxy(name, (PropertyChangeListener)v.get(j)));
                }
            }
        }
        return list2.toArray(new PropertyChangeListener[list2.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        if (l != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            p = (PropertyChangeListenerProxy)l;
            if (propertyName == null ? p.propertyName != null : propertyName.equals(p.propertyName) == false) {
                return;
            }
            l = (PropertyChangeListener)p.getListener();
lbl7:
            // 2 sources

            ** while (l instanceof PropertyChangeListenerProxy)
        }
lbl8:
        // 1 sources

        s = null;
        if (this.children == null) {
            this.children = new Hashtable<K, V>();
        } else {
            s = (PropertyChangeSupport)this.children.get(propertyName);
        }
        if (s == null) {
            s = new PropertyChangeSupport(this.source);
            s.listeners = new Vector<T>();
            this.children.put(propertyName, s);
        }
        s.listeners.add(l);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        if (this.children == null) {
            return;
        }
        s = (PropertyChangeSupport)this.children.get(propertyName);
        if (s != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            p = (PropertyChangeListenerProxy)l;
            if (propertyName == null ? p.propertyName != null : propertyName.equals(p.propertyName) == false) {
                return;
            }
            l = (PropertyChangeListener)p.getListener();
lbl10:
            // 2 sources

            ** while (l instanceof PropertyChangeListenerProxy)
        }
lbl11:
        // 1 sources

        s.listeners.remove(l);
        if (s.listeners.isEmpty()) {
            this.children.remove(propertyName);
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.children == null || propertyName == null) {
            return new PropertyChangeListener[0];
        }
        PropertyChangeSupport s = (PropertyChangeSupport)this.children.get(propertyName);
        if (s == null) {
            return new PropertyChangeListener[0];
        }
        return s.listeners.toArray((S[])new PropertyChangeListener[s.listeners.size()]);
    }

    public void firePropertyChange(String propertyName, Object oldVal, Object newVal) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldVal, newVal));
    }

    public void firePropertyChange(String propertyName, int oldVal, int newVal) {
        if (oldVal != newVal) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldVal, newVal));
        }
    }

    public void firePropertyChange(String propertyName, boolean oldVal, boolean newVal) {
        if (oldVal != newVal) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldVal, newVal));
        }
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        PropertyChangeSupport s;
        Hashtable h;
        if (event.oldValue != null && event.oldValue.equals(event.newValue)) {
            return;
        }
        Vector v = this.listeners;
        if (v != null) {
            int i = v.size();
            while (--i >= 0) {
                ((PropertyChangeListener)v.get(i)).propertyChange(event);
            }
        }
        if ((h = this.children) != null && event.propertyName != null && (s = (PropertyChangeSupport)h.get(event.propertyName)) != null) {
            v = s.listeners;
            int i = v == null ? 0 : v.size();
            while (--i >= 0) {
                ((PropertyChangeListener)v.get(i)).propertyChange(event);
            }
        }
    }

    public void fireIndexedPropertyChange(String name, int index, Object oldValue, Object newValue) {
        this.firePropertyChange(new IndexedPropertyChangeEvent(this.source, name, oldValue, newValue, index));
    }

    public void fireIndexedPropertyChange(String name, int index, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.fireIndexedPropertyChange(name, index, (Object)oldValue, (Object)newValue);
        }
    }

    public void fireIndexedPropertyChange(String name, int index, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.fireIndexedPropertyChange(name, index, (Object)oldValue, (Object)newValue);
        }
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.listeners != null || this.children != null && this.children.get(propertyName) != null;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.listeners != null) {
            int i = this.listeners.size();
            while (--i >= 0) {
                if (!(this.listeners.get(i) instanceof Serializable)) continue;
                s.writeObject(this.listeners.get(i));
            }
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        PropertyChangeListener l = (PropertyChangeListener)s.readObject();
        while (l != null) {
            this.addPropertyChangeListener(l);
            l = (PropertyChangeListener)s.readObject();
        }
        if (this.children != null) {
            int i = this.children.size();
            Iterator iter = this.children.entrySet().iterator();
            while (--i >= 0) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                PropertyChangeSupport pcs = (PropertyChangeSupport)e.getValue();
                if (pcs.listeners == null) {
                    pcs.listeners = new Vector();
                }
                if (pcs.children != null) {
                    pcs.listeners.addAll((Collection)Arrays.asList(pcs.getPropertyChangeListeners(name)));
                }
                if (pcs.listeners.size() == 0) {
                    iter.remove();
                    continue;
                }
                pcs.children = null;
            }
            if (this.children.size() == 0) {
                this.children = null;
            }
        }
    }
}

