/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark;
    protected int count;

    public ByteArrayInputStream(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public ByteArrayInputStream(byte[] buffer, int offset, int length) {
        if (offset < 0 || length < 0 || offset > buffer.length) {
            throw new IllegalArgumentException();
        }
        this.buf = buffer;
        this.count = offset + length;
        if (this.count > this.buf.length) {
            this.count = this.buf.length;
        }
        this.mark = this.pos = offset;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public synchronized void mark(int readLimit) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() {
        if (this.pos < this.count) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] buffer, int offset, int length) {
        if (this.pos >= this.count) {
            return -1;
        }
        int numBytes = Math.min(this.count - this.pos, length);
        System.arraycopy(this.buf, this.pos, buffer, offset, numBytes);
        this.pos += numBytes;
        return numBytes;
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }

    public synchronized long skip(long num) {
        long numBytes = Math.min((long)(this.count - this.pos), num < 0L ? 0L : num);
        this.pos = (int)((long)this.pos + numBytes);
        return numBytes;
    }
}

