/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

abstract class AbstractStringBuffer
implements Serializable,
CharSequence,
Appendable {
    int count;
    char[] value;
    private static final int DEFAULT_CAPACITY = 16;

    AbstractStringBuffer() {
        this(16);
    }

    AbstractStringBuffer(int capacity) {
        this.value = new char[capacity];
    }

    AbstractStringBuffer(String str) {
        this.count = str.count;
        this.value = new char[this.count + 16];
        str.getChars(0, this.count, this.value, 0);
    }

    AbstractStringBuffer(CharSequence seq) {
        int len = seq.length();
        this.count = len <= 0 ? 0 : len;
        this.value = new char[this.count + 16];
        int i = 0;
        while (i < len) {
            this.value[i] = seq.charAt(i);
            ++i;
        }
    }

    public void ensureCapacity(int minimumCapacity) {
        this.ensureCapacity_unsynchronized(minimumCapacity);
    }

    /*
     * Unable to fully structure code
     */
    public void setLength(int newLength) {
        block2: {
            if (newLength < 0) {
                throw new StringIndexOutOfBoundsException(newLength);
            }
            valueLength = this.value.length;
            this.ensureCapacity_unsynchronized(newLength);
            if (newLength >= valueLength) ** GOTO lbl9
            this.count = newLength;
            break block2;
lbl-1000:
            // 1 sources

            {
                this.value[this.count++] = '\u0000';
lbl9:
                // 2 sources

                ** while (this.count < newLength)
            }
        }
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public int codePointAt(int index) {
        return Character.codePointAt(this.value, index, this.count);
    }

    public int codePointBefore(int index) {
        if (index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointBefore(this.value, index, 1);
    }

    public void getChars(int srcOffset, int srcEnd, char[] dst, int dstOffset) {
        if (srcOffset < 0 || srcEnd > this.count || srcEnd < srcOffset) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, srcOffset, dst, dstOffset, srcEnd - srcOffset);
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.ensureCapacity_unsynchronized(this.count);
        this.value[index] = ch;
    }

    public AbstractStringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public AbstractStringBuffer append(String str) {
        if (str == null) {
            str = "null";
        }
        int len = str.count;
        this.ensureCapacity_unsynchronized(this.count + len);
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractStringBuffer append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append("null");
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int len = stringBuffer.count;
            this.ensureCapacity(this.count + len);
            System.arraycopy(stringBuffer.value, 0, this.value, this.count, len);
            this.count += len;
        }
        return this;
    }

    public AbstractStringBuffer append(char[] data) {
        return this.append(data, 0, data.length);
    }

    public AbstractStringBuffer append(char[] data, int offset, int count) {
        if (offset < 0 || count < 0 || offset > data.length - count) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count + count);
        System.arraycopy(data, offset, this.value, this.count, count);
        this.count += count;
        return this;
    }

    public AbstractStringBuffer append(boolean bool) {
        return this.append(bool ? "true" : "false");
    }

    public AbstractStringBuffer append(char ch) {
        this.ensureCapacity_unsynchronized(this.count + 1);
        this.value[this.count++] = ch;
        return this;
    }

    public AbstractStringBuffer append(CharSequence seq) {
        return this.append(seq, 0, seq.length());
    }

    public AbstractStringBuffer append(CharSequence seq, int start, int end) {
        if (seq == null) {
            seq = "null";
        }
        if (end - start > 0) {
            this.ensureCapacity_unsynchronized(this.count + end - start);
            while (start < end) {
                this.value[this.count++] = seq.charAt(start);
                ++start;
            }
        }
        return this;
    }

    public native AbstractStringBuffer append(int var1);

    public AbstractStringBuffer append(long lnum) {
        return this.append(Long.toString(lnum, 10));
    }

    public AbstractStringBuffer append(float fnum) {
        return this.append(Float.toString(fnum));
    }

    public AbstractStringBuffer append(double dnum) {
        return this.append(Double.toString(dnum));
    }

    public AbstractStringBuffer appendCodePoint(int code) {
        int len = Character.charCount(code);
        this.ensureCapacity_unsynchronized(this.count + len);
        Character.toChars(code, this.value, this.count);
        this.count += len;
        return this;
    }

    public AbstractStringBuffer delete(int start, int end) {
        if (start < 0 || start > this.count || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        this.ensureCapacity_unsynchronized(this.count);
        if (this.count - end != 0) {
            System.arraycopy(this.value, end, this.value, start, this.count - end);
        }
        this.count -= end - start;
        return this;
    }

    public AbstractStringBuffer deleteCharAt(int index) {
        return this.delete(index, index + 1);
    }

    public AbstractStringBuffer replace(int start, int end, String str) {
        if (start < 0 || start > this.count || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int len = str.count;
        int delta = len - (end > this.count ? this.count : end) + start;
        this.ensureCapacity_unsynchronized(this.count + delta);
        if (delta != 0 && end < this.count) {
            System.arraycopy(this.value, end, this.value, end + delta, this.count - end);
        }
        str.getChars(0, len, this.value, start);
        this.count += delta;
        return this;
    }

    public AbstractStringBuffer insert(int offset, char[] str, int str_offset, int len) {
        if (offset < 0 || offset > this.count || len < 0 || str_offset < 0 || str_offset > str.length - len) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, str_offset, this.value, offset, len);
        this.count += len;
        return this;
    }

    public AbstractStringBuffer insert(int offset, Object obj) {
        return this.insert(offset, obj == null ? "null" : obj.toString());
    }

    public AbstractStringBuffer insert(int offset, String str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (str == null) {
            str = "null";
        }
        int len = str.count;
        this.ensureCapacity_unsynchronized(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count += len;
        return this;
    }

    public AbstractStringBuffer insert(int offset, CharSequence sequence) {
        if (sequence == null) {
            sequence = "null";
        }
        return this.insert(offset, sequence, 0, sequence.length());
    }

    public AbstractStringBuffer insert(int offset, CharSequence sequence, int start, int end) {
        if (sequence == null) {
            sequence = "null";
        }
        if (start < 0 || end < 0 || start > end || end > sequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int len = end - start;
        this.ensureCapacity_unsynchronized(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        int i = start;
        while (i < end) {
            this.value[offset++] = sequence.charAt(i);
            ++i;
        }
        this.count += len;
        return this;
    }

    public AbstractStringBuffer insert(int offset, char[] data) {
        return this.insert(offset, data, 0, data.length);
    }

    public AbstractStringBuffer insert(int offset, boolean bool) {
        return this.insert(offset, bool ? "true" : "false");
    }

    public AbstractStringBuffer insert(int offset, char ch) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        this.ensureCapacity_unsynchronized(this.count + 1);
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = ch;
        ++this.count;
        return this;
    }

    public AbstractStringBuffer insert(int offset, int inum) {
        return this.insert(offset, String.valueOf(inum));
    }

    public AbstractStringBuffer insert(int offset, long lnum) {
        return this.insert(offset, Long.toString(lnum, 10));
    }

    public AbstractStringBuffer insert(int offset, float fnum) {
        return this.insert(offset, Float.toString(fnum));
    }

    public AbstractStringBuffer insert(int offset, double dnum) {
        return this.insert(offset, Double.toString(dnum));
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int limit = this.count - str.count;
        while (fromIndex <= limit) {
            if (this.regionMatches(fromIndex, str)) {
                return fromIndex;
            }
            ++fromIndex;
        }
        return -1;
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count - str.count);
    }

    public int lastIndexOf(String str, int fromIndex) {
        fromIndex = Math.min(fromIndex, this.count - str.count);
        while (fromIndex >= 0) {
            if (this.regionMatches(fromIndex, str)) {
                return fromIndex;
            }
            --fromIndex;
        }
        return -1;
    }

    public AbstractStringBuffer reverse() {
        this.ensureCapacity_unsynchronized(this.count);
        int i = this.count >> 1;
        int j = this.count - i;
        while (--i >= 0) {
            char c = this.value[i];
            this.value[i] = this.value[j];
            this.value[j] = c;
            ++j;
        }
        return this;
    }

    public void trimToSize() {
        int wouldSave = this.value.length - this.count;
        if (wouldSave < 20) {
            return;
        }
        if (wouldSave > 200 || wouldSave * 4 > this.value.length) {
            char[] newValue = new char[this.count];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
    }

    public int codePointCount(int start, int end) {
        if (start < 0 || end >= this.count || start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int count = 0;
        while (start < end) {
            char base = this.value[start];
            if (base >= '\ud800' && base <= '\udbff' && start != end && start != count && this.value[start + 1] >= '\udc00' && this.value[start + 1] <= '\udfff') {
                ++start;
            }
            ++start;
            ++count;
        }
        return count;
    }

    public int offsetByCodePoints(int start, int codePoints) {
        while (codePoints > 0) {
            char base = this.value[start];
            if (base >= '\ud800' && base <= '\udbff' && start != this.count && this.value[start + 1] >= '\udc00' && this.value[start + 1] <= '\udfff') {
                ++start;
            }
            ++start;
            --codePoints;
        }
        return start;
    }

    void ensureCapacity_unsynchronized(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            int max = this.value.length * 2 + 2;
            minimumCapacity = minimumCapacity < max ? max : minimumCapacity;
            char[] nb = new char[minimumCapacity];
            System.arraycopy(this.value, 0, nb, 0, this.count);
            this.value = nb;
        }
    }

    private native boolean regionMatches(int var1, String var2);
}

