/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class Math {
    private static Random rand;
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;

    private Math() {
    }

    public static int abs(int i) {
        return i < 0 ? -i : i;
    }

    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static float abs(float f) {
        return f <= 0.0f ? 0.0f - f : f;
    }

    public static double abs(double d) {
        return d <= 0.0 ? 0.0 - d : d;
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static long min(long a, long b) {
        return a < b ? a : b;
    }

    public static float min(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f) {
            return -(-a - b);
        }
        return a < b ? a : b;
    }

    public static double min(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0) {
            return -(-a - b);
        }
        return a < b ? a : b;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static long max(long a, long b) {
        return a > b ? a : b;
    }

    public static float max(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f) {
            return a - -b;
        }
        return a > b ? a : b;
    }

    public static double max(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0) {
            return a - -b;
        }
        return a > b ? a : b;
    }

    public static native double sin(double var0);

    public static native double cos(double var0);

    public static native double tan(double var0);

    public static native double asin(double var0);

    public static native double acos(double var0);

    public static native double atan(double var0);

    public static native double atan2(double var0, double var2);

    public static native double exp(double var0);

    public static native double log(double var0);

    public static native double sqrt(double var0);

    public static native double pow(double var0, double var2);

    public static native double IEEEremainder(double var0, double var2);

    public static native double ceil(double var0);

    public static native double floor(double var0);

    public static native double rint(double var0);

    public static int round(float a) {
        if (a != a) {
            return 0;
        }
        return (int)Math.floor(a + 0.5f);
    }

    public static long round(double a) {
        if (a != a) {
            return 0L;
        }
        return (long)Math.floor(a + 0.5);
    }

    public static synchronized double random() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextDouble();
    }

    public static double toRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static double toDegrees(double rads) {
        return rads * 180.0 / Math.PI;
    }

    public static native double cbrt(double var0);

    public static native double cosh(double var0);

    public static native double expm1(double var0);

    public static native double hypot(double var0, double var2);

    public static native double log10(double var0);

    public static native double log1p(double var0);

    public static double signum(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (a > 0.0) {
            return 1.0;
        }
        if (a < 0.0) {
            return -1.0;
        }
        return a;
    }

    public static float signum(float a) {
        if (Float.isNaN(a)) {
            return Float.NaN;
        }
        if (a > 0.0f) {
            return 1.0f;
        }
        if (a < 0.0f) {
            return -1.0f;
        }
        return a;
    }

    public static native double sinh(double var0);

    public static native double tanh(double var0);

    public static double ulp(double d) {
        long newMantissa;
        if (Double.isNaN(d)) {
            return d;
        }
        if (Double.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == 0.0) {
            return Double.MIN_VALUE;
        }
        long bits = Double.doubleToLongBits(d);
        long exponent = bits >>> 52 & 0x7FFL;
        if (exponent == 0L) {
            long result = exponent << 52 | 1L;
            return Double.longBitsToDouble(result);
        }
        long newExponent = exponent - 52L;
        if (newExponent > 0L) {
            newMantissa = 0L;
        } else {
            newMantissa = 1L << (int)(-(newExponent - 1L));
            newExponent = 0L;
        }
        return Double.longBitsToDouble(newExponent << 52 | newMantissa);
    }

    public static float ulp(float f) {
        int newMantissa;
        if (Float.isNaN(f)) {
            return f;
        }
        if (Float.isInfinite(f)) {
            return Float.POSITIVE_INFINITY;
        }
        if ((double)f == 0.0) {
            return Float.MIN_VALUE;
        }
        int bits = Float.floatToIntBits(f);
        int exponent = bits >>> 23 & 0xFF;
        if (exponent == 0) {
            int result = exponent << 23 | 1;
            return Float.intBitsToFloat(result);
        }
        int newExponent = exponent - 23;
        if (newExponent > 0) {
            newMantissa = 0;
        } else {
            newMantissa = 1 << -(newExponent - 1);
            newExponent = 0;
        }
        return Float.intBitsToFloat(newExponent << 23 | newMantissa);
    }
}

