/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.ResolverCache;
import java.net.UnknownHostException;
import java.net.VMInetAddress;

public class InetAddress
implements Serializable {
    private static final long serialVersionUID = 3286316764910316507L;
    static InetAddress ANY_IF;
    static InetAddress LOCALHOST;
    private int address;
    transient byte[] addr;
    String hostName;
    private int family;

    static {
        byte[] addr;
        try {
            addr = VMInetAddress.lookupInaddrAny();
        }
        catch (UnknownHostException unknownHostException) {
            addr = new byte[4];
        }
        try {
            ANY_IF = InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            throw (InternalError)new InternalError().initCause(e);
        }
        InetAddress.ANY_IF.hostName = ANY_IF.getHostName();
        try {
            byte[] byArray = new byte[4];
            byArray[0] = 127;
            byArray[3] = 1;
            LOCALHOST = InetAddress.getByAddress("localhost", byArray);
        }
        catch (UnknownHostException e) {
            throw (InternalError)new InternalError().initCause(e);
        }
    }

    InetAddress(byte[] ipaddr, String hostname, int family) {
        this.addr = ipaddr == null ? null : (byte[])ipaddr.clone();
        this.hostName = hostname;
        this.family = family;
    }

    public boolean isMulticastAddress() {
        throw new UnsupportedOperationException();
    }

    public boolean isAnyLocalAddress() {
        throw new UnsupportedOperationException();
    }

    public boolean isLoopbackAddress() {
        throw new UnsupportedOperationException();
    }

    public boolean isLinkLocalAddress() {
        throw new UnsupportedOperationException();
    }

    public boolean isSiteLocalAddress() {
        throw new UnsupportedOperationException();
    }

    public boolean isMCGlobal() {
        throw new UnsupportedOperationException();
    }

    public boolean isMCNodeLocal() {
        throw new UnsupportedOperationException();
    }

    public boolean isMCLinkLocal() {
        throw new UnsupportedOperationException();
    }

    public boolean isMCSiteLocal() {
        throw new UnsupportedOperationException();
    }

    public boolean isMCOrgLocal() {
        throw new UnsupportedOperationException();
    }

    public String getHostName() {
        if (this.hostName == null) {
            this.hostName = this.getCanonicalHostName();
        }
        return this.hostName;
    }

    String internalGetCanonicalHostName() {
        try {
            return ResolverCache.getHostByAddr(this.addr);
        }
        catch (UnknownHostException unknownHostException) {
            return this.getHostAddress();
        }
    }

    public String getCanonicalHostName() {
        String hostname = this.internalGetCanonicalHostName();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkConnect(hostname, -1);
            }
            catch (SecurityException securityException) {
                return this.getHostAddress();
            }
        }
        return hostname;
    }

    public byte[] getAddress() {
        return (byte[])this.addr.clone();
    }

    public String getHostAddress() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int hash = 0;
        int len = this.addr.length;
        int i = len > 4 ? len - 4 : 0;
        while (i < len) {
            hash = hash << 8 | this.addr[i] & 0xFF;
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InetAddress)) {
            return false;
        }
        byte[] addr2 = ((InetAddress)obj).addr;
        if (this.addr.length != addr2.length) {
            return false;
        }
        int i = 0;
        while (i < this.addr.length) {
            if (this.addr[i] != addr2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String addr = this.getHostAddress();
        String host = this.hostName != null ? this.hostName : "";
        return String.valueOf(host) + "/" + addr;
    }

    public static InetAddress getByAddress(byte[] addr) throws UnknownHostException {
        return InetAddress.getByAddress(null, addr);
    }

    public static InetAddress getByAddress(String host, byte[] addr) throws UnknownHostException {
        if (addr.length == 4) {
            return new Inet4Address(addr, host);
        }
        if (addr.length == 16) {
            int i = 0;
            while (i < 12) {
                if (addr[i] != (i < 10 ? (byte)0 : -1)) {
                    return new Inet6Address(addr, host);
                }
                ++i;
            }
            byte[] ip4addr = new byte[]{addr[12], addr[13], addr[14], addr[15]};
            return new Inet4Address(ip4addr, host);
        }
        throw new UnknownHostException("IP address has illegal length");
    }

    static InetAddress getByLiteral(String literal) {
        byte[] address = VMInetAddress.aton(literal);
        if (address == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            throw (InternalError)new InternalError().initCause(e);
        }
    }

    public static InetAddress getByName(String hostname) throws UnknownHostException {
        InetAddress[] addresses = InetAddress.getAllByName(hostname);
        return addresses[0];
    }

    public static InetAddress[] getAllByName(String hostname) throws UnknownHostException {
        byte[][] iplist;
        if (hostname == null || hostname.length() == 0) {
            return new InetAddress[]{LOCALHOST};
        }
        InetAddress address = InetAddress.getByLiteral(hostname);
        if (address != null) {
            return new InetAddress[]{address};
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(hostname, -1);
        }
        if ((iplist = ResolverCache.getHostByName(hostname)).length == 0) {
            throw new UnknownHostException(hostname);
        }
        InetAddress[] addresses = new InetAddress[iplist.length];
        int i = 0;
        while (i < iplist.length) {
            addresses[i] = InetAddress.getByAddress(hostname, iplist[i]);
            ++i;
        }
        return addresses;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        String hostname = VMInetAddress.getLocalHostname();
        try {
            return InetAddress.getByName(hostname);
        }
        catch (SecurityException securityException) {
            return LOCALHOST;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.addr, this.hostName);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.addr = new byte[4];
        this.addr[3] = (byte)this.address;
        int i = 2;
        while (i >= 0) {
            this.addr[i] = (byte)(this.address >>= 8);
            --i;
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int len = this.addr.length;
        int i = len - 4;
        while (i < len) {
            this.address = this.address << 8 | this.addr[i] & 0xFF;
            ++i;
        }
        oos.defaultWriteObject();
    }
}

