/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TimerTask;

public class Timer {
    private static int nr;
    private TaskQueue queue = new TaskQueue();
    private Scheduler scheduler = new Scheduler(this.queue);
    private Thread thread;
    private boolean canceled = false;

    public Timer() {
        this(false);
    }

    public Timer(boolean daemon) {
        this(daemon, 5);
    }

    public Timer(String name) {
        this(false, 5, name);
    }

    public Timer(String name, boolean daemon) {
        this(daemon, 5, name);
    }

    private Timer(boolean daemon, int priority) {
        this(daemon, priority, "Timer-" + ++nr);
    }

    private Timer(boolean daemon, int priority, String name) {
        this.thread = new Thread(this.scheduler, name);
        this.thread.setDaemon(daemon);
        this.thread.setPriority(priority);
        this.thread.start();
    }

    public void cancel() {
        this.canceled = true;
        this.queue.stop();
    }

    private void schedule(TimerTask task, long time, long period, boolean fixed) {
        if (time < 0L) {
            throw new IllegalArgumentException("negative time");
        }
        if (task.scheduled != 0L || task.lastExecutionTime != -1L) {
            throw new IllegalStateException("task was already scheduled or canceled");
        }
        task.scheduled = time;
        task.period = period;
        task.fixed = fixed;
        if (this.canceled || this.thread == null) {
            throw new IllegalStateException("timer was canceled or scheduler thread has died");
        }
        this.queue.enqueue(task);
    }

    private static void positiveDelay(long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("delay is negative");
        }
    }

    private static void positivePeriod(long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("period is negative");
        }
    }

    public void schedule(TimerTask task, Date date) {
        long time = date.getTime();
        this.schedule(task, time, -1L, false);
    }

    public void schedule(TimerTask task, Date date, long period) {
        Timer.positivePeriod(period);
        long time = date.getTime();
        this.schedule(task, time, period, false);
    }

    public void schedule(TimerTask task, long delay) {
        Timer.positiveDelay(delay);
        long time = System.currentTimeMillis() + delay;
        this.schedule(task, time, -1L, false);
    }

    public void schedule(TimerTask task, long delay, long period) {
        Timer.positiveDelay(delay);
        Timer.positivePeriod(period);
        long time = System.currentTimeMillis() + delay;
        this.schedule(task, time, period, false);
    }

    public void scheduleAtFixedRate(TimerTask task, Date date, long period) {
        Timer.positivePeriod(period);
        long time = date.getTime();
        this.schedule(task, time, period, true);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        Timer.positiveDelay(delay);
        Timer.positivePeriod(period);
        long time = System.currentTimeMillis() + delay;
        this.schedule(task, time, period, true);
    }

    protected void finalize() throws Throwable {
        this.queue.setNullOnEmpty(true);
    }

    public int purge() {
        return this.queue.purge();
    }

    private static final class Scheduler
    implements Runnable {
        private TaskQueue queue;

        public Scheduler(TaskQueue queue) {
            this.queue = queue;
        }

        public void run() {
            TimerTask task;
            while ((task = this.queue.serve()) != null) {
                if (task.scheduled >= 0L) {
                    task.lastExecutionTime = task.scheduled;
                    if (task.period < 0L) {
                        task.scheduled = -1L;
                    }
                    try {
                        task.run();
                    }
                    catch (ThreadDeath death) {
                        this.queue.stop();
                        throw death;
                    }
                    catch (Throwable throwable) {
                        this.queue.stop();
                    }
                }
                if (task.scheduled < 0L) continue;
                task.scheduled = task.fixed ? (task.scheduled += task.period) : task.period + System.currentTimeMillis();
                try {
                    this.queue.enqueue(task);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    private static final class TaskQueue {
        private static final int DEFAULT_SIZE = 32;
        private boolean nullOnEmpty = false;
        private TimerTask[] heap = new TimerTask[32];
        private int elements = 0;

        private void add(TimerTask task) {
            ++this.elements;
            if (this.elements == this.heap.length) {
                TimerTask[] new_heap = new TimerTask[this.heap.length * 2];
                System.arraycopy(this.heap, 0, new_heap, 0, this.heap.length);
                this.heap = new_heap;
            }
            this.heap[this.elements] = task;
        }

        private void remove() {
            this.heap[this.elements] = null;
            --this.elements;
            if (this.elements + 16 <= this.heap.length / 4) {
                TimerTask[] new_heap = new TimerTask[this.heap.length / 2];
                System.arraycopy(this.heap, 0, new_heap, 0, this.elements + 1);
                this.heap = new_heap;
            }
        }

        public synchronized void enqueue(TimerTask task) {
            if (this.heap == null) {
                throw new IllegalStateException("cannot enqueue when stop() has been called on queue");
            }
            this.heap[0] = task;
            this.add(task);
            int child = this.elements;
            int parent = child / 2;
            while (this.heap[parent].scheduled > task.scheduled) {
                this.heap[child] = this.heap[parent];
                child = parent;
                parent = child / 2;
            }
            this.heap[child] = task;
            this.heap[0] = null;
            this.notify();
        }

        private TimerTask top() {
            if (this.elements == 0) {
                return null;
            }
            return this.heap[1];
        }

        public synchronized TimerTask serve() {
            TimerTask task = null;
            while (task == null) {
                task = this.top();
                if (this.heap == null || task == null && this.nullOnEmpty) {
                    return null;
                }
                if (task != null) {
                    long time = task.scheduled - System.currentTimeMillis();
                    if (time <= 0L) continue;
                    task = null;
                    try {
                        this.wait(time);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            TimerTask lastTask = this.heap[this.elements];
            this.remove();
            int parent = 1;
            int child = 2;
            this.heap[1] = lastTask;
            while (child <= this.elements) {
                if (child < this.elements && this.heap[child].scheduled > this.heap[child + 1].scheduled) {
                    ++child;
                }
                if (lastTask.scheduled <= this.heap[child].scheduled) break;
                this.heap[parent] = this.heap[child];
                parent = child;
                child = parent * 2;
            }
            this.heap[parent] = lastTask;
            return task;
        }

        public synchronized void setNullOnEmpty(boolean nullOnEmpty) {
            this.nullOnEmpty = nullOnEmpty;
            this.notify();
        }

        public synchronized void stop() {
            this.heap = null;
            this.elements = 0;
            this.notify();
        }

        public synchronized int purge() {
            int removed = 0;
            int i = this.elements;
            while (i > 0) {
                if (this.heap[i].scheduled < 0L) {
                    ++removed;
                    int index = i;
                    while (this.heap[index] != null) {
                        int child = 2 * index;
                        if (child >= this.heap.length) {
                            this.heap[index] = null;
                            break;
                        }
                        if (child + 1 < this.heap.length && this.heap[child + 1] != null && (this.heap[child] == null || this.heap[child].scheduled > this.heap[child + 1].scheduled)) {
                            ++child;
                        }
                        this.heap[index] = this.heap[child];
                        index = child;
                    }
                }
                --i;
            }
            int newLen = this.heap.length;
            while (this.elements - removed + 16 <= newLen / 4) {
                newLen /= 2;
            }
            if (newLen != this.heap.length) {
                TimerTask[] newHeap = new TimerTask[newLen];
                System.arraycopy(this.heap, 0, newHeap, 0, this.elements + 1);
                this.heap = newHeap;
            }
            return removed;
        }
    }
}

