/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.MenuItemUI;

public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    private static final long serialVersionUID = 4227225638931828014L;
    private JPopupMenu popupMenu = null;
    private MenuEvent menuEvent = new MenuEvent(this);
    private int delay;
    protected WinListener popupListener;
    private Point menuLocation;
    private ChangeListener menuChangeListener;

    public JMenu() {
        this.setOpaque(false);
    }

    public JMenu(String text) {
        super(text);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setInvoker(this);
        this.setOpaque(false);
    }

    public JMenu(Action action) {
        super(action);
        this.createActionChangeListener(this);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setInvoker(this);
        this.setOpaque(false);
    }

    public JMenu(String text, boolean tearoff) {
        this(text);
    }

    public JMenuItem add(JMenuItem item) {
        return this.getPopupMenu().add(item);
    }

    public Component add(Component component) {
        this.getPopupMenu().insert(component, -1);
        return component;
    }

    public Component add(Component component, int index) {
        return this.getPopupMenu().add(component, index);
    }

    public JMenuItem add(String text) {
        return this.add(new JMenuItem(text));
    }

    public JMenuItem add(Action action) {
        JMenuItem i = this.createActionComponent(action);
        i.setAction(action);
        this.add(i);
        return i;
    }

    public void remove(JMenuItem item) {
        this.getPopupMenu().remove(item);
    }

    public void remove(int index) {
        if (index < 0 || index > 0 && this.getMenuComponentCount() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.getMenuComponentCount() > 0) {
            this.popupMenu.remove(index);
        }
    }

    public void remove(Component component) {
        int index = this.getPopupMenu().getComponentIndex(component);
        if (index >= 0) {
            this.getPopupMenu().remove(index);
        }
    }

    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
    }

    public void insert(String text, int index) {
        this.insert(new JMenuItem(text), index);
    }

    public JMenuItem insert(JMenuItem item, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than zero");
        }
        this.getPopupMenu().insert(item, index);
        return item;
    }

    public JMenuItem insert(Action action, int index) {
        JMenuItem item = new JMenuItem(action);
        this.insert(item, index);
        return item;
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "MenuUI";
    }

    public void setModel(ButtonModel model) {
        ButtonModel oldModel = this.getModel();
        if (oldModel != null && this.menuChangeListener != null) {
            oldModel.removeChangeListener(this.menuChangeListener);
        }
        super.setModel(model);
        if (model != null) {
            if (this.menuChangeListener == null) {
                this.menuChangeListener = new MenuChangeListener();
            }
            model.addChangeListener(this.menuChangeListener);
        }
    }

    public boolean isSelected() {
        return super.isSelected();
    }

    public void setSelected(boolean selected) {
        ButtonModel m = this.getModel();
        if (selected != m.isSelected()) {
            m.setSelected(selected);
        }
    }

    public boolean isPopupMenuVisible() {
        return this.getPopupMenu().isVisible();
    }

    public void setPopupMenuVisible(boolean popup) {
        if (popup != this.isPopupMenuVisible() && (this.isEnabled() || !popup)) {
            if (popup && this.isShowing()) {
                Point loc = this.menuLocation == null ? this.getPopupMenuOrigin() : this.menuLocation;
                this.getPopupMenu().show(this, loc.x, loc.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    protected Point getPopupMenuOrigin() {
        Point screenLoc = this.getLocationOnScreen();
        Dimension size = this.getSize();
        JPopupMenu popup = this.getPopupMenu();
        Dimension popupSize = popup.getSize();
        if (popupSize.width == 0 || popupSize.height == 0) {
            popupSize = popup.getPreferredSize();
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Rectangle screenBounds = new Rectangle(tk.getScreenSize());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        Insets screenInsets = tk.getScreenInsets(gc);
        screenBounds.x -= screenInsets.left;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.y -= screenInsets.top;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        screenLoc.x -= screenInsets.left;
        screenLoc.y -= screenInsets.top;
        Point point = new Point();
        if (this.isTopLevelMenu()) {
            int xOffset = UIManager.getInt("Menu.menuPopupOffsetX");
            int yOffset = UIManager.getInt("Menu.menuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                point.x = xOffset;
                if (screenLoc.x + point.x + popupSize.width > screenBounds.width + screenBounds.width && screenBounds.width - size.width < 2 * (screenLoc.x - screenBounds.x)) {
                    point.x = size.width - xOffset - popupSize.width;
                }
            } else {
                point.x = size.width - xOffset - popupSize.width;
                if (screenLoc.x + point.x < screenBounds.x && screenBounds.width - size.width > 2 * (screenLoc.x - screenBounds.x)) {
                    point.x = xOffset;
                }
            }
            point.y = size.height + yOffset;
            if (screenLoc.y + point.y + popupSize.height >= screenBounds.height && screenBounds.height - size.height < 2 * (screenLoc.y - screenBounds.y)) {
                point.y = -yOffset - popupSize.height;
            }
        } else {
            int xOffset = UIManager.getInt("Menu.submenuPopupOffsetX");
            int yOffset = UIManager.getInt("Menu.submenuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                point.x = size.width + xOffset;
                if (screenLoc.x + point.x + popupSize.width >= screenBounds.x + screenBounds.width && screenBounds.width - size.width < 2 * (screenLoc.x - screenBounds.x)) {
                    point.x = -xOffset - popupSize.width;
                }
            } else {
                point.x = -xOffset - popupSize.width;
                if (screenLoc.x + point.x < screenBounds.x && screenBounds.width - size.width > 2 * (screenLoc.x - screenBounds.x)) {
                    point.x = size.width + xOffset;
                }
            }
            point.y = yOffset;
            if (screenLoc.y + point.y + popupSize.height >= screenBounds.y + screenBounds.height && screenBounds.height - size.height < 2 * (screenLoc.y - screenBounds.y)) {
                point.y = size.height - yOffset - popupSize.height;
            }
        }
        return point;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("delay less than 0");
        }
        this.delay = delay;
    }

    public void setMenuLocation(int x, int y) {
        this.menuLocation = new Point(x, y);
        if (this.popupMenu != null) {
            this.popupMenu.setLocation(x, y);
        }
    }

    protected JMenuItem createActionComponent(Action action) {
        return new JMenuItem(action);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem item) {
        return new ActionChangedListener(item);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void insertSeparator(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        this.getPopupMenu().insert(new JPopupMenu.Separator(), index);
    }

    public JMenuItem getItem(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        if (this.getItemCount() == 0) {
            return null;
        }
        Component c = this.popupMenu.getComponentAtIndex(index);
        if (c instanceof JMenuItem) {
            return (JMenuItem)c;
        }
        return null;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public boolean isTearOff() {
        throw new Error("The method isTearOff() has not yet been implemented.");
    }

    public int getMenuComponentCount() {
        return this.getPopupMenu().getComponentCount();
    }

    public Component getMenuComponent(int index) {
        if (this.getPopupMenu() == null || this.getMenuComponentCount() == 0) {
            return null;
        }
        return this.popupMenu.getComponentAtIndex(index);
    }

    public Component[] getMenuComponents() {
        return this.getPopupMenu().getComponents();
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component component) {
        return false;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setInvoker(this);
        }
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener listener) {
        this.listenerList.add(MenuListener.class, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.listenerList.remove(MenuListener.class, listener);
    }

    public MenuListener[] getMenuListeners() {
        return (MenuListener[])this.listenerList.getListeners(MenuListener.class);
    }

    protected void fireMenuSelected() {
        MenuListener[] listeners = this.getMenuListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].menuSelected(this.menuEvent);
            ++index;
        }
    }

    protected void fireMenuDeselected() {
        EventListener[] ll = this.listenerList.getListeners(MenuListener.class);
        int i = 0;
        while (i < ll.length) {
            ((MenuListener)ll[i]).menuDeselected(this.menuEvent);
            ++i;
        }
    }

    protected void fireMenuCanceled() {
        EventListener[] ll = this.listenerList.getListeners(MenuListener.class);
        int i = 0;
        while (i < ll.length) {
            ((MenuListener)ll[i]).menuCanceled(this.menuEvent);
            ++i;
        }
    }

    protected WinListener createWinListener(JPopupMenu popup) {
        return new WinListener(popup);
    }

    public void menuSelectionChanged(boolean changed) {
        this.setSelected(changed);
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[]{this.popupMenu};
    }

    public Component getComponent() {
        return this;
    }

    public void setAccelerator(KeyStroke keystroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    protected void processKeyEvent(KeyEvent event) {
        MenuSelectionManager.defaultManager().processKeyEvent(event);
    }

    public void doClick(int time) {
        this.getModel().setArmed(true);
        this.getModel().setPressed(true);
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {}
        this.getModel().setPressed(false);
        this.getModel().setArmed(false);
        this.popupMenu.show(this, this.getWidth(), 0);
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu();
        }
        return this.accessibleContext;
    }

    MenuElement[] createPath(JMenu leaf) {
        ArrayList<JComponent> path = new ArrayList<JComponent>();
        MenuElement[] array = null;
        Component current = leaf.getPopupMenu();
        while (true) {
            if (current instanceof JPopupMenu) {
                JPopupMenu popupMenu = current;
                path.add(0, popupMenu);
                current = popupMenu.getInvoker();
                continue;
            }
            if (current instanceof JMenu) {
                JMenu menu = (JMenu)current;
                path.add(0, menu);
                current = menu.getParent();
                continue;
            }
            if (current instanceof JMenuBar) break;
        }
        JMenuBar menuBar = (JMenuBar)current;
        path.add(0, menuBar);
        array = new MenuElement[path.size()];
        array = path.toArray(array);
        return array;
    }

    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        private static final long serialVersionUID = -8131864021059524309L;

        protected AccessibleJMenu() {
        }

        public int getAccessibleChildrenCount() {
            Component[] children = JMenu.this.getMenuComponents();
            int count = 0;
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Accessible) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        public Accessible getAccessibleChild(int index) {
            Component[] children = JMenu.this.getMenuComponents();
            int count = 0;
            Accessible found = null;
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Accessible) {
                    if (count == index) {
                        found = (Accessible)((Object)children[i]);
                        break;
                    }
                    ++count;
                }
                ++i;
            }
            return found;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int index) {
            MenuSelectionManager msm;
            MenuElement[] me;
            Accessible selected = null;
            if (index == 0 && (me = (msm = MenuSelectionManager.defaultManager()).getSelectedPath()) != null) {
                int i = 0;
                while (i < me.length) {
                    if (me[i] == JMenu.this) {
                        do {
                            if (!(me[i] instanceof Accessible)) continue;
                            selected = (Accessible)((Object)me[i]);
                            break;
                        } while (++i < me.length);
                    }
                    if (selected != null) break;
                    ++i;
                }
            }
            return selected;
        }

        public boolean isAccessibleChildSelected(int index) {
            boolean selected = false;
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] me = msm.getSelectedPath();
            if (me != null) {
                Accessible toBeFound = this.getAccessibleChild(index);
                int i = 0;
                while (i < me.length) {
                    if (me[i] == toBeFound) {
                        selected = true;
                        break;
                    }
                    ++i;
                }
            }
            return selected;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public int getAccessibleSelectionCount() {
            int count = 0;
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] me = msm.getSelectedPath();
            if (me != null) {
                int i = 0;
                while (i < me.length) {
                    if (me[i] == JMenu.this && i + 1 < me.length) {
                        count = 1;
                        break;
                    }
                    ++i;
                }
            }
            return count;
        }

        public void addAccessibleSelection(int index) {
            Accessible child = this.getAccessibleChild(index);
            if (child != null && child instanceof JMenuItem) {
                JMenuItem cfr_ignored_0 = (JMenuItem)child;
                MenuSelectionManager msm = MenuSelectionManager.defaultManager();
                msm.setSelectedPath(JMenu.this.createPath(JMenu.this));
            }
        }

        public void removeAccessibleSelection(int index) {
            Accessible child = this.getAccessibleChild(index);
            if (child != null) {
                MenuSelectionManager msm = MenuSelectionManager.defaultManager();
                MenuElement[] oldSelection = msm.getSelectedPath();
                int i = 0;
                while (i < oldSelection.length) {
                    if (oldSelection[i] == child) {
                        MenuElement[] newSel = new MenuElement[i - 1];
                        System.arraycopy(oldSelection, 0, newSel, 0, i - 1);
                        msm.setSelectedPath(newSel);
                        break;
                    }
                    ++i;
                }
            }
        }

        public void clearAccessibleSelection() {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] oldSelection = msm.getSelectedPath();
            int i = 0;
            while (i < oldSelection.length) {
                if (oldSelection[i] == JMenu.this) {
                    MenuElement[] newSel = new MenuElement[i];
                    System.arraycopy(oldSelection, 0, newSel, 0, i);
                    msm.setSelectedPath(newSel);
                    break;
                }
                ++i;
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        private JMenuItem menuItem;

        public ActionChangedListener(JMenuItem menuItem) {
            this.menuItem = menuItem;
            Action a = menuItem.getAction();
            if (a != null) {
                a.addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    private class MenuChangeListener
    implements ChangeListener {
        private boolean selected;

        private MenuChangeListener() {
        }

        public void stateChanged(ChangeEvent ev) {
            ButtonModel m = (ButtonModel)ev.getSource();
            boolean s = m.isSelected();
            if (s != this.selected) {
                if (s) {
                    JMenu.this.fireMenuSelected();
                } else {
                    JMenu.this.fireMenuDeselected();
                }
                this.selected = s;
            }
        }
    }

    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        private static final long serialVersionUID = -6415815570638474823L;

        public WinListener(JPopupMenu popup) {
        }

        public void windowClosing(WindowEvent event) {
            JMenu.this.setSelected(false);
        }
    }
}

