/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ScrollPaneLayout
implements LayoutManager,
ScrollPaneConstants,
Serializable {
    private static final long serialVersionUID = -4480022884523193743L;
    protected JViewport viewport;
    protected JScrollBar vsb;
    protected JScrollBar hsb;
    protected JViewport rowHead;
    protected JViewport colHead;
    protected Component lowerLeft;
    protected Component lowerRight;
    protected Component upperLeft;
    protected Component upperRight;
    protected int vsbPolicy;
    protected int hsbPolicy;

    public void syncWithScrollPane(JScrollPane scrollPane) {
        this.viewport = scrollPane.getViewport();
        this.rowHead = scrollPane.getRowHeader();
        this.colHead = scrollPane.getColumnHeader();
        this.vsb = scrollPane.getVerticalScrollBar();
        this.hsb = scrollPane.getHorizontalScrollBar();
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        this.lowerLeft = scrollPane.getCorner("LOWER_LEFT_CORNER");
        this.lowerRight = scrollPane.getCorner("LOWER_RIGHT_CORNER");
        this.upperLeft = scrollPane.getCorner("UPPER_LEFT_CORNER");
        this.upperRight = scrollPane.getCorner("UPPER_RIGHT_CORNER");
    }

    protected Component addSingletonComponent(Component oldComponent, Component newComponent) {
        if (oldComponent != null && oldComponent != newComponent) {
            oldComponent.getParent().remove(oldComponent);
        }
        return newComponent;
    }

    public void addLayoutComponent(String key, Component component) {
        if (key == "VIEWPORT") {
            this.viewport = (JViewport)component;
        } else if (key == "VERTICAL_SCROLLBAR") {
            this.vsb = (JScrollBar)component;
        } else if (key == "HORIZONTAL_SCROLLBAR") {
            this.hsb = (JScrollBar)component;
        } else if (key == "ROW_HEADER") {
            this.rowHead = (JViewport)component;
        } else if (key == "COLUMN_HEADER") {
            this.colHead = (JViewport)component;
        } else if (key == "LOWER_RIGHT_CORNER") {
            this.lowerRight = component;
        } else if (key == "UPPER_RIGHT_CORNER") {
            this.upperRight = component;
        } else if (key == "LOWER_LEFT_CORNER") {
            this.lowerLeft = component;
        } else if (key == "UPPER_LEFT_CORNER") {
            this.upperLeft = component;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.viewport) {
            this.viewport = null;
        } else if (component == this.vsb) {
            this.vsb = null;
        } else if (component == this.hsb) {
            this.hsb = null;
        } else if (component == this.rowHead) {
            this.rowHead = null;
        } else if (component == this.colHead) {
            this.colHead = null;
        } else if (component == this.lowerRight) {
            this.lowerRight = null;
        } else if (component == this.upperRight) {
            this.upperRight = null;
        } else if (component == this.lowerLeft) {
            this.lowerLeft = null;
        } else if (component == this.upperLeft) {
            this.upperLeft = null;
        }
    }

    public int getVerticalScrollBarPolicy() {
        return this.vsbPolicy;
    }

    public void setVerticalScrollBarPolicy(int policy) {
        if (policy != 20 && policy != 21 && policy != 22) {
            throw new IllegalArgumentException("Illegal Scrollbar Policy");
        }
        this.vsbPolicy = policy;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.hsbPolicy;
    }

    public void setHorizontalScrollBarPolicy(int policy) {
        if (policy != 30 && policy != 31 && policy != 32) {
            throw new IllegalArgumentException("Illegal Scrollbar Policy");
        }
        this.hsbPolicy = policy;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.hsb;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.vsb;
    }

    public JViewport getRowHeader() {
        return this.rowHead;
    }

    public JViewport getColumnHeader() {
        return this.colHead;
    }

    public Component getCorner(String key) {
        if (key == "LOWER_RIGHT_CORNER") {
            return this.lowerRight;
        }
        if (key == "UPPER_RIGHT_CORNER") {
            return this.upperRight;
        }
        if (key == "LOWER_LEFT_CORNER") {
            return this.lowerLeft;
        }
        if (key == "UPPER_LEFT_CORNER") {
            return this.upperLeft;
        }
        return null;
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets i;
        Border vpBorder;
        JScrollPane sc = (JScrollPane)parent;
        Dimension viewportSize = this.viewport.getPreferredSize();
        Dimension viewSize = this.viewport.getViewSize();
        int width = viewportSize.width;
        int height = viewportSize.height;
        if (this.hsb != null && viewSize.width > viewportSize.width) {
            height += this.hsb.getPreferredSize().height;
        }
        if (this.vsb != null && viewSize.height > viewportSize.height) {
            width += this.vsb.getPreferredSize().width;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            width += this.rowHead.getPreferredSize().width;
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            height += this.colHead.getPreferredSize().height;
        }
        if ((vpBorder = sc.getViewportBorder()) != null) {
            i = vpBorder.getBorderInsets(sc);
            width += i.left + i.right;
            height += i.top + i.bottom;
        }
        i = sc.getInsets();
        return new Dimension(width + i.left + i.right, height + i.left + i.right);
    }

    public Dimension minimumLayoutSize(Container parent) {
        Border vpBorder;
        JScrollPane sc = (JScrollPane)parent;
        Insets i = sc.getInsets();
        Dimension viewportMinSize = sc.getViewport().getMinimumSize();
        int width = i.left + i.right + viewportMinSize.width;
        if (sc.getVerticalScrollBarPolicy() != 21) {
            width += sc.getVerticalScrollBar().getMinimumSize().width;
        }
        int height = i.top + i.bottom + viewportMinSize.height;
        if (sc.getHorizontalScrollBarPolicy() != 31) {
            height += sc.getHorizontalScrollBar().getMinimumSize().height;
        }
        if ((vpBorder = sc.getViewportBorder()) != null) {
            i = vpBorder.getBorderInsets(sc);
            width += i.left + i.right;
            height += i.top + i.bottom;
        }
        return new Dimension(width, height);
    }

    public void layoutContainer(Container parent) {
        boolean showHsb;
        boolean showVsb;
        JScrollPane sc = (JScrollPane)parent;
        JViewport viewport = sc.getViewport();
        Component view = viewport.getView();
        if (view == null) {
            return;
        }
        Dimension viewSize = viewport.getView().getPreferredSize();
        int x1 = 0;
        int x2 = 0;
        int x3 = 0;
        int x4 = 0;
        int y1 = 0;
        int y2 = 0;
        int y3 = 0;
        int y4 = 0;
        Rectangle scrollPaneBounds = SwingUtilities.calculateInnerArea(sc, null);
        Border vpBorder = sc.getViewportBorder();
        Insets vpi = vpBorder != null ? vpBorder.getBorderInsets(sc) : new Insets(0, 0, 0, 0);
        x1 = scrollPaneBounds.x;
        y1 = scrollPaneBounds.y;
        x4 = scrollPaneBounds.x + scrollPaneBounds.width;
        y4 = scrollPaneBounds.y + scrollPaneBounds.height;
        y2 = this.colHead != null ? y1 + this.colHead.getPreferredSize().height : y1;
        x2 = this.rowHead != null ? x1 + this.rowHead.getPreferredSize().width : x1;
        int vsbPolicy = sc.getVerticalScrollBarPolicy();
        int hsbPolicy = sc.getHorizontalScrollBarPolicy();
        int vsWidth = 0;
        int hsHeight = 0;
        boolean bl = showVsb = this.vsb != null && (vsbPolicy == 22 || vsbPolicy == 20 && viewSize.height > y4 - y2);
        if (showVsb) {
            vsWidth = this.vsb.getPreferredSize().width;
        }
        boolean bl2 = showHsb = this.hsb != null && (hsbPolicy == 32 || hsbPolicy == 30 && viewSize.width > x4 - x2 - vsWidth);
        if (showHsb) {
            hsHeight = this.hsb.getPreferredSize().height;
        }
        if (!showVsb) {
            boolean bl3 = showVsb = this.vsb != null && (vsbPolicy == 22 || vsbPolicy == 20 && viewSize.height > y4 - y2);
            if (showVsb) {
                vsWidth = this.vsb.getPreferredSize().width;
            }
        }
        x3 = x4 - vsWidth;
        y3 = y4 - hsHeight;
        if (viewport != null) {
            viewport.setBounds(new Rectangle(x2 + vpi.left, y2 + vpi.top, x3 - x2 - vpi.left - vpi.right, y3 - y2 - vpi.top - vpi.bottom));
        }
        if (this.colHead != null) {
            this.colHead.setBounds(new Rectangle(x2, y1, x3 - x2, y2 - y1));
        }
        if (this.rowHead != null) {
            this.rowHead.setBounds(new Rectangle(x1, y2, x2 - x1, y3 - y2));
        }
        if (showVsb) {
            this.vsb.setVisible(true);
            this.vsb.setBounds(new Rectangle(x3, y2, x4 - x3, y3 - y2));
        } else if (this.vsb != null) {
            this.vsb.setVisible(false);
        }
        if (showHsb) {
            this.hsb.setVisible(true);
            this.hsb.setBounds(new Rectangle(x2, y3, x3 - x2, y4 - y3));
        } else if (this.hsb != null) {
            this.hsb.setVisible(false);
        }
        if (this.upperLeft != null) {
            this.upperLeft.setBounds(new Rectangle(x1, y1, x2 - x1, y2 - y1));
        }
        if (this.upperRight != null) {
            this.upperRight.setBounds(new Rectangle(x3, y1, x4 - x3, y2 - y1));
        }
        if (this.lowerLeft != null) {
            this.lowerLeft.setBounds(new Rectangle(x1, y3, x2 - x1, y4 - y3));
        }
        if (this.lowerRight != null) {
            this.lowerRight.setBounds(new Rectangle(x3, y3, x4 - x3, y4 - y3));
        }
    }

    public Rectangle getViewportBorderBounds(JScrollPane scrollPane) {
        return null;
    }

    public static class UIResource
    extends ScrollPaneLayout
    implements javax.swing.plaf.UIResource {
    }
}

