/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import javax.swing.AbstractSpinnerModel;

public class SpinnerNumberModel
extends AbstractSpinnerModel
implements Serializable {
    private static final long serialVersionUID = 7279176385485777821L;
    private Number value;
    private Comparable minimum;
    private Comparable maximum;
    private Number stepSize;

    public SpinnerNumberModel() {
        this(new Integer(0), null, null, new Integer(1));
    }

    public SpinnerNumberModel(double value, double minimum, double maximum, double stepSize) {
        this(new Double(value), new Double(minimum), new Double(maximum), new Double(stepSize));
    }

    public SpinnerNumberModel(int value, int minimum, int maximum, int stepSize) {
        this(new Integer(value), new Integer(minimum), new Integer(maximum), new Integer(stepSize));
    }

    public SpinnerNumberModel(Number value, Comparable minimum, Comparable maximum, Number stepSize) {
        if (stepSize == null) {
            throw new IllegalArgumentException("stepSize may not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value may not be null");
        }
        if (minimum != null && minimum.compareTo(value) > 0) {
            throw new IllegalArgumentException("minimum is not <= value");
        }
        if (maximum != null && maximum.compareTo(value) < 0) {
            throw new IllegalArgumentException("maximum is not >= value");
        }
        this.value = value;
        this.stepSize = stepSize;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public void setValue(Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("value must be a Number");
        }
        if (!this.value.equals(value)) {
            this.value = (Number)value;
            this.fireStateChanged();
        }
    }

    public Object getValue() {
        return this.value;
    }

    public Object getNextValue() {
        Number num = this.value instanceof Double ? (Number)new Double(this.value.doubleValue() + this.stepSize.doubleValue()) : (Number)(this.value instanceof Float ? (Number)new Double(this.value.floatValue() + this.stepSize.floatValue()) : (Number)(this.value instanceof Long ? (Number)new Long(this.value.longValue() + this.stepSize.longValue()) : (Number)(this.value instanceof Integer ? (Number)new Integer(this.value.intValue() + this.stepSize.intValue()) : (Number)(this.value instanceof Short ? (Number)new Short((short)(this.value.shortValue() + this.stepSize.shortValue())) : (Number)new Byte((byte)(this.value.byteValue() + this.stepSize.byteValue()))))));
        if (this.maximum != null && this.maximum.compareTo(num) < 0) {
            num = null;
        }
        return num;
    }

    public Object getPreviousValue() {
        Number num = this.value instanceof Double ? (Number)new Double(this.value.doubleValue() - this.stepSize.doubleValue()) : (Number)(this.value instanceof Float ? (Number)new Double(this.value.floatValue() - this.stepSize.floatValue()) : (Number)(this.value instanceof Long ? (Number)new Long(this.value.longValue() - this.stepSize.longValue()) : (Number)(this.value instanceof Integer ? (Number)new Integer(this.value.intValue() - this.stepSize.intValue()) : (Number)(this.value instanceof Short ? (Number)new Short((short)(this.value.shortValue() - this.stepSize.shortValue())) : (Number)new Byte((byte)(this.value.byteValue() - this.stepSize.byteValue()))))));
        if (this.minimum != null && this.minimum.compareTo(num) > 0) {
            num = null;
        }
        return num;
    }

    public Number getNumber() {
        return this.value;
    }

    public Comparable getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Comparable newMinimum) {
        if (this.minimum != null ? !this.minimum.equals(newMinimum) : newMinimum != null) {
            this.minimum = newMinimum;
            this.fireStateChanged();
        }
    }

    public Comparable getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Comparable newMaximum) {
        if (this.maximum != null ? !this.maximum.equals(newMaximum) : newMaximum != null) {
            this.maximum = newMaximum;
            this.fireStateChanged();
        }
    }

    public Number getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(Number newStepSize) {
        if (newStepSize == null) {
            throw new IllegalArgumentException();
        }
        if (!this.stepSize.equals(newStepSize)) {
            this.stepSize = newStepSize;
            this.fireStateChanged();
        }
    }
}

