/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Spring;

public class SpringLayout
implements LayoutManager2 {
    public static final String EAST = "East";
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String WEST = "West";
    private Map constraintsMap = new HashMap();

    public void addLayoutComponent(Component component, Object constraint) {
        this.constraintsMap.put(component, constraint);
    }

    public void addLayoutComponent(String name, Component c) {
    }

    public Spring getConstraint(String edgeName, Component c) {
        return new DeferredSpring(this, edgeName, c);
    }

    public Constraints getConstraints(Component c) {
        Constraints constraints = (Constraints)this.constraintsMap.get(c);
        if (constraints == null) {
            constraints = new Constraints();
            constraints.setWidth(new DeferredWidth(c));
            constraints.setHeight(new DeferredHeight(c));
            constraints.setX(Spring.constant(0));
            constraints.setY(Spring.constant(0));
            this.constraintsMap.put(c, constraints);
        }
        return constraints;
    }

    public float getLayoutAlignmentX(Container p) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container p) {
        return 0.0f;
    }

    public void invalidateLayout(Container p) {
    }

    private Constraints initContainer(Container p) {
        Constraints c = this.getConstraints(p);
        c.setX(Spring.constant(0));
        c.setY(Spring.constant(0));
        c.setWidth(null);
        c.setHeight(null);
        if (c.getEast() == null) {
            c.setEast(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
        if (c.getSouth() == null) {
            c.setSouth(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
        return c;
    }

    public void layoutContainer(Container p) {
        Insets insets = p.getInsets();
        Component[] components = p.getComponents();
        Constraints cs = this.initContainer(p);
        cs.dropCalcResult();
        int index = 0;
        while (index < components.length) {
            Component c = components[index];
            this.getConstraints(c).dropCalcResult();
            ++index;
        }
        int offsetX = p.getInsets().left;
        int offsetY = p.getInsets().right;
        cs.getX().setValue(0);
        cs.getY().setValue(0);
        cs.getWidth().setValue(p.getWidth() - offsetX - insets.right);
        cs.getHeight().setValue(p.getHeight() - offsetY - insets.bottom);
        int index2 = 0;
        while (index2 < components.length) {
            Component c = components[index2];
            Constraints constraints = this.getConstraints(c);
            int x = constraints.getX().getValue();
            int y = constraints.getY().getValue();
            int width = constraints.getWidth().getValue();
            int height = constraints.getHeight().getValue();
            c.setBounds(x + offsetX, y + offsetY, width, height);
            ++index2;
        }
    }

    public Dimension maximumLayoutSize(Container p) {
        Insets insets = p.getInsets();
        Constraints cs = this.initContainer(p);
        int maxX = cs.getWidth().getMaximumValue() + insets.left + insets.right;
        int maxY = cs.getHeight().getMaximumValue() + insets.top + insets.bottom;
        return new Dimension(maxX, maxY);
    }

    public Dimension minimumLayoutSize(Container p) {
        Insets insets = p.getInsets();
        Constraints cs = this.initContainer(p);
        int maxX = cs.getWidth().getMinimumValue() + insets.left + insets.right;
        int maxY = cs.getHeight().getMinimumValue() + insets.top + insets.bottom;
        return new Dimension(maxX, maxY);
    }

    public Dimension preferredLayoutSize(Container p) {
        Insets insets = p.getInsets();
        Constraints cs = this.initContainer(p);
        int maxX = cs.getWidth().getPreferredValue() + insets.left + insets.right;
        int maxY = cs.getHeight().getPreferredValue() + insets.top + insets.bottom;
        return new Dimension(maxX, maxY);
    }

    public void putConstraint(String e1, Component c1, int pad, String e2, Component c2) {
        this.putConstraint(e1, c1, Spring.constant(pad), e2, c2);
    }

    public void putConstraint(String e1, Component c1, Spring s, String e2, Component c2) {
        Constraints constraints1 = this.getConstraints(c1);
        Spring otherEdge = this.getConstraint(e2, c2);
        constraints1.setConstraint(e1, Spring.sum(s, otherEdge));
    }

    public void removeLayoutComponent(Component c) {
    }

    public static class Constraints {
        private Spring x;
        private Spring y;
        private Spring height;
        private Spring width;
        private Spring east;
        private Spring south;
        private Spring v;
        private Spring h;

        public Constraints() {
            this.h = null;
            this.v = null;
            this.south = null;
            this.east = null;
            this.width = null;
            this.height = null;
            this.y = null;
            this.x = null;
        }

        public Constraints(Spring x, Spring y) {
            this.x = x;
            this.y = y;
            this.h = null;
            this.v = null;
            this.south = null;
            this.east = null;
            this.height = null;
            this.width = null;
        }

        public Constraints(Spring x, Spring y, Spring width, Spring height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.h = null;
            this.v = null;
            this.south = null;
            this.east = null;
        }

        public Constraints(Component component) {
            this(Spring.constant(component.getX()), Spring.constant(component.getY()), Spring.width(component), Spring.height(component));
        }

        public Spring getConstraint(String edgeName) {
            Spring retVal = null;
            if (edgeName.equals(SpringLayout.NORTH)) {
                retVal = this.getY();
            } else if (edgeName.equals(SpringLayout.WEST)) {
                retVal = this.getX();
            } else if (edgeName.equals(SpringLayout.SOUTH)) {
                retVal = this.getSouth();
            } else if (edgeName.equals(SpringLayout.EAST)) {
                retVal = this.getEast();
            }
            return retVal;
        }

        public Spring getHeight() {
            if (this.height != null) {
                return this.height;
            }
            if (this.v == null && this.y != null && this.south != null) {
                this.v = Spring.sum(this.south, Spring.minus(this.y));
            }
            return this.v;
        }

        public Spring getWidth() {
            if (this.width != null) {
                return this.width;
            }
            if (this.h == null && this.x != null && this.east != null) {
                this.h = Spring.sum(this.east, Spring.minus(this.x));
            }
            return this.h;
        }

        public Spring getX() {
            if (this.x != null) {
                return this.x;
            }
            if (this.h == null && this.width != null && this.east != null) {
                this.h = Spring.sum(this.east, Spring.minus(this.width));
            }
            return this.h;
        }

        public Spring getY() {
            if (this.y != null) {
                return this.y;
            }
            if (this.v == null && this.height != null && this.south != null) {
                this.v = Spring.sum(this.south, Spring.minus(this.height));
            }
            return this.v;
        }

        public Spring getSouth() {
            if (this.south != null) {
                return this.south;
            }
            if (this.v == null && this.height != null && this.y != null) {
                this.v = Spring.sum(this.y, this.height);
            }
            return this.v;
        }

        public Spring getEast() {
            if (this.east != null) {
                return this.east;
            }
            if (this.h == null && this.width != null && this.x != null) {
                this.h = Spring.sum(this.x, this.width);
            }
            return this.h;
        }

        public void setConstraint(String edgeName, Spring s) {
            if (edgeName.equals(SpringLayout.WEST)) {
                this.setX(s);
            } else if (edgeName.equals(SpringLayout.NORTH)) {
                this.setY(s);
            } else if (edgeName.equals(SpringLayout.EAST)) {
                this.setEast(s);
            } else if (edgeName.equals(SpringLayout.SOUTH)) {
                this.setSouth(s);
            }
        }

        public void setHeight(Spring s) {
            this.height = s;
            this.v = null;
            if (this.south != null && this.y != null && this.height != null) {
                this.south = null;
            }
        }

        public void setWidth(Spring s) {
            this.width = s;
            this.h = null;
            if (this.east != null && this.x != null && this.width != null) {
                this.east = null;
            }
        }

        public void setX(Spring s) {
            this.x = s;
            this.h = null;
            if (this.width != null && this.east != null && this.x != null) {
                this.width = null;
            }
        }

        public void setY(Spring s) {
            this.y = s;
            this.v = null;
            if (this.height != null && this.south != null && this.y != null) {
                this.height = null;
            }
        }

        public void setSouth(Spring s) {
            this.south = s;
            this.v = null;
            if (this.height != null && this.south != null && this.y != null) {
                this.y = null;
            }
        }

        public void setEast(Spring s) {
            this.east = s;
            this.h = null;
            if (this.width != null && this.east != null && this.x != null) {
                this.x = null;
            }
        }

        public void dropCalcResult() {
            if (this.x != null) {
                this.x.setValue(Integer.MIN_VALUE);
            }
            if (this.y != null) {
                this.y.setValue(Integer.MIN_VALUE);
            }
            if (this.width != null) {
                this.width.setValue(Integer.MIN_VALUE);
            }
            if (this.height != null) {
                this.height.setValue(Integer.MIN_VALUE);
            }
            if (this.east != null) {
                this.east.setValue(Integer.MIN_VALUE);
            }
            if (this.south != null) {
                this.south.setValue(Integer.MIN_VALUE);
            }
            if (this.h != null) {
                this.h.setValue(Integer.MIN_VALUE);
            }
            if (this.v != null) {
                this.v.setValue(Integer.MIN_VALUE);
            }
        }
    }

    private static abstract class DeferredDimension
    extends Spring {
        private int value = Integer.MIN_VALUE;

        public void setValue(int val) {
            this.value = val;
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                return this.getPreferredValue();
            }
            return this.value;
        }
    }

    private static class DeferredHeight
    extends DeferredDimension {
        private Component c;

        public String toString() {
            return "DeferredHeight of something";
        }

        public DeferredHeight(Component component) {
            this.c = component;
        }

        public int getMaximumValue() {
            int widget_height = this.c.getMaximumSize().height;
            return Math.min(Short.MAX_VALUE, widget_height);
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().height;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().height;
        }
    }

    private static class DeferredSpring
    extends Spring {
        private SpringLayout sl;
        private String edgeName;
        private Component c;

        public String toString() {
            return "DeferredSpring of edge" + this.edgeName + " of " + "something";
        }

        public DeferredSpring(SpringLayout s, String edge, Component component) {
            this.sl = s;
            this.edgeName = edge;
            this.c = component;
        }

        private Spring resolveSpring() {
            return this.sl.getConstraints(this.c).getConstraint(this.edgeName);
        }

        public int getMaximumValue() {
            return this.resolveSpring().getMaximumValue();
        }

        public int getMinimumValue() {
            return this.resolveSpring().getMinimumValue();
        }

        public int getPreferredValue() {
            return this.resolveSpring().getPreferredValue();
        }

        public int getValue() {
            int nRet = this.resolveSpring().getValue();
            if (nRet == Integer.MIN_VALUE) {
                nRet = this.getPreferredValue();
            }
            return nRet;
        }

        public void setValue(int size) {
            this.resolveSpring().setValue(size);
        }
    }

    private static class DeferredWidth
    extends DeferredDimension {
        private Component c;

        public DeferredWidth(Component component) {
            this.c = component;
        }

        public String toString() {
            return "DeferredWidth of something";
        }

        public int getMaximumValue() {
            int widget_width = this.c.getMaximumSize().width;
            return Math.min(Short.MAX_VALUE, widget_width);
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().width;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().width;
        }
    }
}

