/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalRootPaneUI
extends BasicRootPaneUI {
    private static MetalRootPaneUI instance;

    public static ComponentUI createUI(JComponent component) {
        if (instance == null) {
            instance = new MetalRootPaneUI();
        }
        return instance;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        JRootPane rp = (JRootPane)c;
        if (rp.getWindowDecorationStyle() != 0) {
            this.installWindowDecorations(rp);
        }
    }

    public void uninstallUI(JComponent c) {
        JRootPane rp = (JRootPane)c;
        if (rp.getWindowDecorationStyle() != 0) {
            this.uninstallWindowDecorations(rp);
        }
        super.uninstallUI(c);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        super.propertyChange(ev);
        String propertyName = ev.getPropertyName();
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane rp = (JRootPane)ev.getSource();
            if (rp.getWindowDecorationStyle() != 0) {
                this.installWindowDecorations(rp);
            } else {
                this.uninstallWindowDecorations(rp);
            }
        }
    }

    private void installWindowDecorations(JRootPane rp) {
        rp.setBorder(new MetalFrameBorder());
        MetalTitlePane titlePane = new MetalTitlePane(rp);
        rp.setLayout(new MetalRootLayout(titlePane));
        assert (rp.getLayeredPane().getComponentCount() > 0) : "We should have a contentPane already";
        rp.getLayeredPane().add(titlePane, JLayeredPane.FRAME_CONTENT_LAYER, 1);
    }

    private void uninstallWindowDecorations(JRootPane rp) {
        rp.setBorder(null);
        JLayeredPane lp = rp.getLayeredPane();
        int i = lp.getComponentCount() - 1;
        while (i >= 0) {
            if (lp.getComponent(i) instanceof MetalTitlePane) {
                lp.remove(i);
                break;
            }
            --i;
        }
    }

    private static class MetalFrameBorder
    extends AbstractBorder {
        private MetalFrameBorder() {
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            if (newInsets == null) {
                newInsets = new Insets(5, 5, 5, 5);
            } else {
                newInsets.top = 5;
                newInsets.left = 5;
                newInsets.bottom = 5;
                newInsets.right = 5;
            }
            return newInsets;
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JRootPane f = (JRootPane)c;
            Window frame = SwingUtilities.getWindowAncestor(f);
            if (frame.isActive()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.fillRect(x, y, w, 5);
            g.fillRect(x, y, 5, h);
            g.fillRect(x + w - 5, y, 5, h);
            g.fillRect(x, y + h - 5, w, 5);
            g.setColor(MetalLookAndFeel.getControl());
            g.fillRect(x, y, 1, 1);
            g.fillRect(x + w - 1, y, 1, 1);
            g.fillRect(x + w - 1, y + h - 1, 1, 1);
            g.fillRect(x, y + h - 1, 1, 1);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 14, y + 2, x + w - 15, y + 2);
            g.drawLine(x + 14, y + h - 3, x + w - 15, y + h - 3);
            g.drawLine(x + 2, y + 14, x + 2, y + h - 15);
            g.drawLine(x + w - 3, y + 14, x + w - 3, y + h - 15);
            if (frame.isActive()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
            }
            g.drawLine(x + 15, y + 3, x + w - 14, y + 3);
            g.drawLine(x + 15, y + h - 2, x + w - 14, y + h - 2);
            g.drawLine(x + 3, y + 15, x + 3, y + h - 14);
            g.drawLine(x + w - 2, y + 15, x + w - 2, y + h - 14);
        }
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private Rectangle glassPaneBounds;
        private Rectangle layeredPaneBounds;
        private Rectangle contentPaneBounds;
        private Rectangle menuBarBounds;
        private Rectangle titlePaneBounds;
        private Dimension prefSize;
        private MetalTitlePane titlePane;

        MetalRootLayout(MetalTitlePane tp) {
            this.titlePane = tp;
        }

        public void addLayoutComponent(Component component, Object constraints) {
        }

        public Dimension maximumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateLayout(Container target) {
            MetalRootLayout metalRootLayout = this;
            synchronized (metalRootLayout) {
                this.glassPaneBounds = null;
                this.layeredPaneBounds = null;
                this.contentPaneBounds = null;
                this.menuBarBounds = null;
                this.titlePaneBounds = null;
                this.prefSize = null;
            }
        }

        public void addLayoutComponent(String name, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container parent) {
            JRootPane rp = (JRootPane)parent;
            rp.getLayeredPane();
            Container contentPane = rp.getContentPane();
            JMenuBar menuBar = rp.getJMenuBar();
            MetalRootLayout metalRootLayout = this;
            synchronized (metalRootLayout) {
                if (this.prefSize == null) {
                    Insets i = parent.getInsets();
                    this.prefSize = new Dimension(i.left + i.right, i.top + i.bottom);
                    Dimension contentPrefSize = ((Component)contentPane).getPreferredSize();
                    this.prefSize.width += contentPrefSize.width;
                    this.prefSize.height += contentPrefSize.height + this.titlePane.getPreferredSize().height;
                    if (menuBar != null) {
                        Dimension menuBarSize = ((Component)menuBar).getPreferredSize();
                        if (menuBarSize.width > contentPrefSize.width) {
                            this.prefSize.width += menuBarSize.width - contentPrefSize.width;
                        }
                        this.prefSize.height += menuBarSize.height;
                    }
                }
                return new Dimension(this.prefSize);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            JRootPane rp = (JRootPane)parent;
            JLayeredPane layeredPane = rp.getLayeredPane();
            Container contentPane = rp.getContentPane();
            JMenuBar menuBar = rp.getJMenuBar();
            Component glassPane = rp.getGlassPane();
            if (this.glassPaneBounds == null || this.layeredPaneBounds == null || this.contentPaneBounds == null || this.menuBarBounds == null) {
                Insets i = rp.getInsets();
                int containerWidth = parent.getBounds().width - i.left - i.right;
                int containerHeight = parent.getBounds().height - i.top - i.bottom;
                if (this.titlePaneBounds == null) {
                    this.titlePaneBounds = new Rectangle();
                }
                this.titlePaneBounds.width = containerWidth;
                this.titlePaneBounds.height = this.titlePane.getPreferredSize().height;
                if (this.menuBarBounds == null) {
                    this.menuBarBounds = new Rectangle();
                }
                this.menuBarBounds.setBounds(0, this.titlePaneBounds.y + this.titlePaneBounds.height, containerWidth, 0);
                if (menuBar != null) {
                    Dimension menuBarSize = ((Component)menuBar).getPreferredSize();
                    this.menuBarBounds.height = menuBarSize.height > containerHeight ? containerHeight : menuBarSize.height;
                }
                if (this.contentPaneBounds == null) {
                    this.contentPaneBounds = new Rectangle();
                }
                this.contentPaneBounds.setBounds(0, this.menuBarBounds.y + this.menuBarBounds.height, containerWidth, containerHeight - this.menuBarBounds.y - this.menuBarBounds.height);
                this.glassPaneBounds = new Rectangle(i.left, i.top, containerWidth, containerHeight);
                this.layeredPaneBounds = new Rectangle(i.left, i.top, containerWidth, containerHeight);
            }
            glassPane.setBounds(this.glassPaneBounds);
            layeredPane.setBounds(this.layeredPaneBounds);
            if (menuBar != null) {
                menuBar.setBounds(this.menuBarBounds);
            }
            contentPane.setBounds(this.contentPaneBounds);
            this.titlePane.setBounds(this.titlePaneBounds);
        }
    }

    private static class MetalTitlePane
    extends JComponent {
        JRootPane rootPane;
        JButton closeButton;
        JButton iconButton;
        JButton maxButton;
        Icon minIcon;
        Icon maxIcon;
        private Icon iconIcon;
        Icon closeIcon;
        private Color notSelectedTitleColor;
        private Color selectedTitleColor;
        JLabel title;
        private Action closeAction;
        private Action iconifyAction;
        private Action maximizeAction;
        private JMenuBar menuBar;
        protected JMenu windowMenu;

        MetalTitlePane(JRootPane rp) {
            this.rootPane = rp;
            this.setLayout(this.createLayout());
            this.title = new JLabel();
            this.title.setHorizontalAlignment(2);
            this.title.setHorizontalTextPosition(2);
            this.title.setOpaque(false);
            this.installTitlePane();
        }

        protected LayoutManager createLayout() {
            return new MetalTitlePaneLayout();
        }

        protected void installTitlePane() {
            this.installDefaults();
            this.installListeners();
            this.createActions();
            this.assembleSystemMenu();
            this.createButtons();
            this.setButtonIcons();
            this.addSubComponents();
            this.enableActions();
        }

        private void enableActions() {
        }

        private void addSubComponents() {
            this.add(this.menuBar);
            this.add(this.closeButton);
            this.add(this.iconButton);
            this.add(this.maxButton);
        }

        private void installListeners() {
            MouseHandler mouseHandler = new MouseHandler();
            this.addMouseListener(mouseHandler);
            this.addMouseMotionListener(mouseHandler);
        }

        private void createActions() {
            this.closeAction = new CloseAction();
            this.iconifyAction = new IconifyAction();
            this.maximizeAction = new MaximizeAction();
        }

        private void assembleSystemMenu() {
            this.menuBar = this.createSystemMenuBar();
            this.windowMenu = this.createSystemMenu();
            this.menuBar.add(this.windowMenu);
            this.addSystemMenuItems(this.windowMenu);
            this.enableActions();
        }

        protected JMenuBar createSystemMenuBar() {
            if (this.menuBar == null) {
                this.menuBar = new JMenuBar();
            }
            this.menuBar.removeAll();
            return this.menuBar;
        }

        protected JMenu createSystemMenu() {
            if (this.windowMenu == null) {
                this.windowMenu = new JMenu();
            }
            this.windowMenu.removeAll();
            return this.windowMenu;
        }

        private void addSystemMenuItems(JMenu menu) {
        }

        protected void createButtons() {
            this.closeButton = new PaneButton(this.closeAction);
            this.closeButton.setText(null);
            this.iconButton = new PaneButton(this.iconifyAction);
            this.iconButton.setText(null);
            this.maxButton = new PaneButton(this.maximizeAction);
            this.maxButton.setText(null);
            this.closeButton.setBorderPainted(false);
            this.closeButton.setContentAreaFilled(false);
            this.iconButton.setBorderPainted(false);
            this.iconButton.setContentAreaFilled(false);
            this.maxButton.setBorderPainted(false);
            this.maxButton.setContentAreaFilled(false);
        }

        protected void setButtonIcons() {
            if (this.closeIcon != null && this.closeButton != null) {
                this.closeButton.setIcon(this.closeIcon);
            }
            if (this.iconIcon != null && this.iconButton != null) {
                this.iconButton.setIcon(this.iconIcon);
            }
            if (this.maxIcon != null && this.maxButton != null) {
                this.maxButton.setIcon(this.maxIcon);
            }
        }

        public void paintComponent(Graphics g) {
            int startX;
            Window frame = SwingUtilities.getWindowAncestor(this.rootPane);
            Color savedColor = g.getColor();
            this.paintTitleBackground(g);
            this.paintChildren(g);
            Dimension d = this.getSize();
            if (frame.isActive()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(0, 0, 0, 0);
            g.drawLine(d.width - 1, 0, d.width - 1, 0);
            g.drawLine(0, d.height - 1, d.width - 1, d.height - 1);
            if (UIManager.get("InternalFrame.activeTitleGradient") != null && frame.isActive()) {
                MetalUtils.paintGradient(g, 0, 0, this.getWidth(), this.getHeight(), 1, "InternalFrame.activeTitleGradient");
            }
            Rectangle b = this.title.getBounds();
            int endX = startX = b.x + b.width + 5;
            if (this.iconButton.isVisible()) {
                endX = Math.max(this.iconButton.getX(), endX);
            } else if (this.maxButton.isVisible()) {
                endX = Math.max(this.maxButton.getX(), endX);
            } else if (this.closeButton.isVisible()) {
                endX = Math.max(this.closeButton.getX(), endX);
            }
            if ((endX -= 7) > startX) {
                MetalUtils.fillMetalPattern(this, g, startX, 3, endX - startX, this.getHeight() - 6, Color.white, Color.gray);
            }
            g.setColor(savedColor);
        }

        protected void paintTitleBackground(Graphics g) {
            Window frame = SwingUtilities.getWindowAncestor(this.rootPane);
            if (!this.isOpaque()) {
                return;
            }
            Color saved = g.getColor();
            Dimension dims = this.getSize();
            Color bg = this.getBackground();
            bg = frame.isActive() ? this.selectedTitleColor : this.notSelectedTitleColor;
            g.setColor(bg);
            g.fillRect(0, 0, dims.width, dims.height);
            g.setColor(saved);
        }

        private void installDefaults() {
            this.title.setFont(UIManager.getFont("InternalFrame.titleFont"));
            this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
            this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
            this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
            this.iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
            this.maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
            this.minIcon = MetalIconFactory.getInternalFrameAltMaximizeIcon(16);
            Frame frame = (Frame)SwingUtilities.getWindowAncestor(this.rootPane);
            this.title = new JLabel(frame.getTitle(), MetalIconFactory.getInternalFrameDefaultMenuIcon(), 2);
        }

        private class CloseAction
        extends AbstractAction {
            public CloseAction() {
                super("Close");
            }

            public void actionPerformed(ActionEvent e) {
                Window frame = SwingUtilities.getWindowAncestor(MetalTitlePane.this.rootPane);
                if (frame instanceof JFrame) {
                    JFrame jframe = (JFrame)frame;
                    switch (jframe.getDefaultCloseOperation()) {
                        case 3: {
                            jframe.setVisible(false);
                            jframe.dispose();
                            System.exit(0);
                            break;
                        }
                        case 2: {
                            jframe.setVisible(false);
                            jframe.dispose();
                            break;
                        }
                        case 1: {
                            jframe.setVisible(false);
                            break;
                        }
                    }
                } else if (frame instanceof JDialog) {
                    JDialog jdialog = (JDialog)frame;
                    switch (jdialog.getDefaultCloseOperation()) {
                        case 2: {
                            jdialog.setVisible(false);
                            jdialog.dispose();
                            break;
                        }
                        case 1: {
                            jdialog.setVisible(false);
                            break;
                        }
                    }
                }
            }
        }

        private class IconifyAction
        extends AbstractAction {
            private IconifyAction() {
            }

            public void actionPerformed(ActionEvent event) {
                Window w = SwingUtilities.getWindowAncestor(MetalTitlePane.this.rootPane);
                if (w instanceof Frame) {
                    Frame f = (Frame)w;
                    f.getExtendedState();
                    f.setExtendedState(1);
                }
            }
        }

        private class MaximizeAction
        extends AbstractAction {
            private MaximizeAction() {
            }

            public void actionPerformed(ActionEvent event) {
                Window w = SwingUtilities.getWindowAncestor(MetalTitlePane.this.rootPane);
                if (w instanceof Frame) {
                    Frame f = (Frame)w;
                    f.getExtendedState();
                    f.setExtendedState(6);
                }
            }
        }

        private class MetalTitlePaneLayout
        implements LayoutManager {
            public void addLayoutComponent(String name, Component c) {
            }

            public void layoutContainer(Container c) {
                int buttonWidth;
                Dimension size = c.getSize();
                Insets insets = c.getInsets();
                int width = size.width - insets.left - insets.right;
                int height = size.height - insets.top - insets.bottom;
                int loc = width - insets.right - 1;
                int top = insets.top + 2;
                int buttonHeight = height - 4;
                if (MetalTitlePane.this.closeButton.isVisible()) {
                    buttonWidth = MetalTitlePane.this.closeIcon.getIconWidth();
                    MetalTitlePane.this.closeButton.setBounds(loc -= buttonWidth + 2, top, buttonWidth, buttonHeight);
                    loc -= 6;
                }
                if (MetalTitlePane.this.maxButton.isVisible()) {
                    buttonWidth = MetalTitlePane.this.maxIcon.getIconWidth();
                    MetalTitlePane.this.maxButton.setBounds(loc -= buttonWidth + 4, top, buttonWidth, buttonHeight);
                }
                if (MetalTitlePane.this.iconButton.isVisible()) {
                    buttonWidth = MetalTitlePane.this.minIcon.getIconWidth();
                    MetalTitlePane.this.iconButton.setBounds(loc -= buttonWidth + 4, top, buttonWidth, buttonHeight);
                    loc -= 2;
                }
                Dimension titlePreferredSize = MetalTitlePane.this.title.getPreferredSize();
                MetalTitlePane.this.title.setBounds(insets.left + 5, insets.top, Math.min(titlePreferredSize.width, loc - insets.left - 10), height);
            }

            public Dimension minimumLayoutSize(Container c) {
                return this.preferredLayoutSize(c);
            }

            public Dimension preferredLayoutSize(Container c) {
                return new Dimension(22, 22);
            }

            public void removeLayoutComponent(Component c) {
            }
        }

        private class MouseHandler
        extends MouseInputAdapter {
            Point lastDragLocation;

            private MouseHandler() {
            }

            public void mousePressed(MouseEvent ev) {
                this.lastDragLocation = ev.getPoint();
            }

            public void mouseDragged(MouseEvent ev) {
                Point dragLocation = ev.getPoint();
                int deltaX = dragLocation.x - this.lastDragLocation.x;
                int deltaY = dragLocation.y - this.lastDragLocation.y;
                Window window = SwingUtilities.getWindowAncestor(MetalTitlePane.this.rootPane);
                Point loc = window.getLocation();
                window.setLocation(loc.x + deltaX, loc.y + deltaY);
            }
        }

        private class PaneButton
        extends JButton {
            public PaneButton(Action a) {
                super(a);
                this.setMargin(new Insets(0, 0, 0, 0));
            }

            public boolean isFocusable() {
                return false;
            }
        }
    }
}

