/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.appletviewer;

import gnu.classpath.tools.appletviewer.AppletClassLoader;
import gnu.classpath.tools.appletviewer.AppletTag;
import gnu.classpath.tools.appletviewer.ErrorApplet;
import gnu.classpath.tools.appletviewer.Messages;
import gnu.classpath.tools.appletviewer.PluginAppletViewer;
import gnu.classpath.tools.appletviewer.StandaloneAppletViewer;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import java.applet.Applet;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class Main {
    private static HashMap classLoaderCache = new HashMap();
    private static String code = null;
    private static String codebase = null;
    private static String archive = null;
    private static List parameters = new ArrayList();
    private static Dimension dimensions = new Dimension(-1, -1);
    private static String pipeInName = null;
    private static String pipeOutName = null;
    private static boolean pluginMode = false;
    private static Parser parser = null;
    protected static boolean verbose;

    Main() {
    }

    private static ClassLoader getClassLoader(URL codebase, ArrayList archives) {
        AppletClassLoader loader = new AppletClassLoader(codebase, archives);
        classLoaderCache.put(codebase, loader);
        return loader;
    }

    static Applet createApplet(AppletTag tag) {
        Applet applet = null;
        try {
            ClassLoader loader = Main.getClassLoader(tag.prependCodeBase(""), tag.getArchives());
            String code = tag.getCode();
            if (code.endsWith(".class")) {
                code = code.substring(0, code.length() - 6).replace('/', '.');
            }
            Class<?> c = loader.loadClass(code);
            applet = (Applet)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (applet == null) {
            applet = new ErrorApplet(Messages.getString("Main.ErrorApplet"));
        }
        return applet;
    }

    public static void main(String[] args) throws IOException {
        parser = new ClasspathToolParser("appletviewer", true);
        parser.setHeader(Messages.getString("Main.Usage"));
        OptionGroup attributeGroup = new OptionGroup(Messages.getString("Main.AppletTagOptions"));
        attributeGroup.add(new Option("code", Messages.getString("Main.CodeDescription"), Messages.getString("Main.CodeArgument")){

            public void parsed(String argument) throws OptionException {
                code = argument;
            }
        });
        attributeGroup.add(new Option("codebase", Messages.getString("Main.CodebaseDescription"), Messages.getString("Main.CodebaseArgument")){

            public void parsed(String argument) throws OptionException {
                codebase = argument;
            }
        });
        attributeGroup.add(new Option("archive", Messages.getString("Main.ArchiveDescription"), Messages.getString("Main.ArchiveArgument")){

            public void parsed(String argument) throws OptionException {
                archive = argument;
            }
        });
        attributeGroup.add(new Option("width", Messages.getString("Main.WidthDescription"), Messages.getString("Main.WidthArgument")){

            public void parsed(String argument) throws OptionException {
                dimensions.width = Integer.parseInt(argument);
            }
        });
        attributeGroup.add(new Option("height", Messages.getString("Main.HeightDescription"), Messages.getString("Main.HeightArgument")){

            public void parsed(String argument) throws OptionException {
                dimensions.height = Integer.parseInt(argument);
            }
        });
        attributeGroup.add(new Option("param", Messages.getString("Main.ParamDescription"), Messages.getString("Main.ParamArgument")){

            public void parsed(String argument) throws OptionException {
                parameters.add(argument);
            }
        });
        OptionGroup pluginGroup = new OptionGroup(Messages.getString("Main.PluginOption"));
        pluginGroup.add(new Option("plugin", Messages.getString("Main.PluginDescription"), Messages.getString("Main.PluginArgument")){

            public void parsed(String argument) throws OptionException {
                pluginMode = true;
                int comma = argument.indexOf(44);
                pipeInName = argument.substring(0, comma);
                pipeOutName = argument.substring(comma + 1);
            }
        });
        OptionGroup debuggingGroup = new OptionGroup(Messages.getString("Main.DebuggingOption"));
        debuggingGroup.add(new Option("verbose", Messages.getString("Main.VerboseDescription"), null){

            public void parsed(String argument) throws OptionException {
                verbose = true;
            }
        });
        OptionGroup compatibilityGroup = new OptionGroup(Messages.getString("Main.CompatibilityOptions"));
        compatibilityGroup.add(new Option("debug", Messages.getString("Main.DebugDescription"), null){

            public void parsed(String argument) throws OptionException {
            }
        });
        compatibilityGroup.add(new Option("encoding", Messages.getString("Main.EncodingDescription"), Messages.getString("Main.EncodingArgument")){

            public void parsed(String argument) throws OptionException {
            }
        });
        parser.add(attributeGroup);
        parser.add(pluginGroup);
        parser.add(debuggingGroup);
        parser.add(compatibilityGroup);
        String[] urls = parser.parse(args);
        Main.printArguments(args);
        args = urls;
        if (Main.dimensions.height < 0) {
            Main.dimensions.height = 200;
        }
        if (Main.dimensions.width < 0) {
            Main.dimensions.width = (int)(1.6 * (double)Main.dimensions.height);
        }
        if (pluginMode) {
            FileInputStream in = new FileInputStream(pipeInName);
            FileOutputStream out = new FileOutputStream(pipeOutName);
            PluginAppletViewer.start(in, out);
        } else {
            System.err.println(String.valueOf(Messages.getString("Main.SecurityWarning")) + "\n");
            System.err.println(Messages.getString("Main.ContinuationPrompt"));
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            String response = null;
            try {
                response = stdin.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read response to continuation prompt.", e);
            }
            if (!response.equals("c") && !response.equals("C")) {
                System.exit(0);
            }
            if (code == null) {
                if (args.length == 0) {
                    System.err.println(Messages.getString("Main.NoInputFiles"));
                    System.exit(1);
                }
                new StandaloneAppletViewer(args);
            } else {
                new StandaloneAppletViewer(code, codebase, archive, parameters, dimensions);
            }
        }
    }

    static void printArguments(String[] args) {
        if (verbose) {
            System.out.println(Messages.getString("Main.RawArguments"));
            int i = 0;
            while (i < args.length) {
                System.out.println(" " + args[i]);
                ++i;
            }
        }
    }
}

