/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.javah.Main;
import gnu.classpath.tools.javah.Text;
import java.io.IOException;
import java.util.ArrayList;

public class GcjhMain
extends Main {
    ArrayList commands = new ArrayList();

    public GcjhMain() {
        this.cni = true;
    }

    protected String getName() {
        return "gcjh";
    }

    protected ClasspathToolParser getParser() {
        ClasspathToolParser result = super.getParser();
        result.setHeader("usage: gcjh [OPTION]... CLASS...");
        OptionGroup text = new OptionGroup("CNI text options");
        text.add(new Option("add", "Insert TEXT into class body", "TEXT"){

            public void parsed(String arg) throws OptionException {
                GcjhMain.this.commands.add(new Text(0, arg));
            }
        });
        text.add(new Option("append", "Append TEXT after class declaration", "TEXT"){

            public void parsed(String arg) throws OptionException {
                GcjhMain.this.commands.add(new Text(1, arg));
            }
        });
        text.add(new Option("friend", "Insert TEXT as a 'friend' declaration", "TEXT"){

            public void parsed(String arg) throws OptionException {
                GcjhMain.this.commands.add(new Text(2, arg));
            }
        });
        text.add(new Option("prepend", "Insert TEXT before start of class", "TEXT"){

            public void parsed(String arg) throws OptionException {
                GcjhMain.this.commands.add(new Text(3, arg));
            }
        });
        result.add(text);
        OptionGroup compat = new OptionGroup("Compatibility options (unused)");
        compat.add(new Option("td", "Unused compatibility option", "DIRECTORY"){

            public void parsed(String arg) throws OptionException {
            }
        });
        compat.add(new Option("M", "Unused compatibility option"){

            public void parsed(String arg) throws OptionException {
            }
        });
        compat.add(new Option("MM", "Unused compatibility option"){

            public void parsed(String arg) throws OptionException {
            }
        });
        compat.add(new Option("MD", "Unused compatibility option"){

            public void parsed(String arg) throws OptionException {
            }
        });
        compat.add(new Option("MMD", "Unused compatibility option"){

            public void parsed(String arg) throws OptionException {
            }
        });
        result.add(compat);
        return result;
    }

    protected void postParse(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.textMap.put(names[i].replace('.', '/'), this.commands);
            ++i;
        }
    }

    public static void main(String[] args) throws IOException {
        new GcjhMain().run(args);
    }
}

