/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.logging.Logger;

public class CACertCmd
extends Command {
    private static final Logger log = Logger.getLogger(CACertCmd.class.getName());
    protected String _certFileName;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private CertificateFactory x509Factory;

    public void setFile(String pathName) {
        this._certFileName = pathName;
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    void setup() throws Exception {
        this.setInputStreamParam(this._certFileName);
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        if (Configuration.DEBUG) {
            log.fine("-cacert handler will use the following options:");
            log.fine("  -file=" + this._certFileName);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        this.alias = this.getAliasFromFileName(this._certFileName);
        if (this.store.containsAlias(this.alias)) {
            throw new IllegalArgumentException(Messages.getFormattedString("CACertCmd.0", this.alias));
        }
        this.x509Factory = CertificateFactory.getInstance("X.509");
        Certificate certificate = this.x509Factory.generateCertificate(this.inStream);
        if (Configuration.DEBUG) {
            log.fine("certificate = " + certificate);
        }
        this.store.setCertificateEntry(this.alias, certificate);
        this.saveKeyStore();
        if (this.verbose) {
            System.out.println(Messages.getFormattedString("CACertCmd.1", new Object[]{this._certFileName, this.alias}));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("cacert", true);
        result.setHeader(Messages.getString("CACertCmd.2"));
        result.setFooter(Messages.getString("CACertCmd.3"));
        OptionGroup options = new OptionGroup(Messages.getString("CACertCmd.4"));
        options.add(new Option("file", Messages.getString("CACertCmd.5"), Messages.getString("CACertCmd.6")){

            public void parsed(String argument) throws OptionException {
                CACertCmd.this._certFileName = argument;
            }
        });
        options.add(new Option("storetype", Messages.getString("CACertCmd.7"), Messages.getString("CACertCmd.8")){

            public void parsed(String argument) throws OptionException {
                CACertCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("CACertCmd.9"), Messages.getString("CACertCmd.10")){

            public void parsed(String argument) throws OptionException {
                CACertCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("CACertCmd.11"), Messages.getString("CACertCmd.12")){

            public void parsed(String argument) throws OptionException {
                CACertCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("CACertCmd.13"), Messages.getString("CACertCmd.14")){

            public void parsed(String argument) throws OptionException {
                CACertCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("CACertCmd.15")){

            public void parsed(String argument) throws OptionException {
                CACertCmd.this.verbose = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }

    private String getAliasFromFileName(String fileName) {
        int ndx;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getAliasFromFileName", fileName);
        }
        if ((fileName = new File(fileName).getName()).startsWith(".")) {
            fileName = fileName.substring(1);
        }
        if ((ndx = fileName.lastIndexOf(46)) > 0) {
            fileName = fileName.substring(0, ndx);
        }
        char[] chars = fileName.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == ' ' || c == '.') {
                chars[i] = 95;
            }
            ++i;
        }
        String result = new String(chars);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getAliasFromFileName", result);
        }
        return result;
    }
}

