/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.tools.gc_analyze;

import gnu.gcj.tools.gc_analyze.MemoryAnalyze;
import gnu.gcj.tools.gc_analyze.MemoryMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

class BlockMap {
    static final int HBLKSIZE = 4096;
    private TreeMap<SizeKind, ArrayList<PtrMarks>> map = new TreeMap();

    public BlockMap(BufferedReader reader) throws IOException {
        String s;
        while ((s = reader.readLine()) != null) {
            if (s.charAt(0) == '#' || s.indexOf("Begin block map") < 0) continue;
            while (true) {
                if ((s = reader.readLine()).charAt(0) == '#') {
                    continue;
                }
                if (s.indexOf("End block map") >= 0) {
                    return;
                }
                String[] items = s.split(",");
                long ptr = 0L;
                int kind = 0;
                int size = 0;
                int marks = 0;
                int i = 0;
                while (i < items.length) {
                    String[] x = items[i].split(" ");
                    String last = x[x.length - 1];
                    switch (i) {
                        case 0: {
                            ptr = MemoryMap.parseHexLong(last.substring(2));
                            break;
                        }
                        case 1: {
                            kind = Integer.parseInt(last);
                            break;
                        }
                        case 2: {
                            size = Integer.parseInt(last);
                            break;
                        }
                        case 3: {
                            marks = Integer.parseInt(last);
                        }
                    }
                    ++i;
                }
                SizeKind sk = new SizeKind(size, kind);
                ArrayList<PtrMarks> m = this.map.get(sk);
                if (m == null) {
                    m = new ArrayList();
                    this.map.put(sk, m);
                }
                PtrMarks pm = new PtrMarks(ptr, marks);
                m.add(pm);
            }
        }
    }

    public void dump() {
        System.out.println();
        System.out.println();
        System.out.println("*** Used Blocks ***\n");
        System.out.println();
        System.out.println("  Size     Kind            Blocks     Used       Free       Wasted");
        System.out.println("-------  -------------    ------- ---------- ----------    -------");
        int total_blocks = 0;
        int total_used = 0;
        int total_free = 0;
        int total_wasted = 0;
        for (Map.Entry<SizeKind, ArrayList<PtrMarks>> me : this.map.entrySet()) {
            SizeKind sk = me.getKey();
            System.out.println(String.valueOf(MemoryAnalyze.format(sk.size, 7)) + "  " + MemoryAnalyze.kindToName(sk.kind));
            int sub_blocks = 0;
            int sub_used = 0;
            int sub_free = 0;
            int sub_wasted = 0;
            int sub_count = 0;
            ArrayList<PtrMarks> v = me.getValue();
            for (PtrMarks pm : v) {
                int wasted;
                int free;
                int used;
                int bytes = sk.size;
                int blocks = (sk.size + 4096 - 1) / 4096;
                if (bytes < 4096) {
                    used = bytes * pm.marks;
                    free = bytes * (4096 / bytes - pm.marks);
                    wasted = 4096 - 4096 / bytes * bytes;
                } else if (pm.marks != 0) {
                    used = bytes;
                    free = 0;
                    wasted = (bytes + 4096 - 1) / 4096 * 4096 - used;
                } else {
                    used = 0;
                    free = bytes;
                    wasted = 0;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("                            ");
                sb.append(MemoryAnalyze.format(blocks, 5));
                sb.append("  ");
                sb.append(MemoryAnalyze.format(used, 9));
                sb.append("  ");
                sb.append(MemoryAnalyze.format(free, 9));
                sb.append("  ");
                sb.append(MemoryAnalyze.format(wasted, 9));
                System.out.println(sb);
                sub_blocks += blocks;
                sub_used += used;
                sub_free += free;
                sub_wasted += wasted;
                ++sub_count;
                total_blocks += blocks;
                total_used += used;
                total_free += free;
                total_wasted += wasted;
            }
            if (sub_count <= true) continue;
            System.out.println("                          ------- ---------- ----------    -------");
            StringBuilder sb = new StringBuilder();
            sb.append("                            ");
            sb.append(MemoryAnalyze.format(sub_blocks, 5));
            sb.append("  ");
            sb.append(MemoryAnalyze.format(sub_used, 9));
            sb.append("  ");
            sb.append(MemoryAnalyze.format(sub_free, 9));
            sb.append("  ");
            sb.append(MemoryAnalyze.format(sub_wasted, 9));
            System.out.println(sb);
        }
        System.out.println("-------  -------------    ------- ---------- ----------    -------");
        StringBuilder sb = new StringBuilder();
        sb.append("                            ");
        sb.append(MemoryAnalyze.format(total_blocks, 5));
        sb.append("  ");
        sb.append(MemoryAnalyze.format(total_used, 9));
        sb.append("  ");
        sb.append(MemoryAnalyze.format(total_free, 9));
        sb.append("  ");
        sb.append(MemoryAnalyze.format(total_wasted, 9));
        System.out.println(sb);
        System.out.println("Total bytes = " + MemoryAnalyze.format(total_blocks * 4096, 10));
    }

    class PtrMarks {
        long ptr;
        int marks;

        public PtrMarks(long ptr, int marks) {
            this.ptr = ptr;
            this.marks = marks;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SizeKind
    implements Comparable<SizeKind> {
        int size;
        int kind;

        public SizeKind(int size, int kind) {
            this.size = size;
            this.kind = kind;
        }

        @Override
        public int compareTo(SizeKind b) {
            if (this.size != b.size) {
                return this.size - b.size;
            }
            return this.kind - b.kind;
        }
    }
}

