/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.tools.gc_analyze;

import gnu.gcj.tools.gc_analyze.MemoryAnalyze;
import gnu.gcj.tools.gc_analyze.ObjectMap;
import gnu.gcj.tools.gc_analyze.SymbolLookup;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

class ItemList {
    private TreeMap<Long, HashMap<ObjectMap.ObjectItem, Integer>> map;

    public void add(ObjectMap.ObjectItem item) {
        Integer count;
        Long x;
        HashMap<ObjectMap.ObjectItem, Integer> list;
        if (this.map == null) {
            this.map = new TreeMap();
        }
        if ((list = this.map.get(x = new Long(item.klass))) == null) {
            list = new HashMap();
            this.map.put(x, list);
        }
        if ((count = list.get(item)) == null) {
            list.put(item, new Integer(1));
        } else {
            list.put(item, new Integer(count + 1));
        }
    }

    void dump(String title, SymbolLookup lookup) throws IOException {
        if (this.map == null) {
            return;
        }
        System.out.println(title);
        for (Map.Entry<Long, HashMap<ObjectMap.ObjectItem, Integer>> me : this.map.entrySet()) {
            HashMap<ObjectMap.ObjectItem, Integer> list = me.getValue();
            boolean first = true;
            for (Map.Entry<ObjectMap.ObjectItem, Integer> me2 : list.entrySet()) {
                ObjectMap.ObjectItem item = me2.getKey();
                Integer count = me2.getValue();
                if (first) {
                    String name = MemoryAnalyze.getSymbolPretty(lookup, item, false);
                    System.out.println("    " + name + ":");
                    first = false;
                }
                System.out.print("        0x" + Long.toHexString(item.ptr));
                if (count != 1) {
                    System.out.print(" * " + count);
                }
                System.out.println();
            }
        }
    }
}

