config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# Keep same perms on rc.mysqld.new:
if [ -e etc/rc.d/rc.mysqld ]; then
  cp -a etc/rc.d/rc.mysqld etc/rc.d/rc.mysqld.new.incoming
  cat etc/rc.d/rc.mysqld.new > etc/rc.d/rc.mysqld.new.incoming
  mv etc/rc.d/rc.mysqld.new.incoming etc/rc.d/rc.mysqld.new
fi

config etc/rc.d/rc.mysqld.new

( cd usr/lib ; rm -rf libmysqlclient.so )
( cd usr/lib ; ln -sf mysql/libmysqlclient.so libmysqlclient.so )
( cd usr/lib ; rm -rf libmysqlclient.so.16 )
( cd usr/lib ; ln -sf mysql/libmysqlclient.so.16 libmysqlclient.so.16 )
( cd usr/lib ; rm -rf libmysqlclient_r.so.16 )
( cd usr/lib ; ln -sf mysql/libmysqlclient_r.so.16 libmysqlclient_r.so.16 )
( cd usr/lib/mysql ; rm -rf libmysqlclient.so )
( cd usr/lib/mysql ; ln -sf libmysqlclient.so.16.0.0 libmysqlclient.so )
( cd usr/lib/mysql ; rm -rf libmysqlclient.so.16 )
( cd usr/lib/mysql ; ln -sf libmysqlclient.so.16.0.0 libmysqlclient.so.16 )
( cd usr/lib/mysql/plugin ; rm -rf mypluglib.so )
( cd usr/lib/mysql/plugin ; ln -sf mypluglib.so.0.0.0 mypluglib.so )
( cd usr/lib/mysql/plugin ; rm -rf ha_federated.so )
( cd usr/lib/mysql/plugin ; ln -sf ha_federated.so.0.0.0 ha_federated.so )
( cd usr/lib/mysql/plugin ; rm -rf ha_example.so )
( cd usr/lib/mysql/plugin ; ln -sf ha_example.so.0.0.0 ha_example.so )
( cd usr/lib/mysql/plugin ; rm -rf libdaemon_example.so.0 )
( cd usr/lib/mysql/plugin ; ln -sf libdaemon_example.so.0.0.0 libdaemon_example.so.0 )
( cd usr/lib/mysql/plugin ; rm -rf ha_federated.so.0 )
( cd usr/lib/mysql/plugin ; ln -sf ha_federated.so.0.0.0 ha_federated.so.0 )
( cd usr/lib/mysql/plugin ; rm -rf libdaemon_example.so )
( cd usr/lib/mysql/plugin ; ln -sf libdaemon_example.so.0.0.0 libdaemon_example.so )
( cd usr/lib/mysql/plugin ; rm -rf ha_blackhole.so )
( cd usr/lib/mysql/plugin ; ln -sf ha_blackhole.so.0.0.0 ha_blackhole.so )
( cd usr/lib/mysql/plugin ; rm -rf ha_innodb_plugin.so.0 )
( cd usr/lib/mysql/plugin ; ln -sf ha_innodb_plugin.so.0.0.0 ha_innodb_plugin.so.0 )
( cd usr/lib/mysql/plugin ; rm -rf ha_blackhole.so.0 )
( cd usr/lib/mysql/plugin ; ln -sf ha_blackhole.so.0.0.0 ha_blackhole.so.0 )
( cd usr/lib/mysql/plugin ; rm -rf ha_archive.so.0 )
( cd usr/lib/mysql/plugin ; ln -sf ha_archive.so.0.0.0 ha_archive.so.0 )
( cd usr/lib/mysql/plugin ; rm -rf ha_example.so.0 )
( cd usr/lib/mysql/plugin ; ln -sf ha_example.so.0.0.0 ha_example.so.0 )
( cd usr/lib/mysql/plugin ; rm -rf ha_archive.so )
( cd usr/lib/mysql/plugin ; ln -sf ha_archive.so.0.0.0 ha_archive.so )
( cd usr/lib/mysql/plugin ; rm -rf mypluglib.so.0 )
( cd usr/lib/mysql/plugin ; ln -sf mypluglib.so.0.0.0 mypluglib.so.0 )
( cd usr/lib/mysql/plugin ; rm -rf ha_innodb_plugin.so )
( cd usr/lib/mysql/plugin ; ln -sf ha_innodb_plugin.so.0.0.0 ha_innodb_plugin.so )
( cd usr/lib/mysql ; rm -rf libmysqlclient_r.so.16 )
( cd usr/lib/mysql ; ln -sf libmysqlclient_r.so.16.0.0 libmysqlclient_r.so.16 )
( cd usr/lib/mysql ; rm -rf libmysqlclient_r.so )
( cd usr/lib/mysql ; ln -sf libmysqlclient_r.so.16.0.0 libmysqlclient_r.so )
( cd usr/lib ; rm -rf libmysqlclient_r.so )
( cd usr/lib ; ln -sf mysql/libmysqlclient_r.so libmysqlclient_r.so )
