
# X.Org will work without any xorg.conf now, so don't move anything
# into place by default.  Commenting out the block below:

## Use framebuffer by default if no xorg.conf is found:
#if [ ! -r etc/X11/xorg.conf -a -r etc/X11/xorg.conf-vesa ]; then
#  cp -a etc/X11/xorg.conf-vesa etc/X11/xorg.conf
#fi

( cd usr/lib/X11 ; rm -rf fonts )
( cd usr/lib/X11 ; ln -sf ../../share/fonts fonts )
# This setup should allow the following packages to install in a
# sane fashion, and should also allow third-party video drivers to
# find X in the old places.  However, anything you've installed in
# your /usr/X11R6 directory will be moved to /usr/X11R6.bak.
# Anything you really want want to keep will need to be merged back
# by hand.
if [ ! -L usr/X11R6/bin ]; then
  if [ -d usr/X11R6 ]; then
    mv usr/X11R6 usr/X11R6.bak
  fi
fi
mkdir -p usr/X11R6
( cd usr/X11R6
  for dir in ../bin ../include ../lib ../libexec ../man ../share ; do
    rm -rf $(basename $dir)
    ln -sf $dir .
  done
)
( cd usr ; rm -rf X11 )
( cd usr ; ln -sf X11R6 X11 )
( cd usr/bin ; rm -rf X11 )
( cd usr/bin ; ln -sf . X11 )
if [ -L usr/include/X11 ]; then
  ( cd usr/include ; rm -rf X11 )
fi
# Determine which architecture we're being installed on
# in order to install the correct xorg config file.
# by Stuart Winter <mozes@slackware.com>
# 22-Nov-2004

# This is the list of currently supported architectures in Slackware ARM.
# More will be added (Netwinder perhaps) if I get my hands on any other
# kit!
#
# I suppose I could automate this entirely to save on maintenance by simply having
# the files named xorg.conf.{RiscPC,Iyonix,NetWinder} but I prefer it this way
# incase I have to do something other than just making a symlink to the correct
# files.  For example, on the RiscPC I want to determine the amount of VRAM available
# and update the VideoRam directive appropriately.  Atm I don't know how to determine
# the amount of VRAM so this is not currently being done.
#
grep Acorn-RiscPC    /proc/cpuinfo 2>&1 >/dev/null && TYPE=riscpc
grep Iyonix          /proc/cpuinfo 2>&1 >/dev/null && TYPE=iyonix
grep Rebel-NetWinder /proc/cpuinfo 2>&1 >/dev/null && TYPE=netwinder
grep ARM-Versatile   /proc/cpuinfo 2>&1 >/dev/null && TYPE=versatile
grep OpenRD          /proc/cpuinfo 2>&1 >/dev/null && TYPE=openrd
# We support the SheevaPlug too, but it has no VGA so we'd only run X
# through VNC or some other remote method.

# Make the symlink. One of the great things about "stock" type ARM stuff
# is that it has a static graphics chip, so we can make a pretty good
# stab at providing an appropriate X11 configuration:
# (This long drawn out way is to make the Slackware package tools happy)
if [ ! -z $TYPE ]; then
( cd etc/X11 ; rm -f xorg.conf )
( cd etc/X11 ; ln -fs xorg.conf-$TYPE xorg.conf )
fi
