/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAbAddressCollector.idl
 */

#ifndef __gen_nsIAbAddressCollector_h__
#define __gen_nsIAbAddressCollector_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIAbCard; /* forward declaration */


/* starting interface:    nsIAbAddressCollector */
#define NS_IABADDRESSCOLLECTOR_IID_STR "069d3fba-37d4-4158-b401-a8efaeea0b66"

#define NS_IABADDRESSCOLLECTOR_IID \
  {0x069d3fba, 0x37d4, 0x4158, \
    { 0xb4, 0x01, 0xa8, 0xef, 0xae, 0xea, 0x0b, 0x66 }}

/**
 * nsIAbAddressCollector is the interface to the address collecter service.
 * It will save and update the supplied addresses into the address book
 * specified by the "mail.collect_addressbook" pref.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIAbAddressCollector : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IABADDRESSCOLLECTOR_IID)

  /**
   * Collects email addresses into the address book.
   * If a card already exists for the email, the first/last/display names
   * will be updated if they are supplied alongside the address.
   * If a card does not exist for the email it will be created if aCreateCard
   * is true.
   * 
   * @param  aAddresses  The list of emails (in standard header format)
   *                     to collect into the address book.
   * @param  aCreateCard Set to true if a card should be created if the
   *                     email address doesn't exist.
   * @param  aSendFormat The send format to save for the card. See
   *                     nsIAbPreferMailFormat for values. If updating a card
   *                     this value will only be changed if the current value
   *                     for the card is "unknown".
   */
  /* void collectAddress (in AUTF8String aAddresses, in boolean aCreateCard, in unsigned long aSendFormat); */
  NS_SCRIPTABLE NS_IMETHOD CollectAddress(const nsACString & aAddresses, PRBool aCreateCard, PRUint32 aSendFormat) = 0;

  /**
   * Collects a single name and email address into the address book.
   * By default, it saves the address without checking for an existing one.
   * See collectAddress for the general implementation.
   *
   * @param  aEmail         The email address to collect.
   * @param  aDisplayName   The display name associated with the email address.
   * @param  aCreateCard    Set to true if a card should be created if the
   *                        email address doesn't exist (ignored if
   *                        aSkipCheckExisting is true).
   * @param  aSendFormat    The send format to save for the card. See
   *                        nsIAbPreferMailFormat for values. If updating a card
   *                        this value will only be changed if the current value
   *                        for the card is "unknown".
   * @param  aSkipCheckExisting Optional parameter, if this is set then the
   *                            implementation will skip checking for an
   *                            existing card, and just create a new card.
   */
  /* void collectSingleAddress (in AUTF8String aEmail, in AUTF8String aDisplayName, in boolean aCreateCard, in unsigned long aSendFormat, [optional] in boolean aSkipCheckExisting); */
  NS_SCRIPTABLE NS_IMETHOD CollectSingleAddress(const nsACString & aEmail, const nsACString & aDisplayName, PRBool aCreateCard, PRUint32 aSendFormat, PRBool aSkipCheckExisting) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAbAddressCollector, NS_IABADDRESSCOLLECTOR_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIABADDRESSCOLLECTOR \
  NS_SCRIPTABLE NS_IMETHOD CollectAddress(const nsACString & aAddresses, PRBool aCreateCard, PRUint32 aSendFormat); \
  NS_SCRIPTABLE NS_IMETHOD CollectSingleAddress(const nsACString & aEmail, const nsACString & aDisplayName, PRBool aCreateCard, PRUint32 aSendFormat, PRBool aSkipCheckExisting); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIABADDRESSCOLLECTOR(_to) \
  NS_SCRIPTABLE NS_IMETHOD CollectAddress(const nsACString & aAddresses, PRBool aCreateCard, PRUint32 aSendFormat) { return _to CollectAddress(aAddresses, aCreateCard, aSendFormat); } \
  NS_SCRIPTABLE NS_IMETHOD CollectSingleAddress(const nsACString & aEmail, const nsACString & aDisplayName, PRBool aCreateCard, PRUint32 aSendFormat, PRBool aSkipCheckExisting) { return _to CollectSingleAddress(aEmail, aDisplayName, aCreateCard, aSendFormat, aSkipCheckExisting); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIABADDRESSCOLLECTOR(_to) \
  NS_SCRIPTABLE NS_IMETHOD CollectAddress(const nsACString & aAddresses, PRBool aCreateCard, PRUint32 aSendFormat) { return !_to ? NS_ERROR_NULL_POINTER : _to->CollectAddress(aAddresses, aCreateCard, aSendFormat); } \
  NS_SCRIPTABLE NS_IMETHOD CollectSingleAddress(const nsACString & aEmail, const nsACString & aDisplayName, PRBool aCreateCard, PRUint32 aSendFormat, PRBool aSkipCheckExisting) { return !_to ? NS_ERROR_NULL_POINTER : _to->CollectSingleAddress(aEmail, aDisplayName, aCreateCard, aSendFormat, aSkipCheckExisting); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAbAddressCollector : public nsIAbAddressCollector
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIABADDRESSCOLLECTOR

  nsAbAddressCollector();

private:
  ~nsAbAddressCollector();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAbAddressCollector, nsIAbAddressCollector)

nsAbAddressCollector::nsAbAddressCollector()
{
  /* member initializers and constructor code */
}

nsAbAddressCollector::~nsAbAddressCollector()
{
  /* destructor code */
}

/* void collectAddress (in AUTF8String aAddresses, in boolean aCreateCard, in unsigned long aSendFormat); */
NS_IMETHODIMP nsAbAddressCollector::CollectAddress(const nsACString & aAddresses, PRBool aCreateCard, PRUint32 aSendFormat)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void collectSingleAddress (in AUTF8String aEmail, in AUTF8String aDisplayName, in boolean aCreateCard, in unsigned long aSendFormat, [optional] in boolean aSkipCheckExisting); */
NS_IMETHODIMP nsAbAddressCollector::CollectSingleAddress(const nsACString & aEmail, const nsACString & aDisplayName, PRBool aCreateCard, PRUint32 aSendFormat, PRBool aSkipCheckExisting)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAbAddressCollector_h__ */
