/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAbManager.idl
 */

#ifndef __gen_nsIAbManager_h__
#define __gen_nsIAbManager_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIAbListener_h__
#include "nsIAbListener.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMWindow; /* forward declaration */

class nsIAbDirectory; /* forward declaration */

class nsIAbCard; /* forward declaration */

class nsIAbDirectoryProperties; /* forward declaration */

class nsIRDFDataSource; /* forward declaration */

class nsILocalFile; /* forward declaration */

class nsISimpleEnumerator; /* forward declaration */


/* starting interface:    nsIAbManager */
#define NS_IABMANAGER_IID_STR "549bf1f6-ada4-40c5-9f59-4ea9eda4a935"

#define NS_IABMANAGER_IID \
  {0x549bf1f6, 0xada4, 0x40c5, \
    { 0x9f, 0x59, 0x4e, 0xa9, 0xed, 0xa4, 0xa9, 0x35 }}

/**
 * nsIAbManager is an interface to the main address book mananger
 * via the contract id "@mozilla.org/abmanager;1"
 *
 * It contains the main functions to create and delete address books as well
 * as some helper functions.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIAbManager : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IABMANAGER_IID)

  /**
   * Returns an enumerator containing all the top-level directories
   * (non-recursive)
   */
  /* readonly attribute nsISimpleEnumerator directories; */
  NS_SCRIPTABLE NS_IMETHOD GetDirectories(nsISimpleEnumerator **aDirectories) = 0;

  /**
   * Returns the directory that represents the supplied URI.
   *
   * @param  aURI       The URI of the address book to find.
   * @return            The found address book.
   */
  /* nsIAbDirectory getDirectory (in ACString aURI); */
  NS_SCRIPTABLE NS_IMETHOD GetDirectory(const nsACString & aURI, nsIAbDirectory **_retval NS_OUTPARAM) = 0;

  /**
   * Creates a new address book.
   *
   * @param  aDirName   The description of the address book.
   * @param  aURI       The URI for the address book. This is specific to each
   *                    type of address book.
   * @param  aType      The type of the address book (see nsDirPrefs.h)
   * @param  aPrefName  Overrides the default of ldap_2.servers.<aDirName>
   *                    (note that the caller must ensure its uniqueness).
   */
  /* ACString newAddressBook (in AString aDirName, in ACString aURI, in unsigned long aType, [optional] in ACString aPrefName); */
  NS_SCRIPTABLE NS_IMETHOD NewAddressBook(const nsAString & aDirName, const nsACString & aURI, PRUint32 aType, const nsACString & aPrefName, nsACString & _retval NS_OUTPARAM) = 0;

  /**
   * Deletes an address book.
   *
   * @param  aURI       The URI for the address book. This is specific to each
   *                    type of address book.
   */
  /* void deleteAddressBook (in ACString aURI); */
  NS_SCRIPTABLE NS_IMETHOD DeleteAddressBook(const nsACString & aURI) = 0;

  /**
   * Exports an address book, it will provide a dialog to the user for the
   * location to save the file to and will then save the address book to media.
   *
   * @param  aParentWin Parent Window for the file save dialog to use.
   * @param  aDirectory The directory to export.
   */
  /* void exportAddressBook (in nsIDOMWindow aParentWin, in nsIAbDirectory aDirectory); */
  NS_SCRIPTABLE NS_IMETHOD ExportAddressBook(nsIDOMWindow *aParentWin, nsIAbDirectory *aDirectory) = 0;

  /**
   * Adds a nsIAbListener to receive notifications of address book updates
   * according to the specified notifyFlags.
   *
   * @param  aListener      The listener that is to receive updates.
   * @param  aNotifyFlags   A bitwise-or of abListenerNotifyFlagValue items
   *                        specifying which notifications to receive. See
   *                        nsIAbListener for possible values.
   */
  /* void addAddressBookListener (in nsIAbListener aListener, in abListenerNotifyFlagValue aNotifyFlags); */
  NS_SCRIPTABLE NS_IMETHOD AddAddressBookListener(nsIAbListener *aListener, abListenerNotifyFlagValue aNotifyFlags) = 0;

  /**
   * Removes a nsIAbListener from receive notifications of address book
   * updates.
   *
   * @param  aListener     The listener that is to no longer receive updates.
   */
  /* void removeAddressBookListener (in nsIAbListener aListener); */
  NS_SCRIPTABLE NS_IMETHOD RemoveAddressBookListener(nsIAbListener *aListener) = 0;

  /**
   * Call to notify the registered listeners when a property on an item has
   * changed.
   *
   * @param  aItem         The items that has changed (e.g. an nsIAbDirectory)
   * @param  aProperty     The property that has changed (e.g. DirName)
   * @param  aOldValue     The old value of the property.
   * @param  aNewValue     The new value of the property.
   */
  /* void notifyItemPropertyChanged (in nsISupports aItem, in string aProperty, in wstring aOldValue, in wstring aNewValue); */
  NS_SCRIPTABLE NS_IMETHOD NotifyItemPropertyChanged(nsISupports *aItem, const char *aProperty, const PRUnichar *aOldValue, const PRUnichar *aNewValue) = 0;

  /**
   * Call to notify the registered listeners when a directory item is added.
   *
   * @param  aParentDirectory  The parent directory of the item that has been
   *                           added.
   * @param  aItem             The item that has been added.
   */
  /* void notifyDirectoryItemAdded (in nsIAbDirectory aParentDirectory, in nsISupports aItem); */
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryItemAdded(nsIAbDirectory *aParentDirectory, nsISupports *aItem) = 0;

  /**
   * Call to notify the registered listeners when a directory item is removed.
   *
   * @param  aParentDirectory  The parent directory of the item that has been
   *                           removed.
   * @param  aItem             The item that has been removed.
   */
  /* void notifyDirectoryItemDeleted (in nsIAbDirectory aParentDirectory, in nsISupports aItem); */
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryItemDeleted(nsIAbDirectory *aParentDirectory, nsISupports *aItem) = 0;

  /**
   * Call to notify the registered listeners when a directory is removed.
   *
   * @param  aParentDirectory  The parent directory of the directory that has
   *                           been removed.
   * @param  aDirectory        The directory that has been removed.
   */
  /* void notifyDirectoryDeleted (in nsIAbDirectory aParentDirectory, in nsISupports aDirectory); */
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryDeleted(nsIAbDirectory *aParentDirectory, nsISupports *aDirectory) = 0;

  /**
   * Returns the user profile directory. NOTE: this should not be used
   * as it may go away soon.
   */
  /* readonly attribute nsILocalFile userProfileDirectory; */
  NS_SCRIPTABLE NS_IMETHOD GetUserProfileDirectory(nsILocalFile **aUserProfileDirectory) = 0;

  /**
   * Finds out if the mailing list name exists in any *mork/MDB* based
   * address book
   *
   * @param  aName      The name of the list to try and find.
   *
   * @return            True if the name exists.
   */
  /* boolean mailListNameExists (in wstring name); */
  NS_SCRIPTABLE NS_IMETHOD MailListNameExists(const PRUnichar *name, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Translates an escaped vcard string into a nsIAbCard.
   *
   * @param  escapedVCardStr  The string containing the vcard.
   *
   * @return            A card containing the translated vcard data.
   */
  /* nsIAbCard escapedVCardToAbCard (in string escapedVCardStr); */
  NS_SCRIPTABLE NS_IMETHOD EscapedVCardToAbCard(const char *escapedVCardStr, nsIAbCard **_retval NS_OUTPARAM) = 0;

  /**
   * Generates a UUID from a (directory ID, local ID) tuple.
   *
   * Use of this method is preferred in such cases, since it is designed to work
   * with other methods of this interface.
   *
   * @param directoryId The directory ID.
   * @param localId     The per-directory ID.
   * @return            A string to use for the UUID.
   */
  /* AUTF8String generateUUID (in AUTF8String directoryId, in AUTF8String localId); */
  NS_SCRIPTABLE NS_IMETHOD GenerateUUID(const nsACString & directoryId, const nsACString & localId, nsACString & _retval NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAbManager, NS_IABMANAGER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIABMANAGER \
  NS_SCRIPTABLE NS_IMETHOD GetDirectories(nsISimpleEnumerator **aDirectories); \
  NS_SCRIPTABLE NS_IMETHOD GetDirectory(const nsACString & aURI, nsIAbDirectory **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD NewAddressBook(const nsAString & aDirName, const nsACString & aURI, PRUint32 aType, const nsACString & aPrefName, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD DeleteAddressBook(const nsACString & aURI); \
  NS_SCRIPTABLE NS_IMETHOD ExportAddressBook(nsIDOMWindow *aParentWin, nsIAbDirectory *aDirectory); \
  NS_SCRIPTABLE NS_IMETHOD AddAddressBookListener(nsIAbListener *aListener, abListenerNotifyFlagValue aNotifyFlags); \
  NS_SCRIPTABLE NS_IMETHOD RemoveAddressBookListener(nsIAbListener *aListener); \
  NS_SCRIPTABLE NS_IMETHOD NotifyItemPropertyChanged(nsISupports *aItem, const char *aProperty, const PRUnichar *aOldValue, const PRUnichar *aNewValue); \
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryItemAdded(nsIAbDirectory *aParentDirectory, nsISupports *aItem); \
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryItemDeleted(nsIAbDirectory *aParentDirectory, nsISupports *aItem); \
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryDeleted(nsIAbDirectory *aParentDirectory, nsISupports *aDirectory); \
  NS_SCRIPTABLE NS_IMETHOD GetUserProfileDirectory(nsILocalFile **aUserProfileDirectory); \
  NS_SCRIPTABLE NS_IMETHOD MailListNameExists(const PRUnichar *name, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD EscapedVCardToAbCard(const char *escapedVCardStr, nsIAbCard **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GenerateUUID(const nsACString & directoryId, const nsACString & localId, nsACString & _retval NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIABMANAGER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetDirectories(nsISimpleEnumerator **aDirectories) { return _to GetDirectories(aDirectories); } \
  NS_SCRIPTABLE NS_IMETHOD GetDirectory(const nsACString & aURI, nsIAbDirectory **_retval NS_OUTPARAM) { return _to GetDirectory(aURI, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD NewAddressBook(const nsAString & aDirName, const nsACString & aURI, PRUint32 aType, const nsACString & aPrefName, nsACString & _retval NS_OUTPARAM) { return _to NewAddressBook(aDirName, aURI, aType, aPrefName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteAddressBook(const nsACString & aURI) { return _to DeleteAddressBook(aURI); } \
  NS_SCRIPTABLE NS_IMETHOD ExportAddressBook(nsIDOMWindow *aParentWin, nsIAbDirectory *aDirectory) { return _to ExportAddressBook(aParentWin, aDirectory); } \
  NS_SCRIPTABLE NS_IMETHOD AddAddressBookListener(nsIAbListener *aListener, abListenerNotifyFlagValue aNotifyFlags) { return _to AddAddressBookListener(aListener, aNotifyFlags); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveAddressBookListener(nsIAbListener *aListener) { return _to RemoveAddressBookListener(aListener); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyItemPropertyChanged(nsISupports *aItem, const char *aProperty, const PRUnichar *aOldValue, const PRUnichar *aNewValue) { return _to NotifyItemPropertyChanged(aItem, aProperty, aOldValue, aNewValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryItemAdded(nsIAbDirectory *aParentDirectory, nsISupports *aItem) { return _to NotifyDirectoryItemAdded(aParentDirectory, aItem); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryItemDeleted(nsIAbDirectory *aParentDirectory, nsISupports *aItem) { return _to NotifyDirectoryItemDeleted(aParentDirectory, aItem); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryDeleted(nsIAbDirectory *aParentDirectory, nsISupports *aDirectory) { return _to NotifyDirectoryDeleted(aParentDirectory, aDirectory); } \
  NS_SCRIPTABLE NS_IMETHOD GetUserProfileDirectory(nsILocalFile **aUserProfileDirectory) { return _to GetUserProfileDirectory(aUserProfileDirectory); } \
  NS_SCRIPTABLE NS_IMETHOD MailListNameExists(const PRUnichar *name, PRBool *_retval NS_OUTPARAM) { return _to MailListNameExists(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD EscapedVCardToAbCard(const char *escapedVCardStr, nsIAbCard **_retval NS_OUTPARAM) { return _to EscapedVCardToAbCard(escapedVCardStr, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GenerateUUID(const nsACString & directoryId, const nsACString & localId, nsACString & _retval NS_OUTPARAM) { return _to GenerateUUID(directoryId, localId, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIABMANAGER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetDirectories(nsISimpleEnumerator **aDirectories) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDirectories(aDirectories); } \
  NS_SCRIPTABLE NS_IMETHOD GetDirectory(const nsACString & aURI, nsIAbDirectory **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDirectory(aURI, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD NewAddressBook(const nsAString & aDirName, const nsACString & aURI, PRUint32 aType, const nsACString & aPrefName, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->NewAddressBook(aDirName, aURI, aType, aPrefName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteAddressBook(const nsACString & aURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteAddressBook(aURI); } \
  NS_SCRIPTABLE NS_IMETHOD ExportAddressBook(nsIDOMWindow *aParentWin, nsIAbDirectory *aDirectory) { return !_to ? NS_ERROR_NULL_POINTER : _to->ExportAddressBook(aParentWin, aDirectory); } \
  NS_SCRIPTABLE NS_IMETHOD AddAddressBookListener(nsIAbListener *aListener, abListenerNotifyFlagValue aNotifyFlags) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddAddressBookListener(aListener, aNotifyFlags); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveAddressBookListener(nsIAbListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveAddressBookListener(aListener); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyItemPropertyChanged(nsISupports *aItem, const char *aProperty, const PRUnichar *aOldValue, const PRUnichar *aNewValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyItemPropertyChanged(aItem, aProperty, aOldValue, aNewValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryItemAdded(nsIAbDirectory *aParentDirectory, nsISupports *aItem) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyDirectoryItemAdded(aParentDirectory, aItem); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryItemDeleted(nsIAbDirectory *aParentDirectory, nsISupports *aItem) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyDirectoryItemDeleted(aParentDirectory, aItem); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyDirectoryDeleted(nsIAbDirectory *aParentDirectory, nsISupports *aDirectory) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyDirectoryDeleted(aParentDirectory, aDirectory); } \
  NS_SCRIPTABLE NS_IMETHOD GetUserProfileDirectory(nsILocalFile **aUserProfileDirectory) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUserProfileDirectory(aUserProfileDirectory); } \
  NS_SCRIPTABLE NS_IMETHOD MailListNameExists(const PRUnichar *name, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->MailListNameExists(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD EscapedVCardToAbCard(const char *escapedVCardStr, nsIAbCard **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->EscapedVCardToAbCard(escapedVCardStr, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GenerateUUID(const nsACString & directoryId, const nsACString & localId, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GenerateUUID(directoryId, localId, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAbManager : public nsIAbManager
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIABMANAGER

  nsAbManager();

private:
  ~nsAbManager();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAbManager, nsIAbManager)

nsAbManager::nsAbManager()
{
  /* member initializers and constructor code */
}

nsAbManager::~nsAbManager()
{
  /* destructor code */
}

/* readonly attribute nsISimpleEnumerator directories; */
NS_IMETHODIMP nsAbManager::GetDirectories(nsISimpleEnumerator **aDirectories)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAbDirectory getDirectory (in ACString aURI); */
NS_IMETHODIMP nsAbManager::GetDirectory(const nsACString & aURI, nsIAbDirectory **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString newAddressBook (in AString aDirName, in ACString aURI, in unsigned long aType, [optional] in ACString aPrefName); */
NS_IMETHODIMP nsAbManager::NewAddressBook(const nsAString & aDirName, const nsACString & aURI, PRUint32 aType, const nsACString & aPrefName, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteAddressBook (in ACString aURI); */
NS_IMETHODIMP nsAbManager::DeleteAddressBook(const nsACString & aURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void exportAddressBook (in nsIDOMWindow aParentWin, in nsIAbDirectory aDirectory); */
NS_IMETHODIMP nsAbManager::ExportAddressBook(nsIDOMWindow *aParentWin, nsIAbDirectory *aDirectory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addAddressBookListener (in nsIAbListener aListener, in abListenerNotifyFlagValue aNotifyFlags); */
NS_IMETHODIMP nsAbManager::AddAddressBookListener(nsIAbListener *aListener, abListenerNotifyFlagValue aNotifyFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeAddressBookListener (in nsIAbListener aListener); */
NS_IMETHODIMP nsAbManager::RemoveAddressBookListener(nsIAbListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void notifyItemPropertyChanged (in nsISupports aItem, in string aProperty, in wstring aOldValue, in wstring aNewValue); */
NS_IMETHODIMP nsAbManager::NotifyItemPropertyChanged(nsISupports *aItem, const char *aProperty, const PRUnichar *aOldValue, const PRUnichar *aNewValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void notifyDirectoryItemAdded (in nsIAbDirectory aParentDirectory, in nsISupports aItem); */
NS_IMETHODIMP nsAbManager::NotifyDirectoryItemAdded(nsIAbDirectory *aParentDirectory, nsISupports *aItem)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void notifyDirectoryItemDeleted (in nsIAbDirectory aParentDirectory, in nsISupports aItem); */
NS_IMETHODIMP nsAbManager::NotifyDirectoryItemDeleted(nsIAbDirectory *aParentDirectory, nsISupports *aItem)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void notifyDirectoryDeleted (in nsIAbDirectory aParentDirectory, in nsISupports aDirectory); */
NS_IMETHODIMP nsAbManager::NotifyDirectoryDeleted(nsIAbDirectory *aParentDirectory, nsISupports *aDirectory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsILocalFile userProfileDirectory; */
NS_IMETHODIMP nsAbManager::GetUserProfileDirectory(nsILocalFile **aUserProfileDirectory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean mailListNameExists (in wstring name); */
NS_IMETHODIMP nsAbManager::MailListNameExists(const PRUnichar *name, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAbCard escapedVCardToAbCard (in string escapedVCardStr); */
NS_IMETHODIMP nsAbManager::EscapedVCardToAbCard(const char *escapedVCardStr, nsIAbCard **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AUTF8String generateUUID (in AUTF8String directoryId, in AUTF8String localId); */
NS_IMETHODIMP nsAbManager::GenerateUUID(const nsACString & directoryId, const nsACString & localId, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAbManager_h__ */
