/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAddrDatabase.idl
 */

#ifndef __gen_nsIAddrDatabase_h__
#define __gen_nsIAddrDatabase_h__


#ifndef __gen_nsIAddrDBAnnouncer_h__
#include "nsIAddrDBAnnouncer.h"
#endif

#ifndef __gen_nsIAbCard_h__
#include "nsIAbCard.h"
#endif

#ifndef __gen_nsIAbDirectory_h__
#include "nsIAbDirectory.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIFile; /* forward declaration */

class nsIMdbTableRowCursor; /* forward declaration */

class nsIMdbEnv; /* forward declaration */

class nsIMdbRow; /* forward declaration */

class nsIArray; /* forward declaration */

class nsISimpleEnumerator; /* forward declaration */

// this is the prefix we for attributes that are specific
// to the mozilla addressbook, and weren't in 4.x and aren't specified in
// RFC 2789.  used when exporting and import LDIF
// see nsTextAddress.cpp, nsAddressBook.cpp
#define MOZ_AB_LDIF_PREFIX "mozilla"
// note, GeneratedName is not a real column
// if you change any of this, make sure to change 
// Get / Set CardValue in nsAbCardProperty.cpp
#define kPhoneticNameColumn       "_PhoneticName"
#define kAddressCharSetColumn     "AddrCharSet"
#define kMailListName             "ListName"
#define kMailListNickName         "ListNickName"
#define kMailListDescription      "ListDescription"
#define kMailListTotalAddresses   "ListTotalAddresses"
// not shown in the UI
#define kLowerPriEmailColumn      "LowercasePrimaryEmail"
// Palm Integration
#define  CARD_ATTRIB_PALMID "PalmRecId"
#define  CARD_ATTRIB_DISPLAY "DisplayName"

/* starting interface:    nsAddrDBCommitType */
#define NS_ADDRDBCOMMITTYPE_IID_STR "8532d6db-95eb-48b3-8879-26e7168b90f7"

#define NS_ADDRDBCOMMITTYPE_IID \
  {0x8532d6db, 0x95eb, 0x48b3, \
    { 0x88, 0x79, 0x26, 0xe7, 0x16, 0x8b, 0x90, 0xf7 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsAddrDBCommitType {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ADDRDBCOMMITTYPE_IID)

  enum { kSmallCommit = 0 };

  enum { kLargeCommit = 1 };

  enum { kSessionCommit = 2 };

  enum { kCompressCommit = 3 };

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsAddrDBCommitType, NS_ADDRDBCOMMITTYPE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSADDRDBCOMMITTYPE \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSADDRDBCOMMITTYPE(_to) \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSADDRDBCOMMITTYPE(_to) \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public nsAddrDBCommitType
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSADDRDBCOMMITTYPE

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, nsAddrDBCommitType)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIAddrDatabase */
#define NS_IADDRDATABASE_IID_STR "a71d3d0d-5605-4dd9-8ac1-b258cc3bda93"

#define NS_IADDRDATABASE_IID \
  {0xa71d3d0d, 0x5605, 0x4dd9, \
    { 0x8a, 0xc1, 0xb2, 0x58, 0xcc, 0x3b, 0xda, 0x93 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIAddrDatabase : public nsIAddrDBAnnouncer {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IADDRDATABASE_IID)

  /**
   * Path to the address book database that this instance represents.
   */
  /* attribute nsIFile dbPath; */
  NS_SCRIPTABLE NS_IMETHOD GetDbPath(nsIFile **aDbPath) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDbPath(nsIFile *aDbPath) = 0;

  /* nsIAddrDatabase open (in nsIFile dbFile, in boolean create, in boolean upgrading); */
  NS_SCRIPTABLE NS_IMETHOD Open(nsIFile *dbFile, PRBool create, PRBool upgrading, nsIAddrDatabase **_retval NS_OUTPARAM) = 0;

  /* void close (in boolean forceCommit); */
  NS_SCRIPTABLE NS_IMETHOD Close(PRBool forceCommit) = 0;

  /**
   * Open the MDB database synchronously creating it if required. If
   * successful, this routine will set up the m_mdbStore and m_mdbEnv of the
   * database object so other database calls can work.
   *
   * @param     dbName                      The location of the database file
   *                                        to open.
   * @param     create                      If set to true, will create the
   *                                        database file if it does not
   *                                        already exist.
   * @exception NS_ERROR_FILE_NOT_FOUND     The file was not found at the
   *                                        specified location (and create was
   *                                        false).
   * @exception NS_ERROR_FILE_ACCESS_DENIED The file could not be opened as
   *                                        access was denied.
   */
  /* void openMDB (in nsIFile dbName, in boolean create); */
  NS_SCRIPTABLE NS_IMETHOD OpenMDB(nsIFile *dbName, PRBool create) = 0;

  /* void closeMDB (in boolean commit); */
  NS_SCRIPTABLE NS_IMETHOD CloseMDB(PRBool commit) = 0;

  /* void commit (in unsigned long commitType); */
  NS_SCRIPTABLE NS_IMETHOD Commit(PRUint32 commitType) = 0;

  /* void forceClosed (); */
  NS_SCRIPTABLE NS_IMETHOD ForceClosed(void) = 0;

  /**
   * Create a new card and add to the database
   *
   * @param     aNewCard       the card to be added
   * @param     aNotify        if set to true, all the listeners of the
   *                           database will be notified.
   * @param     aParent        parent directory or mailing list to which the
   *                           card is added. If set to null, listeners of the
   *                           database will not be notified of card creation.
   */
  /* void createNewCardAndAddToDB (in nsIAbCard aNewCard, in boolean aNotify, in nsIAbDirectory aParent); */
  NS_SCRIPTABLE NS_IMETHOD CreateNewCardAndAddToDB(nsIAbCard *aNewCard, PRBool aNotify, nsIAbDirectory *aParent) = 0;

  /* void createNewListCardAndAddToDB (in nsIAbDirectory list, in unsigned long listRowID, in nsIAbCard newCard, in boolean aNotify); */
  NS_SCRIPTABLE NS_IMETHOD CreateNewListCardAndAddToDB(nsIAbDirectory *list, PRUint32 listRowID, nsIAbCard *newCard, PRBool aNotify) = 0;

  /**
   * Create a new mailing list and add to the database
   *
   * @param     aNewList       the mailing list to be added.
   * @param     aNotify        if set to true, all the listeners of the
   *                           database will be notified.
   * @param     aParent        parent directory to which the mailing list
   *                           is added. If set to null, listeners of the database
   *                           will not be notified of mailing list creation.
   */
  /* void createMailListAndAddToDB (in nsIAbDirectory aNewList, in boolean aNotify, in nsIAbDirectory aParent); */
  NS_SCRIPTABLE NS_IMETHOD CreateMailListAndAddToDB(nsIAbDirectory *aNewList, PRBool aNotify, nsIAbDirectory *aParent) = 0;

  /**
   * Enumerate the cards in the directory. The enumerator will return the
   * cards associated with mailing lists too.
   *
   * @param directory the directory of which to enumerate the cards.
   * @return an enumerator.
   */
  /* nsISimpleEnumerator enumerateCards (in nsIAbDirectory directory); */
  NS_SCRIPTABLE NS_IMETHOD EnumerateCards(nsIAbDirectory *directory, nsISimpleEnumerator **_retval NS_OUTPARAM) = 0;

  /**
   * Enumerate the cards associated with the mailing lists in the directory.
   *
   * @param directory the directory of which to enumerate the cards.
   * @return an enumerator.
   */
  /* nsISimpleEnumerator enumerateListAddresses (in nsIAbDirectory directory); */
  NS_SCRIPTABLE NS_IMETHOD EnumerateListAddresses(nsIAbDirectory *directory, nsISimpleEnumerator **_retval NS_OUTPARAM) = 0;

  /* void getMailingListsFromDB (in nsIAbDirectory parentDir); */
  NS_SCRIPTABLE NS_IMETHOD GetMailingListsFromDB(nsIAbDirectory *parentDir) = 0;

  /**
   * Delete a card from the database.
   *
   * @param     aCard          the card to be deleted.
   * @param     aNotify        if set to true, all the listeners of the
   *                           database will be notified.
   * @param     aParent        parent directory from which the card
   *                           is to be deleted. If set to null, listeners of
   *                           the database will not be notified of card deletion.
   */
  /* void deleteCard (in nsIAbCard aCard, in boolean aNotify, in nsIAbDirectory aParent); */
  NS_SCRIPTABLE NS_IMETHOD DeleteCard(nsIAbCard *aCard, PRBool aNotify, nsIAbDirectory *aParent) = 0;

  /**
   * Edit a card in the database.
   *
   * @param     aCard          the card to be edited.
   * @param     aNotify        if set to true, all the listeners of the
   *                           database will be notified.
   * @param     aParent        parent directory in which the card
   *                           is to be edited. If set to null, listeners of
   *                           the database will not be notified of card entry
   *                           change.
   */
  /* void editCard (in nsIAbCard aCard, in boolean aNotify, in nsIAbDirectory aParent); */
  NS_SCRIPTABLE NS_IMETHOD EditCard(nsIAbCard *aCard, PRBool aNotify, nsIAbDirectory *aParent) = 0;

  /* boolean containsCard (in nsIAbCard card); */
  NS_SCRIPTABLE NS_IMETHOD ContainsCard(nsIAbCard *card, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Deletes a mailing list from the directory
   *
   * @param aMailList         The nsIAbDirectory implementation of the mailing
   *                          list that is to be deleted.
   * @param aParent           The parent of the mailing list that is being
   *                          deleted. If this is supplied, then a notification
   *                          of card entry change in the database will be made.
   */
  /* void deleteMailList (in nsIAbDirectory aMailList, [optional] in nsIAbDirectory aParent); */
  NS_SCRIPTABLE NS_IMETHOD DeleteMailList(nsIAbDirectory *aMailList, nsIAbDirectory *aParent) = 0;

  /* void editMailList (in nsIAbDirectory mailList, in nsIAbCard listCard, in boolean aNotify); */
  NS_SCRIPTABLE NS_IMETHOD EditMailList(nsIAbDirectory *mailList, nsIAbCard *listCard, PRBool aNotify) = 0;

  /* boolean containsMailList (in nsIAbDirectory mailList); */
  NS_SCRIPTABLE NS_IMETHOD ContainsMailList(nsIAbDirectory *mailList, PRBool *_retval NS_OUTPARAM) = 0;

  /* void deleteCardFromMailList (in nsIAbDirectory mailList, in nsIAbCard card, in boolean aNotify); */
  NS_SCRIPTABLE NS_IMETHOD DeleteCardFromMailList(nsIAbDirectory *mailList, nsIAbCard *card, PRBool aNotify) = 0;

  /**
   * Gets the first card which matches the attribute/value pair supplied.
   *
   * @param  aDirectory       The current nsIAbDirectory associated with this
   *                          instance of the database.
   * @param  aName            The attribute to look up the value in.
   * @param  aUTF8Value       The value to look up in UTF8 format.
   * @param  aCaseInsensitive Set to true for case-insenstive matching.
   * @result                  Returns an nsIAbCard if one is found, otherwise
   *                          NULL.
   */
  /* nsIAbCard getCardFromAttribute (in nsIAbDirectory aDirectory, in string aName, in AUTF8String aUTF8Value, in boolean aCaseInsensitive); */
  NS_SCRIPTABLE NS_IMETHOD GetCardFromAttribute(nsIAbDirectory *aDirectory, const char *aName, const nsACString & aUTF8Value, PRBool aCaseInsensitive, nsIAbCard **_retval NS_OUTPARAM) = 0;

  /**
   * Gets all cards which matches the attribute/value pair supplied.
   *
   * @param  aDirectory       The current nsIAbDirectory associated with this
   *                          instance of the database.
   * @param  aName            The attribute to look up the value in.
   * @param  aUTF8Value       The value to look up in UTF8 format.
   * @param  aCaseInsensitive Set to true for case-insenstive matching.
   * @result                  Returns an nsISimpleEnumerator of nsIAbCard
   *                          instances.
   */
  /* nsISimpleEnumerator getCardsFromAttribute (in nsIAbDirectory aDirectory, in string aName, in AUTF8String uUTF8Value, in boolean aCaseInsensitive); */
  NS_SCRIPTABLE NS_IMETHOD GetCardsFromAttribute(nsIAbDirectory *aDirectory, const char *aName, const nsACString & uUTF8Value, PRBool aCaseInsensitive, nsISimpleEnumerator **_retval NS_OUTPARAM) = 0;

  /* PRBool findMailListbyUnicodeName (in wstring listName); */
  NS_SCRIPTABLE NS_IMETHOD FindMailListbyUnicodeName(const PRUnichar *listName, PRBool *_retval NS_OUTPARAM) = 0;

  /* void getCardCount (out PRUint32 count); */
  NS_SCRIPTABLE NS_IMETHOD GetCardCount(PRUint32 *count NS_OUTPARAM) = 0;

  /* [noscript] readonly attribute nsIMdbRow newRow; */
  NS_IMETHOD GetNewRow(nsIMdbRow **aNewRow) = 0;

  /* [noscript] readonly attribute nsIMdbRow newListRow; */
  NS_IMETHOD GetNewListRow(nsIMdbRow **aNewListRow) = 0;

  /* [noscript] void addCardRowToDB (in nsIMdbRow newRow); */
  NS_IMETHOD AddCardRowToDB(nsIMdbRow *newRow) = 0;

  /* [noscript] void addLdifListMember (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddLdifListMember(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addFirstName (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddFirstName(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addLastName (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddLastName(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addPhoneticFirstName (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddPhoneticFirstName(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addPhoneticLastName (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddPhoneticLastName(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addDisplayName (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddDisplayName(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addNickName (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddNickName(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addPrimaryEmail (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddPrimaryEmail(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void add2ndEmail (in nsIMdbRow row, in string value); */
  NS_IMETHOD Add2ndEmail(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addWorkPhone (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddWorkPhone(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addHomePhone (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddHomePhone(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addFaxNumber (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddFaxNumber(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addPagerNumber (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddPagerNumber(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addCellularNumber (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddCellularNumber(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addWorkPhoneType (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddWorkPhoneType(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addHomePhoneType (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddHomePhoneType(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addFaxNumberType (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddFaxNumberType(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addPagerNumberType (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddPagerNumberType(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addCellularNumberType (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddCellularNumberType(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addHomeAddress (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddHomeAddress(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addHomeAddress2 (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddHomeAddress2(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addHomeCity (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddHomeCity(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addHomeState (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddHomeState(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addHomeZipCode (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddHomeZipCode(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addHomeCountry (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddHomeCountry(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addWorkAddress (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddWorkAddress(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addWorkAddress2 (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddWorkAddress2(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addWorkCity (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddWorkCity(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addWorkState (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddWorkState(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addWorkZipCode (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddWorkZipCode(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addWorkCountry (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddWorkCountry(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addJobTitle (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddJobTitle(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addDepartment (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddDepartment(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addCompany (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddCompany(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addAimScreenName (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddAimScreenName(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addAnniversaryYear (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddAnniversaryYear(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addAnniversaryMonth (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddAnniversaryMonth(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addAnniversaryDay (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddAnniversaryDay(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addSpouseName (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddSpouseName(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addFamilyName (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddFamilyName(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addDefaultAddress (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddDefaultAddress(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addCategory (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddCategory(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addWebPage1 (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddWebPage1(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addWebPage2 (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddWebPage2(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addBirthYear (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddBirthYear(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addBirthMonth (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddBirthMonth(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addBirthDay (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddBirthDay(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addCustom1 (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddCustom1(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addCustom2 (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddCustom2(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addCustom3 (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddCustom3(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addCustom4 (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddCustom4(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addNotes (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddNotes(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addPreferMailFormat (in nsIMdbRow row, in unsigned long value); */
  NS_IMETHOD AddPreferMailFormat(nsIMdbRow *row, PRUint32 value) = 0;

  /* [noscript] void addPopularityIndex (in nsIMdbRow row, in unsigned long value); */
  NS_IMETHOD AddPopularityIndex(nsIMdbRow *row, PRUint32 value) = 0;

  /* [noscript] void addAllowRemoteContent (in nsIMdbRow row, in boolean value); */
  NS_IMETHOD AddAllowRemoteContent(nsIMdbRow *row, PRBool value) = 0;

  /* [noscript] void addListName (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddListName(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addListNickName (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddListNickName(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addListDescription (in nsIMdbRow row, in string value); */
  NS_IMETHOD AddListDescription(nsIMdbRow *row, const char *value) = 0;

  /* [noscript] void addListDirNode (in nsIMdbRow listRow); */
  NS_IMETHOD AddListDirNode(nsIMdbRow *listRow) = 0;

  /**
   * use for getting and setting generic string attributes
   * like _AimScreenName
   */
  /* void setCardValue (in nsIAbCard card, in string name, in wstring value, in boolean notify); */
  NS_SCRIPTABLE NS_IMETHOD SetCardValue(nsIAbCard *card, const char *name, const PRUnichar *value, PRBool notify) = 0;

  /* wstring getCardValue (in nsIAbCard card, in string name); */
  NS_SCRIPTABLE NS_IMETHOD GetCardValue(nsIAbCard *card, const char *name, PRUnichar **_retval NS_OUTPARAM) = 0;

  /**
   * Returns an array of the deleted cards currently stored in the mork file.
   */
  /* readonly attribute nsIArray deletedCardList; */
  NS_SCRIPTABLE NS_IMETHOD GetDeletedCardList(nsIArray **aDeletedCardList) = 0;

  /**
   * Returns the count of the deleted card currently stored in the mork file.
   */
  /* readonly attribute unsigned long deletedCardCount; */
  NS_SCRIPTABLE NS_IMETHOD GetDeletedCardCount(PRUint32 *aDeletedCardCount) = 0;

  /**
   * Add the column representing the card to the mailing list row
   * in the database.
   *
   * @param     aPCard         the card to be added.
   * @param     aPListRow      the row to which the column will be added.
   * @param     aPos           the position of the card in the mailing list.
   * @param     aPNewCard      a pointer to hold the new card added to the row.
   * @param     aInMailingList If set to true, the card is already present
   *                           in the mailing list
   * @param     aParent        parent mailing list to which the card
   *                           is added. If set to null, listeners of the
   *                           database will not be notified of card creation.
   * @param     aRoot          If the card is created while creating a new mailing 
   *                           list, its set to the parent addressbook.
   *                           Set to null in other case.
   */
  /* void AddListCardColumnsToRow (in nsIAbCard aPCard, in nsIMdbRow aPListRow, in unsigned long aPos, out nsIAbCard aPNewCard, in boolean aInMailingList, in nsIAbDirectory aParent, in nsIAbDirectory aRoot); */
  NS_SCRIPTABLE NS_IMETHOD AddListCardColumnsToRow(nsIAbCard *aPCard, nsIMdbRow *aPListRow, PRUint32 aPos, nsIAbCard **aPNewCard NS_OUTPARAM, PRBool aInMailingList, nsIAbDirectory *aParent, nsIAbDirectory *aRoot) = 0;

  /* void InitCardFromRow (in nsIAbCard aNewCard, in nsIMdbRow aCardRow); */
  NS_SCRIPTABLE NS_IMETHOD InitCardFromRow(nsIAbCard *aNewCard, nsIMdbRow *aCardRow) = 0;

  /* void SetListAddressTotal (in nsIMdbRow aListRow, in PRUint32 aTotal); */
  NS_SCRIPTABLE NS_IMETHOD SetListAddressTotal(nsIMdbRow *aListRow, PRUint32 aTotal) = 0;

  /* nsIMdbRow FindRowByCard (in nsIAbCard aCard); */
  NS_SCRIPTABLE NS_IMETHOD FindRowByCard(nsIAbCard *aCard, nsIMdbRow **_retval NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAddrDatabase, NS_IADDRDATABASE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIADDRDATABASE \
  NS_SCRIPTABLE NS_IMETHOD GetDbPath(nsIFile **aDbPath); \
  NS_SCRIPTABLE NS_IMETHOD SetDbPath(nsIFile *aDbPath); \
  NS_SCRIPTABLE NS_IMETHOD Open(nsIFile *dbFile, PRBool create, PRBool upgrading, nsIAddrDatabase **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD Close(PRBool forceCommit); \
  NS_SCRIPTABLE NS_IMETHOD OpenMDB(nsIFile *dbName, PRBool create); \
  NS_SCRIPTABLE NS_IMETHOD CloseMDB(PRBool commit); \
  NS_SCRIPTABLE NS_IMETHOD Commit(PRUint32 commitType); \
  NS_SCRIPTABLE NS_IMETHOD ForceClosed(void); \
  NS_SCRIPTABLE NS_IMETHOD CreateNewCardAndAddToDB(nsIAbCard *aNewCard, PRBool aNotify, nsIAbDirectory *aParent); \
  NS_SCRIPTABLE NS_IMETHOD CreateNewListCardAndAddToDB(nsIAbDirectory *list, PRUint32 listRowID, nsIAbCard *newCard, PRBool aNotify); \
  NS_SCRIPTABLE NS_IMETHOD CreateMailListAndAddToDB(nsIAbDirectory *aNewList, PRBool aNotify, nsIAbDirectory *aParent); \
  NS_SCRIPTABLE NS_IMETHOD EnumerateCards(nsIAbDirectory *directory, nsISimpleEnumerator **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD EnumerateListAddresses(nsIAbDirectory *directory, nsISimpleEnumerator **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetMailingListsFromDB(nsIAbDirectory *parentDir); \
  NS_SCRIPTABLE NS_IMETHOD DeleteCard(nsIAbCard *aCard, PRBool aNotify, nsIAbDirectory *aParent); \
  NS_SCRIPTABLE NS_IMETHOD EditCard(nsIAbCard *aCard, PRBool aNotify, nsIAbDirectory *aParent); \
  NS_SCRIPTABLE NS_IMETHOD ContainsCard(nsIAbCard *card, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD DeleteMailList(nsIAbDirectory *aMailList, nsIAbDirectory *aParent); \
  NS_SCRIPTABLE NS_IMETHOD EditMailList(nsIAbDirectory *mailList, nsIAbCard *listCard, PRBool aNotify); \
  NS_SCRIPTABLE NS_IMETHOD ContainsMailList(nsIAbDirectory *mailList, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD DeleteCardFromMailList(nsIAbDirectory *mailList, nsIAbCard *card, PRBool aNotify); \
  NS_SCRIPTABLE NS_IMETHOD GetCardFromAttribute(nsIAbDirectory *aDirectory, const char *aName, const nsACString & aUTF8Value, PRBool aCaseInsensitive, nsIAbCard **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetCardsFromAttribute(nsIAbDirectory *aDirectory, const char *aName, const nsACString & uUTF8Value, PRBool aCaseInsensitive, nsISimpleEnumerator **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD FindMailListbyUnicodeName(const PRUnichar *listName, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetCardCount(PRUint32 *count NS_OUTPARAM); \
  NS_IMETHOD GetNewRow(nsIMdbRow **aNewRow); \
  NS_IMETHOD GetNewListRow(nsIMdbRow **aNewListRow); \
  NS_IMETHOD AddCardRowToDB(nsIMdbRow *newRow); \
  NS_IMETHOD AddLdifListMember(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddFirstName(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddLastName(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddPhoneticFirstName(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddPhoneticLastName(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddDisplayName(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddNickName(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddPrimaryEmail(nsIMdbRow *row, const char *value); \
  NS_IMETHOD Add2ndEmail(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddWorkPhone(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddHomePhone(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddFaxNumber(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddPagerNumber(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddCellularNumber(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddWorkPhoneType(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddHomePhoneType(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddFaxNumberType(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddPagerNumberType(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddCellularNumberType(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddHomeAddress(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddHomeAddress2(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddHomeCity(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddHomeState(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddHomeZipCode(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddHomeCountry(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddWorkAddress(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddWorkAddress2(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddWorkCity(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddWorkState(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddWorkZipCode(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddWorkCountry(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddJobTitle(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddDepartment(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddCompany(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddAimScreenName(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddAnniversaryYear(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddAnniversaryMonth(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddAnniversaryDay(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddSpouseName(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddFamilyName(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddDefaultAddress(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddCategory(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddWebPage1(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddWebPage2(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddBirthYear(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddBirthMonth(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddBirthDay(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddCustom1(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddCustom2(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddCustom3(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddCustom4(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddNotes(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddPreferMailFormat(nsIMdbRow *row, PRUint32 value); \
  NS_IMETHOD AddPopularityIndex(nsIMdbRow *row, PRUint32 value); \
  NS_IMETHOD AddAllowRemoteContent(nsIMdbRow *row, PRBool value); \
  NS_IMETHOD AddListName(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddListNickName(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddListDescription(nsIMdbRow *row, const char *value); \
  NS_IMETHOD AddListDirNode(nsIMdbRow *listRow); \
  NS_SCRIPTABLE NS_IMETHOD SetCardValue(nsIAbCard *card, const char *name, const PRUnichar *value, PRBool notify); \
  NS_SCRIPTABLE NS_IMETHOD GetCardValue(nsIAbCard *card, const char *name, PRUnichar **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetDeletedCardList(nsIArray **aDeletedCardList); \
  NS_SCRIPTABLE NS_IMETHOD GetDeletedCardCount(PRUint32 *aDeletedCardCount); \
  NS_SCRIPTABLE NS_IMETHOD AddListCardColumnsToRow(nsIAbCard *aPCard, nsIMdbRow *aPListRow, PRUint32 aPos, nsIAbCard **aPNewCard NS_OUTPARAM, PRBool aInMailingList, nsIAbDirectory *aParent, nsIAbDirectory *aRoot); \
  NS_SCRIPTABLE NS_IMETHOD InitCardFromRow(nsIAbCard *aNewCard, nsIMdbRow *aCardRow); \
  NS_SCRIPTABLE NS_IMETHOD SetListAddressTotal(nsIMdbRow *aListRow, PRUint32 aTotal); \
  NS_SCRIPTABLE NS_IMETHOD FindRowByCard(nsIAbCard *aCard, nsIMdbRow **_retval NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIADDRDATABASE(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetDbPath(nsIFile **aDbPath) { return _to GetDbPath(aDbPath); } \
  NS_SCRIPTABLE NS_IMETHOD SetDbPath(nsIFile *aDbPath) { return _to SetDbPath(aDbPath); } \
  NS_SCRIPTABLE NS_IMETHOD Open(nsIFile *dbFile, PRBool create, PRBool upgrading, nsIAddrDatabase **_retval NS_OUTPARAM) { return _to Open(dbFile, create, upgrading, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Close(PRBool forceCommit) { return _to Close(forceCommit); } \
  NS_SCRIPTABLE NS_IMETHOD OpenMDB(nsIFile *dbName, PRBool create) { return _to OpenMDB(dbName, create); } \
  NS_SCRIPTABLE NS_IMETHOD CloseMDB(PRBool commit) { return _to CloseMDB(commit); } \
  NS_SCRIPTABLE NS_IMETHOD Commit(PRUint32 commitType) { return _to Commit(commitType); } \
  NS_SCRIPTABLE NS_IMETHOD ForceClosed(void) { return _to ForceClosed(); } \
  NS_SCRIPTABLE NS_IMETHOD CreateNewCardAndAddToDB(nsIAbCard *aNewCard, PRBool aNotify, nsIAbDirectory *aParent) { return _to CreateNewCardAndAddToDB(aNewCard, aNotify, aParent); } \
  NS_SCRIPTABLE NS_IMETHOD CreateNewListCardAndAddToDB(nsIAbDirectory *list, PRUint32 listRowID, nsIAbCard *newCard, PRBool aNotify) { return _to CreateNewListCardAndAddToDB(list, listRowID, newCard, aNotify); } \
  NS_SCRIPTABLE NS_IMETHOD CreateMailListAndAddToDB(nsIAbDirectory *aNewList, PRBool aNotify, nsIAbDirectory *aParent) { return _to CreateMailListAndAddToDB(aNewList, aNotify, aParent); } \
  NS_SCRIPTABLE NS_IMETHOD EnumerateCards(nsIAbDirectory *directory, nsISimpleEnumerator **_retval NS_OUTPARAM) { return _to EnumerateCards(directory, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD EnumerateListAddresses(nsIAbDirectory *directory, nsISimpleEnumerator **_retval NS_OUTPARAM) { return _to EnumerateListAddresses(directory, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetMailingListsFromDB(nsIAbDirectory *parentDir) { return _to GetMailingListsFromDB(parentDir); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteCard(nsIAbCard *aCard, PRBool aNotify, nsIAbDirectory *aParent) { return _to DeleteCard(aCard, aNotify, aParent); } \
  NS_SCRIPTABLE NS_IMETHOD EditCard(nsIAbCard *aCard, PRBool aNotify, nsIAbDirectory *aParent) { return _to EditCard(aCard, aNotify, aParent); } \
  NS_SCRIPTABLE NS_IMETHOD ContainsCard(nsIAbCard *card, PRBool *_retval NS_OUTPARAM) { return _to ContainsCard(card, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteMailList(nsIAbDirectory *aMailList, nsIAbDirectory *aParent) { return _to DeleteMailList(aMailList, aParent); } \
  NS_SCRIPTABLE NS_IMETHOD EditMailList(nsIAbDirectory *mailList, nsIAbCard *listCard, PRBool aNotify) { return _to EditMailList(mailList, listCard, aNotify); } \
  NS_SCRIPTABLE NS_IMETHOD ContainsMailList(nsIAbDirectory *mailList, PRBool *_retval NS_OUTPARAM) { return _to ContainsMailList(mailList, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteCardFromMailList(nsIAbDirectory *mailList, nsIAbCard *card, PRBool aNotify) { return _to DeleteCardFromMailList(mailList, card, aNotify); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardFromAttribute(nsIAbDirectory *aDirectory, const char *aName, const nsACString & aUTF8Value, PRBool aCaseInsensitive, nsIAbCard **_retval NS_OUTPARAM) { return _to GetCardFromAttribute(aDirectory, aName, aUTF8Value, aCaseInsensitive, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardsFromAttribute(nsIAbDirectory *aDirectory, const char *aName, const nsACString & uUTF8Value, PRBool aCaseInsensitive, nsISimpleEnumerator **_retval NS_OUTPARAM) { return _to GetCardsFromAttribute(aDirectory, aName, uUTF8Value, aCaseInsensitive, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FindMailListbyUnicodeName(const PRUnichar *listName, PRBool *_retval NS_OUTPARAM) { return _to FindMailListbyUnicodeName(listName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardCount(PRUint32 *count NS_OUTPARAM) { return _to GetCardCount(count); } \
  NS_IMETHOD GetNewRow(nsIMdbRow **aNewRow) { return _to GetNewRow(aNewRow); } \
  NS_IMETHOD GetNewListRow(nsIMdbRow **aNewListRow) { return _to GetNewListRow(aNewListRow); } \
  NS_IMETHOD AddCardRowToDB(nsIMdbRow *newRow) { return _to AddCardRowToDB(newRow); } \
  NS_IMETHOD AddLdifListMember(nsIMdbRow *row, const char *value) { return _to AddLdifListMember(row, value); } \
  NS_IMETHOD AddFirstName(nsIMdbRow *row, const char *value) { return _to AddFirstName(row, value); } \
  NS_IMETHOD AddLastName(nsIMdbRow *row, const char *value) { return _to AddLastName(row, value); } \
  NS_IMETHOD AddPhoneticFirstName(nsIMdbRow *row, const char *value) { return _to AddPhoneticFirstName(row, value); } \
  NS_IMETHOD AddPhoneticLastName(nsIMdbRow *row, const char *value) { return _to AddPhoneticLastName(row, value); } \
  NS_IMETHOD AddDisplayName(nsIMdbRow *row, const char *value) { return _to AddDisplayName(row, value); } \
  NS_IMETHOD AddNickName(nsIMdbRow *row, const char *value) { return _to AddNickName(row, value); } \
  NS_IMETHOD AddPrimaryEmail(nsIMdbRow *row, const char *value) { return _to AddPrimaryEmail(row, value); } \
  NS_IMETHOD Add2ndEmail(nsIMdbRow *row, const char *value) { return _to Add2ndEmail(row, value); } \
  NS_IMETHOD AddWorkPhone(nsIMdbRow *row, const char *value) { return _to AddWorkPhone(row, value); } \
  NS_IMETHOD AddHomePhone(nsIMdbRow *row, const char *value) { return _to AddHomePhone(row, value); } \
  NS_IMETHOD AddFaxNumber(nsIMdbRow *row, const char *value) { return _to AddFaxNumber(row, value); } \
  NS_IMETHOD AddPagerNumber(nsIMdbRow *row, const char *value) { return _to AddPagerNumber(row, value); } \
  NS_IMETHOD AddCellularNumber(nsIMdbRow *row, const char *value) { return _to AddCellularNumber(row, value); } \
  NS_IMETHOD AddWorkPhoneType(nsIMdbRow *row, const char *value) { return _to AddWorkPhoneType(row, value); } \
  NS_IMETHOD AddHomePhoneType(nsIMdbRow *row, const char *value) { return _to AddHomePhoneType(row, value); } \
  NS_IMETHOD AddFaxNumberType(nsIMdbRow *row, const char *value) { return _to AddFaxNumberType(row, value); } \
  NS_IMETHOD AddPagerNumberType(nsIMdbRow *row, const char *value) { return _to AddPagerNumberType(row, value); } \
  NS_IMETHOD AddCellularNumberType(nsIMdbRow *row, const char *value) { return _to AddCellularNumberType(row, value); } \
  NS_IMETHOD AddHomeAddress(nsIMdbRow *row, const char *value) { return _to AddHomeAddress(row, value); } \
  NS_IMETHOD AddHomeAddress2(nsIMdbRow *row, const char *value) { return _to AddHomeAddress2(row, value); } \
  NS_IMETHOD AddHomeCity(nsIMdbRow *row, const char *value) { return _to AddHomeCity(row, value); } \
  NS_IMETHOD AddHomeState(nsIMdbRow *row, const char *value) { return _to AddHomeState(row, value); } \
  NS_IMETHOD AddHomeZipCode(nsIMdbRow *row, const char *value) { return _to AddHomeZipCode(row, value); } \
  NS_IMETHOD AddHomeCountry(nsIMdbRow *row, const char *value) { return _to AddHomeCountry(row, value); } \
  NS_IMETHOD AddWorkAddress(nsIMdbRow *row, const char *value) { return _to AddWorkAddress(row, value); } \
  NS_IMETHOD AddWorkAddress2(nsIMdbRow *row, const char *value) { return _to AddWorkAddress2(row, value); } \
  NS_IMETHOD AddWorkCity(nsIMdbRow *row, const char *value) { return _to AddWorkCity(row, value); } \
  NS_IMETHOD AddWorkState(nsIMdbRow *row, const char *value) { return _to AddWorkState(row, value); } \
  NS_IMETHOD AddWorkZipCode(nsIMdbRow *row, const char *value) { return _to AddWorkZipCode(row, value); } \
  NS_IMETHOD AddWorkCountry(nsIMdbRow *row, const char *value) { return _to AddWorkCountry(row, value); } \
  NS_IMETHOD AddJobTitle(nsIMdbRow *row, const char *value) { return _to AddJobTitle(row, value); } \
  NS_IMETHOD AddDepartment(nsIMdbRow *row, const char *value) { return _to AddDepartment(row, value); } \
  NS_IMETHOD AddCompany(nsIMdbRow *row, const char *value) { return _to AddCompany(row, value); } \
  NS_IMETHOD AddAimScreenName(nsIMdbRow *row, const char *value) { return _to AddAimScreenName(row, value); } \
  NS_IMETHOD AddAnniversaryYear(nsIMdbRow *row, const char *value) { return _to AddAnniversaryYear(row, value); } \
  NS_IMETHOD AddAnniversaryMonth(nsIMdbRow *row, const char *value) { return _to AddAnniversaryMonth(row, value); } \
  NS_IMETHOD AddAnniversaryDay(nsIMdbRow *row, const char *value) { return _to AddAnniversaryDay(row, value); } \
  NS_IMETHOD AddSpouseName(nsIMdbRow *row, const char *value) { return _to AddSpouseName(row, value); } \
  NS_IMETHOD AddFamilyName(nsIMdbRow *row, const char *value) { return _to AddFamilyName(row, value); } \
  NS_IMETHOD AddDefaultAddress(nsIMdbRow *row, const char *value) { return _to AddDefaultAddress(row, value); } \
  NS_IMETHOD AddCategory(nsIMdbRow *row, const char *value) { return _to AddCategory(row, value); } \
  NS_IMETHOD AddWebPage1(nsIMdbRow *row, const char *value) { return _to AddWebPage1(row, value); } \
  NS_IMETHOD AddWebPage2(nsIMdbRow *row, const char *value) { return _to AddWebPage2(row, value); } \
  NS_IMETHOD AddBirthYear(nsIMdbRow *row, const char *value) { return _to AddBirthYear(row, value); } \
  NS_IMETHOD AddBirthMonth(nsIMdbRow *row, const char *value) { return _to AddBirthMonth(row, value); } \
  NS_IMETHOD AddBirthDay(nsIMdbRow *row, const char *value) { return _to AddBirthDay(row, value); } \
  NS_IMETHOD AddCustom1(nsIMdbRow *row, const char *value) { return _to AddCustom1(row, value); } \
  NS_IMETHOD AddCustom2(nsIMdbRow *row, const char *value) { return _to AddCustom2(row, value); } \
  NS_IMETHOD AddCustom3(nsIMdbRow *row, const char *value) { return _to AddCustom3(row, value); } \
  NS_IMETHOD AddCustom4(nsIMdbRow *row, const char *value) { return _to AddCustom4(row, value); } \
  NS_IMETHOD AddNotes(nsIMdbRow *row, const char *value) { return _to AddNotes(row, value); } \
  NS_IMETHOD AddPreferMailFormat(nsIMdbRow *row, PRUint32 value) { return _to AddPreferMailFormat(row, value); } \
  NS_IMETHOD AddPopularityIndex(nsIMdbRow *row, PRUint32 value) { return _to AddPopularityIndex(row, value); } \
  NS_IMETHOD AddAllowRemoteContent(nsIMdbRow *row, PRBool value) { return _to AddAllowRemoteContent(row, value); } \
  NS_IMETHOD AddListName(nsIMdbRow *row, const char *value) { return _to AddListName(row, value); } \
  NS_IMETHOD AddListNickName(nsIMdbRow *row, const char *value) { return _to AddListNickName(row, value); } \
  NS_IMETHOD AddListDescription(nsIMdbRow *row, const char *value) { return _to AddListDescription(row, value); } \
  NS_IMETHOD AddListDirNode(nsIMdbRow *listRow) { return _to AddListDirNode(listRow); } \
  NS_SCRIPTABLE NS_IMETHOD SetCardValue(nsIAbCard *card, const char *name, const PRUnichar *value, PRBool notify) { return _to SetCardValue(card, name, value, notify); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardValue(nsIAbCard *card, const char *name, PRUnichar **_retval NS_OUTPARAM) { return _to GetCardValue(card, name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetDeletedCardList(nsIArray **aDeletedCardList) { return _to GetDeletedCardList(aDeletedCardList); } \
  NS_SCRIPTABLE NS_IMETHOD GetDeletedCardCount(PRUint32 *aDeletedCardCount) { return _to GetDeletedCardCount(aDeletedCardCount); } \
  NS_SCRIPTABLE NS_IMETHOD AddListCardColumnsToRow(nsIAbCard *aPCard, nsIMdbRow *aPListRow, PRUint32 aPos, nsIAbCard **aPNewCard NS_OUTPARAM, PRBool aInMailingList, nsIAbDirectory *aParent, nsIAbDirectory *aRoot) { return _to AddListCardColumnsToRow(aPCard, aPListRow, aPos, aPNewCard, aInMailingList, aParent, aRoot); } \
  NS_SCRIPTABLE NS_IMETHOD InitCardFromRow(nsIAbCard *aNewCard, nsIMdbRow *aCardRow) { return _to InitCardFromRow(aNewCard, aCardRow); } \
  NS_SCRIPTABLE NS_IMETHOD SetListAddressTotal(nsIMdbRow *aListRow, PRUint32 aTotal) { return _to SetListAddressTotal(aListRow, aTotal); } \
  NS_SCRIPTABLE NS_IMETHOD FindRowByCard(nsIAbCard *aCard, nsIMdbRow **_retval NS_OUTPARAM) { return _to FindRowByCard(aCard, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIADDRDATABASE(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetDbPath(nsIFile **aDbPath) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDbPath(aDbPath); } \
  NS_SCRIPTABLE NS_IMETHOD SetDbPath(nsIFile *aDbPath) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDbPath(aDbPath); } \
  NS_SCRIPTABLE NS_IMETHOD Open(nsIFile *dbFile, PRBool create, PRBool upgrading, nsIAddrDatabase **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->Open(dbFile, create, upgrading, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Close(PRBool forceCommit) { return !_to ? NS_ERROR_NULL_POINTER : _to->Close(forceCommit); } \
  NS_SCRIPTABLE NS_IMETHOD OpenMDB(nsIFile *dbName, PRBool create) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenMDB(dbName, create); } \
  NS_SCRIPTABLE NS_IMETHOD CloseMDB(PRBool commit) { return !_to ? NS_ERROR_NULL_POINTER : _to->CloseMDB(commit); } \
  NS_SCRIPTABLE NS_IMETHOD Commit(PRUint32 commitType) { return !_to ? NS_ERROR_NULL_POINTER : _to->Commit(commitType); } \
  NS_SCRIPTABLE NS_IMETHOD ForceClosed(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ForceClosed(); } \
  NS_SCRIPTABLE NS_IMETHOD CreateNewCardAndAddToDB(nsIAbCard *aNewCard, PRBool aNotify, nsIAbDirectory *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateNewCardAndAddToDB(aNewCard, aNotify, aParent); } \
  NS_SCRIPTABLE NS_IMETHOD CreateNewListCardAndAddToDB(nsIAbDirectory *list, PRUint32 listRowID, nsIAbCard *newCard, PRBool aNotify) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateNewListCardAndAddToDB(list, listRowID, newCard, aNotify); } \
  NS_SCRIPTABLE NS_IMETHOD CreateMailListAndAddToDB(nsIAbDirectory *aNewList, PRBool aNotify, nsIAbDirectory *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateMailListAndAddToDB(aNewList, aNotify, aParent); } \
  NS_SCRIPTABLE NS_IMETHOD EnumerateCards(nsIAbDirectory *directory, nsISimpleEnumerator **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->EnumerateCards(directory, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD EnumerateListAddresses(nsIAbDirectory *directory, nsISimpleEnumerator **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->EnumerateListAddresses(directory, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetMailingListsFromDB(nsIAbDirectory *parentDir) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMailingListsFromDB(parentDir); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteCard(nsIAbCard *aCard, PRBool aNotify, nsIAbDirectory *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteCard(aCard, aNotify, aParent); } \
  NS_SCRIPTABLE NS_IMETHOD EditCard(nsIAbCard *aCard, PRBool aNotify, nsIAbDirectory *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->EditCard(aCard, aNotify, aParent); } \
  NS_SCRIPTABLE NS_IMETHOD ContainsCard(nsIAbCard *card, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ContainsCard(card, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteMailList(nsIAbDirectory *aMailList, nsIAbDirectory *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteMailList(aMailList, aParent); } \
  NS_SCRIPTABLE NS_IMETHOD EditMailList(nsIAbDirectory *mailList, nsIAbCard *listCard, PRBool aNotify) { return !_to ? NS_ERROR_NULL_POINTER : _to->EditMailList(mailList, listCard, aNotify); } \
  NS_SCRIPTABLE NS_IMETHOD ContainsMailList(nsIAbDirectory *mailList, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ContainsMailList(mailList, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteCardFromMailList(nsIAbDirectory *mailList, nsIAbCard *card, PRBool aNotify) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteCardFromMailList(mailList, card, aNotify); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardFromAttribute(nsIAbDirectory *aDirectory, const char *aName, const nsACString & aUTF8Value, PRBool aCaseInsensitive, nsIAbCard **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCardFromAttribute(aDirectory, aName, aUTF8Value, aCaseInsensitive, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardsFromAttribute(nsIAbDirectory *aDirectory, const char *aName, const nsACString & uUTF8Value, PRBool aCaseInsensitive, nsISimpleEnumerator **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCardsFromAttribute(aDirectory, aName, uUTF8Value, aCaseInsensitive, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FindMailListbyUnicodeName(const PRUnichar *listName, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FindMailListbyUnicodeName(listName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardCount(PRUint32 *count NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCardCount(count); } \
  NS_IMETHOD GetNewRow(nsIMdbRow **aNewRow) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNewRow(aNewRow); } \
  NS_IMETHOD GetNewListRow(nsIMdbRow **aNewListRow) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNewListRow(aNewListRow); } \
  NS_IMETHOD AddCardRowToDB(nsIMdbRow *newRow) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCardRowToDB(newRow); } \
  NS_IMETHOD AddLdifListMember(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddLdifListMember(row, value); } \
  NS_IMETHOD AddFirstName(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddFirstName(row, value); } \
  NS_IMETHOD AddLastName(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddLastName(row, value); } \
  NS_IMETHOD AddPhoneticFirstName(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddPhoneticFirstName(row, value); } \
  NS_IMETHOD AddPhoneticLastName(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddPhoneticLastName(row, value); } \
  NS_IMETHOD AddDisplayName(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddDisplayName(row, value); } \
  NS_IMETHOD AddNickName(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddNickName(row, value); } \
  NS_IMETHOD AddPrimaryEmail(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddPrimaryEmail(row, value); } \
  NS_IMETHOD Add2ndEmail(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->Add2ndEmail(row, value); } \
  NS_IMETHOD AddWorkPhone(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWorkPhone(row, value); } \
  NS_IMETHOD AddHomePhone(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddHomePhone(row, value); } \
  NS_IMETHOD AddFaxNumber(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddFaxNumber(row, value); } \
  NS_IMETHOD AddPagerNumber(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddPagerNumber(row, value); } \
  NS_IMETHOD AddCellularNumber(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCellularNumber(row, value); } \
  NS_IMETHOD AddWorkPhoneType(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWorkPhoneType(row, value); } \
  NS_IMETHOD AddHomePhoneType(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddHomePhoneType(row, value); } \
  NS_IMETHOD AddFaxNumberType(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddFaxNumberType(row, value); } \
  NS_IMETHOD AddPagerNumberType(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddPagerNumberType(row, value); } \
  NS_IMETHOD AddCellularNumberType(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCellularNumberType(row, value); } \
  NS_IMETHOD AddHomeAddress(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddHomeAddress(row, value); } \
  NS_IMETHOD AddHomeAddress2(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddHomeAddress2(row, value); } \
  NS_IMETHOD AddHomeCity(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddHomeCity(row, value); } \
  NS_IMETHOD AddHomeState(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddHomeState(row, value); } \
  NS_IMETHOD AddHomeZipCode(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddHomeZipCode(row, value); } \
  NS_IMETHOD AddHomeCountry(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddHomeCountry(row, value); } \
  NS_IMETHOD AddWorkAddress(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWorkAddress(row, value); } \
  NS_IMETHOD AddWorkAddress2(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWorkAddress2(row, value); } \
  NS_IMETHOD AddWorkCity(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWorkCity(row, value); } \
  NS_IMETHOD AddWorkState(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWorkState(row, value); } \
  NS_IMETHOD AddWorkZipCode(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWorkZipCode(row, value); } \
  NS_IMETHOD AddWorkCountry(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWorkCountry(row, value); } \
  NS_IMETHOD AddJobTitle(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddJobTitle(row, value); } \
  NS_IMETHOD AddDepartment(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddDepartment(row, value); } \
  NS_IMETHOD AddCompany(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCompany(row, value); } \
  NS_IMETHOD AddAimScreenName(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddAimScreenName(row, value); } \
  NS_IMETHOD AddAnniversaryYear(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddAnniversaryYear(row, value); } \
  NS_IMETHOD AddAnniversaryMonth(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddAnniversaryMonth(row, value); } \
  NS_IMETHOD AddAnniversaryDay(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddAnniversaryDay(row, value); } \
  NS_IMETHOD AddSpouseName(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddSpouseName(row, value); } \
  NS_IMETHOD AddFamilyName(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddFamilyName(row, value); } \
  NS_IMETHOD AddDefaultAddress(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddDefaultAddress(row, value); } \
  NS_IMETHOD AddCategory(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCategory(row, value); } \
  NS_IMETHOD AddWebPage1(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWebPage1(row, value); } \
  NS_IMETHOD AddWebPage2(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWebPage2(row, value); } \
  NS_IMETHOD AddBirthYear(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddBirthYear(row, value); } \
  NS_IMETHOD AddBirthMonth(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddBirthMonth(row, value); } \
  NS_IMETHOD AddBirthDay(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddBirthDay(row, value); } \
  NS_IMETHOD AddCustom1(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCustom1(row, value); } \
  NS_IMETHOD AddCustom2(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCustom2(row, value); } \
  NS_IMETHOD AddCustom3(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCustom3(row, value); } \
  NS_IMETHOD AddCustom4(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCustom4(row, value); } \
  NS_IMETHOD AddNotes(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddNotes(row, value); } \
  NS_IMETHOD AddPreferMailFormat(nsIMdbRow *row, PRUint32 value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddPreferMailFormat(row, value); } \
  NS_IMETHOD AddPopularityIndex(nsIMdbRow *row, PRUint32 value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddPopularityIndex(row, value); } \
  NS_IMETHOD AddAllowRemoteContent(nsIMdbRow *row, PRBool value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddAllowRemoteContent(row, value); } \
  NS_IMETHOD AddListName(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddListName(row, value); } \
  NS_IMETHOD AddListNickName(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddListNickName(row, value); } \
  NS_IMETHOD AddListDescription(nsIMdbRow *row, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddListDescription(row, value); } \
  NS_IMETHOD AddListDirNode(nsIMdbRow *listRow) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddListDirNode(listRow); } \
  NS_SCRIPTABLE NS_IMETHOD SetCardValue(nsIAbCard *card, const char *name, const PRUnichar *value, PRBool notify) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCardValue(card, name, value, notify); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardValue(nsIAbCard *card, const char *name, PRUnichar **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCardValue(card, name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetDeletedCardList(nsIArray **aDeletedCardList) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDeletedCardList(aDeletedCardList); } \
  NS_SCRIPTABLE NS_IMETHOD GetDeletedCardCount(PRUint32 *aDeletedCardCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDeletedCardCount(aDeletedCardCount); } \
  NS_SCRIPTABLE NS_IMETHOD AddListCardColumnsToRow(nsIAbCard *aPCard, nsIMdbRow *aPListRow, PRUint32 aPos, nsIAbCard **aPNewCard NS_OUTPARAM, PRBool aInMailingList, nsIAbDirectory *aParent, nsIAbDirectory *aRoot) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddListCardColumnsToRow(aPCard, aPListRow, aPos, aPNewCard, aInMailingList, aParent, aRoot); } \
  NS_SCRIPTABLE NS_IMETHOD InitCardFromRow(nsIAbCard *aNewCard, nsIMdbRow *aCardRow) { return !_to ? NS_ERROR_NULL_POINTER : _to->InitCardFromRow(aNewCard, aCardRow); } \
  NS_SCRIPTABLE NS_IMETHOD SetListAddressTotal(nsIMdbRow *aListRow, PRUint32 aTotal) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetListAddressTotal(aListRow, aTotal); } \
  NS_SCRIPTABLE NS_IMETHOD FindRowByCard(nsIAbCard *aCard, nsIMdbRow **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FindRowByCard(aCard, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAddrDatabase : public nsIAddrDatabase
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIADDRDATABASE

  nsAddrDatabase();

private:
  ~nsAddrDatabase();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAddrDatabase, nsIAddrDatabase)

nsAddrDatabase::nsAddrDatabase()
{
  /* member initializers and constructor code */
}

nsAddrDatabase::~nsAddrDatabase()
{
  /* destructor code */
}

/* attribute nsIFile dbPath; */
NS_IMETHODIMP nsAddrDatabase::GetDbPath(nsIFile **aDbPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAddrDatabase::SetDbPath(nsIFile *aDbPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAddrDatabase open (in nsIFile dbFile, in boolean create, in boolean upgrading); */
NS_IMETHODIMP nsAddrDatabase::Open(nsIFile *dbFile, PRBool create, PRBool upgrading, nsIAddrDatabase **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void close (in boolean forceCommit); */
NS_IMETHODIMP nsAddrDatabase::Close(PRBool forceCommit)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void openMDB (in nsIFile dbName, in boolean create); */
NS_IMETHODIMP nsAddrDatabase::OpenMDB(nsIFile *dbName, PRBool create)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void closeMDB (in boolean commit); */
NS_IMETHODIMP nsAddrDatabase::CloseMDB(PRBool commit)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void commit (in unsigned long commitType); */
NS_IMETHODIMP nsAddrDatabase::Commit(PRUint32 commitType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void forceClosed (); */
NS_IMETHODIMP nsAddrDatabase::ForceClosed()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createNewCardAndAddToDB (in nsIAbCard aNewCard, in boolean aNotify, in nsIAbDirectory aParent); */
NS_IMETHODIMP nsAddrDatabase::CreateNewCardAndAddToDB(nsIAbCard *aNewCard, PRBool aNotify, nsIAbDirectory *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createNewListCardAndAddToDB (in nsIAbDirectory list, in unsigned long listRowID, in nsIAbCard newCard, in boolean aNotify); */
NS_IMETHODIMP nsAddrDatabase::CreateNewListCardAndAddToDB(nsIAbDirectory *list, PRUint32 listRowID, nsIAbCard *newCard, PRBool aNotify)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createMailListAndAddToDB (in nsIAbDirectory aNewList, in boolean aNotify, in nsIAbDirectory aParent); */
NS_IMETHODIMP nsAddrDatabase::CreateMailListAndAddToDB(nsIAbDirectory *aNewList, PRBool aNotify, nsIAbDirectory *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISimpleEnumerator enumerateCards (in nsIAbDirectory directory); */
NS_IMETHODIMP nsAddrDatabase::EnumerateCards(nsIAbDirectory *directory, nsISimpleEnumerator **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISimpleEnumerator enumerateListAddresses (in nsIAbDirectory directory); */
NS_IMETHODIMP nsAddrDatabase::EnumerateListAddresses(nsIAbDirectory *directory, nsISimpleEnumerator **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getMailingListsFromDB (in nsIAbDirectory parentDir); */
NS_IMETHODIMP nsAddrDatabase::GetMailingListsFromDB(nsIAbDirectory *parentDir)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteCard (in nsIAbCard aCard, in boolean aNotify, in nsIAbDirectory aParent); */
NS_IMETHODIMP nsAddrDatabase::DeleteCard(nsIAbCard *aCard, PRBool aNotify, nsIAbDirectory *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void editCard (in nsIAbCard aCard, in boolean aNotify, in nsIAbDirectory aParent); */
NS_IMETHODIMP nsAddrDatabase::EditCard(nsIAbCard *aCard, PRBool aNotify, nsIAbDirectory *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean containsCard (in nsIAbCard card); */
NS_IMETHODIMP nsAddrDatabase::ContainsCard(nsIAbCard *card, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteMailList (in nsIAbDirectory aMailList, [optional] in nsIAbDirectory aParent); */
NS_IMETHODIMP nsAddrDatabase::DeleteMailList(nsIAbDirectory *aMailList, nsIAbDirectory *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void editMailList (in nsIAbDirectory mailList, in nsIAbCard listCard, in boolean aNotify); */
NS_IMETHODIMP nsAddrDatabase::EditMailList(nsIAbDirectory *mailList, nsIAbCard *listCard, PRBool aNotify)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean containsMailList (in nsIAbDirectory mailList); */
NS_IMETHODIMP nsAddrDatabase::ContainsMailList(nsIAbDirectory *mailList, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteCardFromMailList (in nsIAbDirectory mailList, in nsIAbCard card, in boolean aNotify); */
NS_IMETHODIMP nsAddrDatabase::DeleteCardFromMailList(nsIAbDirectory *mailList, nsIAbCard *card, PRBool aNotify)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAbCard getCardFromAttribute (in nsIAbDirectory aDirectory, in string aName, in AUTF8String aUTF8Value, in boolean aCaseInsensitive); */
NS_IMETHODIMP nsAddrDatabase::GetCardFromAttribute(nsIAbDirectory *aDirectory, const char *aName, const nsACString & aUTF8Value, PRBool aCaseInsensitive, nsIAbCard **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISimpleEnumerator getCardsFromAttribute (in nsIAbDirectory aDirectory, in string aName, in AUTF8String uUTF8Value, in boolean aCaseInsensitive); */
NS_IMETHODIMP nsAddrDatabase::GetCardsFromAttribute(nsIAbDirectory *aDirectory, const char *aName, const nsACString & uUTF8Value, PRBool aCaseInsensitive, nsISimpleEnumerator **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRBool findMailListbyUnicodeName (in wstring listName); */
NS_IMETHODIMP nsAddrDatabase::FindMailListbyUnicodeName(const PRUnichar *listName, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getCardCount (out PRUint32 count); */
NS_IMETHODIMP nsAddrDatabase::GetCardCount(PRUint32 *count NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] readonly attribute nsIMdbRow newRow; */
NS_IMETHODIMP nsAddrDatabase::GetNewRow(nsIMdbRow **aNewRow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] readonly attribute nsIMdbRow newListRow; */
NS_IMETHODIMP nsAddrDatabase::GetNewListRow(nsIMdbRow **aNewListRow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addCardRowToDB (in nsIMdbRow newRow); */
NS_IMETHODIMP nsAddrDatabase::AddCardRowToDB(nsIMdbRow *newRow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addLdifListMember (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddLdifListMember(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addFirstName (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddFirstName(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addLastName (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddLastName(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addPhoneticFirstName (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddPhoneticFirstName(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addPhoneticLastName (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddPhoneticLastName(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addDisplayName (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddDisplayName(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addNickName (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddNickName(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addPrimaryEmail (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddPrimaryEmail(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void add2ndEmail (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::Add2ndEmail(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addWorkPhone (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddWorkPhone(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addHomePhone (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddHomePhone(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addFaxNumber (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddFaxNumber(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addPagerNumber (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddPagerNumber(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addCellularNumber (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddCellularNumber(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addWorkPhoneType (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddWorkPhoneType(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addHomePhoneType (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddHomePhoneType(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addFaxNumberType (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddFaxNumberType(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addPagerNumberType (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddPagerNumberType(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addCellularNumberType (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddCellularNumberType(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addHomeAddress (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddHomeAddress(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addHomeAddress2 (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddHomeAddress2(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addHomeCity (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddHomeCity(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addHomeState (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddHomeState(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addHomeZipCode (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddHomeZipCode(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addHomeCountry (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddHomeCountry(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addWorkAddress (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddWorkAddress(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addWorkAddress2 (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddWorkAddress2(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addWorkCity (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddWorkCity(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addWorkState (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddWorkState(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addWorkZipCode (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddWorkZipCode(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addWorkCountry (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddWorkCountry(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addJobTitle (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddJobTitle(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addDepartment (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddDepartment(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addCompany (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddCompany(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addAimScreenName (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddAimScreenName(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addAnniversaryYear (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddAnniversaryYear(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addAnniversaryMonth (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddAnniversaryMonth(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addAnniversaryDay (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddAnniversaryDay(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addSpouseName (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddSpouseName(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addFamilyName (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddFamilyName(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addDefaultAddress (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddDefaultAddress(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addCategory (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddCategory(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addWebPage1 (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddWebPage1(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addWebPage2 (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddWebPage2(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addBirthYear (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddBirthYear(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addBirthMonth (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddBirthMonth(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addBirthDay (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddBirthDay(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addCustom1 (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddCustom1(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addCustom2 (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddCustom2(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addCustom3 (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddCustom3(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addCustom4 (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddCustom4(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addNotes (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddNotes(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addPreferMailFormat (in nsIMdbRow row, in unsigned long value); */
NS_IMETHODIMP nsAddrDatabase::AddPreferMailFormat(nsIMdbRow *row, PRUint32 value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addPopularityIndex (in nsIMdbRow row, in unsigned long value); */
NS_IMETHODIMP nsAddrDatabase::AddPopularityIndex(nsIMdbRow *row, PRUint32 value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addAllowRemoteContent (in nsIMdbRow row, in boolean value); */
NS_IMETHODIMP nsAddrDatabase::AddAllowRemoteContent(nsIMdbRow *row, PRBool value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addListName (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddListName(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addListNickName (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddListNickName(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addListDescription (in nsIMdbRow row, in string value); */
NS_IMETHODIMP nsAddrDatabase::AddListDescription(nsIMdbRow *row, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addListDirNode (in nsIMdbRow listRow); */
NS_IMETHODIMP nsAddrDatabase::AddListDirNode(nsIMdbRow *listRow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCardValue (in nsIAbCard card, in string name, in wstring value, in boolean notify); */
NS_IMETHODIMP nsAddrDatabase::SetCardValue(nsIAbCard *card, const char *name, const PRUnichar *value, PRBool notify)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring getCardValue (in nsIAbCard card, in string name); */
NS_IMETHODIMP nsAddrDatabase::GetCardValue(nsIAbCard *card, const char *name, PRUnichar **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIArray deletedCardList; */
NS_IMETHODIMP nsAddrDatabase::GetDeletedCardList(nsIArray **aDeletedCardList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long deletedCardCount; */
NS_IMETHODIMP nsAddrDatabase::GetDeletedCardCount(PRUint32 *aDeletedCardCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void AddListCardColumnsToRow (in nsIAbCard aPCard, in nsIMdbRow aPListRow, in unsigned long aPos, out nsIAbCard aPNewCard, in boolean aInMailingList, in nsIAbDirectory aParent, in nsIAbDirectory aRoot); */
NS_IMETHODIMP nsAddrDatabase::AddListCardColumnsToRow(nsIAbCard *aPCard, nsIMdbRow *aPListRow, PRUint32 aPos, nsIAbCard **aPNewCard NS_OUTPARAM, PRBool aInMailingList, nsIAbDirectory *aParent, nsIAbDirectory *aRoot)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InitCardFromRow (in nsIAbCard aNewCard, in nsIMdbRow aCardRow); */
NS_IMETHODIMP nsAddrDatabase::InitCardFromRow(nsIAbCard *aNewCard, nsIMdbRow *aCardRow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetListAddressTotal (in nsIMdbRow aListRow, in PRUint32 aTotal); */
NS_IMETHODIMP nsAddrDatabase::SetListAddressTotal(nsIMdbRow *aListRow, PRUint32 aTotal)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMdbRow FindRowByCard (in nsIAbCard aCard); */
NS_IMETHODIMP nsAddrDatabase::FindRowByCard(nsIAbCard *aCard, nsIMdbRow **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAddrDatabase_h__ */
