/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAutoSyncState.idl
 */

#ifndef __gen_nsIAutoSyncState_h__
#define __gen_nsIAutoSyncState_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIMsgFolder; /* forward declaration */

class nsIMsgWindow; /* forward declaration */

class nsIArray; /* forward declaration */

class nsIMutableArray; /* forward declaration */


/* starting interface:    nsIAutoSyncState */
#define NS_IAUTOSYNCSTATE_IID_STR "7512f927-b8f0-48c4-b101-03e859e61281"

#define NS_IAUTOSYNCSTATE_IID \
  {0x7512f927, 0xb8f0, 0x48c4, \
    { 0xb1, 0x01, 0x03, 0xe8, 0x59, 0xe6, 0x12, 0x81 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIAutoSyncState : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IAUTOSYNCSTATE_IID)

  /**
   * Auto-Sync states.
   *
   * ***WARNING***: If you change these, be sure to update stateStrings in
   * nsAutoSyncState.cpp. If you do not, out-of-bounds memory accesses may
   * happen.
   */
/** sync'd and no pending messages */
  enum { stCompletedIdle = 0 };

  /** STATUS issued. Will check to see if  any counts changed since last STATUS */
  enum { stStatusIssued = 1 };

  /**
   * Status found new messages. Update should be issued next. Status most
   * likely was issued by non-autosync code (e.g., check other folders for
   * new messages).
   */
  enum { stUpdateNeeded = 2 };

  /** Update issued. Will figure out if there are any bodies to download */
  enum { stUpdateIssued = 3 };

  /** Message body download in progress */
  enum { stDownloadInProgress = 4 };

  /** ready to download the next group of messages */
  enum { stReadyToDownload = 5 };

  /**
   * Puts the download queue offset to its previous position. 
   */
  /* void rollback (); */
  NS_SCRIPTABLE NS_IMETHOD Rollback(void) = 0;

  /**
   * Clears the download queue. Resets the offsets.
   */
  /* void resetDownloadQ (); */
  NS_SCRIPTABLE NS_IMETHOD ResetDownloadQ(void) = 0;

  /**
   * Rollbacks the offset to the previous position and
   * changes the state to ready-to-download.
   */
  /* void tryCurrentGroupAgain (in unsigned long aRetryCount); */
  NS_SCRIPTABLE NS_IMETHOD TryCurrentGroupAgain(PRUint32 aRetryCount) = 0;

  /**
   * Resets the retry counter.
   */
  /* void resetRetryCounter (); */
  NS_SCRIPTABLE NS_IMETHOD ResetRetryCounter(void) = 0;

  /**
   * Tests whether the given folder has the same imap server. 
   */
  /* boolean isSibling (in nsIAutoSyncState aAnotherStateObj); */
  NS_SCRIPTABLE NS_IMETHOD IsSibling(nsIAutoSyncState *aAnotherStateObj, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Update the folder to find new message headers to download
   */
  /* void updateFolder (); */
  NS_SCRIPTABLE NS_IMETHOD UpdateFolder(void) = 0;

  /**
   * Downloads the bodies of the given messages from the server.
   */
  /* void downloadMessagesForOffline (in nsIArray aMessageList); */
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(nsIArray *aMessageList) = 0;

  /**
   * Populates the given array with the keys of the messages that will 
   * be downloaded next.
   *
   * @param aSuggestedGroupSizeLimit suggested size per group in bytes
   * @param aActualGroupSize total size of the messages in bytes in the group
   */
  /* nsIMutableArray getNextGroupOfMessages (in unsigned long aSuggestedGroupSizeLimit, out unsigned long aActualGroupSize); */
  NS_SCRIPTABLE NS_IMETHOD GetNextGroupOfMessages(PRUint32 aSuggestedGroupSizeLimit, PRUint32 *aActualGroupSize NS_OUTPARAM, nsIMutableArray **_retval NS_OUTPARAM) = 0;

  /**
   * Iterates through the existing headers of the folder to find 
   * the messages not downloaded yet. 
   *
   * @param aNumberOfHeadersToProcess number of headers to be processed
   *                                  at this pass
   *
   * @return the number of headers left to process
   */
  /* unsigned long processExistingHeaders (in unsigned long aNumberOfHeadersToProcess); */
  NS_SCRIPTABLE NS_IMETHOD ProcessExistingHeaders(PRUint32 aNumberOfHeadersToProcess, PRUint32 *_retval NS_OUTPARAM) = 0;

  /**
   * Last time the existing headers are completely processed. 
   */
  /* [noscript] readonly attribute PRTime lastSyncTime; */
  NS_IMETHOD GetLastSyncTime(PRTime *aLastSyncTime) = 0;

  /**
   * Last time the owner folder is updated.
   */
  /* [noscript] attribute PRTime lastUpdateTime; */
  NS_IMETHOD GetLastUpdateTime(PRTime *aLastUpdateTime) = 0;
  NS_IMETHOD SetLastUpdateTime(PRTime aLastUpdateTime) = 0;

  /**
   * Download operation state. 
   */
  /* attribute long state; */
  NS_SCRIPTABLE NS_IMETHOD GetState(PRInt32 *aState) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetState(PRInt32 aState) = 0;

  /**
   * Number of messages waiting to be downloaded.
   */
  /* readonly attribute long pendingMessageCount; */
  NS_SCRIPTABLE NS_IMETHOD GetPendingMessageCount(PRInt32 *aPendingMessageCount) = 0;

  /**
   * Total number of messages in the download queue.
   */
  /* readonly attribute long totalMessageCount; */
  NS_SCRIPTABLE NS_IMETHOD GetTotalMessageCount(PRInt32 *aTotalMessageCount) = 0;

  /**
   * The folder this auto-sync object is related to.
   */
  /* readonly attribute nsIMsgFolder ownerFolder; */
  NS_SCRIPTABLE NS_IMETHOD GetOwnerFolder(nsIMsgFolder **aOwnerFolder) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAutoSyncState, NS_IAUTOSYNCSTATE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIAUTOSYNCSTATE \
  NS_SCRIPTABLE NS_IMETHOD Rollback(void); \
  NS_SCRIPTABLE NS_IMETHOD ResetDownloadQ(void); \
  NS_SCRIPTABLE NS_IMETHOD TryCurrentGroupAgain(PRUint32 aRetryCount); \
  NS_SCRIPTABLE NS_IMETHOD ResetRetryCounter(void); \
  NS_SCRIPTABLE NS_IMETHOD IsSibling(nsIAutoSyncState *aAnotherStateObj, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolder(void); \
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(nsIArray *aMessageList); \
  NS_SCRIPTABLE NS_IMETHOD GetNextGroupOfMessages(PRUint32 aSuggestedGroupSizeLimit, PRUint32 *aActualGroupSize NS_OUTPARAM, nsIMutableArray **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ProcessExistingHeaders(PRUint32 aNumberOfHeadersToProcess, PRUint32 *_retval NS_OUTPARAM); \
  NS_IMETHOD GetLastSyncTime(PRTime *aLastSyncTime); \
  NS_IMETHOD GetLastUpdateTime(PRTime *aLastUpdateTime); \
  NS_IMETHOD SetLastUpdateTime(PRTime aLastUpdateTime); \
  NS_SCRIPTABLE NS_IMETHOD GetState(PRInt32 *aState); \
  NS_SCRIPTABLE NS_IMETHOD SetState(PRInt32 aState); \
  NS_SCRIPTABLE NS_IMETHOD GetPendingMessageCount(PRInt32 *aPendingMessageCount); \
  NS_SCRIPTABLE NS_IMETHOD GetTotalMessageCount(PRInt32 *aTotalMessageCount); \
  NS_SCRIPTABLE NS_IMETHOD GetOwnerFolder(nsIMsgFolder **aOwnerFolder); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIAUTOSYNCSTATE(_to) \
  NS_SCRIPTABLE NS_IMETHOD Rollback(void) { return _to Rollback(); } \
  NS_SCRIPTABLE NS_IMETHOD ResetDownloadQ(void) { return _to ResetDownloadQ(); } \
  NS_SCRIPTABLE NS_IMETHOD TryCurrentGroupAgain(PRUint32 aRetryCount) { return _to TryCurrentGroupAgain(aRetryCount); } \
  NS_SCRIPTABLE NS_IMETHOD ResetRetryCounter(void) { return _to ResetRetryCounter(); } \
  NS_SCRIPTABLE NS_IMETHOD IsSibling(nsIAutoSyncState *aAnotherStateObj, PRBool *_retval NS_OUTPARAM) { return _to IsSibling(aAnotherStateObj, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolder(void) { return _to UpdateFolder(); } \
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(nsIArray *aMessageList) { return _to DownloadMessagesForOffline(aMessageList); } \
  NS_SCRIPTABLE NS_IMETHOD GetNextGroupOfMessages(PRUint32 aSuggestedGroupSizeLimit, PRUint32 *aActualGroupSize NS_OUTPARAM, nsIMutableArray **_retval NS_OUTPARAM) { return _to GetNextGroupOfMessages(aSuggestedGroupSizeLimit, aActualGroupSize, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ProcessExistingHeaders(PRUint32 aNumberOfHeadersToProcess, PRUint32 *_retval NS_OUTPARAM) { return _to ProcessExistingHeaders(aNumberOfHeadersToProcess, _retval); } \
  NS_IMETHOD GetLastSyncTime(PRTime *aLastSyncTime) { return _to GetLastSyncTime(aLastSyncTime); } \
  NS_IMETHOD GetLastUpdateTime(PRTime *aLastUpdateTime) { return _to GetLastUpdateTime(aLastUpdateTime); } \
  NS_IMETHOD SetLastUpdateTime(PRTime aLastUpdateTime) { return _to SetLastUpdateTime(aLastUpdateTime); } \
  NS_SCRIPTABLE NS_IMETHOD GetState(PRInt32 *aState) { return _to GetState(aState); } \
  NS_SCRIPTABLE NS_IMETHOD SetState(PRInt32 aState) { return _to SetState(aState); } \
  NS_SCRIPTABLE NS_IMETHOD GetPendingMessageCount(PRInt32 *aPendingMessageCount) { return _to GetPendingMessageCount(aPendingMessageCount); } \
  NS_SCRIPTABLE NS_IMETHOD GetTotalMessageCount(PRInt32 *aTotalMessageCount) { return _to GetTotalMessageCount(aTotalMessageCount); } \
  NS_SCRIPTABLE NS_IMETHOD GetOwnerFolder(nsIMsgFolder **aOwnerFolder) { return _to GetOwnerFolder(aOwnerFolder); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIAUTOSYNCSTATE(_to) \
  NS_SCRIPTABLE NS_IMETHOD Rollback(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Rollback(); } \
  NS_SCRIPTABLE NS_IMETHOD ResetDownloadQ(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ResetDownloadQ(); } \
  NS_SCRIPTABLE NS_IMETHOD TryCurrentGroupAgain(PRUint32 aRetryCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->TryCurrentGroupAgain(aRetryCount); } \
  NS_SCRIPTABLE NS_IMETHOD ResetRetryCounter(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ResetRetryCounter(); } \
  NS_SCRIPTABLE NS_IMETHOD IsSibling(nsIAutoSyncState *aAnotherStateObj, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsSibling(aAnotherStateObj, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolder(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->UpdateFolder(); } \
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(nsIArray *aMessageList) { return !_to ? NS_ERROR_NULL_POINTER : _to->DownloadMessagesForOffline(aMessageList); } \
  NS_SCRIPTABLE NS_IMETHOD GetNextGroupOfMessages(PRUint32 aSuggestedGroupSizeLimit, PRUint32 *aActualGroupSize NS_OUTPARAM, nsIMutableArray **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNextGroupOfMessages(aSuggestedGroupSizeLimit, aActualGroupSize, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ProcessExistingHeaders(PRUint32 aNumberOfHeadersToProcess, PRUint32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ProcessExistingHeaders(aNumberOfHeadersToProcess, _retval); } \
  NS_IMETHOD GetLastSyncTime(PRTime *aLastSyncTime) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastSyncTime(aLastSyncTime); } \
  NS_IMETHOD GetLastUpdateTime(PRTime *aLastUpdateTime) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastUpdateTime(aLastUpdateTime); } \
  NS_IMETHOD SetLastUpdateTime(PRTime aLastUpdateTime) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLastUpdateTime(aLastUpdateTime); } \
  NS_SCRIPTABLE NS_IMETHOD GetState(PRInt32 *aState) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetState(aState); } \
  NS_SCRIPTABLE NS_IMETHOD SetState(PRInt32 aState) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetState(aState); } \
  NS_SCRIPTABLE NS_IMETHOD GetPendingMessageCount(PRInt32 *aPendingMessageCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPendingMessageCount(aPendingMessageCount); } \
  NS_SCRIPTABLE NS_IMETHOD GetTotalMessageCount(PRInt32 *aTotalMessageCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTotalMessageCount(aTotalMessageCount); } \
  NS_SCRIPTABLE NS_IMETHOD GetOwnerFolder(nsIMsgFolder **aOwnerFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOwnerFolder(aOwnerFolder); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAutoSyncState : public nsIAutoSyncState
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIAUTOSYNCSTATE

  nsAutoSyncState();

private:
  ~nsAutoSyncState();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAutoSyncState, nsIAutoSyncState)

nsAutoSyncState::nsAutoSyncState()
{
  /* member initializers and constructor code */
}

nsAutoSyncState::~nsAutoSyncState()
{
  /* destructor code */
}

/* void rollback (); */
NS_IMETHODIMP nsAutoSyncState::Rollback()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void resetDownloadQ (); */
NS_IMETHODIMP nsAutoSyncState::ResetDownloadQ()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void tryCurrentGroupAgain (in unsigned long aRetryCount); */
NS_IMETHODIMP nsAutoSyncState::TryCurrentGroupAgain(PRUint32 aRetryCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void resetRetryCounter (); */
NS_IMETHODIMP nsAutoSyncState::ResetRetryCounter()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isSibling (in nsIAutoSyncState aAnotherStateObj); */
NS_IMETHODIMP nsAutoSyncState::IsSibling(nsIAutoSyncState *aAnotherStateObj, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void updateFolder (); */
NS_IMETHODIMP nsAutoSyncState::UpdateFolder()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void downloadMessagesForOffline (in nsIArray aMessageList); */
NS_IMETHODIMP nsAutoSyncState::DownloadMessagesForOffline(nsIArray *aMessageList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMutableArray getNextGroupOfMessages (in unsigned long aSuggestedGroupSizeLimit, out unsigned long aActualGroupSize); */
NS_IMETHODIMP nsAutoSyncState::GetNextGroupOfMessages(PRUint32 aSuggestedGroupSizeLimit, PRUint32 *aActualGroupSize NS_OUTPARAM, nsIMutableArray **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long processExistingHeaders (in unsigned long aNumberOfHeadersToProcess); */
NS_IMETHODIMP nsAutoSyncState::ProcessExistingHeaders(PRUint32 aNumberOfHeadersToProcess, PRUint32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] readonly attribute PRTime lastSyncTime; */
NS_IMETHODIMP nsAutoSyncState::GetLastSyncTime(PRTime *aLastSyncTime)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] attribute PRTime lastUpdateTime; */
NS_IMETHODIMP nsAutoSyncState::GetLastUpdateTime(PRTime *aLastUpdateTime)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAutoSyncState::SetLastUpdateTime(PRTime aLastUpdateTime)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long state; */
NS_IMETHODIMP nsAutoSyncState::GetState(PRInt32 *aState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsAutoSyncState::SetState(PRInt32 aState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long pendingMessageCount; */
NS_IMETHODIMP nsAutoSyncState::GetPendingMessageCount(PRInt32 *aPendingMessageCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long totalMessageCount; */
NS_IMETHODIMP nsAutoSyncState::GetTotalMessageCount(PRInt32 *aTotalMessageCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIMsgFolder ownerFolder; */
NS_IMETHODIMP nsAutoSyncState::GetOwnerFolder(nsIMsgFolder **aOwnerFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAutoSyncState_h__ */
