/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIImapService.idl
 */

#ifndef __gen_nsIImapService_h__
#define __gen_nsIImapService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIImapUrl_h__
#include "nsIImapUrl.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIImapProtocol; /* forward declaration */

class nsIImapMessageSink; /* forward declaration */

class nsIUrlListener; /* forward declaration */

class nsIURI; /* forward declaration */

class nsIEventTarget; /* forward declaration */

class nsIFile; /* forward declaration */

class nsIMsgFolder; /* forward declaration */

class nsIMsgWindow; /* forward declaration */

class nsIImapIncomingServer; /* forward declaration */

class nsICacheSession; /* forward declaration */


/* starting interface:    nsIImapService */
#define NS_IIMAPSERVICE_IID_STR "7ff02a19-f402-436a-a6cc-c4c454f0b86f"

#define NS_IIMAPSERVICE_IID \
  {0x7ff02a19, 0xf402, 0x436a, \
    { 0xa6, 0xcc, 0xc4, 0xc4, 0x54, 0xf0, 0xb8, 0x6f }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIImapService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IIMAPSERVICE_IID)

  /* void selectFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
  NS_SCRIPTABLE NS_IMETHOD SelectFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) = 0;

  /**
   * Select the folder on the imap server without doing a sync of flags or
   * headers. This is used for offline playback, where we don't want to
   * download hdrs we don't have, because they may have been offline deleted.
   *
   * @param aClientEventTarget  the event target of the ui thread
   * @param aImapMailFolder     the folder to select
   * @param aUrlListener        url listener, can be null
   * @param aMsgWindow          msg window url is running in, can be null
   *
   * @returns the url created to run the lite select in.
   */
  /* nsIURI liteSelectFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD LiteSelectFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) = 0;

  /* void addImapFetchToUrl (in nsIURI aURL, in nsIMsgFolder aImapMailFolder, in ACString aMessageIdentifierList, in ACString aAdditionalHeader); */
  NS_SCRIPTABLE NS_IMETHOD AddImapFetchToUrl(nsIURI *aURL, nsIMsgFolder *aImapMailFolder, const nsACString & aMessageIdentifierList, const nsACString & aAdditionalHeader) = 0;

  /* void fetchMessage (in nsIImapUrl aUrl, in nsImapState aImapAction, in nsIMsgFolder aImapMailFolder, in nsIImapMessageSink aImapMessageSink, in nsIMsgWindow aMsgWindow, in nsISupports aConsumer, in ACString aMessageIdentifierList, in boolean convertDataToText, in ACString additionalHeader, out nsIURI aOutURL); */
  NS_SCRIPTABLE NS_IMETHOD FetchMessage(nsIImapUrl *aUrl, nsImapState aImapAction, nsIMsgFolder *aImapMailFolder, nsIImapMessageSink *aImapMessageSink, nsIMsgWindow *aMsgWindow, nsISupports *aConsumer, const nsACString & aMessageIdentifierList, PRBool convertDataToText, const nsACString & additionalHeader, nsIURI **aOutURL NS_OUTPARAM) = 0;

  /* void noop (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
  NS_SCRIPTABLE NS_IMETHOD Noop(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) = 0;

  /* void getHeaders (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in ACString aMessageIdentifierList, in boolean aMessageIdsAreUID); */
  NS_SCRIPTABLE NS_IMETHOD GetHeaders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, PRBool aMessageIdsAreUID) = 0;

  /* nsIURI getBodyStart (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in ACString aMessageIdentifierList, in long numBytes); */
  NS_SCRIPTABLE NS_IMETHOD GetBodyStart(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const nsACString & aMessageIdentifierList, PRInt32 numBytes, nsIURI **_retval NS_OUTPARAM) = 0;

  /**
   * Issue an EXPUNGE on the target folder.
   *
   * @param aClientEventTarget  the event target of the ui thread
   * @param aImapMailFolder     the folder to expunge
   * @param aUrlListener        url listener, can be null
   * @param aMsgWindow          msg window url is running in, can be null
   *
   * @returns the url created to run the expunge.
   */
  /* void expunge (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
  NS_SCRIPTABLE NS_IMETHOD Expunge(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) = 0;

  /**
   * Issue a STATUS on the target folder.
   *
   * @param aClientEventTarget  the event target of the ui thread
   * @param aImapMailFolder     the folder to expunge
   * @param aUrlListener        url listener, can be null
   *
   * @returns the url created to run the status.
   */
  /* nsIURI updateFolderStatus (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD UpdateFolderStatus(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) = 0;

  /**
   * Verify that we can login.
   *
   * @param aImapMailFolder - any old imap folder - we just need it to
   *                          set url sinks.
   * @param aMsgWindow    - nsIMsgWindow to use for notification callbacks.
   * @return - the url that we run.
   */
  /* nsIURI verifyLogon (in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) = 0;

  /* void biff (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in unsigned long aUidHighWater); */
  NS_SCRIPTABLE NS_IMETHOD Biff(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, PRUint32 aUidHighWater) = 0;

  /* void deleteMessages (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in ACString aMessageIdentifierList, in boolean aMessageIdsAreUID); */
  NS_SCRIPTABLE NS_IMETHOD DeleteMessages(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, PRBool aMessageIdsAreUID) = 0;

  /* void deleteAllMessages (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
  NS_SCRIPTABLE NS_IMETHOD DeleteAllMessages(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) = 0;

  /* void addMessageFlags (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in ACString aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
  NS_SCRIPTABLE NS_IMETHOD AddMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) = 0;

  /* void subtractMessageFlags (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in ACString aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
  NS_SCRIPTABLE NS_IMETHOD SubtractMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) = 0;

  /* void setMessageFlags (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in ACString aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
  NS_SCRIPTABLE NS_IMETHOD SetMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) = 0;

  /* void discoverAllFolders (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
  NS_SCRIPTABLE NS_IMETHOD DiscoverAllFolders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) = 0;

  /* void discoverAllAndSubscribedFolders (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
  NS_SCRIPTABLE NS_IMETHOD DiscoverAllAndSubscribedFolders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) = 0;

  /* void discoverChildren (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in ACString folderPath, out nsIURI aURL); */
  NS_SCRIPTABLE NS_IMETHOD DiscoverChildren(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const nsACString & folderPath, nsIURI **aURL NS_OUTPARAM) = 0;

  /* void onlineMessageCopy (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aSrcFolder, in ACString aMessageIds, in nsIMsgFolder aDstFolder, in boolean aIdsAreUids, in boolean aIsMove, in nsIUrlListener aUrlListener, out nsIURI aURL, in nsISupports aCopyState, in nsIMsgWindow aWindow); */
  NS_SCRIPTABLE NS_IMETHOD OnlineMessageCopy(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, const nsACString & aMessageIds, nsIMsgFolder *aDstFolder, PRBool aIdsAreUids, PRBool aIsMove, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, nsISupports *aCopyState, nsIMsgWindow *aWindow) = 0;

  /* void appendMessageFromFile (in nsIEventTarget aClientEventTarget, in nsIFile aFile, in nsIMsgFolder aDstFolder, in ACString aMessageId, in boolean idsAreUids, in boolean aInSelectedState, in nsIUrlListener aUrlListener, out nsIURI aURL, in nsISupports aCopyState, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD AppendMessageFromFile(nsIEventTarget *aClientEventTarget, nsIFile *aFile, nsIMsgFolder *aDstFolder, const nsACString & aMessageId, PRBool idsAreUids, PRBool aInSelectedState, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, nsISupports *aCopyState, nsIMsgWindow *aMsgWindow) = 0;

  /* void downloadMessagesForOffline (in ACString aMessageIds, in nsIMsgFolder aSrcFolder, in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(const nsACString & aMessageIds, nsIMsgFolder *aSrcFolder, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) = 0;

  /* nsIURI moveFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aSrcFolder, in nsIMsgFolder aDstFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD MoveFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI renameLeaf (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aSrcFolder, in AString aLeafName, in nsIUrlListener aUrlListener, in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD RenameLeaf(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI deleteFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD DeleteFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI createFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aParentFolder, in AString aLeafName, in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD CreateFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aParentFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI listFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD ListFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI subscribeFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in AString mailboxName, in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD SubscribeFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, const nsAString & mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI unsubscribeFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in AString mailboxName, in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD UnsubscribeFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, const nsAString & mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI ensureFolderExists (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aParentFolder, in AString aLeafName, in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD EnsureFolderExists(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aParentFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI getFolderAdminUrl (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD GetFolderAdminUrl(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI issueCommandOnMsgs (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in ACString aCommand, in ACString aMessageIdentifierList); */
  NS_SCRIPTABLE NS_IMETHOD IssueCommandOnMsgs(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & aCommand, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI fetchCustomMsgAttribute (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in ACString aAttribute, in ACString aMessageIdentifierList); */
  NS_SCRIPTABLE NS_IMETHOD FetchCustomMsgAttribute(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & aAttribute, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI storeCustomKeywords (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in ACString flagsToAdd, in ACString flagsToSubtract, in ACString aMessageIdentifierList); */
  NS_SCRIPTABLE NS_IMETHOD StoreCustomKeywords(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & flagsToAdd, const nsACString & flagsToSubtract, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM) = 0;

  /* void getListOfFoldersOnServer (in nsIImapIncomingServer aServer, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD GetListOfFoldersOnServer(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow) = 0;

  /* void getListOfFoldersWithPath (in nsIImapIncomingServer aServer, in nsIMsgWindow aMsgWindow, in ACString folderPath); */
  NS_SCRIPTABLE NS_IMETHOD GetListOfFoldersWithPath(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow, const nsACString & folderPath) = 0;

  /* nsISupports playbackAllOfflineOperations (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
  NS_SCRIPTABLE NS_IMETHOD PlaybackAllOfflineOperations(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener, nsISupports **_retval NS_OUTPARAM) = 0;

  /* void downloadAllOffineImapFolders (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
  NS_SCRIPTABLE NS_IMETHOD DownloadAllOffineImapFolders(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) = 0;

  /* readonly attribute nsICacheSession cacheSession; */
  NS_SCRIPTABLE NS_IMETHOD GetCacheSession(nsICacheSession **aCacheSession) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIImapService, NS_IIMAPSERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIIMAPSERVICE \
  NS_SCRIPTABLE NS_IMETHOD SelectFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD LiteSelectFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddImapFetchToUrl(nsIURI *aURL, nsIMsgFolder *aImapMailFolder, const nsACString & aMessageIdentifierList, const nsACString & aAdditionalHeader); \
  NS_SCRIPTABLE NS_IMETHOD FetchMessage(nsIImapUrl *aUrl, nsImapState aImapAction, nsIMsgFolder *aImapMailFolder, nsIImapMessageSink *aImapMessageSink, nsIMsgWindow *aMsgWindow, nsISupports *aConsumer, const nsACString & aMessageIdentifierList, PRBool convertDataToText, const nsACString & additionalHeader, nsIURI **aOutURL NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD Noop(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetHeaders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, PRBool aMessageIdsAreUID); \
  NS_SCRIPTABLE NS_IMETHOD GetBodyStart(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const nsACString & aMessageIdentifierList, PRInt32 numBytes, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD Expunge(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolderStatus(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD Biff(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, PRUint32 aUidHighWater); \
  NS_SCRIPTABLE NS_IMETHOD DeleteMessages(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, PRBool aMessageIdsAreUID); \
  NS_SCRIPTABLE NS_IMETHOD DeleteAllMessages(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID); \
  NS_SCRIPTABLE NS_IMETHOD SubtractMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID); \
  NS_SCRIPTABLE NS_IMETHOD SetMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID); \
  NS_SCRIPTABLE NS_IMETHOD DiscoverAllFolders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD DiscoverAllAndSubscribedFolders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD DiscoverChildren(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const nsACString & folderPath, nsIURI **aURL NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD OnlineMessageCopy(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, const nsACString & aMessageIds, nsIMsgFolder *aDstFolder, PRBool aIdsAreUids, PRBool aIsMove, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, nsISupports *aCopyState, nsIMsgWindow *aWindow); \
  NS_SCRIPTABLE NS_IMETHOD AppendMessageFromFile(nsIEventTarget *aClientEventTarget, nsIFile *aFile, nsIMsgFolder *aDstFolder, const nsACString & aMessageId, PRBool idsAreUids, PRBool aInSelectedState, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, nsISupports *aCopyState, nsIMsgWindow *aMsgWindow); \
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(const nsACString & aMessageIds, nsIMsgFolder *aSrcFolder, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow); \
  NS_SCRIPTABLE NS_IMETHOD MoveFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD RenameLeaf(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD DeleteFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aParentFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ListFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SubscribeFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, const nsAString & mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD UnsubscribeFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, const nsAString & mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD EnsureFolderExists(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aParentFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetFolderAdminUrl(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD IssueCommandOnMsgs(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & aCommand, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD FetchCustomMsgAttribute(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & aAttribute, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD StoreCustomKeywords(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & flagsToAdd, const nsACString & flagsToSubtract, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetListOfFoldersOnServer(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow); \
  NS_SCRIPTABLE NS_IMETHOD GetListOfFoldersWithPath(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow, const nsACString & folderPath); \
  NS_SCRIPTABLE NS_IMETHOD PlaybackAllOfflineOperations(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener, nsISupports **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD DownloadAllOffineImapFolders(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener); \
  NS_SCRIPTABLE NS_IMETHOD GetCacheSession(nsICacheSession **aCacheSession); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIIMAPSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD SelectFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) { return _to SelectFolder(aClientEventTarget, aImapMailFolder, aUrlListener, aMsgWindow, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD LiteSelectFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) { return _to LiteSelectFolder(aClientEventTarget, aImapMailFolder, aUrlListener, aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddImapFetchToUrl(nsIURI *aURL, nsIMsgFolder *aImapMailFolder, const nsACString & aMessageIdentifierList, const nsACString & aAdditionalHeader) { return _to AddImapFetchToUrl(aURL, aImapMailFolder, aMessageIdentifierList, aAdditionalHeader); } \
  NS_SCRIPTABLE NS_IMETHOD FetchMessage(nsIImapUrl *aUrl, nsImapState aImapAction, nsIMsgFolder *aImapMailFolder, nsIImapMessageSink *aImapMessageSink, nsIMsgWindow *aMsgWindow, nsISupports *aConsumer, const nsACString & aMessageIdentifierList, PRBool convertDataToText, const nsACString & additionalHeader, nsIURI **aOutURL NS_OUTPARAM) { return _to FetchMessage(aUrl, aImapAction, aImapMailFolder, aImapMessageSink, aMsgWindow, aConsumer, aMessageIdentifierList, convertDataToText, additionalHeader, aOutURL); } \
  NS_SCRIPTABLE NS_IMETHOD Noop(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) { return _to Noop(aClientEventTarget, aImapMailFolder, aUrlListener, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD GetHeaders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, PRBool aMessageIdsAreUID) { return _to GetHeaders(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aMessageIdsAreUID); } \
  NS_SCRIPTABLE NS_IMETHOD GetBodyStart(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const nsACString & aMessageIdentifierList, PRInt32 numBytes, nsIURI **_retval NS_OUTPARAM) { return _to GetBodyStart(aClientEventTarget, aImapMailFolder, aUrlListener, aMessageIdentifierList, numBytes, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Expunge(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) { return _to Expunge(aClientEventTarget, aImapMailFolder, aUrlListener, aMsgWindow, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolderStatus(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return _to UpdateFolderStatus(aClientEventTarget, aImapMailFolder, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) { return _to VerifyLogon(aImapMailFolder, aUrlListener, aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Biff(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, PRUint32 aUidHighWater) { return _to Biff(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aUidHighWater); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteMessages(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, PRBool aMessageIdsAreUID) { return _to DeleteMessages(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aMessageIdsAreUID); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteAllMessages(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) { return _to DeleteAllMessages(aClientEventTarget, aImapMailFolder, aUrlListener, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD AddMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return _to AddMessageFlags(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_SCRIPTABLE NS_IMETHOD SubtractMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return _to SubtractMessageFlags(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_SCRIPTABLE NS_IMETHOD SetMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return _to SetMessageFlags(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_SCRIPTABLE NS_IMETHOD DiscoverAllFolders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) { return _to DiscoverAllFolders(aClientEventTarget, aImapMailFolder, aUrlListener, aMsgWindow, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD DiscoverAllAndSubscribedFolders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) { return _to DiscoverAllAndSubscribedFolders(aClientEventTarget, aImapMailFolder, aUrlListener, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD DiscoverChildren(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const nsACString & folderPath, nsIURI **aURL NS_OUTPARAM) { return _to DiscoverChildren(aClientEventTarget, aImapMailFolder, aUrlListener, folderPath, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD OnlineMessageCopy(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, const nsACString & aMessageIds, nsIMsgFolder *aDstFolder, PRBool aIdsAreUids, PRBool aIsMove, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, nsISupports *aCopyState, nsIMsgWindow *aWindow) { return _to OnlineMessageCopy(aClientEventTarget, aSrcFolder, aMessageIds, aDstFolder, aIdsAreUids, aIsMove, aUrlListener, aURL, aCopyState, aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD AppendMessageFromFile(nsIEventTarget *aClientEventTarget, nsIFile *aFile, nsIMsgFolder *aDstFolder, const nsACString & aMessageId, PRBool idsAreUids, PRBool aInSelectedState, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, nsISupports *aCopyState, nsIMsgWindow *aMsgWindow) { return _to AppendMessageFromFile(aClientEventTarget, aFile, aDstFolder, aMessageId, idsAreUids, aInSelectedState, aUrlListener, aURL, aCopyState, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(const nsACString & aMessageIds, nsIMsgFolder *aSrcFolder, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) { return _to DownloadMessagesForOffline(aMessageIds, aSrcFolder, aListener, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD MoveFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval NS_OUTPARAM) { return _to MoveFolder(aClientEventTarget, aSrcFolder, aDstFolder, aUrlListener, msgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD RenameLeaf(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval NS_OUTPARAM) { return _to RenameLeaf(aClientEventTarget, aSrcFolder, aLeafName, aUrlListener, msgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) { return _to DeleteFolder(aClientEventTarget, aFolder, aUrlListener, aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aParentFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return _to CreateFolder(aClientEventTarget, aParentFolder, aLeafName, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ListFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return _to ListFolder(aClientEventTarget, aMailFolder, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SubscribeFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, const nsAString & mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return _to SubscribeFolder(aClientEventTarget, aMailFolder, mailboxName, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD UnsubscribeFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, const nsAString & mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return _to UnsubscribeFolder(aClientEventTarget, aMailFolder, mailboxName, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD EnsureFolderExists(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aParentFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return _to EnsureFolderExists(aClientEventTarget, aParentFolder, aLeafName, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetFolderAdminUrl(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return _to GetFolderAdminUrl(aClientEventTarget, aMailFolder, aMsgWindow, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD IssueCommandOnMsgs(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & aCommand, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM) { return _to IssueCommandOnMsgs(aClientEventTarget, aMailFolder, aMsgWindow, aCommand, aMessageIdentifierList, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FetchCustomMsgAttribute(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & aAttribute, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM) { return _to FetchCustomMsgAttribute(aClientEventTarget, aMailFolder, aMsgWindow, aAttribute, aMessageIdentifierList, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD StoreCustomKeywords(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & flagsToAdd, const nsACString & flagsToSubtract, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM) { return _to StoreCustomKeywords(aClientEventTarget, aMailFolder, aMsgWindow, flagsToAdd, flagsToSubtract, aMessageIdentifierList, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetListOfFoldersOnServer(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow) { return _to GetListOfFoldersOnServer(aServer, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD GetListOfFoldersWithPath(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow, const nsACString & folderPath) { return _to GetListOfFoldersWithPath(aServer, aMsgWindow, folderPath); } \
  NS_SCRIPTABLE NS_IMETHOD PlaybackAllOfflineOperations(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener, nsISupports **_retval NS_OUTPARAM) { return _to PlaybackAllOfflineOperations(aMsgWindow, aListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DownloadAllOffineImapFolders(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) { return _to DownloadAllOffineImapFolders(aMsgWindow, aListener); } \
  NS_SCRIPTABLE NS_IMETHOD GetCacheSession(nsICacheSession **aCacheSession) { return _to GetCacheSession(aCacheSession); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIIMAPSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD SelectFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectFolder(aClientEventTarget, aImapMailFolder, aUrlListener, aMsgWindow, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD LiteSelectFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->LiteSelectFolder(aClientEventTarget, aImapMailFolder, aUrlListener, aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddImapFetchToUrl(nsIURI *aURL, nsIMsgFolder *aImapMailFolder, const nsACString & aMessageIdentifierList, const nsACString & aAdditionalHeader) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddImapFetchToUrl(aURL, aImapMailFolder, aMessageIdentifierList, aAdditionalHeader); } \
  NS_SCRIPTABLE NS_IMETHOD FetchMessage(nsIImapUrl *aUrl, nsImapState aImapAction, nsIMsgFolder *aImapMailFolder, nsIImapMessageSink *aImapMessageSink, nsIMsgWindow *aMsgWindow, nsISupports *aConsumer, const nsACString & aMessageIdentifierList, PRBool convertDataToText, const nsACString & additionalHeader, nsIURI **aOutURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FetchMessage(aUrl, aImapAction, aImapMailFolder, aImapMessageSink, aMsgWindow, aConsumer, aMessageIdentifierList, convertDataToText, additionalHeader, aOutURL); } \
  NS_SCRIPTABLE NS_IMETHOD Noop(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->Noop(aClientEventTarget, aImapMailFolder, aUrlListener, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD GetHeaders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, PRBool aMessageIdsAreUID) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHeaders(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aMessageIdsAreUID); } \
  NS_SCRIPTABLE NS_IMETHOD GetBodyStart(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const nsACString & aMessageIdentifierList, PRInt32 numBytes, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBodyStart(aClientEventTarget, aImapMailFolder, aUrlListener, aMessageIdentifierList, numBytes, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Expunge(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->Expunge(aClientEventTarget, aImapMailFolder, aUrlListener, aMsgWindow, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolderStatus(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->UpdateFolderStatus(aClientEventTarget, aImapMailFolder, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->VerifyLogon(aImapMailFolder, aUrlListener, aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Biff(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, PRUint32 aUidHighWater) { return !_to ? NS_ERROR_NULL_POINTER : _to->Biff(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aUidHighWater); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteMessages(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, PRBool aMessageIdsAreUID) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteMessages(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aMessageIdsAreUID); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteAllMessages(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteAllMessages(aClientEventTarget, aImapMailFolder, aUrlListener, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD AddMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddMessageFlags(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_SCRIPTABLE NS_IMETHOD SubtractMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return !_to ? NS_ERROR_NULL_POINTER : _to->SubtractMessageFlags(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_SCRIPTABLE NS_IMETHOD SetMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetMessageFlags(aClientEventTarget, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_SCRIPTABLE NS_IMETHOD DiscoverAllFolders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->DiscoverAllFolders(aClientEventTarget, aImapMailFolder, aUrlListener, aMsgWindow, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD DiscoverAllAndSubscribedFolders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->DiscoverAllAndSubscribedFolders(aClientEventTarget, aImapMailFolder, aUrlListener, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD DiscoverChildren(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const nsACString & folderPath, nsIURI **aURL NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->DiscoverChildren(aClientEventTarget, aImapMailFolder, aUrlListener, folderPath, aURL); } \
  NS_SCRIPTABLE NS_IMETHOD OnlineMessageCopy(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, const nsACString & aMessageIds, nsIMsgFolder *aDstFolder, PRBool aIdsAreUids, PRBool aIsMove, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, nsISupports *aCopyState, nsIMsgWindow *aWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnlineMessageCopy(aClientEventTarget, aSrcFolder, aMessageIds, aDstFolder, aIdsAreUids, aIsMove, aUrlListener, aURL, aCopyState, aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD AppendMessageFromFile(nsIEventTarget *aClientEventTarget, nsIFile *aFile, nsIMsgFolder *aDstFolder, const nsACString & aMessageId, PRBool idsAreUids, PRBool aInSelectedState, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, nsISupports *aCopyState, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->AppendMessageFromFile(aClientEventTarget, aFile, aDstFolder, aMessageId, idsAreUids, aInSelectedState, aUrlListener, aURL, aCopyState, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(const nsACString & aMessageIds, nsIMsgFolder *aSrcFolder, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->DownloadMessagesForOffline(aMessageIds, aSrcFolder, aListener, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD MoveFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->MoveFolder(aClientEventTarget, aSrcFolder, aDstFolder, aUrlListener, msgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD RenameLeaf(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->RenameLeaf(aClientEventTarget, aSrcFolder, aLeafName, aUrlListener, msgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteFolder(aClientEventTarget, aFolder, aUrlListener, aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aParentFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateFolder(aClientEventTarget, aParentFolder, aLeafName, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ListFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ListFolder(aClientEventTarget, aMailFolder, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SubscribeFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, const nsAString & mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->SubscribeFolder(aClientEventTarget, aMailFolder, mailboxName, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD UnsubscribeFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, const nsAString & mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->UnsubscribeFolder(aClientEventTarget, aMailFolder, mailboxName, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD EnsureFolderExists(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aParentFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->EnsureFolderExists(aClientEventTarget, aParentFolder, aLeafName, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetFolderAdminUrl(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFolderAdminUrl(aClientEventTarget, aMailFolder, aMsgWindow, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD IssueCommandOnMsgs(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & aCommand, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->IssueCommandOnMsgs(aClientEventTarget, aMailFolder, aMsgWindow, aCommand, aMessageIdentifierList, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FetchCustomMsgAttribute(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & aAttribute, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FetchCustomMsgAttribute(aClientEventTarget, aMailFolder, aMsgWindow, aAttribute, aMessageIdentifierList, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD StoreCustomKeywords(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & flagsToAdd, const nsACString & flagsToSubtract, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->StoreCustomKeywords(aClientEventTarget, aMailFolder, aMsgWindow, flagsToAdd, flagsToSubtract, aMessageIdentifierList, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetListOfFoldersOnServer(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetListOfFoldersOnServer(aServer, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD GetListOfFoldersWithPath(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow, const nsACString & folderPath) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetListOfFoldersWithPath(aServer, aMsgWindow, folderPath); } \
  NS_SCRIPTABLE NS_IMETHOD PlaybackAllOfflineOperations(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener, nsISupports **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->PlaybackAllOfflineOperations(aMsgWindow, aListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DownloadAllOffineImapFolders(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->DownloadAllOffineImapFolders(aMsgWindow, aListener); } \
  NS_SCRIPTABLE NS_IMETHOD GetCacheSession(nsICacheSession **aCacheSession) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCacheSession(aCacheSession); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsImapService : public nsIImapService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIIMAPSERVICE

  nsImapService();

private:
  ~nsImapService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsImapService, nsIImapService)

nsImapService::nsImapService()
{
  /* member initializers and constructor code */
}

nsImapService::~nsImapService()
{
  /* destructor code */
}

/* void selectFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::SelectFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI liteSelectFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsImapService::LiteSelectFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addImapFetchToUrl (in nsIURI aURL, in nsIMsgFolder aImapMailFolder, in ACString aMessageIdentifierList, in ACString aAdditionalHeader); */
NS_IMETHODIMP nsImapService::AddImapFetchToUrl(nsIURI *aURL, nsIMsgFolder *aImapMailFolder, const nsACString & aMessageIdentifierList, const nsACString & aAdditionalHeader)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void fetchMessage (in nsIImapUrl aUrl, in nsImapState aImapAction, in nsIMsgFolder aImapMailFolder, in nsIImapMessageSink aImapMessageSink, in nsIMsgWindow aMsgWindow, in nsISupports aConsumer, in ACString aMessageIdentifierList, in boolean convertDataToText, in ACString additionalHeader, out nsIURI aOutURL); */
NS_IMETHODIMP nsImapService::FetchMessage(nsIImapUrl *aUrl, nsImapState aImapAction, nsIMsgFolder *aImapMailFolder, nsIImapMessageSink *aImapMessageSink, nsIMsgWindow *aMsgWindow, nsISupports *aConsumer, const nsACString & aMessageIdentifierList, PRBool convertDataToText, const nsACString & additionalHeader, nsIURI **aOutURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void noop (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::Noop(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getHeaders (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in ACString aMessageIdentifierList, in boolean aMessageIdsAreUID); */
NS_IMETHODIMP nsImapService::GetHeaders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, PRBool aMessageIdsAreUID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI getBodyStart (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in ACString aMessageIdentifierList, in long numBytes); */
NS_IMETHODIMP nsImapService::GetBodyStart(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const nsACString & aMessageIdentifierList, PRInt32 numBytes, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void expunge (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::Expunge(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI updateFolderStatus (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::UpdateFolderStatus(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI verifyLogon (in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsImapService::VerifyLogon(nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void biff (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in unsigned long aUidHighWater); */
NS_IMETHODIMP nsImapService::Biff(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, PRUint32 aUidHighWater)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteMessages (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in ACString aMessageIdentifierList, in boolean aMessageIdsAreUID); */
NS_IMETHODIMP nsImapService::DeleteMessages(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, PRBool aMessageIdsAreUID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteAllMessages (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::DeleteAllMessages(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addMessageFlags (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in ACString aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
NS_IMETHODIMP nsImapService::AddMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void subtractMessageFlags (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in ACString aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
NS_IMETHODIMP nsImapService::SubtractMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setMessageFlags (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in ACString aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
NS_IMETHODIMP nsImapService::SetMessageFlags(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, const nsACString & aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void discoverAllFolders (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::DiscoverAllFolders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void discoverAllAndSubscribedFolders (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::DiscoverAllAndSubscribedFolders(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void discoverChildren (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in ACString folderPath, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::DiscoverChildren(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const nsACString & folderPath, nsIURI **aURL NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onlineMessageCopy (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aSrcFolder, in ACString aMessageIds, in nsIMsgFolder aDstFolder, in boolean aIdsAreUids, in boolean aIsMove, in nsIUrlListener aUrlListener, out nsIURI aURL, in nsISupports aCopyState, in nsIMsgWindow aWindow); */
NS_IMETHODIMP nsImapService::OnlineMessageCopy(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, const nsACString & aMessageIds, nsIMsgFolder *aDstFolder, PRBool aIdsAreUids, PRBool aIsMove, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, nsISupports *aCopyState, nsIMsgWindow *aWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void appendMessageFromFile (in nsIEventTarget aClientEventTarget, in nsIFile aFile, in nsIMsgFolder aDstFolder, in ACString aMessageId, in boolean idsAreUids, in boolean aInSelectedState, in nsIUrlListener aUrlListener, out nsIURI aURL, in nsISupports aCopyState, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsImapService::AppendMessageFromFile(nsIEventTarget *aClientEventTarget, nsIFile *aFile, nsIMsgFolder *aDstFolder, const nsACString & aMessageId, PRBool idsAreUids, PRBool aInSelectedState, nsIUrlListener *aUrlListener, nsIURI **aURL NS_OUTPARAM, nsISupports *aCopyState, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void downloadMessagesForOffline (in ACString aMessageIds, in nsIMsgFolder aSrcFolder, in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsImapService::DownloadMessagesForOffline(const nsACString & aMessageIds, nsIMsgFolder *aSrcFolder, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI moveFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aSrcFolder, in nsIMsgFolder aDstFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsImapService::MoveFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI renameLeaf (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aSrcFolder, in AString aLeafName, in nsIUrlListener aUrlListener, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsImapService::RenameLeaf(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aSrcFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI deleteFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsImapService::DeleteFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI createFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aParentFolder, in AString aLeafName, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::CreateFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aParentFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI listFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::ListFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI subscribeFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in AString mailboxName, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::SubscribeFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, const nsAString & mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI unsubscribeFolder (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in AString mailboxName, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::UnsubscribeFolder(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, const nsAString & mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI ensureFolderExists (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aParentFolder, in AString aLeafName, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::EnsureFolderExists(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aParentFolder, const nsAString & aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI getFolderAdminUrl (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::GetFolderAdminUrl(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI issueCommandOnMsgs (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in ACString aCommand, in ACString aMessageIdentifierList); */
NS_IMETHODIMP nsImapService::IssueCommandOnMsgs(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & aCommand, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI fetchCustomMsgAttribute (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in ACString aAttribute, in ACString aMessageIdentifierList); */
NS_IMETHODIMP nsImapService::FetchCustomMsgAttribute(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & aAttribute, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI storeCustomKeywords (in nsIEventTarget aClientEventTarget, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in ACString flagsToAdd, in ACString flagsToSubtract, in ACString aMessageIdentifierList); */
NS_IMETHODIMP nsImapService::StoreCustomKeywords(nsIEventTarget *aClientEventTarget, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const nsACString & flagsToAdd, const nsACString & flagsToSubtract, const nsACString & aMessageIdentifierList, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getListOfFoldersOnServer (in nsIImapIncomingServer aServer, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsImapService::GetListOfFoldersOnServer(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getListOfFoldersWithPath (in nsIImapIncomingServer aServer, in nsIMsgWindow aMsgWindow, in ACString folderPath); */
NS_IMETHODIMP nsImapService::GetListOfFoldersWithPath(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow, const nsACString & folderPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupports playbackAllOfflineOperations (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
NS_IMETHODIMP nsImapService::PlaybackAllOfflineOperations(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener, nsISupports **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void downloadAllOffineImapFolders (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
NS_IMETHODIMP nsImapService::DownloadAllOffineImapFolders(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsICacheSession cacheSession; */
NS_IMETHODIMP nsImapService::GetCacheSession(nsICacheSession **aCacheSession)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIImapService_h__ */
