/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsILDAPURL.idl
 */

#ifndef __gen_nsILDAPURL_h__
#define __gen_nsILDAPURL_h__


#ifndef __gen_nsIURI_h__
#include "nsIURI.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#define NS_LDAPURL_CONTRACTID "@mozilla.org/network/ldap-url;1"

/* starting interface:    nsILDAPURL */
#define NS_ILDAPURL_IID_STR "acc5cd8f-95a4-454b-acc4-4646b9424ef2"

#define NS_ILDAPURL_IID \
  {0xacc5cd8f, 0x95a4, 0x454b, \
    { 0xac, 0xc4, 0x46, 0x46, 0xb9, 0x42, 0x4e, 0xf2 }}

/**
 * Strings in methods inherited from nsIURI, which are using XPIDL
 * |string| types, are expected to be UTF8 encoded. All such strings
 * in this interface, except attribute types (e.g. "cn"), should in fact
 * be UTF8. It's important to remember that attributes can not be UTF8,
 * they can only be of a limited subset of ASCII (see RFC 2251).
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsILDAPURL : public nsIURI {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ILDAPURL_IID)

  /**
     * Initialize an LDAP URL
     *
     * @param aUrlType       - one of the URLTYPE_ flags @seealso nsIStandardURL
     * @param aDefaultPort   - if the port parsed from the URL string matches
     *                         this port, then the port will be removed from the
     *                         canonical form of the URL.
     * @param aSpec          - URL string.
     * @param aOriginCharset - the charset from which this URI string
     *                         originated.  this corresponds to the charset
     *                         that should be used when communicating this
     *                         URI to an origin server, for example.  if
     *                         null, then provide aBaseURI implements this
     *                         interface, the origin charset of aBaseURI will
     *                         be assumed, otherwise defaulting to UTF-8 (i.e.,
     *                         no charset transformation from aSpec).
     * @param aBaseURI       - if null, aSpec must specify an absolute URI.
     *                         otherwise, aSpec will be resolved relative
     *                         to aBaseURI.
     */
  /* void init (in unsigned long aUrlType, in long aDefaultPort, in AUTF8String aSpec, in string aOriginCharset, in nsIURI aBaseURI); */
  NS_SCRIPTABLE NS_IMETHOD Init(PRUint32 aUrlType, PRInt32 aDefaultPort, const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI) = 0;

  /**
     * The distinguished name of the URL (ie the base DN for the search).
     * This string is expected to be a valid UTF8 string.
     *
     * for the getter:
     *
     * @exception NS_ERROR_NULL_POINTER     NULL pointer to GET method
     * @exception NS_ERROR_OUT_OF_MEMORY	Ran out of memory
     */
  /* attribute AUTF8String dn; */
  NS_SCRIPTABLE NS_IMETHOD GetDn(nsACString & aDn) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDn(const nsACString & aDn) = 0;

  /**
     * The attributes to get for this URL, in comma-separated format. If the
     * list is empty, all attributes are requested.
     */
  /* attribute ACString attributes; */
  NS_SCRIPTABLE NS_IMETHOD GetAttributes(nsACString & aAttributes) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetAttributes(const nsACString & aAttributes) = 0;

  /**
     * Add one attribute to the array of attributes to request. If the
     * attribute is already in our array, this becomes a noop.
     *
     * @param aAttribute          An LDAP attribute (e.g. "cn")
     */
  /* void addAttribute (in ACString aAttribute); */
  NS_SCRIPTABLE NS_IMETHOD AddAttribute(const nsACString & aAttribute) = 0;

  /**
     * Remove one attribute from the array of attributes to request. If
     * the attribute didn't exist in the array, this becomes a noop.
     *
     * @param aAttribute                    An LDAP attribute (e.g. "cn")
     * @exception NS_ERROR_OUT_OF_MEMORY	Ran out of memory
     */
  /* void removeAttribute (in ACString aAttribute); */
  NS_SCRIPTABLE NS_IMETHOD RemoveAttribute(const nsACString & aAttribute) = 0;

  /**
     * Test if an attribute is in our list of attributes already
     *
     * @param aAttribute                    An LDAP attribute (e.g. "cn")
     * @return boolean                      Truth value
     * @exception NS_ERROR_NULL_POINTER     NULL pointer to GET method
     */
  /* boolean hasAttribute (in ACString aAttribute); */
  NS_SCRIPTABLE NS_IMETHOD HasAttribute(const nsACString & aAttribute, PRBool *_retval NS_OUTPARAM) = 0;

  /**
     * The scope of the search.  defaults to SCOPE_BASE. 
     *
     * @exception NS_ERROR_NULL_POINTER     NULL pointer to GET method
     * @exception NS_ERROR_MALFORMED_URI	Illegal base to SET method
     */
  /* attribute long scope; */
  NS_SCRIPTABLE NS_IMETHOD GetScope(PRInt32 *aScope) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetScope(PRInt32 aScope) = 0;

  /**
     * Search just the base object
     */
  enum { SCOPE_BASE = 0 };

  /** 
     * Search only the children of the base object
     */
  enum { SCOPE_ONELEVEL = 1 };

  /**
     * Search the entire subtree under and including the base object
     */
  enum { SCOPE_SUBTREE = 2 };

  /**
     * The search filter. "(objectClass=*)" is the default.
     */
  /* attribute AUTF8String filter; */
  NS_SCRIPTABLE NS_IMETHOD GetFilter(nsACString & aFilter) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetFilter(const nsACString & aFilter) = 0;

  /**
     * Any options defined for this URL (check options using a bitwise and)
     * 
     * @exception NS_ERROR_NULL_POINTER     NULL pointer to GET method
     * @exception NS_ERROR_OUT_OF_MEMORY    Ran out of memory
     */
  /* attribute unsigned long options; */
  NS_SCRIPTABLE NS_IMETHOD GetOptions(PRUint32 *aOptions) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetOptions(PRUint32 aOptions) = 0;

  /**
     * If this is set/true, this is an ldaps: URL, not an ldap: URL
     */
  enum { OPT_SECURE = 1U };

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsILDAPURL, NS_ILDAPURL_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSILDAPURL \
  NS_SCRIPTABLE NS_IMETHOD Init(PRUint32 aUrlType, PRInt32 aDefaultPort, const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI); \
  NS_SCRIPTABLE NS_IMETHOD GetDn(nsACString & aDn); \
  NS_SCRIPTABLE NS_IMETHOD SetDn(const nsACString & aDn); \
  NS_SCRIPTABLE NS_IMETHOD GetAttributes(nsACString & aAttributes); \
  NS_SCRIPTABLE NS_IMETHOD SetAttributes(const nsACString & aAttributes); \
  NS_SCRIPTABLE NS_IMETHOD AddAttribute(const nsACString & aAttribute); \
  NS_SCRIPTABLE NS_IMETHOD RemoveAttribute(const nsACString & aAttribute); \
  NS_SCRIPTABLE NS_IMETHOD HasAttribute(const nsACString & aAttribute, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetScope(PRInt32 *aScope); \
  NS_SCRIPTABLE NS_IMETHOD SetScope(PRInt32 aScope); \
  NS_SCRIPTABLE NS_IMETHOD GetFilter(nsACString & aFilter); \
  NS_SCRIPTABLE NS_IMETHOD SetFilter(const nsACString & aFilter); \
  NS_SCRIPTABLE NS_IMETHOD GetOptions(PRUint32 *aOptions); \
  NS_SCRIPTABLE NS_IMETHOD SetOptions(PRUint32 aOptions); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSILDAPURL(_to) \
  NS_SCRIPTABLE NS_IMETHOD Init(PRUint32 aUrlType, PRInt32 aDefaultPort, const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI) { return _to Init(aUrlType, aDefaultPort, aSpec, aOriginCharset, aBaseURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetDn(nsACString & aDn) { return _to GetDn(aDn); } \
  NS_SCRIPTABLE NS_IMETHOD SetDn(const nsACString & aDn) { return _to SetDn(aDn); } \
  NS_SCRIPTABLE NS_IMETHOD GetAttributes(nsACString & aAttributes) { return _to GetAttributes(aAttributes); } \
  NS_SCRIPTABLE NS_IMETHOD SetAttributes(const nsACString & aAttributes) { return _to SetAttributes(aAttributes); } \
  NS_SCRIPTABLE NS_IMETHOD AddAttribute(const nsACString & aAttribute) { return _to AddAttribute(aAttribute); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveAttribute(const nsACString & aAttribute) { return _to RemoveAttribute(aAttribute); } \
  NS_SCRIPTABLE NS_IMETHOD HasAttribute(const nsACString & aAttribute, PRBool *_retval NS_OUTPARAM) { return _to HasAttribute(aAttribute, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetScope(PRInt32 *aScope) { return _to GetScope(aScope); } \
  NS_SCRIPTABLE NS_IMETHOD SetScope(PRInt32 aScope) { return _to SetScope(aScope); } \
  NS_SCRIPTABLE NS_IMETHOD GetFilter(nsACString & aFilter) { return _to GetFilter(aFilter); } \
  NS_SCRIPTABLE NS_IMETHOD SetFilter(const nsACString & aFilter) { return _to SetFilter(aFilter); } \
  NS_SCRIPTABLE NS_IMETHOD GetOptions(PRUint32 *aOptions) { return _to GetOptions(aOptions); } \
  NS_SCRIPTABLE NS_IMETHOD SetOptions(PRUint32 aOptions) { return _to SetOptions(aOptions); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSILDAPURL(_to) \
  NS_SCRIPTABLE NS_IMETHOD Init(PRUint32 aUrlType, PRInt32 aDefaultPort, const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(aUrlType, aDefaultPort, aSpec, aOriginCharset, aBaseURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetDn(nsACString & aDn) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDn(aDn); } \
  NS_SCRIPTABLE NS_IMETHOD SetDn(const nsACString & aDn) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDn(aDn); } \
  NS_SCRIPTABLE NS_IMETHOD GetAttributes(nsACString & aAttributes) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAttributes(aAttributes); } \
  NS_SCRIPTABLE NS_IMETHOD SetAttributes(const nsACString & aAttributes) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAttributes(aAttributes); } \
  NS_SCRIPTABLE NS_IMETHOD AddAttribute(const nsACString & aAttribute) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddAttribute(aAttribute); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveAttribute(const nsACString & aAttribute) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveAttribute(aAttribute); } \
  NS_SCRIPTABLE NS_IMETHOD HasAttribute(const nsACString & aAttribute, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->HasAttribute(aAttribute, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetScope(PRInt32 *aScope) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetScope(aScope); } \
  NS_SCRIPTABLE NS_IMETHOD SetScope(PRInt32 aScope) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetScope(aScope); } \
  NS_SCRIPTABLE NS_IMETHOD GetFilter(nsACString & aFilter) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFilter(aFilter); } \
  NS_SCRIPTABLE NS_IMETHOD SetFilter(const nsACString & aFilter) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFilter(aFilter); } \
  NS_SCRIPTABLE NS_IMETHOD GetOptions(PRUint32 *aOptions) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOptions(aOptions); } \
  NS_SCRIPTABLE NS_IMETHOD SetOptions(PRUint32 aOptions) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetOptions(aOptions); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsLDAPURL : public nsILDAPURL
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSILDAPURL

  nsLDAPURL();

private:
  ~nsLDAPURL();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsLDAPURL, nsILDAPURL)

nsLDAPURL::nsLDAPURL()
{
  /* member initializers and constructor code */
}

nsLDAPURL::~nsLDAPURL()
{
  /* destructor code */
}

/* void init (in unsigned long aUrlType, in long aDefaultPort, in AUTF8String aSpec, in string aOriginCharset, in nsIURI aBaseURI); */
NS_IMETHODIMP nsLDAPURL::Init(PRUint32 aUrlType, PRInt32 aDefaultPort, const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AUTF8String dn; */
NS_IMETHODIMP nsLDAPURL::GetDn(nsACString & aDn)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLDAPURL::SetDn(const nsACString & aDn)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString attributes; */
NS_IMETHODIMP nsLDAPURL::GetAttributes(nsACString & aAttributes)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLDAPURL::SetAttributes(const nsACString & aAttributes)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addAttribute (in ACString aAttribute); */
NS_IMETHODIMP nsLDAPURL::AddAttribute(const nsACString & aAttribute)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeAttribute (in ACString aAttribute); */
NS_IMETHODIMP nsLDAPURL::RemoveAttribute(const nsACString & aAttribute)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean hasAttribute (in ACString aAttribute); */
NS_IMETHODIMP nsLDAPURL::HasAttribute(const nsACString & aAttribute, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long scope; */
NS_IMETHODIMP nsLDAPURL::GetScope(PRInt32 *aScope)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLDAPURL::SetScope(PRInt32 aScope)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AUTF8String filter; */
NS_IMETHODIMP nsLDAPURL::GetFilter(nsACString & aFilter)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLDAPURL::SetFilter(const nsACString & aFilter)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long options; */
NS_IMETHODIMP nsLDAPURL::GetOptions(PRUint32 *aOptions)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLDAPURL::SetOptions(PRUint32 aOptions)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsILDAPURL_h__ */
