/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgAsyncPrompter.idl
 */

#ifndef __gen_nsIMsgAsyncPrompter_h__
#define __gen_nsIMsgAsyncPrompter_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIMsgAsyncPromptListener; /* forward declaration */


/* starting interface:    nsIMsgAsyncPrompter */
#define NS_IMSGASYNCPROMPTER_IID_STR "15f67d0f-947a-4a1e-8f72-6ab7162b4b9c"

#define NS_IMSGASYNCPROMPTER_IID \
  {0x15f67d0f, 0x947a, 0x4a1e, \
    { 0x8f, 0x72, 0x6a, 0xb7, 0x16, 0x2b, 0x4b, 0x9c }}

/**
 * The nsIMsgAsyncPrompter is intended to provide a way to make asynchoronous
 * message prompts into synchronous ones - so that the user is only prompted
 * with one at a time.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgAsyncPrompter : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGASYNCPROMPTER_IID)

  /**
   * Queues an async prompt request. If there are none queued then this will be
   * actioned straight away, otherwise the prompt will be queued for action
   * once previous prompt(s) have been cleared.
   *
   * Queued prompts using the same aKey may be amalgamated into one prompt to
   * save repeated prompts to the user.
   *
   * @param aKey    A key to determine whether or not the queued prompts can
   *                be combined.
   * @param aPromptImmediately If the user is retrying a failed password, we
   *                           need to prompt right away, even if there is a
   *                           prompt up, or prompts queued up. Note that
   *                           immediately may not be synchronously, on OS/X.
   * @param aCaller An nsIMsgAsyncPromptListener to call back to when the prompt
   *                is ready to be made.
   */
  /* void queueAsyncAuthPrompt (in ACString aKey, in boolean aPromptImmediately, in nsIMsgAsyncPromptListener aCaller); */
  NS_SCRIPTABLE NS_IMETHOD QueueAsyncAuthPrompt(const nsACString & aKey, PRBool aPromptImmediately, nsIMsgAsyncPromptListener *aCaller) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgAsyncPrompter, NS_IMSGASYNCPROMPTER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGASYNCPROMPTER \
  NS_SCRIPTABLE NS_IMETHOD QueueAsyncAuthPrompt(const nsACString & aKey, PRBool aPromptImmediately, nsIMsgAsyncPromptListener *aCaller); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGASYNCPROMPTER(_to) \
  NS_SCRIPTABLE NS_IMETHOD QueueAsyncAuthPrompt(const nsACString & aKey, PRBool aPromptImmediately, nsIMsgAsyncPromptListener *aCaller) { return _to QueueAsyncAuthPrompt(aKey, aPromptImmediately, aCaller); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGASYNCPROMPTER(_to) \
  NS_SCRIPTABLE NS_IMETHOD QueueAsyncAuthPrompt(const nsACString & aKey, PRBool aPromptImmediately, nsIMsgAsyncPromptListener *aCaller) { return !_to ? NS_ERROR_NULL_POINTER : _to->QueueAsyncAuthPrompt(aKey, aPromptImmediately, aCaller); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgAsyncPrompter : public nsIMsgAsyncPrompter
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGASYNCPROMPTER

  nsMsgAsyncPrompter();

private:
  ~nsMsgAsyncPrompter();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgAsyncPrompter, nsIMsgAsyncPrompter)

nsMsgAsyncPrompter::nsMsgAsyncPrompter()
{
  /* member initializers and constructor code */
}

nsMsgAsyncPrompter::~nsMsgAsyncPrompter()
{
  /* destructor code */
}

/* void queueAsyncAuthPrompt (in ACString aKey, in boolean aPromptImmediately, in nsIMsgAsyncPromptListener aCaller); */
NS_IMETHODIMP nsMsgAsyncPrompter::QueueAsyncAuthPrompt(const nsACString & aKey, PRBool aPromptImmediately, nsIMsgAsyncPromptListener *aCaller)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIMsgAsyncPromptListener */
#define NS_IMSGASYNCPROMPTLISTENER_IID_STR "fb5307a3-39d0-462e-92c8-c5c288a2612f"

#define NS_IMSGASYNCPROMPTLISTENER_IID \
  {0xfb5307a3, 0x39d0, 0x462e, \
    { 0x92, 0xc8, 0xc5, 0xc2, 0x88, 0xa2, 0x61, 0x2f }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgAsyncPromptListener : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGASYNCPROMPTLISTENER_IID)

  /**
 * This is used in combination with nsIMsgAsyncPrompter.
 */
/**
   * Called when the listener should do its prompt. The listener
   * should not return until the prompt is complete.
   *
   * @return  True if there is auth information available following the prompt,
   *          false otherwise.
   */
  /* boolean onPromptStart (); */
  NS_SCRIPTABLE NS_IMETHOD OnPromptStart(PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Called in the case that the queued prompt was combined with another and
   * there is now authentication information available.
   */
  /* void onPromptAuthAvailable (); */
  NS_SCRIPTABLE NS_IMETHOD OnPromptAuthAvailable(void) = 0;

  /**
   * Called in the case that the queued prompt was combined with another but
   * the prompt was canceled.
   */
  /* void onPromptCanceled (); */
  NS_SCRIPTABLE NS_IMETHOD OnPromptCanceled(void) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgAsyncPromptListener, NS_IMSGASYNCPROMPTLISTENER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGASYNCPROMPTLISTENER \
  NS_SCRIPTABLE NS_IMETHOD OnPromptStart(PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD OnPromptAuthAvailable(void); \
  NS_SCRIPTABLE NS_IMETHOD OnPromptCanceled(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGASYNCPROMPTLISTENER(_to) \
  NS_SCRIPTABLE NS_IMETHOD OnPromptStart(PRBool *_retval NS_OUTPARAM) { return _to OnPromptStart(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD OnPromptAuthAvailable(void) { return _to OnPromptAuthAvailable(); } \
  NS_SCRIPTABLE NS_IMETHOD OnPromptCanceled(void) { return _to OnPromptCanceled(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGASYNCPROMPTLISTENER(_to) \
  NS_SCRIPTABLE NS_IMETHOD OnPromptStart(PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnPromptStart(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD OnPromptAuthAvailable(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnPromptAuthAvailable(); } \
  NS_SCRIPTABLE NS_IMETHOD OnPromptCanceled(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnPromptCanceled(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgAsyncPromptListener : public nsIMsgAsyncPromptListener
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGASYNCPROMPTLISTENER

  nsMsgAsyncPromptListener();

private:
  ~nsMsgAsyncPromptListener();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgAsyncPromptListener, nsIMsgAsyncPromptListener)

nsMsgAsyncPromptListener::nsMsgAsyncPromptListener()
{
  /* member initializers and constructor code */
}

nsMsgAsyncPromptListener::~nsMsgAsyncPromptListener()
{
  /* destructor code */
}

/* boolean onPromptStart (); */
NS_IMETHODIMP nsMsgAsyncPromptListener::OnPromptStart(PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onPromptAuthAvailable (); */
NS_IMETHODIMP nsMsgAsyncPromptListener::OnPromptAuthAvailable()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onPromptCanceled (); */
NS_IMETHODIMP nsMsgAsyncPromptListener::OnPromptCanceled()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMsgAsyncPrompter_h__ */
