/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgFolder.idl
 */

#ifndef __gen_nsIMsgFolder_h__
#define __gen_nsIMsgFolder_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIFolderListener_h__
#include "nsIFolderListener.h"
#endif

#ifndef __gen_nsIMsgThread_h__
#include "nsIMsgThread.h"
#endif

#ifndef __gen_nsIMsgIncomingServer_h__
#include "nsIMsgIncomingServer.h"
#endif

#ifndef __gen_nsIMsgCopyServiceListener_h__
#include "nsIMsgCopyServiceListener.h"
#endif

#ifndef __gen_nsIUrlListener_h__
#include "nsIUrlListener.h"
#endif

#ifndef __gen_nsISimpleEnumerator_h__
#include "nsISimpleEnumerator.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIMsgDBHdr; /* forward declaration */

class nsIMsgWindow; /* forward declaration */

class nsIMsgDatabase; /* forward declaration */

class nsIDBFolderInfo; /* forward declaration */

class nsIMsgFilterList; /* forward declaration */

class nsIMsgFolderCacheElement; /* forward declaration */

class nsITransport; /* forward declaration */

class nsIFile; /* forward declaration */

class nsIOutputStream; /* forward declaration */

class nsIInputStream; /* forward declaration */

class nsILocalFile; /* forward declaration */

class nsIMsgIdentity; /* forward declaration */

class nsIArray; /* forward declaration */

class nsIMutableArray; /* forward declaration */

class nsISupportsArray; /* forward declaration */

typedef PRInt32  nsMsgBiffState;

typedef PRInt32  nsMsgDispositionState;


/* starting interface:    nsIMsgFolder */
#define NS_IMSGFOLDER_IID_STR "953b7bb1-6a3e-4a5b-841f-637ac68dee0e"

#define NS_IMSGFOLDER_IID \
  {0x953b7bb1, 0x6a3e, 0x4a5b, \
    { 0x84, 0x1f, 0x63, 0x7a, 0xc6, 0x8d, 0xee, 0x0e }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgFolder : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGFOLDER_IID)

  enum { nsMsgBiffState_NewMail = 0 };

  enum { nsMsgBiffState_NoMail = 1 };

  enum { nsMsgBiffState_Unknown = 2 };

  /* readonly attribute nsISimpleEnumerator messages; */
  NS_SCRIPTABLE NS_IMETHOD GetMessages(nsISimpleEnumerator **aMessages) = 0;

  /* void startFolderLoading (); */
  NS_SCRIPTABLE NS_IMETHOD StartFolderLoading(void) = 0;

  /* void endFolderLoading (); */
  NS_SCRIPTABLE NS_IMETHOD EndFolderLoading(void) = 0;

  /* void updateFolder (in nsIMsgWindow aWindow); */
  NS_SCRIPTABLE NS_IMETHOD UpdateFolder(nsIMsgWindow *aWindow) = 0;

  /* readonly attribute AString prettiestName; */
  NS_SCRIPTABLE NS_IMETHOD GetPrettiestName(nsAString & aPrettiestName) = 0;

  /**
   * URL for this folder
   */
  /* readonly attribute ACString folderURL; */
  NS_SCRIPTABLE NS_IMETHOD GetFolderURL(nsACString & aFolderURL) = 0;

  /**
   * should probably move to the server
   */
  /* readonly attribute boolean showDeletedMessages; */
  NS_SCRIPTABLE NS_IMETHOD GetShowDeletedMessages(PRBool *aShowDeletedMessages) = 0;

  /**
   * this folder's parent server
   */
  /* readonly attribute nsIMsgIncomingServer server; */
  NS_SCRIPTABLE NS_IMETHOD GetServer(nsIMsgIncomingServer **aServer) = 0;

  /**
   * is this folder the "phantom" server folder?
   */
  /* readonly attribute boolean isServer; */
  NS_SCRIPTABLE NS_IMETHOD GetIsServer(PRBool *aIsServer) = 0;

  /* readonly attribute boolean canSubscribe; */
  NS_SCRIPTABLE NS_IMETHOD GetCanSubscribe(PRBool *aCanSubscribe) = 0;

  /* readonly attribute boolean canFileMessages; */
  NS_SCRIPTABLE NS_IMETHOD GetCanFileMessages(PRBool *aCanFileMessages) = 0;

  /* readonly attribute boolean noSelect; */
  NS_SCRIPTABLE NS_IMETHOD GetNoSelect(PRBool *aNoSelect) = 0;

  /* readonly attribute boolean imapShared; */
  NS_SCRIPTABLE NS_IMETHOD GetImapShared(PRBool *aImapShared) = 0;

  /* readonly attribute boolean canDeleteMessages; */
  NS_SCRIPTABLE NS_IMETHOD GetCanDeleteMessages(PRBool *aCanDeleteMessages) = 0;

  /**
   * does this folder allow subfolders?
   * for example, newsgroups cannot have subfolders, and the INBOX
   * on some IMAP servers cannot have subfolders
   */
  /* readonly attribute boolean canCreateSubfolders; */
  NS_SCRIPTABLE NS_IMETHOD GetCanCreateSubfolders(PRBool *aCanCreateSubfolders) = 0;

  /**
   * can you change the name of this folder?
   * for example, newsgroups
   * and some special folders can't be renamed
   */
  /* readonly attribute boolean canRename; */
  NS_SCRIPTABLE NS_IMETHOD GetCanRename(PRBool *aCanRename) = 0;

  /* readonly attribute boolean canCompact; */
  NS_SCRIPTABLE NS_IMETHOD GetCanCompact(PRBool *aCanCompact) = 0;

  /**
   * the phantom server folder
   */
  /* readonly attribute nsIMsgFolder rootFolder; */
  NS_SCRIPTABLE NS_IMETHOD GetRootFolder(nsIMsgFolder **aRootFolder) = 0;

  /**
   * Get the server's list of filters. (Or in the case of news, the 
   * filter list for this newsgroup)
   * This list SHOULD be used for all incoming messages.
   *
   * Since the returned nsIMsgFilterList is mutable, it is not necessary to call
   * setFilterList after the filters have been changed.
   *
   * @param aMsgWindow  @ref msgwindow "The standard message window"
   * @return            The list of filters
   */
  /* nsIMsgFilterList getFilterList (in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD GetFilterList(nsIMsgWindow *msgWindow, nsIMsgFilterList **_retval NS_OUTPARAM) = 0;

  /**
   * Set the server's list of filters.
   *
   * Note that this does not persist the filter list. To change the contents
   * of the existing filters, use getFilterList and mutate the values as
   * appopriate.
   *
   * @param aFilterList The new list of filters.
   */
  /* void setFilterList (in nsIMsgFilterList filterList); */
  NS_SCRIPTABLE NS_IMETHOD SetFilterList(nsIMsgFilterList *filterList) = 0;

  /**
   * Get user editable filter list. This does not have to be the same as
   * the filterlist above, typically depending on the users preferences.
   * The filters in this list are not processed, but only to be edited by
   * the user.
   * @see getFilterList
   *
   * @param aMsgWindow  @ref msgwindow "The standard message window"
   * @return            The list of filters
   */
  /* nsIMsgFilterList getEditableFilterList (in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD GetEditableFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval NS_OUTPARAM) = 0;

  /**
   * Set user editable filter list.
   * This does not persist the filterlist, @see setFilterList
   * @see getEditableFilterList
   * @see setFilterList
   *
   * @param aFilterList The new list of filters.
   */
  /* void setEditableFilterList (in nsIMsgFilterList aFilterList); */
  NS_SCRIPTABLE NS_IMETHOD SetEditableFilterList(nsIMsgFilterList *aFilterList) = 0;

  /* void ForceDBClosed (); */
  NS_SCRIPTABLE NS_IMETHOD ForceDBClosed(void) = 0;

  /**
   * Close and backup a folder database prior to reparsing
   *
   * @param  newName  New name of the corresponding message folder.
   *                  Used in rename to set the file name to match the renamed
   *                  folder. Set to empty to use the existing folder name.
   */
  /* void closeAndBackupFolderDB (in ACString newName); */
  NS_SCRIPTABLE NS_IMETHOD CloseAndBackupFolderDB(const nsACString & newName) = 0;

  /* void Delete (); */
  NS_SCRIPTABLE NS_IMETHOD Delete(void) = 0;

  /* void deleteSubFolders (in nsIArray folders, in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD DeleteSubFolders(nsIArray *folders, nsIMsgWindow *msgWindow) = 0;

  /* void propagateDelete (in nsIMsgFolder folder, in boolean deleteStorage, in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD PropagateDelete(nsIMsgFolder *folder, PRBool deleteStorage, nsIMsgWindow *msgWindow) = 0;

  /* void recursiveDelete (in boolean deleteStorage, in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD RecursiveDelete(PRBool deleteStorage, nsIMsgWindow *msgWindow) = 0;

  /* void createSubfolder (in AString folderName, in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD CreateSubfolder(const nsAString & folderName, nsIMsgWindow *msgWindow) = 0;

  /* nsIMsgFolder addSubfolder (in AString folderName); */
  NS_SCRIPTABLE NS_IMETHOD AddSubfolder(const nsAString & folderName, nsIMsgFolder **_retval NS_OUTPARAM) = 0;

  /* void createStorageIfMissing (in nsIUrlListener urlListener); */
  NS_SCRIPTABLE NS_IMETHOD CreateStorageIfMissing(nsIUrlListener *urlListener) = 0;

  /**
   * Compact this folder. For IMAP folders configured for offline use,
   * it will also compact the offline store, and the completed notification
   * will occur when the Expunge is finished, not the offline store compaction.
   *
   * @param aListener   Notified of completion, can be null.
   * @param aMsgWindow  For progress/status, can be null.
   */
  /* void compact (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD Compact(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) = 0;

  /**
   * Compact all folders in the account corresponding to this folder/
   * Optionally compact their offline stores as well (imap/news)
   * 
   * @param aListener   Notified of completion, can be null.
   * @param aMsgWindow  For progress/status, can be null.
   * @param aCompactOfflineAlso  This controls whether we compact all 
   *                             offline stores as well.
   */
  /* void compactAll (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow, in boolean aCompactOfflineAlso); */
  NS_SCRIPTABLE NS_IMETHOD CompactAll(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, PRBool aCompactOfflineAlso) = 0;

  /* void compactAllOfflineStores (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow, in nsIArray aOfflineFolderArray); */
  NS_SCRIPTABLE NS_IMETHOD CompactAllOfflineStores(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, nsIArray *aOfflineFolderArray) = 0;

  /* void emptyTrash (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
  NS_SCRIPTABLE NS_IMETHOD EmptyTrash(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) = 0;

  /**
   * change the name of the folder
   *
   * @param name the new name of the folder
   */
  /* void rename (in AString name, in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD Rename(const nsAString & name, nsIMsgWindow *msgWindow) = 0;

  /* void renameSubFolders (in nsIMsgWindow msgWindow, in nsIMsgFolder oldFolder); */
  NS_SCRIPTABLE NS_IMETHOD RenameSubFolders(nsIMsgWindow *msgWindow, nsIMsgFolder *oldFolder) = 0;

  /* AString generateUniqueSubfolderName (in AString prefix, in nsIMsgFolder otherFolder); */
  NS_SCRIPTABLE NS_IMETHOD GenerateUniqueSubfolderName(const nsAString & prefix, nsIMsgFolder *otherFolder, nsAString & _retval NS_OUTPARAM) = 0;

  /* void updateSummaryTotals (in boolean force); */
  NS_SCRIPTABLE NS_IMETHOD UpdateSummaryTotals(PRBool force) = 0;

  /* void summaryChanged (); */
  NS_SCRIPTABLE NS_IMETHOD SummaryChanged(void) = 0;

  /**
   * get the total number of unread messages in this folder,
   * or in all subfolders
   *
   * @param deep if true, descends into all subfolders and gets a grand total
   */
  /* long getNumUnread (in boolean deep); */
  NS_SCRIPTABLE NS_IMETHOD GetNumUnread(PRBool deep, PRInt32 *_retval NS_OUTPARAM) = 0;

  /**
   * get the total number of messages in this folder,
   * or in all subfolders
   *
   * @param deep if true, descends into all subfolders and gets a grand total
   */
  /* long getTotalMessages (in boolean deep); */
  NS_SCRIPTABLE NS_IMETHOD GetTotalMessages(PRBool deep, PRInt32 *_retval NS_OUTPARAM) = 0;

  /**
  * does this folder have new messages
  *
  */
  /* attribute boolean hasNewMessages; */
  NS_SCRIPTABLE NS_IMETHOD GetHasNewMessages(PRBool *aHasNewMessages) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetHasNewMessages(PRBool aHasNewMessages) = 0;

  /**
   * return the first new message in the folder
   *
   */
  /* readonly attribute nsIMsgDBHdr firstNewMessage; */
  NS_SCRIPTABLE NS_IMETHOD GetFirstNewMessage(nsIMsgDBHdr **aFirstNewMessage) = 0;

  /**
   * clear new status flag of all of the new messages
   *
   */
  /* void clearNewMessages (); */
  NS_SCRIPTABLE NS_IMETHOD ClearNewMessages(void) = 0;

  /* readonly attribute unsigned long expungedBytes; */
  NS_SCRIPTABLE NS_IMETHOD GetExpungedBytes(PRUint32 *aExpungedBytes) = 0;

  /**
   * can this folder be deleted?
   * for example, special folders cannot be deleted
   */
  /* readonly attribute boolean deletable; */
  NS_SCRIPTABLE NS_IMETHOD GetDeletable(PRBool *aDeletable) = 0;

  /**
   * should we be displaying recipients instead of the sender?
   * for example, in the Sent folder, recipients are more relevant
   * than the sender
   */
  /* readonly attribute boolean displayRecipients; */
  NS_SCRIPTABLE NS_IMETHOD GetDisplayRecipients(PRBool *aDisplayRecipients) = 0;

  /**
   * used to determine if it will take a long time to download all
   * the headers in this folder - so that we can do folder notifications
   * synchronously instead of asynchronously
   */
  /* readonly attribute boolean manyHeadersToDownload; */
  NS_SCRIPTABLE NS_IMETHOD GetManyHeadersToDownload(PRBool *aManyHeadersToDownload) = 0;

  /* readonly attribute boolean requiresCleanup; */
  NS_SCRIPTABLE NS_IMETHOD GetRequiresCleanup(PRBool *aRequiresCleanup) = 0;

  /* void clearRequiresCleanup (); */
  NS_SCRIPTABLE NS_IMETHOD ClearRequiresCleanup(void) = 0;

  /**
   * this should go into a news-specific interface
   */
  /* readonly attribute boolean knowsSearchNntpExtension; */
  NS_SCRIPTABLE NS_IMETHOD GetKnowsSearchNntpExtension(PRBool *aKnowsSearchNntpExtension) = 0;

  /**
   * this should go into a news-specific interface
   */
  /* readonly attribute boolean allowsPosting; */
  NS_SCRIPTABLE NS_IMETHOD GetAllowsPosting(PRBool *aAllowsPosting) = 0;

  /* readonly attribute ACString relativePathName; */
  NS_SCRIPTABLE NS_IMETHOD GetRelativePathName(nsACString & aRelativePathName) = 0;

  /**
   * size of this folder on disk (not including .msf file)
   * for imap, it's the sum of the size of the messages
   */
  /* attribute unsigned long sizeOnDisk; */
  NS_SCRIPTABLE NS_IMETHOD GetSizeOnDisk(PRUint32 *aSizeOnDisk) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetSizeOnDisk(PRUint32 aSizeOnDisk) = 0;

  /* readonly attribute ACString username; */
  NS_SCRIPTABLE NS_IMETHOD GetUsername(nsACString & aUsername) = 0;

  /* readonly attribute ACString hostname; */
  NS_SCRIPTABLE NS_IMETHOD GetHostname(nsACString & aHostname) = 0;

  /**
   * Sets a flag on the folder. The known flags are defined in
   * nsMsgFolderFlags.h.
   *
   * @param flag  The flag to set on the folder.
   */
  /* void setFlag (in unsigned long flag); */
  NS_SCRIPTABLE NS_IMETHOD SetFlag(PRUint32 flag) = 0;

  /**
   * Clears a flag on the folder. The known flags are defined in
   * nsMsgFolderFlags.h.
   *
   * @param flag  The flag to clear on the folder.
   */
  /* void clearFlag (in unsigned long flag); */
  NS_SCRIPTABLE NS_IMETHOD ClearFlag(PRUint32 flag) = 0;

  /**
   * Determines if a flag is set on the folder or not. The known flags are
   * defined in nsMsgFolderFlags.h.
   *
   * @param flag  The flag to check on the folder.
   * @return      True if the flag exists.
   */
  /* boolean getFlag (in unsigned long flag); */
  NS_SCRIPTABLE NS_IMETHOD GetFlag(PRUint32 flag, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Toggles a flag on the folder. The known flags are defined in
   * nsMsgFolderFlags.h.
   *
   * @param flag  The flag to toggle
   */
  /* void toggleFlag (in unsigned long flag); */
  NS_SCRIPTABLE NS_IMETHOD ToggleFlag(PRUint32 flag) = 0;

  /**
   * Called to notify the database and/or listeners of a change of flag. The
   * known flags are defined in nsMsgFolderFlags.h 
   *
   * @note        This doesn't need to be called for normal flag changes via
   *              the *Flag functions on this interface.
   *
   * @param flag  The flag that was changed.
   */
  /* void onFlagChange (in unsigned long flag); */
  NS_SCRIPTABLE NS_IMETHOD OnFlagChange(PRUint32 flag) = 0;

  /**
   * Direct access to the set/get all the flags at once.
   */
  /* attribute unsigned long flags; */
  NS_SCRIPTABLE NS_IMETHOD GetFlags(PRUint32 *aFlags) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetFlags(PRUint32 aFlags) = 0;

  /**
   * Gets the first folder that has the specified flags set.
   *
   * @param flags    The flag(s) to check for.
   * @return         The folder or the first available child folder that has
   *                 the specified flags set, or null if there are none.
   */
  /* nsIMsgFolder getFolderWithFlags (in unsigned long flags); */
  NS_SCRIPTABLE NS_IMETHOD GetFolderWithFlags(PRUint32 flags, nsIMsgFolder **_retval NS_OUTPARAM) = 0;

  /**
   * Gets the folders that have the specified flag set.
   *
   * @param flags    The flag(s) to check for.
   * @return         An array of folders that have the specified flags set.
   *                 The array may have zero elements.
   */
  /* nsIArray getFoldersWithFlags (in unsigned long flags); */
  NS_SCRIPTABLE NS_IMETHOD GetFoldersWithFlags(PRUint32 flags, nsIArray **_retval NS_OUTPARAM) = 0;

  /**
   * Lists the folders that have the specified flag set.
   *
   * @param flags    The flag(s) to check for.
   * @param folders  The array in which to append the found folder(s).
   */
  /* void listFoldersWithFlags (in unsigned long flags, in nsIMutableArray folders); */
  NS_SCRIPTABLE NS_IMETHOD ListFoldersWithFlags(PRUint32 flags, nsIMutableArray *folders) = 0;

  /**
   * Check if this folder (or one of its ancestors) is special.
   *
   * @param flags          The "special" flags to check.
   * @param checkAncestors Should ancestors be checked too.
   */
  /* boolean isSpecialFolder (in unsigned long flags, [optional] in boolean checkAncestors); */
  NS_SCRIPTABLE NS_IMETHOD IsSpecialFolder(PRUint32 flags, PRBool checkAncestors, PRBool *_retval NS_OUTPARAM) = 0;

  /* void getExpansionArray (in nsISupportsArray expansionArray); */
  NS_SCRIPTABLE NS_IMETHOD GetExpansionArray(nsISupportsArray *expansionArray) = 0;

  /* ACString getUriForMsg (in nsIMsgDBHdr msgHdr); */
  NS_SCRIPTABLE NS_IMETHOD GetUriForMsg(nsIMsgDBHdr *msgHdr, nsACString & _retval NS_OUTPARAM) = 0;

  /**
   * Deletes the messages from the folder.
   *
   * @param messages      The array of nsIMsgDBHdr objects to be deleted.
   * @param msgWindow     The standard message window object, for alerts et al.
   * @param deleteStorage Whether or not the message should be truly deleted, as
                          opposed to moving to trash.
   * @param isMove        Whether or not this is a deletion for moving messages.
   * @param allowUndo     Whether this action should be undoable.
   */
  /* void deleteMessages (in nsIArray messages, in nsIMsgWindow msgWindow, in boolean deleteStorage, in boolean isMove, in nsIMsgCopyServiceListener listener, in boolean allowUndo); */
  NS_SCRIPTABLE NS_IMETHOD DeleteMessages(nsIArray *messages, nsIMsgWindow *msgWindow, PRBool deleteStorage, PRBool isMove, nsIMsgCopyServiceListener *listener, PRBool allowUndo) = 0;

  /* void copyMessages (in nsIMsgFolder srcFolder, in nsIArray messages, in boolean isMove, in nsIMsgWindow msgWindow, in nsIMsgCopyServiceListener listener, in boolean isFolder, in boolean allowUndo); */
  NS_SCRIPTABLE NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, nsIArray *messages, PRBool isMove, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener, PRBool isFolder, PRBool allowUndo) = 0;

  /* void copyFolder (in nsIMsgFolder srcFolder, in boolean isMoveFolder, in nsIMsgWindow msgWindow, in nsIMsgCopyServiceListener listener); */
  NS_SCRIPTABLE NS_IMETHOD CopyFolder(nsIMsgFolder *srcFolder, PRBool isMoveFolder, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) = 0;

  /* void copyFileMessage (in nsIFile file, in nsIMsgDBHdr msgToReplace, in boolean isDraft, in unsigned long newMsgFlags, in ACString aKeywords, in nsIMsgWindow msgWindow, in nsIMsgCopyServiceListener listener); */
  NS_SCRIPTABLE NS_IMETHOD CopyFileMessage(nsIFile *file, nsIMsgDBHdr *msgToReplace, PRBool isDraft, PRUint32 newMsgFlags, const nsACString & aKeywords, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) = 0;

  /* void acquireSemaphore (in nsISupports semHolder); */
  NS_SCRIPTABLE NS_IMETHOD AcquireSemaphore(nsISupports *semHolder) = 0;

  /* void releaseSemaphore (in nsISupports semHolder); */
  NS_SCRIPTABLE NS_IMETHOD ReleaseSemaphore(nsISupports *semHolder) = 0;

  /* boolean testSemaphore (in nsISupports semHolder); */
  NS_SCRIPTABLE NS_IMETHOD TestSemaphore(nsISupports *semHolder, PRBool *_retval NS_OUTPARAM) = 0;

  /* readonly attribute boolean locked; */
  NS_SCRIPTABLE NS_IMETHOD GetLocked(PRBool *aLocked) = 0;

  /* void getNewMessages (in nsIMsgWindow aWindow, in nsIUrlListener aListener); */
  NS_SCRIPTABLE NS_IMETHOD GetNewMessages(nsIMsgWindow *aWindow, nsIUrlListener *aListener) = 0;

  /**
   * write out summary data for this folder
   * to the given folder cache (i.e. panacea.dat)
   */
  /* void writeToFolderCache (in nsIMsgFolderCache folderCache, in boolean deep); */
  NS_SCRIPTABLE NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache, PRBool deep) = 0;

  /**
   * the charset of this folder
   */
  /* attribute ACString charset; */
  NS_SCRIPTABLE NS_IMETHOD GetCharset(nsACString & aCharset) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetCharset(const nsACString & aCharset) = 0;

  /* attribute boolean charsetOverride; */
  NS_SCRIPTABLE NS_IMETHOD GetCharsetOverride(PRBool *aCharsetOverride) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetCharsetOverride(PRBool aCharsetOverride) = 0;

  /* attribute unsigned long biffState; */
  NS_SCRIPTABLE NS_IMETHOD GetBiffState(PRUint32 *aBiffState) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetBiffState(PRUint32 aBiffState) = 0;

  /**
   * the number of new messages since this folder was last visited
   * @param deep if true, descends into all subfolders and gets a grand total
   */
  /* long getNumNewMessages (in boolean deep); */
  NS_SCRIPTABLE NS_IMETHOD GetNumNewMessages(PRBool deep, PRInt32 *_retval NS_OUTPARAM) = 0;

  /* void setNumNewMessages (in long numNewMessages); */
  NS_SCRIPTABLE NS_IMETHOD SetNumNewMessages(PRInt32 numNewMessages) = 0;

  /**
   * are we running a url as a result of the user clicking get msg?
   */
  /* attribute boolean gettingNewMessages; */
  NS_SCRIPTABLE NS_IMETHOD GetGettingNewMessages(PRBool *aGettingNewMessages) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetGettingNewMessages(PRBool aGettingNewMessages) = 0;

  /**
   * local path of this folder
   */
  /* attribute nsILocalFile filePath; */
  NS_SCRIPTABLE NS_IMETHOD GetFilePath(nsILocalFile **aFilePath) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetFilePath(nsILocalFile *aFilePath) = 0;

  /* readonly attribute ACString baseMessageURI; */
  NS_SCRIPTABLE NS_IMETHOD GetBaseMessageURI(nsACString & aBaseMessageURI) = 0;

  /* ACString generateMessageURI (in nsMsgKey msgKey); */
  NS_SCRIPTABLE NS_IMETHOD GenerateMessageURI(nsMsgKey msgKey, nsACString & _retval NS_OUTPARAM) = 0;

  enum { nsMsgDispositionState_None = -1 };

  enum { nsMsgDispositionState_Replied = 0 };

  enum { nsMsgDispositionState_Forwarded = 1 };

  /* void addMessageDispositionState (in nsIMsgDBHdr aMessage, in nsMsgDispositionState aDispositionFlag); */
  NS_SCRIPTABLE NS_IMETHOD AddMessageDispositionState(nsIMsgDBHdr *aMessage, nsMsgDispositionState aDispositionFlag) = 0;

  /* void markMessagesRead (in nsIArray messages, in boolean markRead); */
  NS_SCRIPTABLE NS_IMETHOD MarkMessagesRead(nsIArray *messages, PRBool markRead) = 0;

  /* void markAllMessagesRead (in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD MarkAllMessagesRead(nsIMsgWindow *aMsgWindow) = 0;

  /* void markMessagesFlagged (in nsIArray messages, in boolean markFlagged); */
  NS_SCRIPTABLE NS_IMETHOD MarkMessagesFlagged(nsIArray *messages, PRBool markFlagged) = 0;

  /* void markThreadRead (in nsIMsgThread thread); */
  NS_SCRIPTABLE NS_IMETHOD MarkThreadRead(nsIMsgThread *thread) = 0;

  /* void setLabelForMessages (in nsIArray messages, in nsMsgLabelValue label); */
  NS_SCRIPTABLE NS_IMETHOD SetLabelForMessages(nsIArray *messages, nsMsgLabelValue label) = 0;

  /**
   * Gets the message database for the folder.
   *
   * Note that if the database is out of date, the implementation MAY choose to
   * throw an error. For a handle to the database which MAY NOT throw an error,
   * one can use getDBFolderInfoAndDB.
   *
   * @exception NS_MSG_ERROR_FOLDER_SUMMARY_MISSING If the database does not
   *                         exist.
   * @exception NS_MSG_ERROR_FOLDER_SUMMARY_OUT_OF_DATE If the database contains
   *                         out of date information.
   * @see nsIMsgFolder::getDBFolderInfoAndDB.
   */
  /* attribute nsIMsgDatabase msgDatabase; */
  NS_SCRIPTABLE NS_IMETHOD GetMsgDatabase(nsIMsgDatabase **aMsgDatabase) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetMsgDatabase(nsIMsgDatabase *aMsgDatabase) = 0;

  /**
   * Get the backup message database, used in reparsing. This database must
   * be created first using closeAndBackupFolderDB()
   *
   * @return   backup message database
   */
  /* nsIMsgDatabase getBackupMsgDatabase (); */
  NS_SCRIPTABLE NS_IMETHOD GetBackupMsgDatabase(nsIMsgDatabase **_retval NS_OUTPARAM) = 0;

  /**
   * Remove the backup message database file
   */
  /* void removeBackupMsgDatabase (); */
  NS_SCRIPTABLE NS_IMETHOD RemoveBackupMsgDatabase(void) = 0;

  /**
   * Open the backup message database file
   */
  /* void openBackupMsgDatabase (); */
  NS_SCRIPTABLE NS_IMETHOD OpenBackupMsgDatabase(void) = 0;

  /* nsIMsgDatabase getDBFolderInfoAndDB (out nsIDBFolderInfo folderInfo); */
  NS_SCRIPTABLE NS_IMETHOD GetDBFolderInfoAndDB(nsIDBFolderInfo **folderInfo NS_OUTPARAM, nsIMsgDatabase **_retval NS_OUTPARAM) = 0;

  /* nsIMsgDBHdr GetMessageHeader (in nsMsgKey msgKey); */
  NS_SCRIPTABLE NS_IMETHOD GetMessageHeader(nsMsgKey msgKey, nsIMsgDBHdr **_retval NS_OUTPARAM) = 0;

  /* readonly attribute boolean supportsOffline; */
  NS_SCRIPTABLE NS_IMETHOD GetSupportsOffline(PRBool *aSupportsOffline) = 0;

  /* boolean shouldStoreMsgOffline (in nsMsgKey msgKey); */
  NS_SCRIPTABLE NS_IMETHOD ShouldStoreMsgOffline(nsMsgKey msgKey, PRBool *_retval NS_OUTPARAM) = 0;

  /* boolean hasMsgOffline (in nsMsgKey msgKey); */
  NS_SCRIPTABLE NS_IMETHOD HasMsgOffline(nsMsgKey msgKey, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Get an input stream to read the offline contents of an imap or news
   * message.
   *
   * @param aMsgKey key of message to get input stream for.
   * @param[out] aOffset filled in with the offset into the stream of the message.
   * @param[out] aSize filled in with the size of the message in the offline store.
   *
   * @returns input stream to read the message from.
   */
  /* nsIInputStream getOfflineFileStream (in nsMsgKey aMsgKey, out unsigned long long aOffset, out unsigned long aSize); */
  NS_SCRIPTABLE NS_IMETHOD GetOfflineFileStream(nsMsgKey aMsgKey, PRUint64 *aOffset NS_OUTPARAM, PRUint32 *aSize NS_OUTPARAM, nsIInputStream **_retval NS_OUTPARAM) = 0;

  /* readonly attribute nsIOutputStream offlineStoreOutputStream; */
  NS_SCRIPTABLE NS_IMETHOD GetOfflineStoreOutputStream(nsIOutputStream **aOfflineStoreOutputStream) = 0;

  /* readonly attribute nsIInputStream offlineStoreInputStream; */
  NS_SCRIPTABLE NS_IMETHOD GetOfflineStoreInputStream(nsIInputStream **aOfflineStoreInputStream) = 0;

  /* void DownloadMessagesForOffline (in nsIArray messages, in nsIMsgWindow window); */
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(nsIArray *messages, nsIMsgWindow *window) = 0;

  /* nsIMsgFolder getChildWithURI (in ACString uri, in boolean deep, in boolean caseInsensitive); */
  NS_SCRIPTABLE NS_IMETHOD GetChildWithURI(const nsACString & uri, PRBool deep, PRBool caseInsensitive, nsIMsgFolder **_retval NS_OUTPARAM) = 0;

  /* void downloadAllForOffline (in nsIUrlListener listener, in nsIMsgWindow window); */
  NS_SCRIPTABLE NS_IMETHOD DownloadAllForOffline(nsIUrlListener *listener, nsIMsgWindow *window) = 0;

  /**
   *  Turn notifications on/off for various notification types. Currently only
   *  supporting allMessageCountNotifications which refers to both total and
   *  unread message counts.
   */
  enum { allMessageCountNotifications = 0U };

  /* void enableNotifications (in long notificationType, in boolean enable, in boolean dbBatching); */
  NS_SCRIPTABLE NS_IMETHOD EnableNotifications(PRInt32 notificationType, PRBool enable, PRBool dbBatching) = 0;

  /* boolean isCommandEnabled (in ACString command); */
  NS_SCRIPTABLE NS_IMETHOD IsCommandEnabled(const nsACString & command, PRBool *_retval NS_OUTPARAM) = 0;

  /* boolean matchOrChangeFilterDestination (in nsIMsgFolder folder, in boolean caseInsensitive); */
  NS_SCRIPTABLE NS_IMETHOD MatchOrChangeFilterDestination(nsIMsgFolder *folder, PRBool caseInsensitive, PRBool *_retval NS_OUTPARAM) = 0;

  /* boolean confirmFolderDeletionForFilter (in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD ConfirmFolderDeletionForFilter(nsIMsgWindow *msgWindow, PRBool *_retval NS_OUTPARAM) = 0;

  /* void alertFilterChanged (in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD AlertFilterChanged(nsIMsgWindow *msgWindow) = 0;

  /* void throwAlertMsg (in string msgName, in nsIMsgWindow msgWindow); */
  NS_SCRIPTABLE NS_IMETHOD ThrowAlertMsg(const char *msgName, nsIMsgWindow *msgWindow) = 0;

  /* AString getStringWithFolderNameFromBundle (in string msgName); */
  NS_SCRIPTABLE NS_IMETHOD GetStringWithFolderNameFromBundle(const char *msgName, nsAString & _retval NS_OUTPARAM) = 0;

  /* void notifyCompactCompleted (); */
  NS_SCRIPTABLE NS_IMETHOD NotifyCompactCompleted(void) = 0;

  /* long compareSortKeys (in nsIMsgFolder msgFolder); */
  NS_SCRIPTABLE NS_IMETHOD CompareSortKeys(nsIMsgFolder *msgFolder, PRInt32 *_retval NS_OUTPARAM) = 0;

  /**
   * Returns a sort key that can be used to sort a list of folders.
   *
   * Prefer nsIMsgFolder::compareSortKeys over this function.
   */
  /* void getSortKey (out unsigned long length, [array, size_is (length), retval] out octet key); */
  NS_SCRIPTABLE NS_IMETHOD GetSortKey(PRUint32 *length NS_OUTPARAM, PRUint8 **key NS_OUTPARAM) = 0;

  /* attribute nsIMsgRetentionSettings retentionSettings; */
  NS_SCRIPTABLE NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings **aRetentionSettings) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings *aRetentionSettings) = 0;

  /* attribute nsIMsgDownloadSettings downloadSettings; */
  NS_SCRIPTABLE NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings **aDownloadSettings) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings *aDownloadSettings) = 0;

  /* boolean callFilterPlugins (in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD CallFilterPlugins(nsIMsgWindow *aMsgWindow, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * used for order in the folder pane, folder pickers, etc.
   */
  /* attribute long sortOrder; */
  NS_SCRIPTABLE NS_IMETHOD GetSortOrder(PRInt32 *aSortOrder) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetSortOrder(PRInt32 aSortOrder) = 0;

  /* attribute nsIDBFolderInfo dBTransferInfo; */
  NS_SCRIPTABLE NS_IMETHOD GetDBTransferInfo(nsIDBFolderInfo **aDBTransferInfo) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDBTransferInfo(nsIDBFolderInfo *aDBTransferInfo) = 0;

  /* ACString getStringProperty (in string propertyName); */
  NS_SCRIPTABLE NS_IMETHOD GetStringProperty(const char *propertyName, nsACString & _retval NS_OUTPARAM) = 0;

  /* void setStringProperty (in string propertyName, in ACString propertyValue); */
  NS_SCRIPTABLE NS_IMETHOD SetStringProperty(const char *propertyName, const nsACString & propertyValue) = 0;

  /* attribute nsMsgKey lastMessageLoaded; */
  NS_SCRIPTABLE NS_IMETHOD GetLastMessageLoaded(nsMsgKey *aLastMessageLoaded) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetLastMessageLoaded(nsMsgKey aLastMessageLoaded) = 0;

  /* readonly attribute ACString URI; */
  NS_SCRIPTABLE NS_IMETHOD GetURI(nsACString & aURI) = 0;

  /* attribute AString name; */
  NS_SCRIPTABLE NS_IMETHOD GetName(nsAString & aName) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetName(const nsAString & aName) = 0;

  /* attribute AString prettyName; */
  NS_SCRIPTABLE NS_IMETHOD GetPrettyName(nsAString & aPrettyName) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetPrettyName(const nsAString & aPrettyName) = 0;

  /* readonly attribute AString abbreviatedName; */
  NS_SCRIPTABLE NS_IMETHOD GetAbbreviatedName(nsAString & aAbbreviatedName) = 0;

  /* attribute nsIMsgFolder parent; */
  NS_SCRIPTABLE NS_IMETHOD GetParent(nsIMsgFolder **aParent) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetParent(nsIMsgFolder *aParent) = 0;

  /**
   * Returns an enumerator containing a list of nsIMsgFolder items that are
   * subfolders of the instance this is called on.
   */
  /* readonly attribute nsISimpleEnumerator subFolders; */
  NS_SCRIPTABLE NS_IMETHOD GetSubFolders(nsISimpleEnumerator **aSubFolders) = 0;

  /**
   * Returns true if this folder has sub folders.
   */
  /* readonly attribute boolean hasSubFolders; */
  NS_SCRIPTABLE NS_IMETHOD GetHasSubFolders(PRBool *aHasSubFolders) = 0;

  /**
   * Returns the number of sub folders that this folder has.
   */
  /* readonly attribute unsigned long numSubFolders; */
  NS_SCRIPTABLE NS_IMETHOD GetNumSubFolders(PRUint32 *aNumSubFolders) = 0;

  /**
   * Determines if this folder is an ancestor of the supplied folder.
   *
   * @param folder  The folder that may or may not be a descendent of this
   *                folder.
   */
  /* boolean isAncestorOf (in nsIMsgFolder folder); */
  NS_SCRIPTABLE NS_IMETHOD IsAncestorOf(nsIMsgFolder *folder, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Looks in immediate children of this folder for the given name.
   *
   * @param name the name of the target subfolder
   */
  /* boolean containsChildNamed (in AString name); */
  NS_SCRIPTABLE NS_IMETHOD ContainsChildNamed(const nsAString & name, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Return the child folder which the specified name.
   *
   * @param aName  The name of the child folder to find
   * @return       The child folder
   * @exception NS_ERROR_FAILURE Thrown if the folder with aName does not exist
   */
  /* nsIMsgFolder getChildNamed (in AString aName); */
  NS_SCRIPTABLE NS_IMETHOD GetChildNamed(const nsAString & aName, nsIMsgFolder **_retval NS_OUTPARAM) = 0;

  /**
   * Finds the sub folder with the specified name.
   *
   * @param escapedSubFolderName  The name of the sub folder to find.
   * @note                        Even if the folder doesn't currently exist,
   *                              a nsIMsgFolder may be returned.
   */
  /* nsIMsgFolder findSubFolder (in ACString escapedSubFolderName); */
  NS_SCRIPTABLE NS_IMETHOD FindSubFolder(const nsACString & escapedSubFolderName, nsIMsgFolder **_retval NS_OUTPARAM) = 0;

  /* void AddFolderListener (in nsIFolderListener listener); */
  NS_SCRIPTABLE NS_IMETHOD AddFolderListener(nsIFolderListener *listener) = 0;

  /* void RemoveFolderListener (in nsIFolderListener listener); */
  NS_SCRIPTABLE NS_IMETHOD RemoveFolderListener(nsIFolderListener *listener) = 0;

  /* void NotifyPropertyChanged (in nsIAtom property, in ACString oldValue, in ACString newValue); */
  NS_SCRIPTABLE NS_IMETHOD NotifyPropertyChanged(nsIAtom *property, const nsACString & oldValue, const nsACString & newValue) = 0;

  /* void NotifyIntPropertyChanged (in nsIAtom property, in long oldValue, in long newValue); */
  NS_SCRIPTABLE NS_IMETHOD NotifyIntPropertyChanged(nsIAtom *property, PRInt32 oldValue, PRInt32 newValue) = 0;

  /* void NotifyBoolPropertyChanged (in nsIAtom property, in boolean oldValue, in boolean newValue); */
  NS_SCRIPTABLE NS_IMETHOD NotifyBoolPropertyChanged(nsIAtom *property, PRBool oldValue, PRBool newValue) = 0;

  /* void NotifyPropertyFlagChanged (in nsIMsgDBHdr item, in nsIAtom property, in unsigned long oldValue, in unsigned long newValue); */
  NS_SCRIPTABLE NS_IMETHOD NotifyPropertyFlagChanged(nsIMsgDBHdr *item, nsIAtom *property, PRUint32 oldValue, PRUint32 newValue) = 0;

  /* void NotifyUnicharPropertyChanged (in nsIAtom property, in AString oldValue, in AString newValue); */
  NS_SCRIPTABLE NS_IMETHOD NotifyUnicharPropertyChanged(nsIAtom *property, const nsAString & oldValue, const nsAString & newValue) = 0;

  /* void NotifyItemAdded (in nsISupports item); */
  NS_SCRIPTABLE NS_IMETHOD NotifyItemAdded(nsISupports *item) = 0;

  /* void NotifyItemRemoved (in nsISupports item); */
  NS_SCRIPTABLE NS_IMETHOD NotifyItemRemoved(nsISupports *item) = 0;

  /* void NotifyFolderEvent (in nsIAtom event); */
  NS_SCRIPTABLE NS_IMETHOD NotifyFolderEvent(nsIAtom *event) = 0;

  /* void ListDescendents (in nsISupportsArray descendents); */
  NS_SCRIPTABLE NS_IMETHOD ListDescendents(nsISupportsArray *descendents) = 0;

  /* void Shutdown (in boolean shutdownChildren); */
  NS_SCRIPTABLE NS_IMETHOD Shutdown(PRBool shutdownChildren) = 0;

  /* readonly attribute boolean inVFEditSearchScope; */
  NS_SCRIPTABLE NS_IMETHOD GetInVFEditSearchScope(PRBool *aInVFEditSearchScope) = 0;

  /* void setInVFEditSearchScope (in boolean aSearchThisFolder, in boolean aSetOnSubFolders); */
  NS_SCRIPTABLE NS_IMETHOD SetInVFEditSearchScope(PRBool aSearchThisFolder, PRBool aSetOnSubFolders) = 0;

  /* void copyDataToOutputStreamForAppend (in nsIInputStream aIStream, in long aLength, in nsIOutputStream outputStream); */
  NS_SCRIPTABLE NS_IMETHOD CopyDataToOutputStreamForAppend(nsIInputStream *aIStream, PRInt32 aLength, nsIOutputStream *outputStream) = 0;

  /* void copyDataDone (); */
  NS_SCRIPTABLE NS_IMETHOD CopyDataDone(void) = 0;

  /* void setJunkScoreForMessages (in nsIArray aMessages, in ACString aJunkScore); */
  NS_SCRIPTABLE NS_IMETHOD SetJunkScoreForMessages(nsIArray *aMessages, const nsACString & aJunkScore) = 0;

  /* void applyRetentionSettings (); */
  NS_SCRIPTABLE NS_IMETHOD ApplyRetentionSettings(void) = 0;

  /**
   * Get the beginning of the message bodies for the passed in keys and store
   * them in the msg hdr property "preview". This is intended for
   * new mail alerts, title tips on folders with new messages, and perhaps
   * titletips/message preview in the thread pane.
   *
   * @param aKeysToFetch   keys of msgs to fetch
   * @param aNumKeys       number of keys to fetch
   * @param aLocalOnly     whether to fetch msgs from server (imap msgs might
   *                       be in memory cache from junk filter)
   * @param aUrlListener   url listener to notify if we run url to fetch msgs
   *
   * @result aAsyncResults if true, we ran a url to fetch one or more of msg bodies
   *
   */
  /* boolean fetchMsgPreviewText ([array, size_is (aNumKeys)] in nsMsgKey aKeysToFetch, in unsigned long aNumKeys, in boolean aLocalOnly, in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD FetchMsgPreviewText(nsMsgKey *aKeysToFetch, PRUint32 aNumKeys, PRBool aLocalOnly, nsIUrlListener *aUrlListener, PRBool *_retval NS_OUTPARAM) = 0;

  /* void addKeywordsToMessages (in nsIArray aMessages, in ACString aKeywords); */
  NS_SCRIPTABLE NS_IMETHOD AddKeywordsToMessages(nsIArray *aMessages, const nsACString & aKeywords) = 0;

  /* void removeKeywordsFromMessages (in nsIArray aMessages, in ACString aKeywords); */
  NS_SCRIPTABLE NS_IMETHOD RemoveKeywordsFromMessages(nsIArray *aMessages, const nsACString & aKeywords) = 0;

  /**
   * Extract the message text from aStream.
   *
   * @param aStream stream to read from
   * @param aCharset character set to use to interpret the body. If an empty string, then the
   *        charset is retrieved from the headers. msgHdr.charset is recommended in case you have it.
   * @param aBytesToRead number of bytes to read from the stream. The function will read till the end
   *        of the line, and there will also be some read ahead due to NS_ReadLine
   * @param aMaxOutputLen desired length of the converted message text. Used to control how many characters
   *        of msg text we want to store.
   * @param aCompressQuotes Replace quotes and citations with " ... " in the preview text
   * @param aStripHTMLTags strip HTML tags from the output, if present
   * @param[out] aContentType the content type of the MIME part that was used to generate the text --
   *             for an HTML part, this will be "text/html" even though aStripHTMLTags might be true
   */
  /* AUTF8String getMsgTextFromStream (in nsIInputStream aStream, in ACString aCharset, in unsigned long aBytesToRead, in unsigned long aMaxOutputLen, in boolean aCompressQuotes, in boolean aStripHTMLTags, out ACString aContentType); */
  NS_SCRIPTABLE NS_IMETHOD GetMsgTextFromStream(nsIInputStream *aStream, const nsACString & aCharset, PRUint32 aBytesToRead, PRUint32 aMaxOutputLen, PRBool aCompressQuotes, PRBool aStripHTMLTags, nsACString & aContentType NS_OUTPARAM, nsACString & _retval NS_OUTPARAM) = 0;

  /* AString convertMsgSnippetToPlainText (in AString aMessageText); */
  NS_SCRIPTABLE NS_IMETHOD ConvertMsgSnippetToPlainText(const nsAString & aMessageText, nsAString & _retval NS_OUTPARAM) = 0;

  /* readonly attribute nsIMsgIdentity customIdentity; */
  NS_SCRIPTABLE NS_IMETHOD GetCustomIdentity(nsIMsgIdentity **aCustomIdentity) = 0;

  /**
   * @{
   * Processing flags, used to manage message processing.
   *
   * @param msgKey   message key
   * @return         processing flags
   */
  /* unsigned long getProcessingFlags (in nsMsgKey msgKey); */
  NS_SCRIPTABLE NS_IMETHOD GetProcessingFlags(nsMsgKey msgKey, PRUint32 *_retval NS_OUTPARAM) = 0;

  /**
   * @param msgKey   message key
   * @param mask     mask to OR into the flags
   */
  /* void orProcessingFlags (in nsMsgKey msgKey, in unsigned long mask); */
  NS_SCRIPTABLE NS_IMETHOD OrProcessingFlags(nsMsgKey msgKey, PRUint32 mask) = 0;

  /**
   * @param msgKey   message key
   * @param mask     mask to AND into the flags
   */
  /* void andProcessingFlags (in nsMsgKey msgKey, in unsigned long mask); */
  NS_SCRIPTABLE NS_IMETHOD AndProcessingFlags(nsMsgKey msgKey, PRUint32 mask) = 0;

  /** @} */
/**
   * Gets an inherited string property from the folder.
   *
   * If the forcePropertyEmpty boolean is set (see below), return an
   * empty string.
   *
   * If the specified folder has a non-empty value for the property,
   * return that value. Otherwise, return getInheritedStringProperty
   * for the folder's parent.
   *
   * If a folder is the root folder for a server, then instead of
   * checking the folder property, check the property of the same name
   * for the server using nsIMsgIncomingServer.getCharValue(...)
   *
   * Note nsIMsgIncomingServer.getCharValue for a server inherits from
   * the preference mail.server.default.(propertyName) as a global value
   * 
   * (ex: if propertyName = "IAmAGlobal" and no folder nor server properties
   * are set, then the inherited property will return the preference value
   * mail.server.default.IAmAGlobal)
   *
   * If the propertyName is undefined, returns an empty, void string.
   *
   * @param propertyName  The name of the property for the value to retrieve.
   */
  /* ACString getInheritedStringProperty (in string propertyName); */
  NS_SCRIPTABLE NS_IMETHOD GetInheritedStringProperty(const char *propertyName, nsACString & _retval NS_OUTPARAM) = 0;

  /**
   * Set a boolean to force an inherited propertyName to return empty instead
   * of inheriting from a parent folder, server, or the global
   *
   * @param propertyName         The name of the property
   * @param aForcePropertyEmpty  true if an empty inherited property should be returned
   */
  /* void setForcePropertyEmpty (in string propertyName, in boolean aForcePropertyEmpty); */
  NS_SCRIPTABLE NS_IMETHOD SetForcePropertyEmpty(const char *propertyName, PRBool aForcePropertyEmpty) = 0;

  /**
   * Get a boolean to force an inherited propertyName to return empty instead
   * of inheriting from a parent folder, server, or the global
   *
   * @param propertyName      The name of the property
   *
   * @return                  true if an empty inherited property should be returned
   */
  /* boolean getForcePropertyEmpty (in string propertyName); */
  NS_SCRIPTABLE NS_IMETHOD GetForcePropertyEmpty(const char *propertyName, PRBool *_retval NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgFolder, NS_IMSGFOLDER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGFOLDER \
  NS_SCRIPTABLE NS_IMETHOD GetMessages(nsISimpleEnumerator **aMessages); \
  NS_SCRIPTABLE NS_IMETHOD StartFolderLoading(void); \
  NS_SCRIPTABLE NS_IMETHOD EndFolderLoading(void); \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolder(nsIMsgWindow *aWindow); \
  NS_SCRIPTABLE NS_IMETHOD GetPrettiestName(nsAString & aPrettiestName); \
  NS_SCRIPTABLE NS_IMETHOD GetFolderURL(nsACString & aFolderURL); \
  NS_SCRIPTABLE NS_IMETHOD GetShowDeletedMessages(PRBool *aShowDeletedMessages); \
  NS_SCRIPTABLE NS_IMETHOD GetServer(nsIMsgIncomingServer **aServer); \
  NS_SCRIPTABLE NS_IMETHOD GetIsServer(PRBool *aIsServer); \
  NS_SCRIPTABLE NS_IMETHOD GetCanSubscribe(PRBool *aCanSubscribe); \
  NS_SCRIPTABLE NS_IMETHOD GetCanFileMessages(PRBool *aCanFileMessages); \
  NS_SCRIPTABLE NS_IMETHOD GetNoSelect(PRBool *aNoSelect); \
  NS_SCRIPTABLE NS_IMETHOD GetImapShared(PRBool *aImapShared); \
  NS_SCRIPTABLE NS_IMETHOD GetCanDeleteMessages(PRBool *aCanDeleteMessages); \
  NS_SCRIPTABLE NS_IMETHOD GetCanCreateSubfolders(PRBool *aCanCreateSubfolders); \
  NS_SCRIPTABLE NS_IMETHOD GetCanRename(PRBool *aCanRename); \
  NS_SCRIPTABLE NS_IMETHOD GetCanCompact(PRBool *aCanCompact); \
  NS_SCRIPTABLE NS_IMETHOD GetRootFolder(nsIMsgFolder **aRootFolder); \
  NS_SCRIPTABLE NS_IMETHOD GetFilterList(nsIMsgWindow *msgWindow, nsIMsgFilterList **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetFilterList(nsIMsgFilterList *filterList); \
  NS_SCRIPTABLE NS_IMETHOD GetEditableFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetEditableFilterList(nsIMsgFilterList *aFilterList); \
  NS_SCRIPTABLE NS_IMETHOD ForceDBClosed(void); \
  NS_SCRIPTABLE NS_IMETHOD CloseAndBackupFolderDB(const nsACString & newName); \
  NS_SCRIPTABLE NS_IMETHOD Delete(void); \
  NS_SCRIPTABLE NS_IMETHOD DeleteSubFolders(nsIArray *folders, nsIMsgWindow *msgWindow); \
  NS_SCRIPTABLE NS_IMETHOD PropagateDelete(nsIMsgFolder *folder, PRBool deleteStorage, nsIMsgWindow *msgWindow); \
  NS_SCRIPTABLE NS_IMETHOD RecursiveDelete(PRBool deleteStorage, nsIMsgWindow *msgWindow); \
  NS_SCRIPTABLE NS_IMETHOD CreateSubfolder(const nsAString & folderName, nsIMsgWindow *msgWindow); \
  NS_SCRIPTABLE NS_IMETHOD AddSubfolder(const nsAString & folderName, nsIMsgFolder **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD CreateStorageIfMissing(nsIUrlListener *urlListener); \
  NS_SCRIPTABLE NS_IMETHOD Compact(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow); \
  NS_SCRIPTABLE NS_IMETHOD CompactAll(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, PRBool aCompactOfflineAlso); \
  NS_SCRIPTABLE NS_IMETHOD CompactAllOfflineStores(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, nsIArray *aOfflineFolderArray); \
  NS_SCRIPTABLE NS_IMETHOD EmptyTrash(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener); \
  NS_SCRIPTABLE NS_IMETHOD Rename(const nsAString & name, nsIMsgWindow *msgWindow); \
  NS_SCRIPTABLE NS_IMETHOD RenameSubFolders(nsIMsgWindow *msgWindow, nsIMsgFolder *oldFolder); \
  NS_SCRIPTABLE NS_IMETHOD GenerateUniqueSubfolderName(const nsAString & prefix, nsIMsgFolder *otherFolder, nsAString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD UpdateSummaryTotals(PRBool force); \
  NS_SCRIPTABLE NS_IMETHOD SummaryChanged(void); \
  NS_SCRIPTABLE NS_IMETHOD GetNumUnread(PRBool deep, PRInt32 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetTotalMessages(PRBool deep, PRInt32 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetHasNewMessages(PRBool *aHasNewMessages); \
  NS_SCRIPTABLE NS_IMETHOD SetHasNewMessages(PRBool aHasNewMessages); \
  NS_SCRIPTABLE NS_IMETHOD GetFirstNewMessage(nsIMsgDBHdr **aFirstNewMessage); \
  NS_SCRIPTABLE NS_IMETHOD ClearNewMessages(void); \
  NS_SCRIPTABLE NS_IMETHOD GetExpungedBytes(PRUint32 *aExpungedBytes); \
  NS_SCRIPTABLE NS_IMETHOD GetDeletable(PRBool *aDeletable); \
  NS_SCRIPTABLE NS_IMETHOD GetDisplayRecipients(PRBool *aDisplayRecipients); \
  NS_SCRIPTABLE NS_IMETHOD GetManyHeadersToDownload(PRBool *aManyHeadersToDownload); \
  NS_SCRIPTABLE NS_IMETHOD GetRequiresCleanup(PRBool *aRequiresCleanup); \
  NS_SCRIPTABLE NS_IMETHOD ClearRequiresCleanup(void); \
  NS_SCRIPTABLE NS_IMETHOD GetKnowsSearchNntpExtension(PRBool *aKnowsSearchNntpExtension); \
  NS_SCRIPTABLE NS_IMETHOD GetAllowsPosting(PRBool *aAllowsPosting); \
  NS_SCRIPTABLE NS_IMETHOD GetRelativePathName(nsACString & aRelativePathName); \
  NS_SCRIPTABLE NS_IMETHOD GetSizeOnDisk(PRUint32 *aSizeOnDisk); \
  NS_SCRIPTABLE NS_IMETHOD SetSizeOnDisk(PRUint32 aSizeOnDisk); \
  NS_SCRIPTABLE NS_IMETHOD GetUsername(nsACString & aUsername); \
  NS_SCRIPTABLE NS_IMETHOD GetHostname(nsACString & aHostname); \
  NS_SCRIPTABLE NS_IMETHOD SetFlag(PRUint32 flag); \
  NS_SCRIPTABLE NS_IMETHOD ClearFlag(PRUint32 flag); \
  NS_SCRIPTABLE NS_IMETHOD GetFlag(PRUint32 flag, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ToggleFlag(PRUint32 flag); \
  NS_SCRIPTABLE NS_IMETHOD OnFlagChange(PRUint32 flag); \
  NS_SCRIPTABLE NS_IMETHOD GetFlags(PRUint32 *aFlags); \
  NS_SCRIPTABLE NS_IMETHOD SetFlags(PRUint32 aFlags); \
  NS_SCRIPTABLE NS_IMETHOD GetFolderWithFlags(PRUint32 flags, nsIMsgFolder **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetFoldersWithFlags(PRUint32 flags, nsIArray **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ListFoldersWithFlags(PRUint32 flags, nsIMutableArray *folders); \
  NS_SCRIPTABLE NS_IMETHOD IsSpecialFolder(PRUint32 flags, PRBool checkAncestors, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetExpansionArray(nsISupportsArray *expansionArray); \
  NS_SCRIPTABLE NS_IMETHOD GetUriForMsg(nsIMsgDBHdr *msgHdr, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD DeleteMessages(nsIArray *messages, nsIMsgWindow *msgWindow, PRBool deleteStorage, PRBool isMove, nsIMsgCopyServiceListener *listener, PRBool allowUndo); \
  NS_SCRIPTABLE NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, nsIArray *messages, PRBool isMove, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener, PRBool isFolder, PRBool allowUndo); \
  NS_SCRIPTABLE NS_IMETHOD CopyFolder(nsIMsgFolder *srcFolder, PRBool isMoveFolder, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener); \
  NS_SCRIPTABLE NS_IMETHOD CopyFileMessage(nsIFile *file, nsIMsgDBHdr *msgToReplace, PRBool isDraft, PRUint32 newMsgFlags, const nsACString & aKeywords, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener); \
  NS_SCRIPTABLE NS_IMETHOD AcquireSemaphore(nsISupports *semHolder); \
  NS_SCRIPTABLE NS_IMETHOD ReleaseSemaphore(nsISupports *semHolder); \
  NS_SCRIPTABLE NS_IMETHOD TestSemaphore(nsISupports *semHolder, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetLocked(PRBool *aLocked); \
  NS_SCRIPTABLE NS_IMETHOD GetNewMessages(nsIMsgWindow *aWindow, nsIUrlListener *aListener); \
  NS_SCRIPTABLE NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache, PRBool deep); \
  NS_SCRIPTABLE NS_IMETHOD GetCharset(nsACString & aCharset); \
  NS_SCRIPTABLE NS_IMETHOD SetCharset(const nsACString & aCharset); \
  NS_SCRIPTABLE NS_IMETHOD GetCharsetOverride(PRBool *aCharsetOverride); \
  NS_SCRIPTABLE NS_IMETHOD SetCharsetOverride(PRBool aCharsetOverride); \
  NS_SCRIPTABLE NS_IMETHOD GetBiffState(PRUint32 *aBiffState); \
  NS_SCRIPTABLE NS_IMETHOD SetBiffState(PRUint32 aBiffState); \
  NS_SCRIPTABLE NS_IMETHOD GetNumNewMessages(PRBool deep, PRInt32 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetNumNewMessages(PRInt32 numNewMessages); \
  NS_SCRIPTABLE NS_IMETHOD GetGettingNewMessages(PRBool *aGettingNewMessages); \
  NS_SCRIPTABLE NS_IMETHOD SetGettingNewMessages(PRBool aGettingNewMessages); \
  NS_SCRIPTABLE NS_IMETHOD GetFilePath(nsILocalFile **aFilePath); \
  NS_SCRIPTABLE NS_IMETHOD SetFilePath(nsILocalFile *aFilePath); \
  NS_SCRIPTABLE NS_IMETHOD GetBaseMessageURI(nsACString & aBaseMessageURI); \
  NS_SCRIPTABLE NS_IMETHOD GenerateMessageURI(nsMsgKey msgKey, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddMessageDispositionState(nsIMsgDBHdr *aMessage, nsMsgDispositionState aDispositionFlag); \
  NS_SCRIPTABLE NS_IMETHOD MarkMessagesRead(nsIArray *messages, PRBool markRead); \
  NS_SCRIPTABLE NS_IMETHOD MarkAllMessagesRead(nsIMsgWindow *aMsgWindow); \
  NS_SCRIPTABLE NS_IMETHOD MarkMessagesFlagged(nsIArray *messages, PRBool markFlagged); \
  NS_SCRIPTABLE NS_IMETHOD MarkThreadRead(nsIMsgThread *thread); \
  NS_SCRIPTABLE NS_IMETHOD SetLabelForMessages(nsIArray *messages, nsMsgLabelValue label); \
  NS_SCRIPTABLE NS_IMETHOD GetMsgDatabase(nsIMsgDatabase **aMsgDatabase); \
  NS_SCRIPTABLE NS_IMETHOD SetMsgDatabase(nsIMsgDatabase *aMsgDatabase); \
  NS_SCRIPTABLE NS_IMETHOD GetBackupMsgDatabase(nsIMsgDatabase **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD RemoveBackupMsgDatabase(void); \
  NS_SCRIPTABLE NS_IMETHOD OpenBackupMsgDatabase(void); \
  NS_SCRIPTABLE NS_IMETHOD GetDBFolderInfoAndDB(nsIDBFolderInfo **folderInfo NS_OUTPARAM, nsIMsgDatabase **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetMessageHeader(nsMsgKey msgKey, nsIMsgDBHdr **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetSupportsOffline(PRBool *aSupportsOffline); \
  NS_SCRIPTABLE NS_IMETHOD ShouldStoreMsgOffline(nsMsgKey msgKey, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD HasMsgOffline(nsMsgKey msgKey, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetOfflineFileStream(nsMsgKey aMsgKey, PRUint64 *aOffset NS_OUTPARAM, PRUint32 *aSize NS_OUTPARAM, nsIInputStream **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetOfflineStoreOutputStream(nsIOutputStream **aOfflineStoreOutputStream); \
  NS_SCRIPTABLE NS_IMETHOD GetOfflineStoreInputStream(nsIInputStream **aOfflineStoreInputStream); \
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(nsIArray *messages, nsIMsgWindow *window); \
  NS_SCRIPTABLE NS_IMETHOD GetChildWithURI(const nsACString & uri, PRBool deep, PRBool caseInsensitive, nsIMsgFolder **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD DownloadAllForOffline(nsIUrlListener *listener, nsIMsgWindow *window); \
  NS_SCRIPTABLE NS_IMETHOD EnableNotifications(PRInt32 notificationType, PRBool enable, PRBool dbBatching); \
  NS_SCRIPTABLE NS_IMETHOD IsCommandEnabled(const nsACString & command, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD MatchOrChangeFilterDestination(nsIMsgFolder *folder, PRBool caseInsensitive, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ConfirmFolderDeletionForFilter(nsIMsgWindow *msgWindow, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AlertFilterChanged(nsIMsgWindow *msgWindow); \
  NS_SCRIPTABLE NS_IMETHOD ThrowAlertMsg(const char *msgName, nsIMsgWindow *msgWindow); \
  NS_SCRIPTABLE NS_IMETHOD GetStringWithFolderNameFromBundle(const char *msgName, nsAString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD NotifyCompactCompleted(void); \
  NS_SCRIPTABLE NS_IMETHOD CompareSortKeys(nsIMsgFolder *msgFolder, PRInt32 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetSortKey(PRUint32 *length NS_OUTPARAM, PRUint8 **key NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings **aRetentionSettings); \
  NS_SCRIPTABLE NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings *aRetentionSettings); \
  NS_SCRIPTABLE NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings **aDownloadSettings); \
  NS_SCRIPTABLE NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings *aDownloadSettings); \
  NS_SCRIPTABLE NS_IMETHOD CallFilterPlugins(nsIMsgWindow *aMsgWindow, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetSortOrder(PRInt32 *aSortOrder); \
  NS_SCRIPTABLE NS_IMETHOD SetSortOrder(PRInt32 aSortOrder); \
  NS_SCRIPTABLE NS_IMETHOD GetDBTransferInfo(nsIDBFolderInfo **aDBTransferInfo); \
  NS_SCRIPTABLE NS_IMETHOD SetDBTransferInfo(nsIDBFolderInfo *aDBTransferInfo); \
  NS_SCRIPTABLE NS_IMETHOD GetStringProperty(const char *propertyName, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetStringProperty(const char *propertyName, const nsACString & propertyValue); \
  NS_SCRIPTABLE NS_IMETHOD GetLastMessageLoaded(nsMsgKey *aLastMessageLoaded); \
  NS_SCRIPTABLE NS_IMETHOD SetLastMessageLoaded(nsMsgKey aLastMessageLoaded); \
  NS_SCRIPTABLE NS_IMETHOD GetURI(nsACString & aURI); \
  NS_SCRIPTABLE NS_IMETHOD GetName(nsAString & aName); \
  NS_SCRIPTABLE NS_IMETHOD SetName(const nsAString & aName); \
  NS_SCRIPTABLE NS_IMETHOD GetPrettyName(nsAString & aPrettyName); \
  NS_SCRIPTABLE NS_IMETHOD SetPrettyName(const nsAString & aPrettyName); \
  NS_SCRIPTABLE NS_IMETHOD GetAbbreviatedName(nsAString & aAbbreviatedName); \
  NS_SCRIPTABLE NS_IMETHOD GetParent(nsIMsgFolder **aParent); \
  NS_SCRIPTABLE NS_IMETHOD SetParent(nsIMsgFolder *aParent); \
  NS_SCRIPTABLE NS_IMETHOD GetSubFolders(nsISimpleEnumerator **aSubFolders); \
  NS_SCRIPTABLE NS_IMETHOD GetHasSubFolders(PRBool *aHasSubFolders); \
  NS_SCRIPTABLE NS_IMETHOD GetNumSubFolders(PRUint32 *aNumSubFolders); \
  NS_SCRIPTABLE NS_IMETHOD IsAncestorOf(nsIMsgFolder *folder, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ContainsChildNamed(const nsAString & name, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetChildNamed(const nsAString & aName, nsIMsgFolder **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD FindSubFolder(const nsACString & escapedSubFolderName, nsIMsgFolder **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddFolderListener(nsIFolderListener *listener); \
  NS_SCRIPTABLE NS_IMETHOD RemoveFolderListener(nsIFolderListener *listener); \
  NS_SCRIPTABLE NS_IMETHOD NotifyPropertyChanged(nsIAtom *property, const nsACString & oldValue, const nsACString & newValue); \
  NS_SCRIPTABLE NS_IMETHOD NotifyIntPropertyChanged(nsIAtom *property, PRInt32 oldValue, PRInt32 newValue); \
  NS_SCRIPTABLE NS_IMETHOD NotifyBoolPropertyChanged(nsIAtom *property, PRBool oldValue, PRBool newValue); \
  NS_SCRIPTABLE NS_IMETHOD NotifyPropertyFlagChanged(nsIMsgDBHdr *item, nsIAtom *property, PRUint32 oldValue, PRUint32 newValue); \
  NS_SCRIPTABLE NS_IMETHOD NotifyUnicharPropertyChanged(nsIAtom *property, const nsAString & oldValue, const nsAString & newValue); \
  NS_SCRIPTABLE NS_IMETHOD NotifyItemAdded(nsISupports *item); \
  NS_SCRIPTABLE NS_IMETHOD NotifyItemRemoved(nsISupports *item); \
  NS_SCRIPTABLE NS_IMETHOD NotifyFolderEvent(nsIAtom *event); \
  NS_SCRIPTABLE NS_IMETHOD ListDescendents(nsISupportsArray *descendents); \
  NS_SCRIPTABLE NS_IMETHOD Shutdown(PRBool shutdownChildren); \
  NS_SCRIPTABLE NS_IMETHOD GetInVFEditSearchScope(PRBool *aInVFEditSearchScope); \
  NS_SCRIPTABLE NS_IMETHOD SetInVFEditSearchScope(PRBool aSearchThisFolder, PRBool aSetOnSubFolders); \
  NS_SCRIPTABLE NS_IMETHOD CopyDataToOutputStreamForAppend(nsIInputStream *aIStream, PRInt32 aLength, nsIOutputStream *outputStream); \
  NS_SCRIPTABLE NS_IMETHOD CopyDataDone(void); \
  NS_SCRIPTABLE NS_IMETHOD SetJunkScoreForMessages(nsIArray *aMessages, const nsACString & aJunkScore); \
  NS_SCRIPTABLE NS_IMETHOD ApplyRetentionSettings(void); \
  NS_SCRIPTABLE NS_IMETHOD FetchMsgPreviewText(nsMsgKey *aKeysToFetch, PRUint32 aNumKeys, PRBool aLocalOnly, nsIUrlListener *aUrlListener, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddKeywordsToMessages(nsIArray *aMessages, const nsACString & aKeywords); \
  NS_SCRIPTABLE NS_IMETHOD RemoveKeywordsFromMessages(nsIArray *aMessages, const nsACString & aKeywords); \
  NS_SCRIPTABLE NS_IMETHOD GetMsgTextFromStream(nsIInputStream *aStream, const nsACString & aCharset, PRUint32 aBytesToRead, PRUint32 aMaxOutputLen, PRBool aCompressQuotes, PRBool aStripHTMLTags, nsACString & aContentType NS_OUTPARAM, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ConvertMsgSnippetToPlainText(const nsAString & aMessageText, nsAString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetCustomIdentity(nsIMsgIdentity **aCustomIdentity); \
  NS_SCRIPTABLE NS_IMETHOD GetProcessingFlags(nsMsgKey msgKey, PRUint32 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD OrProcessingFlags(nsMsgKey msgKey, PRUint32 mask); \
  NS_SCRIPTABLE NS_IMETHOD AndProcessingFlags(nsMsgKey msgKey, PRUint32 mask); \
  NS_SCRIPTABLE NS_IMETHOD GetInheritedStringProperty(const char *propertyName, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetForcePropertyEmpty(const char *propertyName, PRBool aForcePropertyEmpty); \
  NS_SCRIPTABLE NS_IMETHOD GetForcePropertyEmpty(const char *propertyName, PRBool *_retval NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGFOLDER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetMessages(nsISimpleEnumerator **aMessages) { return _to GetMessages(aMessages); } \
  NS_SCRIPTABLE NS_IMETHOD StartFolderLoading(void) { return _to StartFolderLoading(); } \
  NS_SCRIPTABLE NS_IMETHOD EndFolderLoading(void) { return _to EndFolderLoading(); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolder(nsIMsgWindow *aWindow) { return _to UpdateFolder(aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD GetPrettiestName(nsAString & aPrettiestName) { return _to GetPrettiestName(aPrettiestName); } \
  NS_SCRIPTABLE NS_IMETHOD GetFolderURL(nsACString & aFolderURL) { return _to GetFolderURL(aFolderURL); } \
  NS_SCRIPTABLE NS_IMETHOD GetShowDeletedMessages(PRBool *aShowDeletedMessages) { return _to GetShowDeletedMessages(aShowDeletedMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetServer(nsIMsgIncomingServer **aServer) { return _to GetServer(aServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsServer(PRBool *aIsServer) { return _to GetIsServer(aIsServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanSubscribe(PRBool *aCanSubscribe) { return _to GetCanSubscribe(aCanSubscribe); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanFileMessages(PRBool *aCanFileMessages) { return _to GetCanFileMessages(aCanFileMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetNoSelect(PRBool *aNoSelect) { return _to GetNoSelect(aNoSelect); } \
  NS_SCRIPTABLE NS_IMETHOD GetImapShared(PRBool *aImapShared) { return _to GetImapShared(aImapShared); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanDeleteMessages(PRBool *aCanDeleteMessages) { return _to GetCanDeleteMessages(aCanDeleteMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanCreateSubfolders(PRBool *aCanCreateSubfolders) { return _to GetCanCreateSubfolders(aCanCreateSubfolders); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanRename(PRBool *aCanRename) { return _to GetCanRename(aCanRename); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanCompact(PRBool *aCanCompact) { return _to GetCanCompact(aCanCompact); } \
  NS_SCRIPTABLE NS_IMETHOD GetRootFolder(nsIMsgFolder **aRootFolder) { return _to GetRootFolder(aRootFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetFilterList(nsIMsgWindow *msgWindow, nsIMsgFilterList **_retval NS_OUTPARAM) { return _to GetFilterList(msgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetFilterList(nsIMsgFilterList *filterList) { return _to SetFilterList(filterList); } \
  NS_SCRIPTABLE NS_IMETHOD GetEditableFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval NS_OUTPARAM) { return _to GetEditableFilterList(aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetEditableFilterList(nsIMsgFilterList *aFilterList) { return _to SetEditableFilterList(aFilterList); } \
  NS_SCRIPTABLE NS_IMETHOD ForceDBClosed(void) { return _to ForceDBClosed(); } \
  NS_SCRIPTABLE NS_IMETHOD CloseAndBackupFolderDB(const nsACString & newName) { return _to CloseAndBackupFolderDB(newName); } \
  NS_SCRIPTABLE NS_IMETHOD Delete(void) { return _to Delete(); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteSubFolders(nsIArray *folders, nsIMsgWindow *msgWindow) { return _to DeleteSubFolders(folders, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD PropagateDelete(nsIMsgFolder *folder, PRBool deleteStorage, nsIMsgWindow *msgWindow) { return _to PropagateDelete(folder, deleteStorage, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD RecursiveDelete(PRBool deleteStorage, nsIMsgWindow *msgWindow) { return _to RecursiveDelete(deleteStorage, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD CreateSubfolder(const nsAString & folderName, nsIMsgWindow *msgWindow) { return _to CreateSubfolder(folderName, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD AddSubfolder(const nsAString & folderName, nsIMsgFolder **_retval NS_OUTPARAM) { return _to AddSubfolder(folderName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateStorageIfMissing(nsIUrlListener *urlListener) { return _to CreateStorageIfMissing(urlListener); } \
  NS_SCRIPTABLE NS_IMETHOD Compact(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) { return _to Compact(aListener, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD CompactAll(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, PRBool aCompactOfflineAlso) { return _to CompactAll(aListener, aMsgWindow, aCompactOfflineAlso); } \
  NS_SCRIPTABLE NS_IMETHOD CompactAllOfflineStores(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, nsIArray *aOfflineFolderArray) { return _to CompactAllOfflineStores(aListener, aMsgWindow, aOfflineFolderArray); } \
  NS_SCRIPTABLE NS_IMETHOD EmptyTrash(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) { return _to EmptyTrash(aMsgWindow, aListener); } \
  NS_SCRIPTABLE NS_IMETHOD Rename(const nsAString & name, nsIMsgWindow *msgWindow) { return _to Rename(name, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD RenameSubFolders(nsIMsgWindow *msgWindow, nsIMsgFolder *oldFolder) { return _to RenameSubFolders(msgWindow, oldFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GenerateUniqueSubfolderName(const nsAString & prefix, nsIMsgFolder *otherFolder, nsAString & _retval NS_OUTPARAM) { return _to GenerateUniqueSubfolderName(prefix, otherFolder, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateSummaryTotals(PRBool force) { return _to UpdateSummaryTotals(force); } \
  NS_SCRIPTABLE NS_IMETHOD SummaryChanged(void) { return _to SummaryChanged(); } \
  NS_SCRIPTABLE NS_IMETHOD GetNumUnread(PRBool deep, PRInt32 *_retval NS_OUTPARAM) { return _to GetNumUnread(deep, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetTotalMessages(PRBool deep, PRInt32 *_retval NS_OUTPARAM) { return _to GetTotalMessages(deep, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetHasNewMessages(PRBool *aHasNewMessages) { return _to GetHasNewMessages(aHasNewMessages); } \
  NS_SCRIPTABLE NS_IMETHOD SetHasNewMessages(PRBool aHasNewMessages) { return _to SetHasNewMessages(aHasNewMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetFirstNewMessage(nsIMsgDBHdr **aFirstNewMessage) { return _to GetFirstNewMessage(aFirstNewMessage); } \
  NS_SCRIPTABLE NS_IMETHOD ClearNewMessages(void) { return _to ClearNewMessages(); } \
  NS_SCRIPTABLE NS_IMETHOD GetExpungedBytes(PRUint32 *aExpungedBytes) { return _to GetExpungedBytes(aExpungedBytes); } \
  NS_SCRIPTABLE NS_IMETHOD GetDeletable(PRBool *aDeletable) { return _to GetDeletable(aDeletable); } \
  NS_SCRIPTABLE NS_IMETHOD GetDisplayRecipients(PRBool *aDisplayRecipients) { return _to GetDisplayRecipients(aDisplayRecipients); } \
  NS_SCRIPTABLE NS_IMETHOD GetManyHeadersToDownload(PRBool *aManyHeadersToDownload) { return _to GetManyHeadersToDownload(aManyHeadersToDownload); } \
  NS_SCRIPTABLE NS_IMETHOD GetRequiresCleanup(PRBool *aRequiresCleanup) { return _to GetRequiresCleanup(aRequiresCleanup); } \
  NS_SCRIPTABLE NS_IMETHOD ClearRequiresCleanup(void) { return _to ClearRequiresCleanup(); } \
  NS_SCRIPTABLE NS_IMETHOD GetKnowsSearchNntpExtension(PRBool *aKnowsSearchNntpExtension) { return _to GetKnowsSearchNntpExtension(aKnowsSearchNntpExtension); } \
  NS_SCRIPTABLE NS_IMETHOD GetAllowsPosting(PRBool *aAllowsPosting) { return _to GetAllowsPosting(aAllowsPosting); } \
  NS_SCRIPTABLE NS_IMETHOD GetRelativePathName(nsACString & aRelativePathName) { return _to GetRelativePathName(aRelativePathName); } \
  NS_SCRIPTABLE NS_IMETHOD GetSizeOnDisk(PRUint32 *aSizeOnDisk) { return _to GetSizeOnDisk(aSizeOnDisk); } \
  NS_SCRIPTABLE NS_IMETHOD SetSizeOnDisk(PRUint32 aSizeOnDisk) { return _to SetSizeOnDisk(aSizeOnDisk); } \
  NS_SCRIPTABLE NS_IMETHOD GetUsername(nsACString & aUsername) { return _to GetUsername(aUsername); } \
  NS_SCRIPTABLE NS_IMETHOD GetHostname(nsACString & aHostname) { return _to GetHostname(aHostname); } \
  NS_SCRIPTABLE NS_IMETHOD SetFlag(PRUint32 flag) { return _to SetFlag(flag); } \
  NS_SCRIPTABLE NS_IMETHOD ClearFlag(PRUint32 flag) { return _to ClearFlag(flag); } \
  NS_SCRIPTABLE NS_IMETHOD GetFlag(PRUint32 flag, PRBool *_retval NS_OUTPARAM) { return _to GetFlag(flag, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ToggleFlag(PRUint32 flag) { return _to ToggleFlag(flag); } \
  NS_SCRIPTABLE NS_IMETHOD OnFlagChange(PRUint32 flag) { return _to OnFlagChange(flag); } \
  NS_SCRIPTABLE NS_IMETHOD GetFlags(PRUint32 *aFlags) { return _to GetFlags(aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD SetFlags(PRUint32 aFlags) { return _to SetFlags(aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD GetFolderWithFlags(PRUint32 flags, nsIMsgFolder **_retval NS_OUTPARAM) { return _to GetFolderWithFlags(flags, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetFoldersWithFlags(PRUint32 flags, nsIArray **_retval NS_OUTPARAM) { return _to GetFoldersWithFlags(flags, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ListFoldersWithFlags(PRUint32 flags, nsIMutableArray *folders) { return _to ListFoldersWithFlags(flags, folders); } \
  NS_SCRIPTABLE NS_IMETHOD IsSpecialFolder(PRUint32 flags, PRBool checkAncestors, PRBool *_retval NS_OUTPARAM) { return _to IsSpecialFolder(flags, checkAncestors, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetExpansionArray(nsISupportsArray *expansionArray) { return _to GetExpansionArray(expansionArray); } \
  NS_SCRIPTABLE NS_IMETHOD GetUriForMsg(nsIMsgDBHdr *msgHdr, nsACString & _retval NS_OUTPARAM) { return _to GetUriForMsg(msgHdr, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteMessages(nsIArray *messages, nsIMsgWindow *msgWindow, PRBool deleteStorage, PRBool isMove, nsIMsgCopyServiceListener *listener, PRBool allowUndo) { return _to DeleteMessages(messages, msgWindow, deleteStorage, isMove, listener, allowUndo); } \
  NS_SCRIPTABLE NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, nsIArray *messages, PRBool isMove, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener, PRBool isFolder, PRBool allowUndo) { return _to CopyMessages(srcFolder, messages, isMove, msgWindow, listener, isFolder, allowUndo); } \
  NS_SCRIPTABLE NS_IMETHOD CopyFolder(nsIMsgFolder *srcFolder, PRBool isMoveFolder, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) { return _to CopyFolder(srcFolder, isMoveFolder, msgWindow, listener); } \
  NS_SCRIPTABLE NS_IMETHOD CopyFileMessage(nsIFile *file, nsIMsgDBHdr *msgToReplace, PRBool isDraft, PRUint32 newMsgFlags, const nsACString & aKeywords, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) { return _to CopyFileMessage(file, msgToReplace, isDraft, newMsgFlags, aKeywords, msgWindow, listener); } \
  NS_SCRIPTABLE NS_IMETHOD AcquireSemaphore(nsISupports *semHolder) { return _to AcquireSemaphore(semHolder); } \
  NS_SCRIPTABLE NS_IMETHOD ReleaseSemaphore(nsISupports *semHolder) { return _to ReleaseSemaphore(semHolder); } \
  NS_SCRIPTABLE NS_IMETHOD TestSemaphore(nsISupports *semHolder, PRBool *_retval NS_OUTPARAM) { return _to TestSemaphore(semHolder, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetLocked(PRBool *aLocked) { return _to GetLocked(aLocked); } \
  NS_SCRIPTABLE NS_IMETHOD GetNewMessages(nsIMsgWindow *aWindow, nsIUrlListener *aListener) { return _to GetNewMessages(aWindow, aListener); } \
  NS_SCRIPTABLE NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache, PRBool deep) { return _to WriteToFolderCache(folderCache, deep); } \
  NS_SCRIPTABLE NS_IMETHOD GetCharset(nsACString & aCharset) { return _to GetCharset(aCharset); } \
  NS_SCRIPTABLE NS_IMETHOD SetCharset(const nsACString & aCharset) { return _to SetCharset(aCharset); } \
  NS_SCRIPTABLE NS_IMETHOD GetCharsetOverride(PRBool *aCharsetOverride) { return _to GetCharsetOverride(aCharsetOverride); } \
  NS_SCRIPTABLE NS_IMETHOD SetCharsetOverride(PRBool aCharsetOverride) { return _to SetCharsetOverride(aCharsetOverride); } \
  NS_SCRIPTABLE NS_IMETHOD GetBiffState(PRUint32 *aBiffState) { return _to GetBiffState(aBiffState); } \
  NS_SCRIPTABLE NS_IMETHOD SetBiffState(PRUint32 aBiffState) { return _to SetBiffState(aBiffState); } \
  NS_SCRIPTABLE NS_IMETHOD GetNumNewMessages(PRBool deep, PRInt32 *_retval NS_OUTPARAM) { return _to GetNumNewMessages(deep, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetNumNewMessages(PRInt32 numNewMessages) { return _to SetNumNewMessages(numNewMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetGettingNewMessages(PRBool *aGettingNewMessages) { return _to GetGettingNewMessages(aGettingNewMessages); } \
  NS_SCRIPTABLE NS_IMETHOD SetGettingNewMessages(PRBool aGettingNewMessages) { return _to SetGettingNewMessages(aGettingNewMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetFilePath(nsILocalFile **aFilePath) { return _to GetFilePath(aFilePath); } \
  NS_SCRIPTABLE NS_IMETHOD SetFilePath(nsILocalFile *aFilePath) { return _to SetFilePath(aFilePath); } \
  NS_SCRIPTABLE NS_IMETHOD GetBaseMessageURI(nsACString & aBaseMessageURI) { return _to GetBaseMessageURI(aBaseMessageURI); } \
  NS_SCRIPTABLE NS_IMETHOD GenerateMessageURI(nsMsgKey msgKey, nsACString & _retval NS_OUTPARAM) { return _to GenerateMessageURI(msgKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddMessageDispositionState(nsIMsgDBHdr *aMessage, nsMsgDispositionState aDispositionFlag) { return _to AddMessageDispositionState(aMessage, aDispositionFlag); } \
  NS_SCRIPTABLE NS_IMETHOD MarkMessagesRead(nsIArray *messages, PRBool markRead) { return _to MarkMessagesRead(messages, markRead); } \
  NS_SCRIPTABLE NS_IMETHOD MarkAllMessagesRead(nsIMsgWindow *aMsgWindow) { return _to MarkAllMessagesRead(aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD MarkMessagesFlagged(nsIArray *messages, PRBool markFlagged) { return _to MarkMessagesFlagged(messages, markFlagged); } \
  NS_SCRIPTABLE NS_IMETHOD MarkThreadRead(nsIMsgThread *thread) { return _to MarkThreadRead(thread); } \
  NS_SCRIPTABLE NS_IMETHOD SetLabelForMessages(nsIArray *messages, nsMsgLabelValue label) { return _to SetLabelForMessages(messages, label); } \
  NS_SCRIPTABLE NS_IMETHOD GetMsgDatabase(nsIMsgDatabase **aMsgDatabase) { return _to GetMsgDatabase(aMsgDatabase); } \
  NS_SCRIPTABLE NS_IMETHOD SetMsgDatabase(nsIMsgDatabase *aMsgDatabase) { return _to SetMsgDatabase(aMsgDatabase); } \
  NS_SCRIPTABLE NS_IMETHOD GetBackupMsgDatabase(nsIMsgDatabase **_retval NS_OUTPARAM) { return _to GetBackupMsgDatabase(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveBackupMsgDatabase(void) { return _to RemoveBackupMsgDatabase(); } \
  NS_SCRIPTABLE NS_IMETHOD OpenBackupMsgDatabase(void) { return _to OpenBackupMsgDatabase(); } \
  NS_SCRIPTABLE NS_IMETHOD GetDBFolderInfoAndDB(nsIDBFolderInfo **folderInfo NS_OUTPARAM, nsIMsgDatabase **_retval NS_OUTPARAM) { return _to GetDBFolderInfoAndDB(folderInfo, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetMessageHeader(nsMsgKey msgKey, nsIMsgDBHdr **_retval NS_OUTPARAM) { return _to GetMessageHeader(msgKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSupportsOffline(PRBool *aSupportsOffline) { return _to GetSupportsOffline(aSupportsOffline); } \
  NS_SCRIPTABLE NS_IMETHOD ShouldStoreMsgOffline(nsMsgKey msgKey, PRBool *_retval NS_OUTPARAM) { return _to ShouldStoreMsgOffline(msgKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD HasMsgOffline(nsMsgKey msgKey, PRBool *_retval NS_OUTPARAM) { return _to HasMsgOffline(msgKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetOfflineFileStream(nsMsgKey aMsgKey, PRUint64 *aOffset NS_OUTPARAM, PRUint32 *aSize NS_OUTPARAM, nsIInputStream **_retval NS_OUTPARAM) { return _to GetOfflineFileStream(aMsgKey, aOffset, aSize, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetOfflineStoreOutputStream(nsIOutputStream **aOfflineStoreOutputStream) { return _to GetOfflineStoreOutputStream(aOfflineStoreOutputStream); } \
  NS_SCRIPTABLE NS_IMETHOD GetOfflineStoreInputStream(nsIInputStream **aOfflineStoreInputStream) { return _to GetOfflineStoreInputStream(aOfflineStoreInputStream); } \
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(nsIArray *messages, nsIMsgWindow *window) { return _to DownloadMessagesForOffline(messages, window); } \
  NS_SCRIPTABLE NS_IMETHOD GetChildWithURI(const nsACString & uri, PRBool deep, PRBool caseInsensitive, nsIMsgFolder **_retval NS_OUTPARAM) { return _to GetChildWithURI(uri, deep, caseInsensitive, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DownloadAllForOffline(nsIUrlListener *listener, nsIMsgWindow *window) { return _to DownloadAllForOffline(listener, window); } \
  NS_SCRIPTABLE NS_IMETHOD EnableNotifications(PRInt32 notificationType, PRBool enable, PRBool dbBatching) { return _to EnableNotifications(notificationType, enable, dbBatching); } \
  NS_SCRIPTABLE NS_IMETHOD IsCommandEnabled(const nsACString & command, PRBool *_retval NS_OUTPARAM) { return _to IsCommandEnabled(command, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD MatchOrChangeFilterDestination(nsIMsgFolder *folder, PRBool caseInsensitive, PRBool *_retval NS_OUTPARAM) { return _to MatchOrChangeFilterDestination(folder, caseInsensitive, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ConfirmFolderDeletionForFilter(nsIMsgWindow *msgWindow, PRBool *_retval NS_OUTPARAM) { return _to ConfirmFolderDeletionForFilter(msgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AlertFilterChanged(nsIMsgWindow *msgWindow) { return _to AlertFilterChanged(msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD ThrowAlertMsg(const char *msgName, nsIMsgWindow *msgWindow) { return _to ThrowAlertMsg(msgName, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD GetStringWithFolderNameFromBundle(const char *msgName, nsAString & _retval NS_OUTPARAM) { return _to GetStringWithFolderNameFromBundle(msgName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyCompactCompleted(void) { return _to NotifyCompactCompleted(); } \
  NS_SCRIPTABLE NS_IMETHOD CompareSortKeys(nsIMsgFolder *msgFolder, PRInt32 *_retval NS_OUTPARAM) { return _to CompareSortKeys(msgFolder, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSortKey(PRUint32 *length NS_OUTPARAM, PRUint8 **key NS_OUTPARAM) { return _to GetSortKey(length, key); } \
  NS_SCRIPTABLE NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings **aRetentionSettings) { return _to GetRetentionSettings(aRetentionSettings); } \
  NS_SCRIPTABLE NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings *aRetentionSettings) { return _to SetRetentionSettings(aRetentionSettings); } \
  NS_SCRIPTABLE NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings **aDownloadSettings) { return _to GetDownloadSettings(aDownloadSettings); } \
  NS_SCRIPTABLE NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings *aDownloadSettings) { return _to SetDownloadSettings(aDownloadSettings); } \
  NS_SCRIPTABLE NS_IMETHOD CallFilterPlugins(nsIMsgWindow *aMsgWindow, PRBool *_retval NS_OUTPARAM) { return _to CallFilterPlugins(aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSortOrder(PRInt32 *aSortOrder) { return _to GetSortOrder(aSortOrder); } \
  NS_SCRIPTABLE NS_IMETHOD SetSortOrder(PRInt32 aSortOrder) { return _to SetSortOrder(aSortOrder); } \
  NS_SCRIPTABLE NS_IMETHOD GetDBTransferInfo(nsIDBFolderInfo **aDBTransferInfo) { return _to GetDBTransferInfo(aDBTransferInfo); } \
  NS_SCRIPTABLE NS_IMETHOD SetDBTransferInfo(nsIDBFolderInfo *aDBTransferInfo) { return _to SetDBTransferInfo(aDBTransferInfo); } \
  NS_SCRIPTABLE NS_IMETHOD GetStringProperty(const char *propertyName, nsACString & _retval NS_OUTPARAM) { return _to GetStringProperty(propertyName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetStringProperty(const char *propertyName, const nsACString & propertyValue) { return _to SetStringProperty(propertyName, propertyValue); } \
  NS_SCRIPTABLE NS_IMETHOD GetLastMessageLoaded(nsMsgKey *aLastMessageLoaded) { return _to GetLastMessageLoaded(aLastMessageLoaded); } \
  NS_SCRIPTABLE NS_IMETHOD SetLastMessageLoaded(nsMsgKey aLastMessageLoaded) { return _to SetLastMessageLoaded(aLastMessageLoaded); } \
  NS_SCRIPTABLE NS_IMETHOD GetURI(nsACString & aURI) { return _to GetURI(aURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetName(nsAString & aName) { return _to GetName(aName); } \
  NS_SCRIPTABLE NS_IMETHOD SetName(const nsAString & aName) { return _to SetName(aName); } \
  NS_SCRIPTABLE NS_IMETHOD GetPrettyName(nsAString & aPrettyName) { return _to GetPrettyName(aPrettyName); } \
  NS_SCRIPTABLE NS_IMETHOD SetPrettyName(const nsAString & aPrettyName) { return _to SetPrettyName(aPrettyName); } \
  NS_SCRIPTABLE NS_IMETHOD GetAbbreviatedName(nsAString & aAbbreviatedName) { return _to GetAbbreviatedName(aAbbreviatedName); } \
  NS_SCRIPTABLE NS_IMETHOD GetParent(nsIMsgFolder **aParent) { return _to GetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD SetParent(nsIMsgFolder *aParent) { return _to SetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD GetSubFolders(nsISimpleEnumerator **aSubFolders) { return _to GetSubFolders(aSubFolders); } \
  NS_SCRIPTABLE NS_IMETHOD GetHasSubFolders(PRBool *aHasSubFolders) { return _to GetHasSubFolders(aHasSubFolders); } \
  NS_SCRIPTABLE NS_IMETHOD GetNumSubFolders(PRUint32 *aNumSubFolders) { return _to GetNumSubFolders(aNumSubFolders); } \
  NS_SCRIPTABLE NS_IMETHOD IsAncestorOf(nsIMsgFolder *folder, PRBool *_retval NS_OUTPARAM) { return _to IsAncestorOf(folder, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ContainsChildNamed(const nsAString & name, PRBool *_retval NS_OUTPARAM) { return _to ContainsChildNamed(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetChildNamed(const nsAString & aName, nsIMsgFolder **_retval NS_OUTPARAM) { return _to GetChildNamed(aName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FindSubFolder(const nsACString & escapedSubFolderName, nsIMsgFolder **_retval NS_OUTPARAM) { return _to FindSubFolder(escapedSubFolderName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddFolderListener(nsIFolderListener *listener) { return _to AddFolderListener(listener); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveFolderListener(nsIFolderListener *listener) { return _to RemoveFolderListener(listener); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyPropertyChanged(nsIAtom *property, const nsACString & oldValue, const nsACString & newValue) { return _to NotifyPropertyChanged(property, oldValue, newValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyIntPropertyChanged(nsIAtom *property, PRInt32 oldValue, PRInt32 newValue) { return _to NotifyIntPropertyChanged(property, oldValue, newValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyBoolPropertyChanged(nsIAtom *property, PRBool oldValue, PRBool newValue) { return _to NotifyBoolPropertyChanged(property, oldValue, newValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyPropertyFlagChanged(nsIMsgDBHdr *item, nsIAtom *property, PRUint32 oldValue, PRUint32 newValue) { return _to NotifyPropertyFlagChanged(item, property, oldValue, newValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyUnicharPropertyChanged(nsIAtom *property, const nsAString & oldValue, const nsAString & newValue) { return _to NotifyUnicharPropertyChanged(property, oldValue, newValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyItemAdded(nsISupports *item) { return _to NotifyItemAdded(item); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyItemRemoved(nsISupports *item) { return _to NotifyItemRemoved(item); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyFolderEvent(nsIAtom *event) { return _to NotifyFolderEvent(event); } \
  NS_SCRIPTABLE NS_IMETHOD ListDescendents(nsISupportsArray *descendents) { return _to ListDescendents(descendents); } \
  NS_SCRIPTABLE NS_IMETHOD Shutdown(PRBool shutdownChildren) { return _to Shutdown(shutdownChildren); } \
  NS_SCRIPTABLE NS_IMETHOD GetInVFEditSearchScope(PRBool *aInVFEditSearchScope) { return _to GetInVFEditSearchScope(aInVFEditSearchScope); } \
  NS_SCRIPTABLE NS_IMETHOD SetInVFEditSearchScope(PRBool aSearchThisFolder, PRBool aSetOnSubFolders) { return _to SetInVFEditSearchScope(aSearchThisFolder, aSetOnSubFolders); } \
  NS_SCRIPTABLE NS_IMETHOD CopyDataToOutputStreamForAppend(nsIInputStream *aIStream, PRInt32 aLength, nsIOutputStream *outputStream) { return _to CopyDataToOutputStreamForAppend(aIStream, aLength, outputStream); } \
  NS_SCRIPTABLE NS_IMETHOD CopyDataDone(void) { return _to CopyDataDone(); } \
  NS_SCRIPTABLE NS_IMETHOD SetJunkScoreForMessages(nsIArray *aMessages, const nsACString & aJunkScore) { return _to SetJunkScoreForMessages(aMessages, aJunkScore); } \
  NS_SCRIPTABLE NS_IMETHOD ApplyRetentionSettings(void) { return _to ApplyRetentionSettings(); } \
  NS_SCRIPTABLE NS_IMETHOD FetchMsgPreviewText(nsMsgKey *aKeysToFetch, PRUint32 aNumKeys, PRBool aLocalOnly, nsIUrlListener *aUrlListener, PRBool *_retval NS_OUTPARAM) { return _to FetchMsgPreviewText(aKeysToFetch, aNumKeys, aLocalOnly, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddKeywordsToMessages(nsIArray *aMessages, const nsACString & aKeywords) { return _to AddKeywordsToMessages(aMessages, aKeywords); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveKeywordsFromMessages(nsIArray *aMessages, const nsACString & aKeywords) { return _to RemoveKeywordsFromMessages(aMessages, aKeywords); } \
  NS_SCRIPTABLE NS_IMETHOD GetMsgTextFromStream(nsIInputStream *aStream, const nsACString & aCharset, PRUint32 aBytesToRead, PRUint32 aMaxOutputLen, PRBool aCompressQuotes, PRBool aStripHTMLTags, nsACString & aContentType NS_OUTPARAM, nsACString & _retval NS_OUTPARAM) { return _to GetMsgTextFromStream(aStream, aCharset, aBytesToRead, aMaxOutputLen, aCompressQuotes, aStripHTMLTags, aContentType, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ConvertMsgSnippetToPlainText(const nsAString & aMessageText, nsAString & _retval NS_OUTPARAM) { return _to ConvertMsgSnippetToPlainText(aMessageText, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCustomIdentity(nsIMsgIdentity **aCustomIdentity) { return _to GetCustomIdentity(aCustomIdentity); } \
  NS_SCRIPTABLE NS_IMETHOD GetProcessingFlags(nsMsgKey msgKey, PRUint32 *_retval NS_OUTPARAM) { return _to GetProcessingFlags(msgKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD OrProcessingFlags(nsMsgKey msgKey, PRUint32 mask) { return _to OrProcessingFlags(msgKey, mask); } \
  NS_SCRIPTABLE NS_IMETHOD AndProcessingFlags(nsMsgKey msgKey, PRUint32 mask) { return _to AndProcessingFlags(msgKey, mask); } \
  NS_SCRIPTABLE NS_IMETHOD GetInheritedStringProperty(const char *propertyName, nsACString & _retval NS_OUTPARAM) { return _to GetInheritedStringProperty(propertyName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetForcePropertyEmpty(const char *propertyName, PRBool aForcePropertyEmpty) { return _to SetForcePropertyEmpty(propertyName, aForcePropertyEmpty); } \
  NS_SCRIPTABLE NS_IMETHOD GetForcePropertyEmpty(const char *propertyName, PRBool *_retval NS_OUTPARAM) { return _to GetForcePropertyEmpty(propertyName, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGFOLDER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetMessages(nsISimpleEnumerator **aMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMessages(aMessages); } \
  NS_SCRIPTABLE NS_IMETHOD StartFolderLoading(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->StartFolderLoading(); } \
  NS_SCRIPTABLE NS_IMETHOD EndFolderLoading(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->EndFolderLoading(); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolder(nsIMsgWindow *aWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->UpdateFolder(aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD GetPrettiestName(nsAString & aPrettiestName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPrettiestName(aPrettiestName); } \
  NS_SCRIPTABLE NS_IMETHOD GetFolderURL(nsACString & aFolderURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFolderURL(aFolderURL); } \
  NS_SCRIPTABLE NS_IMETHOD GetShowDeletedMessages(PRBool *aShowDeletedMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetShowDeletedMessages(aShowDeletedMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetServer(nsIMsgIncomingServer **aServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServer(aServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsServer(PRBool *aIsServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsServer(aIsServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanSubscribe(PRBool *aCanSubscribe) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanSubscribe(aCanSubscribe); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanFileMessages(PRBool *aCanFileMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanFileMessages(aCanFileMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetNoSelect(PRBool *aNoSelect) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNoSelect(aNoSelect); } \
  NS_SCRIPTABLE NS_IMETHOD GetImapShared(PRBool *aImapShared) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetImapShared(aImapShared); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanDeleteMessages(PRBool *aCanDeleteMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanDeleteMessages(aCanDeleteMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanCreateSubfolders(PRBool *aCanCreateSubfolders) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanCreateSubfolders(aCanCreateSubfolders); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanRename(PRBool *aCanRename) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanRename(aCanRename); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanCompact(PRBool *aCanCompact) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanCompact(aCanCompact); } \
  NS_SCRIPTABLE NS_IMETHOD GetRootFolder(nsIMsgFolder **aRootFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRootFolder(aRootFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetFilterList(nsIMsgWindow *msgWindow, nsIMsgFilterList **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFilterList(msgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetFilterList(nsIMsgFilterList *filterList) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFilterList(filterList); } \
  NS_SCRIPTABLE NS_IMETHOD GetEditableFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEditableFilterList(aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetEditableFilterList(nsIMsgFilterList *aFilterList) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEditableFilterList(aFilterList); } \
  NS_SCRIPTABLE NS_IMETHOD ForceDBClosed(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ForceDBClosed(); } \
  NS_SCRIPTABLE NS_IMETHOD CloseAndBackupFolderDB(const nsACString & newName) { return !_to ? NS_ERROR_NULL_POINTER : _to->CloseAndBackupFolderDB(newName); } \
  NS_SCRIPTABLE NS_IMETHOD Delete(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Delete(); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteSubFolders(nsIArray *folders, nsIMsgWindow *msgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteSubFolders(folders, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD PropagateDelete(nsIMsgFolder *folder, PRBool deleteStorage, nsIMsgWindow *msgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->PropagateDelete(folder, deleteStorage, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD RecursiveDelete(PRBool deleteStorage, nsIMsgWindow *msgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->RecursiveDelete(deleteStorage, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD CreateSubfolder(const nsAString & folderName, nsIMsgWindow *msgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateSubfolder(folderName, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD AddSubfolder(const nsAString & folderName, nsIMsgFolder **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddSubfolder(folderName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD CreateStorageIfMissing(nsIUrlListener *urlListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateStorageIfMissing(urlListener); } \
  NS_SCRIPTABLE NS_IMETHOD Compact(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->Compact(aListener, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD CompactAll(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, PRBool aCompactOfflineAlso) { return !_to ? NS_ERROR_NULL_POINTER : _to->CompactAll(aListener, aMsgWindow, aCompactOfflineAlso); } \
  NS_SCRIPTABLE NS_IMETHOD CompactAllOfflineStores(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, nsIArray *aOfflineFolderArray) { return !_to ? NS_ERROR_NULL_POINTER : _to->CompactAllOfflineStores(aListener, aMsgWindow, aOfflineFolderArray); } \
  NS_SCRIPTABLE NS_IMETHOD EmptyTrash(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->EmptyTrash(aMsgWindow, aListener); } \
  NS_SCRIPTABLE NS_IMETHOD Rename(const nsAString & name, nsIMsgWindow *msgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->Rename(name, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD RenameSubFolders(nsIMsgWindow *msgWindow, nsIMsgFolder *oldFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->RenameSubFolders(msgWindow, oldFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GenerateUniqueSubfolderName(const nsAString & prefix, nsIMsgFolder *otherFolder, nsAString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GenerateUniqueSubfolderName(prefix, otherFolder, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateSummaryTotals(PRBool force) { return !_to ? NS_ERROR_NULL_POINTER : _to->UpdateSummaryTotals(force); } \
  NS_SCRIPTABLE NS_IMETHOD SummaryChanged(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->SummaryChanged(); } \
  NS_SCRIPTABLE NS_IMETHOD GetNumUnread(PRBool deep, PRInt32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumUnread(deep, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetTotalMessages(PRBool deep, PRInt32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTotalMessages(deep, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetHasNewMessages(PRBool *aHasNewMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHasNewMessages(aHasNewMessages); } \
  NS_SCRIPTABLE NS_IMETHOD SetHasNewMessages(PRBool aHasNewMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHasNewMessages(aHasNewMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetFirstNewMessage(nsIMsgDBHdr **aFirstNewMessage) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFirstNewMessage(aFirstNewMessage); } \
  NS_SCRIPTABLE NS_IMETHOD ClearNewMessages(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearNewMessages(); } \
  NS_SCRIPTABLE NS_IMETHOD GetExpungedBytes(PRUint32 *aExpungedBytes) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetExpungedBytes(aExpungedBytes); } \
  NS_SCRIPTABLE NS_IMETHOD GetDeletable(PRBool *aDeletable) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDeletable(aDeletable); } \
  NS_SCRIPTABLE NS_IMETHOD GetDisplayRecipients(PRBool *aDisplayRecipients) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDisplayRecipients(aDisplayRecipients); } \
  NS_SCRIPTABLE NS_IMETHOD GetManyHeadersToDownload(PRBool *aManyHeadersToDownload) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetManyHeadersToDownload(aManyHeadersToDownload); } \
  NS_SCRIPTABLE NS_IMETHOD GetRequiresCleanup(PRBool *aRequiresCleanup) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequiresCleanup(aRequiresCleanup); } \
  NS_SCRIPTABLE NS_IMETHOD ClearRequiresCleanup(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearRequiresCleanup(); } \
  NS_SCRIPTABLE NS_IMETHOD GetKnowsSearchNntpExtension(PRBool *aKnowsSearchNntpExtension) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetKnowsSearchNntpExtension(aKnowsSearchNntpExtension); } \
  NS_SCRIPTABLE NS_IMETHOD GetAllowsPosting(PRBool *aAllowsPosting) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowsPosting(aAllowsPosting); } \
  NS_SCRIPTABLE NS_IMETHOD GetRelativePathName(nsACString & aRelativePathName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRelativePathName(aRelativePathName); } \
  NS_SCRIPTABLE NS_IMETHOD GetSizeOnDisk(PRUint32 *aSizeOnDisk) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSizeOnDisk(aSizeOnDisk); } \
  NS_SCRIPTABLE NS_IMETHOD SetSizeOnDisk(PRUint32 aSizeOnDisk) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSizeOnDisk(aSizeOnDisk); } \
  NS_SCRIPTABLE NS_IMETHOD GetUsername(nsACString & aUsername) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUsername(aUsername); } \
  NS_SCRIPTABLE NS_IMETHOD GetHostname(nsACString & aHostname) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHostname(aHostname); } \
  NS_SCRIPTABLE NS_IMETHOD SetFlag(PRUint32 flag) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFlag(flag); } \
  NS_SCRIPTABLE NS_IMETHOD ClearFlag(PRUint32 flag) { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearFlag(flag); } \
  NS_SCRIPTABLE NS_IMETHOD GetFlag(PRUint32 flag, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFlag(flag, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ToggleFlag(PRUint32 flag) { return !_to ? NS_ERROR_NULL_POINTER : _to->ToggleFlag(flag); } \
  NS_SCRIPTABLE NS_IMETHOD OnFlagChange(PRUint32 flag) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnFlagChange(flag); } \
  NS_SCRIPTABLE NS_IMETHOD GetFlags(PRUint32 *aFlags) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFlags(aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD SetFlags(PRUint32 aFlags) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFlags(aFlags); } \
  NS_SCRIPTABLE NS_IMETHOD GetFolderWithFlags(PRUint32 flags, nsIMsgFolder **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFolderWithFlags(flags, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetFoldersWithFlags(PRUint32 flags, nsIArray **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFoldersWithFlags(flags, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ListFoldersWithFlags(PRUint32 flags, nsIMutableArray *folders) { return !_to ? NS_ERROR_NULL_POINTER : _to->ListFoldersWithFlags(flags, folders); } \
  NS_SCRIPTABLE NS_IMETHOD IsSpecialFolder(PRUint32 flags, PRBool checkAncestors, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsSpecialFolder(flags, checkAncestors, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetExpansionArray(nsISupportsArray *expansionArray) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetExpansionArray(expansionArray); } \
  NS_SCRIPTABLE NS_IMETHOD GetUriForMsg(nsIMsgDBHdr *msgHdr, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUriForMsg(msgHdr, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DeleteMessages(nsIArray *messages, nsIMsgWindow *msgWindow, PRBool deleteStorage, PRBool isMove, nsIMsgCopyServiceListener *listener, PRBool allowUndo) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteMessages(messages, msgWindow, deleteStorage, isMove, listener, allowUndo); } \
  NS_SCRIPTABLE NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, nsIArray *messages, PRBool isMove, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener, PRBool isFolder, PRBool allowUndo) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyMessages(srcFolder, messages, isMove, msgWindow, listener, isFolder, allowUndo); } \
  NS_SCRIPTABLE NS_IMETHOD CopyFolder(nsIMsgFolder *srcFolder, PRBool isMoveFolder, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyFolder(srcFolder, isMoveFolder, msgWindow, listener); } \
  NS_SCRIPTABLE NS_IMETHOD CopyFileMessage(nsIFile *file, nsIMsgDBHdr *msgToReplace, PRBool isDraft, PRUint32 newMsgFlags, const nsACString & aKeywords, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyFileMessage(file, msgToReplace, isDraft, newMsgFlags, aKeywords, msgWindow, listener); } \
  NS_SCRIPTABLE NS_IMETHOD AcquireSemaphore(nsISupports *semHolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->AcquireSemaphore(semHolder); } \
  NS_SCRIPTABLE NS_IMETHOD ReleaseSemaphore(nsISupports *semHolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->ReleaseSemaphore(semHolder); } \
  NS_SCRIPTABLE NS_IMETHOD TestSemaphore(nsISupports *semHolder, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->TestSemaphore(semHolder, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetLocked(PRBool *aLocked) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocked(aLocked); } \
  NS_SCRIPTABLE NS_IMETHOD GetNewMessages(nsIMsgWindow *aWindow, nsIUrlListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNewMessages(aWindow, aListener); } \
  NS_SCRIPTABLE NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache, PRBool deep) { return !_to ? NS_ERROR_NULL_POINTER : _to->WriteToFolderCache(folderCache, deep); } \
  NS_SCRIPTABLE NS_IMETHOD GetCharset(nsACString & aCharset) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharset(aCharset); } \
  NS_SCRIPTABLE NS_IMETHOD SetCharset(const nsACString & aCharset) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCharset(aCharset); } \
  NS_SCRIPTABLE NS_IMETHOD GetCharsetOverride(PRBool *aCharsetOverride) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharsetOverride(aCharsetOverride); } \
  NS_SCRIPTABLE NS_IMETHOD SetCharsetOverride(PRBool aCharsetOverride) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCharsetOverride(aCharsetOverride); } \
  NS_SCRIPTABLE NS_IMETHOD GetBiffState(PRUint32 *aBiffState) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBiffState(aBiffState); } \
  NS_SCRIPTABLE NS_IMETHOD SetBiffState(PRUint32 aBiffState) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBiffState(aBiffState); } \
  NS_SCRIPTABLE NS_IMETHOD GetNumNewMessages(PRBool deep, PRInt32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumNewMessages(deep, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetNumNewMessages(PRInt32 numNewMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetNumNewMessages(numNewMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetGettingNewMessages(PRBool *aGettingNewMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetGettingNewMessages(aGettingNewMessages); } \
  NS_SCRIPTABLE NS_IMETHOD SetGettingNewMessages(PRBool aGettingNewMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetGettingNewMessages(aGettingNewMessages); } \
  NS_SCRIPTABLE NS_IMETHOD GetFilePath(nsILocalFile **aFilePath) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFilePath(aFilePath); } \
  NS_SCRIPTABLE NS_IMETHOD SetFilePath(nsILocalFile *aFilePath) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFilePath(aFilePath); } \
  NS_SCRIPTABLE NS_IMETHOD GetBaseMessageURI(nsACString & aBaseMessageURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBaseMessageURI(aBaseMessageURI); } \
  NS_SCRIPTABLE NS_IMETHOD GenerateMessageURI(nsMsgKey msgKey, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GenerateMessageURI(msgKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddMessageDispositionState(nsIMsgDBHdr *aMessage, nsMsgDispositionState aDispositionFlag) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddMessageDispositionState(aMessage, aDispositionFlag); } \
  NS_SCRIPTABLE NS_IMETHOD MarkMessagesRead(nsIArray *messages, PRBool markRead) { return !_to ? NS_ERROR_NULL_POINTER : _to->MarkMessagesRead(messages, markRead); } \
  NS_SCRIPTABLE NS_IMETHOD MarkAllMessagesRead(nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->MarkAllMessagesRead(aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD MarkMessagesFlagged(nsIArray *messages, PRBool markFlagged) { return !_to ? NS_ERROR_NULL_POINTER : _to->MarkMessagesFlagged(messages, markFlagged); } \
  NS_SCRIPTABLE NS_IMETHOD MarkThreadRead(nsIMsgThread *thread) { return !_to ? NS_ERROR_NULL_POINTER : _to->MarkThreadRead(thread); } \
  NS_SCRIPTABLE NS_IMETHOD SetLabelForMessages(nsIArray *messages, nsMsgLabelValue label) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLabelForMessages(messages, label); } \
  NS_SCRIPTABLE NS_IMETHOD GetMsgDatabase(nsIMsgDatabase **aMsgDatabase) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMsgDatabase(aMsgDatabase); } \
  NS_SCRIPTABLE NS_IMETHOD SetMsgDatabase(nsIMsgDatabase *aMsgDatabase) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetMsgDatabase(aMsgDatabase); } \
  NS_SCRIPTABLE NS_IMETHOD GetBackupMsgDatabase(nsIMsgDatabase **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBackupMsgDatabase(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveBackupMsgDatabase(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveBackupMsgDatabase(); } \
  NS_SCRIPTABLE NS_IMETHOD OpenBackupMsgDatabase(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenBackupMsgDatabase(); } \
  NS_SCRIPTABLE NS_IMETHOD GetDBFolderInfoAndDB(nsIDBFolderInfo **folderInfo NS_OUTPARAM, nsIMsgDatabase **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDBFolderInfoAndDB(folderInfo, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetMessageHeader(nsMsgKey msgKey, nsIMsgDBHdr **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMessageHeader(msgKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSupportsOffline(PRBool *aSupportsOffline) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSupportsOffline(aSupportsOffline); } \
  NS_SCRIPTABLE NS_IMETHOD ShouldStoreMsgOffline(nsMsgKey msgKey, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ShouldStoreMsgOffline(msgKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD HasMsgOffline(nsMsgKey msgKey, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->HasMsgOffline(msgKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetOfflineFileStream(nsMsgKey aMsgKey, PRUint64 *aOffset NS_OUTPARAM, PRUint32 *aSize NS_OUTPARAM, nsIInputStream **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOfflineFileStream(aMsgKey, aOffset, aSize, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetOfflineStoreOutputStream(nsIOutputStream **aOfflineStoreOutputStream) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOfflineStoreOutputStream(aOfflineStoreOutputStream); } \
  NS_SCRIPTABLE NS_IMETHOD GetOfflineStoreInputStream(nsIInputStream **aOfflineStoreInputStream) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOfflineStoreInputStream(aOfflineStoreInputStream); } \
  NS_SCRIPTABLE NS_IMETHOD DownloadMessagesForOffline(nsIArray *messages, nsIMsgWindow *window) { return !_to ? NS_ERROR_NULL_POINTER : _to->DownloadMessagesForOffline(messages, window); } \
  NS_SCRIPTABLE NS_IMETHOD GetChildWithURI(const nsACString & uri, PRBool deep, PRBool caseInsensitive, nsIMsgFolder **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildWithURI(uri, deep, caseInsensitive, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD DownloadAllForOffline(nsIUrlListener *listener, nsIMsgWindow *window) { return !_to ? NS_ERROR_NULL_POINTER : _to->DownloadAllForOffline(listener, window); } \
  NS_SCRIPTABLE NS_IMETHOD EnableNotifications(PRInt32 notificationType, PRBool enable, PRBool dbBatching) { return !_to ? NS_ERROR_NULL_POINTER : _to->EnableNotifications(notificationType, enable, dbBatching); } \
  NS_SCRIPTABLE NS_IMETHOD IsCommandEnabled(const nsACString & command, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsCommandEnabled(command, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD MatchOrChangeFilterDestination(nsIMsgFolder *folder, PRBool caseInsensitive, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->MatchOrChangeFilterDestination(folder, caseInsensitive, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ConfirmFolderDeletionForFilter(nsIMsgWindow *msgWindow, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ConfirmFolderDeletionForFilter(msgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AlertFilterChanged(nsIMsgWindow *msgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->AlertFilterChanged(msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD ThrowAlertMsg(const char *msgName, nsIMsgWindow *msgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->ThrowAlertMsg(msgName, msgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD GetStringWithFolderNameFromBundle(const char *msgName, nsAString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStringWithFolderNameFromBundle(msgName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyCompactCompleted(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyCompactCompleted(); } \
  NS_SCRIPTABLE NS_IMETHOD CompareSortKeys(nsIMsgFolder *msgFolder, PRInt32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CompareSortKeys(msgFolder, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSortKey(PRUint32 *length NS_OUTPARAM, PRUint8 **key NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSortKey(length, key); } \
  NS_SCRIPTABLE NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings **aRetentionSettings) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRetentionSettings(aRetentionSettings); } \
  NS_SCRIPTABLE NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings *aRetentionSettings) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRetentionSettings(aRetentionSettings); } \
  NS_SCRIPTABLE NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings **aDownloadSettings) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDownloadSettings(aDownloadSettings); } \
  NS_SCRIPTABLE NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings *aDownloadSettings) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDownloadSettings(aDownloadSettings); } \
  NS_SCRIPTABLE NS_IMETHOD CallFilterPlugins(nsIMsgWindow *aMsgWindow, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CallFilterPlugins(aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSortOrder(PRInt32 *aSortOrder) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSortOrder(aSortOrder); } \
  NS_SCRIPTABLE NS_IMETHOD SetSortOrder(PRInt32 aSortOrder) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSortOrder(aSortOrder); } \
  NS_SCRIPTABLE NS_IMETHOD GetDBTransferInfo(nsIDBFolderInfo **aDBTransferInfo) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDBTransferInfo(aDBTransferInfo); } \
  NS_SCRIPTABLE NS_IMETHOD SetDBTransferInfo(nsIDBFolderInfo *aDBTransferInfo) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDBTransferInfo(aDBTransferInfo); } \
  NS_SCRIPTABLE NS_IMETHOD GetStringProperty(const char *propertyName, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStringProperty(propertyName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetStringProperty(const char *propertyName, const nsACString & propertyValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetStringProperty(propertyName, propertyValue); } \
  NS_SCRIPTABLE NS_IMETHOD GetLastMessageLoaded(nsMsgKey *aLastMessageLoaded) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastMessageLoaded(aLastMessageLoaded); } \
  NS_SCRIPTABLE NS_IMETHOD SetLastMessageLoaded(nsMsgKey aLastMessageLoaded) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLastMessageLoaded(aLastMessageLoaded); } \
  NS_SCRIPTABLE NS_IMETHOD GetURI(nsACString & aURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetURI(aURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetName(nsAString & aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetName(aName); } \
  NS_SCRIPTABLE NS_IMETHOD SetName(const nsAString & aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetName(aName); } \
  NS_SCRIPTABLE NS_IMETHOD GetPrettyName(nsAString & aPrettyName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPrettyName(aPrettyName); } \
  NS_SCRIPTABLE NS_IMETHOD SetPrettyName(const nsAString & aPrettyName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPrettyName(aPrettyName); } \
  NS_SCRIPTABLE NS_IMETHOD GetAbbreviatedName(nsAString & aAbbreviatedName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAbbreviatedName(aAbbreviatedName); } \
  NS_SCRIPTABLE NS_IMETHOD GetParent(nsIMsgFolder **aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD SetParent(nsIMsgFolder *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD GetSubFolders(nsISimpleEnumerator **aSubFolders) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSubFolders(aSubFolders); } \
  NS_SCRIPTABLE NS_IMETHOD GetHasSubFolders(PRBool *aHasSubFolders) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHasSubFolders(aHasSubFolders); } \
  NS_SCRIPTABLE NS_IMETHOD GetNumSubFolders(PRUint32 *aNumSubFolders) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumSubFolders(aNumSubFolders); } \
  NS_SCRIPTABLE NS_IMETHOD IsAncestorOf(nsIMsgFolder *folder, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsAncestorOf(folder, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ContainsChildNamed(const nsAString & name, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ContainsChildNamed(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetChildNamed(const nsAString & aName, nsIMsgFolder **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildNamed(aName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FindSubFolder(const nsACString & escapedSubFolderName, nsIMsgFolder **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FindSubFolder(escapedSubFolderName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddFolderListener(nsIFolderListener *listener) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddFolderListener(listener); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveFolderListener(nsIFolderListener *listener) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveFolderListener(listener); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyPropertyChanged(nsIAtom *property, const nsACString & oldValue, const nsACString & newValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyPropertyChanged(property, oldValue, newValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyIntPropertyChanged(nsIAtom *property, PRInt32 oldValue, PRInt32 newValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyIntPropertyChanged(property, oldValue, newValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyBoolPropertyChanged(nsIAtom *property, PRBool oldValue, PRBool newValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyBoolPropertyChanged(property, oldValue, newValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyPropertyFlagChanged(nsIMsgDBHdr *item, nsIAtom *property, PRUint32 oldValue, PRUint32 newValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyPropertyFlagChanged(item, property, oldValue, newValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyUnicharPropertyChanged(nsIAtom *property, const nsAString & oldValue, const nsAString & newValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyUnicharPropertyChanged(property, oldValue, newValue); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyItemAdded(nsISupports *item) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyItemAdded(item); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyItemRemoved(nsISupports *item) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyItemRemoved(item); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyFolderEvent(nsIAtom *event) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyFolderEvent(event); } \
  NS_SCRIPTABLE NS_IMETHOD ListDescendents(nsISupportsArray *descendents) { return !_to ? NS_ERROR_NULL_POINTER : _to->ListDescendents(descendents); } \
  NS_SCRIPTABLE NS_IMETHOD Shutdown(PRBool shutdownChildren) { return !_to ? NS_ERROR_NULL_POINTER : _to->Shutdown(shutdownChildren); } \
  NS_SCRIPTABLE NS_IMETHOD GetInVFEditSearchScope(PRBool *aInVFEditSearchScope) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInVFEditSearchScope(aInVFEditSearchScope); } \
  NS_SCRIPTABLE NS_IMETHOD SetInVFEditSearchScope(PRBool aSearchThisFolder, PRBool aSetOnSubFolders) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetInVFEditSearchScope(aSearchThisFolder, aSetOnSubFolders); } \
  NS_SCRIPTABLE NS_IMETHOD CopyDataToOutputStreamForAppend(nsIInputStream *aIStream, PRInt32 aLength, nsIOutputStream *outputStream) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyDataToOutputStreamForAppend(aIStream, aLength, outputStream); } \
  NS_SCRIPTABLE NS_IMETHOD CopyDataDone(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyDataDone(); } \
  NS_SCRIPTABLE NS_IMETHOD SetJunkScoreForMessages(nsIArray *aMessages, const nsACString & aJunkScore) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetJunkScoreForMessages(aMessages, aJunkScore); } \
  NS_SCRIPTABLE NS_IMETHOD ApplyRetentionSettings(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ApplyRetentionSettings(); } \
  NS_SCRIPTABLE NS_IMETHOD FetchMsgPreviewText(nsMsgKey *aKeysToFetch, PRUint32 aNumKeys, PRBool aLocalOnly, nsIUrlListener *aUrlListener, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FetchMsgPreviewText(aKeysToFetch, aNumKeys, aLocalOnly, aUrlListener, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddKeywordsToMessages(nsIArray *aMessages, const nsACString & aKeywords) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddKeywordsToMessages(aMessages, aKeywords); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveKeywordsFromMessages(nsIArray *aMessages, const nsACString & aKeywords) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveKeywordsFromMessages(aMessages, aKeywords); } \
  NS_SCRIPTABLE NS_IMETHOD GetMsgTextFromStream(nsIInputStream *aStream, const nsACString & aCharset, PRUint32 aBytesToRead, PRUint32 aMaxOutputLen, PRBool aCompressQuotes, PRBool aStripHTMLTags, nsACString & aContentType NS_OUTPARAM, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMsgTextFromStream(aStream, aCharset, aBytesToRead, aMaxOutputLen, aCompressQuotes, aStripHTMLTags, aContentType, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ConvertMsgSnippetToPlainText(const nsAString & aMessageText, nsAString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ConvertMsgSnippetToPlainText(aMessageText, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCustomIdentity(nsIMsgIdentity **aCustomIdentity) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCustomIdentity(aCustomIdentity); } \
  NS_SCRIPTABLE NS_IMETHOD GetProcessingFlags(nsMsgKey msgKey, PRUint32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProcessingFlags(msgKey, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD OrProcessingFlags(nsMsgKey msgKey, PRUint32 mask) { return !_to ? NS_ERROR_NULL_POINTER : _to->OrProcessingFlags(msgKey, mask); } \
  NS_SCRIPTABLE NS_IMETHOD AndProcessingFlags(nsMsgKey msgKey, PRUint32 mask) { return !_to ? NS_ERROR_NULL_POINTER : _to->AndProcessingFlags(msgKey, mask); } \
  NS_SCRIPTABLE NS_IMETHOD GetInheritedStringProperty(const char *propertyName, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInheritedStringProperty(propertyName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetForcePropertyEmpty(const char *propertyName, PRBool aForcePropertyEmpty) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetForcePropertyEmpty(propertyName, aForcePropertyEmpty); } \
  NS_SCRIPTABLE NS_IMETHOD GetForcePropertyEmpty(const char *propertyName, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetForcePropertyEmpty(propertyName, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgFolder : public nsIMsgFolder
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGFOLDER

  nsMsgFolder();

private:
  ~nsMsgFolder();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgFolder, nsIMsgFolder)

nsMsgFolder::nsMsgFolder()
{
  /* member initializers and constructor code */
}

nsMsgFolder::~nsMsgFolder()
{
  /* destructor code */
}

/* readonly attribute nsISimpleEnumerator messages; */
NS_IMETHODIMP nsMsgFolder::GetMessages(nsISimpleEnumerator **aMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void startFolderLoading (); */
NS_IMETHODIMP nsMsgFolder::StartFolderLoading()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void endFolderLoading (); */
NS_IMETHODIMP nsMsgFolder::EndFolderLoading()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void updateFolder (in nsIMsgWindow aWindow); */
NS_IMETHODIMP nsMsgFolder::UpdateFolder(nsIMsgWindow *aWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString prettiestName; */
NS_IMETHODIMP nsMsgFolder::GetPrettiestName(nsAString & aPrettiestName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString folderURL; */
NS_IMETHODIMP nsMsgFolder::GetFolderURL(nsACString & aFolderURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean showDeletedMessages; */
NS_IMETHODIMP nsMsgFolder::GetShowDeletedMessages(PRBool *aShowDeletedMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIMsgIncomingServer server; */
NS_IMETHODIMP nsMsgFolder::GetServer(nsIMsgIncomingServer **aServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean isServer; */
NS_IMETHODIMP nsMsgFolder::GetIsServer(PRBool *aIsServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canSubscribe; */
NS_IMETHODIMP nsMsgFolder::GetCanSubscribe(PRBool *aCanSubscribe)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canFileMessages; */
NS_IMETHODIMP nsMsgFolder::GetCanFileMessages(PRBool *aCanFileMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean noSelect; */
NS_IMETHODIMP nsMsgFolder::GetNoSelect(PRBool *aNoSelect)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean imapShared; */
NS_IMETHODIMP nsMsgFolder::GetImapShared(PRBool *aImapShared)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canDeleteMessages; */
NS_IMETHODIMP nsMsgFolder::GetCanDeleteMessages(PRBool *aCanDeleteMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canCreateSubfolders; */
NS_IMETHODIMP nsMsgFolder::GetCanCreateSubfolders(PRBool *aCanCreateSubfolders)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canRename; */
NS_IMETHODIMP nsMsgFolder::GetCanRename(PRBool *aCanRename)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canCompact; */
NS_IMETHODIMP nsMsgFolder::GetCanCompact(PRBool *aCanCompact)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIMsgFolder rootFolder; */
NS_IMETHODIMP nsMsgFolder::GetRootFolder(nsIMsgFolder **aRootFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgFilterList getFilterList (in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsMsgFolder::GetFilterList(nsIMsgWindow *msgWindow, nsIMsgFilterList **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFilterList (in nsIMsgFilterList filterList); */
NS_IMETHODIMP nsMsgFolder::SetFilterList(nsIMsgFilterList *filterList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgFilterList getEditableFilterList (in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgFolder::GetEditableFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setEditableFilterList (in nsIMsgFilterList aFilterList); */
NS_IMETHODIMP nsMsgFolder::SetEditableFilterList(nsIMsgFilterList *aFilterList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void ForceDBClosed (); */
NS_IMETHODIMP nsMsgFolder::ForceDBClosed()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void closeAndBackupFolderDB (in ACString newName); */
NS_IMETHODIMP nsMsgFolder::CloseAndBackupFolderDB(const nsACString & newName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Delete (); */
NS_IMETHODIMP nsMsgFolder::Delete()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteSubFolders (in nsIArray folders, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsMsgFolder::DeleteSubFolders(nsIArray *folders, nsIMsgWindow *msgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void propagateDelete (in nsIMsgFolder folder, in boolean deleteStorage, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsMsgFolder::PropagateDelete(nsIMsgFolder *folder, PRBool deleteStorage, nsIMsgWindow *msgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void recursiveDelete (in boolean deleteStorage, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsMsgFolder::RecursiveDelete(PRBool deleteStorage, nsIMsgWindow *msgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createSubfolder (in AString folderName, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsMsgFolder::CreateSubfolder(const nsAString & folderName, nsIMsgWindow *msgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgFolder addSubfolder (in AString folderName); */
NS_IMETHODIMP nsMsgFolder::AddSubfolder(const nsAString & folderName, nsIMsgFolder **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createStorageIfMissing (in nsIUrlListener urlListener); */
NS_IMETHODIMP nsMsgFolder::CreateStorageIfMissing(nsIUrlListener *urlListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void compact (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgFolder::Compact(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void compactAll (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow, in boolean aCompactOfflineAlso); */
NS_IMETHODIMP nsMsgFolder::CompactAll(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, PRBool aCompactOfflineAlso)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void compactAllOfflineStores (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow, in nsIArray aOfflineFolderArray); */
NS_IMETHODIMP nsMsgFolder::CompactAllOfflineStores(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow, nsIArray *aOfflineFolderArray)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void emptyTrash (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
NS_IMETHODIMP nsMsgFolder::EmptyTrash(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void rename (in AString name, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsMsgFolder::Rename(const nsAString & name, nsIMsgWindow *msgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void renameSubFolders (in nsIMsgWindow msgWindow, in nsIMsgFolder oldFolder); */
NS_IMETHODIMP nsMsgFolder::RenameSubFolders(nsIMsgWindow *msgWindow, nsIMsgFolder *oldFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString generateUniqueSubfolderName (in AString prefix, in nsIMsgFolder otherFolder); */
NS_IMETHODIMP nsMsgFolder::GenerateUniqueSubfolderName(const nsAString & prefix, nsIMsgFolder *otherFolder, nsAString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void updateSummaryTotals (in boolean force); */
NS_IMETHODIMP nsMsgFolder::UpdateSummaryTotals(PRBool force)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void summaryChanged (); */
NS_IMETHODIMP nsMsgFolder::SummaryChanged()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getNumUnread (in boolean deep); */
NS_IMETHODIMP nsMsgFolder::GetNumUnread(PRBool deep, PRInt32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getTotalMessages (in boolean deep); */
NS_IMETHODIMP nsMsgFolder::GetTotalMessages(PRBool deep, PRInt32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean hasNewMessages; */
NS_IMETHODIMP nsMsgFolder::GetHasNewMessages(PRBool *aHasNewMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetHasNewMessages(PRBool aHasNewMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIMsgDBHdr firstNewMessage; */
NS_IMETHODIMP nsMsgFolder::GetFirstNewMessage(nsIMsgDBHdr **aFirstNewMessage)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void clearNewMessages (); */
NS_IMETHODIMP nsMsgFolder::ClearNewMessages()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long expungedBytes; */
NS_IMETHODIMP nsMsgFolder::GetExpungedBytes(PRUint32 *aExpungedBytes)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean deletable; */
NS_IMETHODIMP nsMsgFolder::GetDeletable(PRBool *aDeletable)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean displayRecipients; */
NS_IMETHODIMP nsMsgFolder::GetDisplayRecipients(PRBool *aDisplayRecipients)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean manyHeadersToDownload; */
NS_IMETHODIMP nsMsgFolder::GetManyHeadersToDownload(PRBool *aManyHeadersToDownload)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean requiresCleanup; */
NS_IMETHODIMP nsMsgFolder::GetRequiresCleanup(PRBool *aRequiresCleanup)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void clearRequiresCleanup (); */
NS_IMETHODIMP nsMsgFolder::ClearRequiresCleanup()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean knowsSearchNntpExtension; */
NS_IMETHODIMP nsMsgFolder::GetKnowsSearchNntpExtension(PRBool *aKnowsSearchNntpExtension)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean allowsPosting; */
NS_IMETHODIMP nsMsgFolder::GetAllowsPosting(PRBool *aAllowsPosting)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString relativePathName; */
NS_IMETHODIMP nsMsgFolder::GetRelativePathName(nsACString & aRelativePathName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long sizeOnDisk; */
NS_IMETHODIMP nsMsgFolder::GetSizeOnDisk(PRUint32 *aSizeOnDisk)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetSizeOnDisk(PRUint32 aSizeOnDisk)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString username; */
NS_IMETHODIMP nsMsgFolder::GetUsername(nsACString & aUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString hostname; */
NS_IMETHODIMP nsMsgFolder::GetHostname(nsACString & aHostname)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFlag (in unsigned long flag); */
NS_IMETHODIMP nsMsgFolder::SetFlag(PRUint32 flag)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void clearFlag (in unsigned long flag); */
NS_IMETHODIMP nsMsgFolder::ClearFlag(PRUint32 flag)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean getFlag (in unsigned long flag); */
NS_IMETHODIMP nsMsgFolder::GetFlag(PRUint32 flag, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void toggleFlag (in unsigned long flag); */
NS_IMETHODIMP nsMsgFolder::ToggleFlag(PRUint32 flag)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onFlagChange (in unsigned long flag); */
NS_IMETHODIMP nsMsgFolder::OnFlagChange(PRUint32 flag)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long flags; */
NS_IMETHODIMP nsMsgFolder::GetFlags(PRUint32 *aFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetFlags(PRUint32 aFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgFolder getFolderWithFlags (in unsigned long flags); */
NS_IMETHODIMP nsMsgFolder::GetFolderWithFlags(PRUint32 flags, nsIMsgFolder **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIArray getFoldersWithFlags (in unsigned long flags); */
NS_IMETHODIMP nsMsgFolder::GetFoldersWithFlags(PRUint32 flags, nsIArray **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void listFoldersWithFlags (in unsigned long flags, in nsIMutableArray folders); */
NS_IMETHODIMP nsMsgFolder::ListFoldersWithFlags(PRUint32 flags, nsIMutableArray *folders)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isSpecialFolder (in unsigned long flags, [optional] in boolean checkAncestors); */
NS_IMETHODIMP nsMsgFolder::IsSpecialFolder(PRUint32 flags, PRBool checkAncestors, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getExpansionArray (in nsISupportsArray expansionArray); */
NS_IMETHODIMP nsMsgFolder::GetExpansionArray(nsISupportsArray *expansionArray)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getUriForMsg (in nsIMsgDBHdr msgHdr); */
NS_IMETHODIMP nsMsgFolder::GetUriForMsg(nsIMsgDBHdr *msgHdr, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteMessages (in nsIArray messages, in nsIMsgWindow msgWindow, in boolean deleteStorage, in boolean isMove, in nsIMsgCopyServiceListener listener, in boolean allowUndo); */
NS_IMETHODIMP nsMsgFolder::DeleteMessages(nsIArray *messages, nsIMsgWindow *msgWindow, PRBool deleteStorage, PRBool isMove, nsIMsgCopyServiceListener *listener, PRBool allowUndo)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copyMessages (in nsIMsgFolder srcFolder, in nsIArray messages, in boolean isMove, in nsIMsgWindow msgWindow, in nsIMsgCopyServiceListener listener, in boolean isFolder, in boolean allowUndo); */
NS_IMETHODIMP nsMsgFolder::CopyMessages(nsIMsgFolder *srcFolder, nsIArray *messages, PRBool isMove, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener, PRBool isFolder, PRBool allowUndo)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copyFolder (in nsIMsgFolder srcFolder, in boolean isMoveFolder, in nsIMsgWindow msgWindow, in nsIMsgCopyServiceListener listener); */
NS_IMETHODIMP nsMsgFolder::CopyFolder(nsIMsgFolder *srcFolder, PRBool isMoveFolder, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copyFileMessage (in nsIFile file, in nsIMsgDBHdr msgToReplace, in boolean isDraft, in unsigned long newMsgFlags, in ACString aKeywords, in nsIMsgWindow msgWindow, in nsIMsgCopyServiceListener listener); */
NS_IMETHODIMP nsMsgFolder::CopyFileMessage(nsIFile *file, nsIMsgDBHdr *msgToReplace, PRBool isDraft, PRUint32 newMsgFlags, const nsACString & aKeywords, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void acquireSemaphore (in nsISupports semHolder); */
NS_IMETHODIMP nsMsgFolder::AcquireSemaphore(nsISupports *semHolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void releaseSemaphore (in nsISupports semHolder); */
NS_IMETHODIMP nsMsgFolder::ReleaseSemaphore(nsISupports *semHolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean testSemaphore (in nsISupports semHolder); */
NS_IMETHODIMP nsMsgFolder::TestSemaphore(nsISupports *semHolder, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean locked; */
NS_IMETHODIMP nsMsgFolder::GetLocked(PRBool *aLocked)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getNewMessages (in nsIMsgWindow aWindow, in nsIUrlListener aListener); */
NS_IMETHODIMP nsMsgFolder::GetNewMessages(nsIMsgWindow *aWindow, nsIUrlListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void writeToFolderCache (in nsIMsgFolderCache folderCache, in boolean deep); */
NS_IMETHODIMP nsMsgFolder::WriteToFolderCache(nsIMsgFolderCache *folderCache, PRBool deep)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString charset; */
NS_IMETHODIMP nsMsgFolder::GetCharset(nsACString & aCharset)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetCharset(const nsACString & aCharset)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean charsetOverride; */
NS_IMETHODIMP nsMsgFolder::GetCharsetOverride(PRBool *aCharsetOverride)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetCharsetOverride(PRBool aCharsetOverride)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long biffState; */
NS_IMETHODIMP nsMsgFolder::GetBiffState(PRUint32 *aBiffState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetBiffState(PRUint32 aBiffState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getNumNewMessages (in boolean deep); */
NS_IMETHODIMP nsMsgFolder::GetNumNewMessages(PRBool deep, PRInt32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setNumNewMessages (in long numNewMessages); */
NS_IMETHODIMP nsMsgFolder::SetNumNewMessages(PRInt32 numNewMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean gettingNewMessages; */
NS_IMETHODIMP nsMsgFolder::GetGettingNewMessages(PRBool *aGettingNewMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetGettingNewMessages(PRBool aGettingNewMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsILocalFile filePath; */
NS_IMETHODIMP nsMsgFolder::GetFilePath(nsILocalFile **aFilePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetFilePath(nsILocalFile *aFilePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString baseMessageURI; */
NS_IMETHODIMP nsMsgFolder::GetBaseMessageURI(nsACString & aBaseMessageURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString generateMessageURI (in nsMsgKey msgKey); */
NS_IMETHODIMP nsMsgFolder::GenerateMessageURI(nsMsgKey msgKey, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addMessageDispositionState (in nsIMsgDBHdr aMessage, in nsMsgDispositionState aDispositionFlag); */
NS_IMETHODIMP nsMsgFolder::AddMessageDispositionState(nsIMsgDBHdr *aMessage, nsMsgDispositionState aDispositionFlag)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void markMessagesRead (in nsIArray messages, in boolean markRead); */
NS_IMETHODIMP nsMsgFolder::MarkMessagesRead(nsIArray *messages, PRBool markRead)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void markAllMessagesRead (in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgFolder::MarkAllMessagesRead(nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void markMessagesFlagged (in nsIArray messages, in boolean markFlagged); */
NS_IMETHODIMP nsMsgFolder::MarkMessagesFlagged(nsIArray *messages, PRBool markFlagged)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void markThreadRead (in nsIMsgThread thread); */
NS_IMETHODIMP nsMsgFolder::MarkThreadRead(nsIMsgThread *thread)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setLabelForMessages (in nsIArray messages, in nsMsgLabelValue label); */
NS_IMETHODIMP nsMsgFolder::SetLabelForMessages(nsIArray *messages, nsMsgLabelValue label)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIMsgDatabase msgDatabase; */
NS_IMETHODIMP nsMsgFolder::GetMsgDatabase(nsIMsgDatabase **aMsgDatabase)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetMsgDatabase(nsIMsgDatabase *aMsgDatabase)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgDatabase getBackupMsgDatabase (); */
NS_IMETHODIMP nsMsgFolder::GetBackupMsgDatabase(nsIMsgDatabase **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeBackupMsgDatabase (); */
NS_IMETHODIMP nsMsgFolder::RemoveBackupMsgDatabase()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void openBackupMsgDatabase (); */
NS_IMETHODIMP nsMsgFolder::OpenBackupMsgDatabase()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgDatabase getDBFolderInfoAndDB (out nsIDBFolderInfo folderInfo); */
NS_IMETHODIMP nsMsgFolder::GetDBFolderInfoAndDB(nsIDBFolderInfo **folderInfo NS_OUTPARAM, nsIMsgDatabase **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgDBHdr GetMessageHeader (in nsMsgKey msgKey); */
NS_IMETHODIMP nsMsgFolder::GetMessageHeader(nsMsgKey msgKey, nsIMsgDBHdr **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean supportsOffline; */
NS_IMETHODIMP nsMsgFolder::GetSupportsOffline(PRBool *aSupportsOffline)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean shouldStoreMsgOffline (in nsMsgKey msgKey); */
NS_IMETHODIMP nsMsgFolder::ShouldStoreMsgOffline(nsMsgKey msgKey, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean hasMsgOffline (in nsMsgKey msgKey); */
NS_IMETHODIMP nsMsgFolder::HasMsgOffline(nsMsgKey msgKey, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIInputStream getOfflineFileStream (in nsMsgKey aMsgKey, out unsigned long long aOffset, out unsigned long aSize); */
NS_IMETHODIMP nsMsgFolder::GetOfflineFileStream(nsMsgKey aMsgKey, PRUint64 *aOffset NS_OUTPARAM, PRUint32 *aSize NS_OUTPARAM, nsIInputStream **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIOutputStream offlineStoreOutputStream; */
NS_IMETHODIMP nsMsgFolder::GetOfflineStoreOutputStream(nsIOutputStream **aOfflineStoreOutputStream)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIInputStream offlineStoreInputStream; */
NS_IMETHODIMP nsMsgFolder::GetOfflineStoreInputStream(nsIInputStream **aOfflineStoreInputStream)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DownloadMessagesForOffline (in nsIArray messages, in nsIMsgWindow window); */
NS_IMETHODIMP nsMsgFolder::DownloadMessagesForOffline(nsIArray *messages, nsIMsgWindow *window)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgFolder getChildWithURI (in ACString uri, in boolean deep, in boolean caseInsensitive); */
NS_IMETHODIMP nsMsgFolder::GetChildWithURI(const nsACString & uri, PRBool deep, PRBool caseInsensitive, nsIMsgFolder **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void downloadAllForOffline (in nsIUrlListener listener, in nsIMsgWindow window); */
NS_IMETHODIMP nsMsgFolder::DownloadAllForOffline(nsIUrlListener *listener, nsIMsgWindow *window)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void enableNotifications (in long notificationType, in boolean enable, in boolean dbBatching); */
NS_IMETHODIMP nsMsgFolder::EnableNotifications(PRInt32 notificationType, PRBool enable, PRBool dbBatching)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isCommandEnabled (in ACString command); */
NS_IMETHODIMP nsMsgFolder::IsCommandEnabled(const nsACString & command, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean matchOrChangeFilterDestination (in nsIMsgFolder folder, in boolean caseInsensitive); */
NS_IMETHODIMP nsMsgFolder::MatchOrChangeFilterDestination(nsIMsgFolder *folder, PRBool caseInsensitive, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean confirmFolderDeletionForFilter (in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsMsgFolder::ConfirmFolderDeletionForFilter(nsIMsgWindow *msgWindow, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void alertFilterChanged (in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsMsgFolder::AlertFilterChanged(nsIMsgWindow *msgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void throwAlertMsg (in string msgName, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsMsgFolder::ThrowAlertMsg(const char *msgName, nsIMsgWindow *msgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getStringWithFolderNameFromBundle (in string msgName); */
NS_IMETHODIMP nsMsgFolder::GetStringWithFolderNameFromBundle(const char *msgName, nsAString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void notifyCompactCompleted (); */
NS_IMETHODIMP nsMsgFolder::NotifyCompactCompleted()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long compareSortKeys (in nsIMsgFolder msgFolder); */
NS_IMETHODIMP nsMsgFolder::CompareSortKeys(nsIMsgFolder *msgFolder, PRInt32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getSortKey (out unsigned long length, [array, size_is (length), retval] out octet key); */
NS_IMETHODIMP nsMsgFolder::GetSortKey(PRUint32 *length NS_OUTPARAM, PRUint8 **key NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIMsgRetentionSettings retentionSettings; */
NS_IMETHODIMP nsMsgFolder::GetRetentionSettings(nsIMsgRetentionSettings **aRetentionSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetRetentionSettings(nsIMsgRetentionSettings *aRetentionSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIMsgDownloadSettings downloadSettings; */
NS_IMETHODIMP nsMsgFolder::GetDownloadSettings(nsIMsgDownloadSettings **aDownloadSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetDownloadSettings(nsIMsgDownloadSettings *aDownloadSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean callFilterPlugins (in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgFolder::CallFilterPlugins(nsIMsgWindow *aMsgWindow, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long sortOrder; */
NS_IMETHODIMP nsMsgFolder::GetSortOrder(PRInt32 *aSortOrder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetSortOrder(PRInt32 aSortOrder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIDBFolderInfo dBTransferInfo; */
NS_IMETHODIMP nsMsgFolder::GetDBTransferInfo(nsIDBFolderInfo **aDBTransferInfo)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetDBTransferInfo(nsIDBFolderInfo *aDBTransferInfo)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getStringProperty (in string propertyName); */
NS_IMETHODIMP nsMsgFolder::GetStringProperty(const char *propertyName, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setStringProperty (in string propertyName, in ACString propertyValue); */
NS_IMETHODIMP nsMsgFolder::SetStringProperty(const char *propertyName, const nsACString & propertyValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsMsgKey lastMessageLoaded; */
NS_IMETHODIMP nsMsgFolder::GetLastMessageLoaded(nsMsgKey *aLastMessageLoaded)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetLastMessageLoaded(nsMsgKey aLastMessageLoaded)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString URI; */
NS_IMETHODIMP nsMsgFolder::GetURI(nsACString & aURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString name; */
NS_IMETHODIMP nsMsgFolder::GetName(nsAString & aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetName(const nsAString & aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString prettyName; */
NS_IMETHODIMP nsMsgFolder::GetPrettyName(nsAString & aPrettyName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetPrettyName(const nsAString & aPrettyName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString abbreviatedName; */
NS_IMETHODIMP nsMsgFolder::GetAbbreviatedName(nsAString & aAbbreviatedName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIMsgFolder parent; */
NS_IMETHODIMP nsMsgFolder::GetParent(nsIMsgFolder **aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgFolder::SetParent(nsIMsgFolder *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator subFolders; */
NS_IMETHODIMP nsMsgFolder::GetSubFolders(nsISimpleEnumerator **aSubFolders)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean hasSubFolders; */
NS_IMETHODIMP nsMsgFolder::GetHasSubFolders(PRBool *aHasSubFolders)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long numSubFolders; */
NS_IMETHODIMP nsMsgFolder::GetNumSubFolders(PRUint32 *aNumSubFolders)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isAncestorOf (in nsIMsgFolder folder); */
NS_IMETHODIMP nsMsgFolder::IsAncestorOf(nsIMsgFolder *folder, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean containsChildNamed (in AString name); */
NS_IMETHODIMP nsMsgFolder::ContainsChildNamed(const nsAString & name, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgFolder getChildNamed (in AString aName); */
NS_IMETHODIMP nsMsgFolder::GetChildNamed(const nsAString & aName, nsIMsgFolder **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgFolder findSubFolder (in ACString escapedSubFolderName); */
NS_IMETHODIMP nsMsgFolder::FindSubFolder(const nsACString & escapedSubFolderName, nsIMsgFolder **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void AddFolderListener (in nsIFolderListener listener); */
NS_IMETHODIMP nsMsgFolder::AddFolderListener(nsIFolderListener *listener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RemoveFolderListener (in nsIFolderListener listener); */
NS_IMETHODIMP nsMsgFolder::RemoveFolderListener(nsIFolderListener *listener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void NotifyPropertyChanged (in nsIAtom property, in ACString oldValue, in ACString newValue); */
NS_IMETHODIMP nsMsgFolder::NotifyPropertyChanged(nsIAtom *property, const nsACString & oldValue, const nsACString & newValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void NotifyIntPropertyChanged (in nsIAtom property, in long oldValue, in long newValue); */
NS_IMETHODIMP nsMsgFolder::NotifyIntPropertyChanged(nsIAtom *property, PRInt32 oldValue, PRInt32 newValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void NotifyBoolPropertyChanged (in nsIAtom property, in boolean oldValue, in boolean newValue); */
NS_IMETHODIMP nsMsgFolder::NotifyBoolPropertyChanged(nsIAtom *property, PRBool oldValue, PRBool newValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void NotifyPropertyFlagChanged (in nsIMsgDBHdr item, in nsIAtom property, in unsigned long oldValue, in unsigned long newValue); */
NS_IMETHODIMP nsMsgFolder::NotifyPropertyFlagChanged(nsIMsgDBHdr *item, nsIAtom *property, PRUint32 oldValue, PRUint32 newValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void NotifyUnicharPropertyChanged (in nsIAtom property, in AString oldValue, in AString newValue); */
NS_IMETHODIMP nsMsgFolder::NotifyUnicharPropertyChanged(nsIAtom *property, const nsAString & oldValue, const nsAString & newValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void NotifyItemAdded (in nsISupports item); */
NS_IMETHODIMP nsMsgFolder::NotifyItemAdded(nsISupports *item)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void NotifyItemRemoved (in nsISupports item); */
NS_IMETHODIMP nsMsgFolder::NotifyItemRemoved(nsISupports *item)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void NotifyFolderEvent (in nsIAtom event); */
NS_IMETHODIMP nsMsgFolder::NotifyFolderEvent(nsIAtom *event)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void ListDescendents (in nsISupportsArray descendents); */
NS_IMETHODIMP nsMsgFolder::ListDescendents(nsISupportsArray *descendents)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Shutdown (in boolean shutdownChildren); */
NS_IMETHODIMP nsMsgFolder::Shutdown(PRBool shutdownChildren)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean inVFEditSearchScope; */
NS_IMETHODIMP nsMsgFolder::GetInVFEditSearchScope(PRBool *aInVFEditSearchScope)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setInVFEditSearchScope (in boolean aSearchThisFolder, in boolean aSetOnSubFolders); */
NS_IMETHODIMP nsMsgFolder::SetInVFEditSearchScope(PRBool aSearchThisFolder, PRBool aSetOnSubFolders)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copyDataToOutputStreamForAppend (in nsIInputStream aIStream, in long aLength, in nsIOutputStream outputStream); */
NS_IMETHODIMP nsMsgFolder::CopyDataToOutputStreamForAppend(nsIInputStream *aIStream, PRInt32 aLength, nsIOutputStream *outputStream)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copyDataDone (); */
NS_IMETHODIMP nsMsgFolder::CopyDataDone()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setJunkScoreForMessages (in nsIArray aMessages, in ACString aJunkScore); */
NS_IMETHODIMP nsMsgFolder::SetJunkScoreForMessages(nsIArray *aMessages, const nsACString & aJunkScore)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void applyRetentionSettings (); */
NS_IMETHODIMP nsMsgFolder::ApplyRetentionSettings()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean fetchMsgPreviewText ([array, size_is (aNumKeys)] in nsMsgKey aKeysToFetch, in unsigned long aNumKeys, in boolean aLocalOnly, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsMsgFolder::FetchMsgPreviewText(nsMsgKey *aKeysToFetch, PRUint32 aNumKeys, PRBool aLocalOnly, nsIUrlListener *aUrlListener, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addKeywordsToMessages (in nsIArray aMessages, in ACString aKeywords); */
NS_IMETHODIMP nsMsgFolder::AddKeywordsToMessages(nsIArray *aMessages, const nsACString & aKeywords)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeKeywordsFromMessages (in nsIArray aMessages, in ACString aKeywords); */
NS_IMETHODIMP nsMsgFolder::RemoveKeywordsFromMessages(nsIArray *aMessages, const nsACString & aKeywords)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AUTF8String getMsgTextFromStream (in nsIInputStream aStream, in ACString aCharset, in unsigned long aBytesToRead, in unsigned long aMaxOutputLen, in boolean aCompressQuotes, in boolean aStripHTMLTags, out ACString aContentType); */
NS_IMETHODIMP nsMsgFolder::GetMsgTextFromStream(nsIInputStream *aStream, const nsACString & aCharset, PRUint32 aBytesToRead, PRUint32 aMaxOutputLen, PRBool aCompressQuotes, PRBool aStripHTMLTags, nsACString & aContentType NS_OUTPARAM, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString convertMsgSnippetToPlainText (in AString aMessageText); */
NS_IMETHODIMP nsMsgFolder::ConvertMsgSnippetToPlainText(const nsAString & aMessageText, nsAString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIMsgIdentity customIdentity; */
NS_IMETHODIMP nsMsgFolder::GetCustomIdentity(nsIMsgIdentity **aCustomIdentity)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long getProcessingFlags (in nsMsgKey msgKey); */
NS_IMETHODIMP nsMsgFolder::GetProcessingFlags(nsMsgKey msgKey, PRUint32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void orProcessingFlags (in nsMsgKey msgKey, in unsigned long mask); */
NS_IMETHODIMP nsMsgFolder::OrProcessingFlags(nsMsgKey msgKey, PRUint32 mask)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void andProcessingFlags (in nsMsgKey msgKey, in unsigned long mask); */
NS_IMETHODIMP nsMsgFolder::AndProcessingFlags(nsMsgKey msgKey, PRUint32 mask)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getInheritedStringProperty (in string propertyName); */
NS_IMETHODIMP nsMsgFolder::GetInheritedStringProperty(const char *propertyName, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setForcePropertyEmpty (in string propertyName, in boolean aForcePropertyEmpty); */
NS_IMETHODIMP nsMsgFolder::SetForcePropertyEmpty(const char *propertyName, PRBool aForcePropertyEmpty)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean getForcePropertyEmpty (in string propertyName); */
NS_IMETHODIMP nsMsgFolder::GetForcePropertyEmpty(const char *propertyName, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMsgFolder_h__ */
