/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgImapMailFolder.idl
 */

#ifndef __gen_nsIMsgImapMailFolder_h__
#define __gen_nsIMsgImapMailFolder_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIMsgFolder_h__
#include "nsIMsgFolder.h"
#endif

#ifndef __gen_nsIStringEnumerator_h__
#include "nsIStringEnumerator.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIMsgWindow; /* forward declaration */

class nsIImapIncomingServer; /* forward declaration */

class nsIMsgParseMailMsgState; /* forward declaration */

class nsIAutoSyncState; /* forward declaration */


/* starting interface:    nsIMsgImapFolderProps */
#define NS_IMSGIMAPFOLDERPROPS_IID_STR "09d99f2c-3e23-4f8c-a536-5c277baa9585"

#define NS_IMSGIMAPFOLDERPROPS_IID \
  {0x09d99f2c, 0x3e23, 0x4f8c, \
    { 0xa5, 0x36, 0x5c, 0x27, 0x7b, 0xaa, 0x95, 0x85 }}

/**
 * This is a simple interface which allows the IMAP folder to update some
 * values that the folder props js code will use to update the sharing and
 * quota tabs in the folder properties.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgImapFolderProps : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGIMAPFOLDERPROPS_IID)

  /* void setFolderType (in AString folderType); */
  NS_SCRIPTABLE NS_IMETHOD SetFolderType(const nsAString & folderType) = 0;

  /* void setFolderTypeDescription (in AString folderTypeDescription); */
  NS_SCRIPTABLE NS_IMETHOD SetFolderTypeDescription(const nsAString & folderTypeDescription) = 0;

  /* void setFolderPermissions (in AString permissions); */
  NS_SCRIPTABLE NS_IMETHOD SetFolderPermissions(const nsAString & permissions) = 0;

  /* void serverDoesntSupportACL (); */
  NS_SCRIPTABLE NS_IMETHOD ServerDoesntSupportACL(void) = 0;

  /**
     * Toggles the display of quota information in the Quota tab of the folder properties.
     * If on, the quota root, usage, and percentage used are displayed.
     * If off, a status message is displayed. The status message can be set with setQuotaStatus().
     * @param showData If true, display the quota root, usage information and usage percentage bar.
     *                 If false, display the status message.
     */
  /* void showQuotaData (in boolean showData); */
  NS_SCRIPTABLE NS_IMETHOD ShowQuotaData(PRBool showData) = 0;

  /**
     * Sets the status string displayed in the Quota tab of the folder properties if quota
     * information is not visible.
     */
  /* void setQuotaStatus (in AString folderQuotaStatus); */
  NS_SCRIPTABLE NS_IMETHOD SetQuotaStatus(const nsAString & folderQuotaStatus) = 0;

  /**
     * Updates the quota data displayed in the Quota tab.
     */
  /* void setQuotaData (in ACString quotaroot, in unsigned long usedKB, in unsigned long maxKB); */
  NS_SCRIPTABLE NS_IMETHOD SetQuotaData(const nsACString & quotaroot, PRUint32 usedKB, PRUint32 maxKB) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgImapFolderProps, NS_IMSGIMAPFOLDERPROPS_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGIMAPFOLDERPROPS \
  NS_SCRIPTABLE NS_IMETHOD SetFolderType(const nsAString & folderType); \
  NS_SCRIPTABLE NS_IMETHOD SetFolderTypeDescription(const nsAString & folderTypeDescription); \
  NS_SCRIPTABLE NS_IMETHOD SetFolderPermissions(const nsAString & permissions); \
  NS_SCRIPTABLE NS_IMETHOD ServerDoesntSupportACL(void); \
  NS_SCRIPTABLE NS_IMETHOD ShowQuotaData(PRBool showData); \
  NS_SCRIPTABLE NS_IMETHOD SetQuotaStatus(const nsAString & folderQuotaStatus); \
  NS_SCRIPTABLE NS_IMETHOD SetQuotaData(const nsACString & quotaroot, PRUint32 usedKB, PRUint32 maxKB); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGIMAPFOLDERPROPS(_to) \
  NS_SCRIPTABLE NS_IMETHOD SetFolderType(const nsAString & folderType) { return _to SetFolderType(folderType); } \
  NS_SCRIPTABLE NS_IMETHOD SetFolderTypeDescription(const nsAString & folderTypeDescription) { return _to SetFolderTypeDescription(folderTypeDescription); } \
  NS_SCRIPTABLE NS_IMETHOD SetFolderPermissions(const nsAString & permissions) { return _to SetFolderPermissions(permissions); } \
  NS_SCRIPTABLE NS_IMETHOD ServerDoesntSupportACL(void) { return _to ServerDoesntSupportACL(); } \
  NS_SCRIPTABLE NS_IMETHOD ShowQuotaData(PRBool showData) { return _to ShowQuotaData(showData); } \
  NS_SCRIPTABLE NS_IMETHOD SetQuotaStatus(const nsAString & folderQuotaStatus) { return _to SetQuotaStatus(folderQuotaStatus); } \
  NS_SCRIPTABLE NS_IMETHOD SetQuotaData(const nsACString & quotaroot, PRUint32 usedKB, PRUint32 maxKB) { return _to SetQuotaData(quotaroot, usedKB, maxKB); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGIMAPFOLDERPROPS(_to) \
  NS_SCRIPTABLE NS_IMETHOD SetFolderType(const nsAString & folderType) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFolderType(folderType); } \
  NS_SCRIPTABLE NS_IMETHOD SetFolderTypeDescription(const nsAString & folderTypeDescription) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFolderTypeDescription(folderTypeDescription); } \
  NS_SCRIPTABLE NS_IMETHOD SetFolderPermissions(const nsAString & permissions) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFolderPermissions(permissions); } \
  NS_SCRIPTABLE NS_IMETHOD ServerDoesntSupportACL(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ServerDoesntSupportACL(); } \
  NS_SCRIPTABLE NS_IMETHOD ShowQuotaData(PRBool showData) { return !_to ? NS_ERROR_NULL_POINTER : _to->ShowQuotaData(showData); } \
  NS_SCRIPTABLE NS_IMETHOD SetQuotaStatus(const nsAString & folderQuotaStatus) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetQuotaStatus(folderQuotaStatus); } \
  NS_SCRIPTABLE NS_IMETHOD SetQuotaData(const nsACString & quotaroot, PRUint32 usedKB, PRUint32 maxKB) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetQuotaData(quotaroot, usedKB, maxKB); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgImapFolderProps : public nsIMsgImapFolderProps
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGIMAPFOLDERPROPS

  nsMsgImapFolderProps();

private:
  ~nsMsgImapFolderProps();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgImapFolderProps, nsIMsgImapFolderProps)

nsMsgImapFolderProps::nsMsgImapFolderProps()
{
  /* member initializers and constructor code */
}

nsMsgImapFolderProps::~nsMsgImapFolderProps()
{
  /* destructor code */
}

/* void setFolderType (in AString folderType); */
NS_IMETHODIMP nsMsgImapFolderProps::SetFolderType(const nsAString & folderType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFolderTypeDescription (in AString folderTypeDescription); */
NS_IMETHODIMP nsMsgImapFolderProps::SetFolderTypeDescription(const nsAString & folderTypeDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFolderPermissions (in AString permissions); */
NS_IMETHODIMP nsMsgImapFolderProps::SetFolderPermissions(const nsAString & permissions)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void serverDoesntSupportACL (); */
NS_IMETHODIMP nsMsgImapFolderProps::ServerDoesntSupportACL()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void showQuotaData (in boolean showData); */
NS_IMETHODIMP nsMsgImapFolderProps::ShowQuotaData(PRBool showData)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setQuotaStatus (in AString folderQuotaStatus); */
NS_IMETHODIMP nsMsgImapFolderProps::SetQuotaStatus(const nsAString & folderQuotaStatus)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setQuotaData (in ACString quotaroot, in unsigned long usedKB, in unsigned long maxKB); */
NS_IMETHODIMP nsMsgImapFolderProps::SetQuotaData(const nsACString & quotaroot, PRUint32 usedKB, PRUint32 maxKB)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIMsgImapMailFolder */
#define NS_IMSGIMAPMAILFOLDER_IID_STR "fea0f455-7adf-4683-bf2f-c95c3fff03df"

#define NS_IMSGIMAPMAILFOLDER_IID \
  {0xfea0f455, 0x7adf, 0x4683, \
    { 0xbf, 0x2f, 0xc9, 0x5c, 0x3f, 0xff, 0x03, 0xdf }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgImapMailFolder : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGIMAPMAILFOLDER_IID)

  /* void removeSubFolder (in nsIMsgFolder folder); */
  NS_SCRIPTABLE NS_IMETHOD RemoveSubFolder(nsIMsgFolder *folder) = 0;

  /* void createClientSubfolderInfo (in ACString folderName, in char hierarchyDelimiter, in long flags, in boolean suppressNotification); */
  NS_SCRIPTABLE NS_IMETHOD CreateClientSubfolderInfo(const nsACString & folderName, char hierarchyDelimiter, PRInt32 flags, PRBool suppressNotification) = 0;

  /* void list (); */
  NS_SCRIPTABLE NS_IMETHOD List(void) = 0;

  /* void renameLocal (in ACString newname, in nsIMsgFolder parent); */
  NS_SCRIPTABLE NS_IMETHOD RenameLocal(const nsACString & newname, nsIMsgFolder *parent) = 0;

  /* void prepareToRename (); */
  NS_SCRIPTABLE NS_IMETHOD PrepareToRename(void) = 0;

  /* void performExpand (in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow) = 0;

  /* void recursiveCloseActiveConnections (in nsIImapIncomingServer aImapServer); */
  NS_SCRIPTABLE NS_IMETHOD RecursiveCloseActiveConnections(nsIImapIncomingServer *aImapServer) = 0;

  /* void renameClient (in nsIMsgWindow msgWindow, in nsIMsgFolder msgFolder, in ACString oldName, in ACString newName); */
  NS_SCRIPTABLE NS_IMETHOD RenameClient(nsIMsgWindow *msgWindow, nsIMsgFolder *msgFolder, const nsACString & oldName, const nsACString & newName) = 0;

  /* void storeImapFlags (in long aFlags, in boolean aAddFlags, [array, size_is (aNumKeys)] in nsMsgKey aKeysToFlag, in unsigned long aNumKeys, in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD StoreImapFlags(PRInt32 aFlags, PRBool aAddFlags, nsMsgKey *aKeysToFlag, PRUint32 aNumKeys, nsIUrlListener *aUrlListener) = 0;

  /* nsIURI setImapFlags (in string uids, in long flags); */
  NS_SCRIPTABLE NS_IMETHOD SetImapFlags(const char *uids, PRInt32 flags, nsIURI **_retval NS_OUTPARAM) = 0;

  /* void replayOfflineMoveCopy ([array, size_is (numKeys)] in nsMsgKey keys, in unsigned long numKeys, in boolean isMove, in nsIMsgFolder aDstFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aWindow); */
  NS_SCRIPTABLE NS_IMETHOD ReplayOfflineMoveCopy(nsMsgKey *keys, PRUint32 numKeys, PRBool isMove, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aWindow) = 0;

  /* nsIURI playbackOfflineFolderCreate (in AString folderName, in nsIMsgWindow aWindow); */
  NS_SCRIPTABLE NS_IMETHOD PlaybackOfflineFolderCreate(const nsAString & folderName, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM) = 0;

  /**
   * This is called by the offline sync code to tell the imap folder to
   * remember info about the header with this key (messageId and key) because
   * it's an offline move result header, and we need to generate an
   * nsIMsgFolderListener.msgKeyChanged notification when we download the
   * real header from the imap server.
   *
   * @param aMsgKey msg key of move result pseudo hdr.
   */
  /* void addMoveResultPseudoKey (in nsMsgKey aMsgKey); */
  NS_SCRIPTABLE NS_IMETHOD AddMoveResultPseudoKey(nsMsgKey aMsgKey) = 0;

  /**
   * Select this folder on the imap server without doing a sync of flags or
   * headers. This is used for offline playback, where we don't want to
   * download hdrs we don't have, because they may have been offline deleted.
   *
   * @param aUrlListener        url listener, can be null
   * @param aWindow          msg window url is running in, can be null
   */
  /* void liteSelect (in nsIUrlListener aUrlListener, in nsIMsgWindow aWindow); */
  NS_SCRIPTABLE NS_IMETHOD LiteSelect(nsIUrlListener *aUrlListener, nsIMsgWindow *aWindow) = 0;

  /* void fillInFolderProps (in nsIMsgImapFolderProps aFolderProps); */
  NS_SCRIPTABLE NS_IMETHOD FillInFolderProps(nsIMsgImapFolderProps *aFolderProps) = 0;

  /* void resetNamespaceReferences (); */
  NS_SCRIPTABLE NS_IMETHOD ResetNamespaceReferences(void) = 0;

  /* void folderPrivileges (in nsIMsgWindow aWindow); */
  NS_SCRIPTABLE NS_IMETHOD FolderPrivileges(nsIMsgWindow *aWindow) = 0;

  /* nsIMsgImapMailFolder findOnlineSubFolder (in ACString onlineName); */
  NS_SCRIPTABLE NS_IMETHOD FindOnlineSubFolder(const nsACString & onlineName, nsIMsgImapMailFolder **_retval NS_OUTPARAM) = 0;

  /* void addFolderRights (in ACString userName, in ACString rights); */
  NS_SCRIPTABLE NS_IMETHOD AddFolderRights(const nsACString & userName, const nsACString & rights) = 0;

  /* void refreshFolderRights (); */
  NS_SCRIPTABLE NS_IMETHOD RefreshFolderRights(void) = 0;

  /**
   * Mark/unmark the header as pending removal from the offline store. If mark,
   * this also increases the expungedBytes count on the folder so we know
   * there's more local disk space to be reclaimed.
   *
   * @param aHdr     msg hdr to mark pending removal from offline store.
   * @param aMark    whether to set or clear the pending removal status.
   *
   */
  /* void markPendingRemoval (in nsIMsgDBHdr aHdr, in boolean aMark); */
  NS_SCRIPTABLE NS_IMETHOD MarkPendingRemoval(nsIMsgDBHdr *aHdr, PRBool aMark) = 0;

  /**
   * Issue an expunge of this folder to the imap server.
   *
   * @param aUrlListener     url listener, can be null
   * @param aWindow          msg window url is running in, can be null
   *
   * @returns                status of attempt to run url.
   */
  /* void expunge (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD Expunge(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) = 0;

  /* void updateStatus (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD UpdateStatus(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) = 0;

  /* void updateFolderWithListener (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
  NS_SCRIPTABLE NS_IMETHOD UpdateFolderWithListener(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) = 0;

  /* nsIURI issueCommandOnMsgs (in ACString command, in string uids, in nsIMsgWindow aWindow); */
  NS_SCRIPTABLE NS_IMETHOD IssueCommandOnMsgs(const nsACString & command, const char *uids, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI fetchCustomMsgAttribute (in ACString msgAttribute, in string uids, in nsIMsgWindow aWindow); */
  NS_SCRIPTABLE NS_IMETHOD FetchCustomMsgAttribute(const nsACString & msgAttribute, const char *uids, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM) = 0;

  /* nsIURI storeCustomKeywords (in nsIMsgWindow aMsgWindow, in ACString aFlagsToAdd, in ACString aFlagsToSubtract, [array, size_is (aNumKeys)] in nsMsgKey aKeysToStore, in unsigned long aNumKeys); */
  NS_SCRIPTABLE NS_IMETHOD StoreCustomKeywords(nsIMsgWindow *aMsgWindow, const nsACString & aFlagsToAdd, const nsACString & aFlagsToSubtract, nsMsgKey *aKeysToStore, PRUint32 aNumKeys, nsIURI **_retval NS_OUTPARAM) = 0;

  /* void notifyIfNewMail (); */
  NS_SCRIPTABLE NS_IMETHOD NotifyIfNewMail(void) = 0;

  /* void initiateAutoSync (in nsIUrlListener aUrlListener); */
  NS_SCRIPTABLE NS_IMETHOD InitiateAutoSync(nsIUrlListener *aUrlListener) = 0;

  /* attribute boolean verifiedAsOnlineFolder; */
  NS_SCRIPTABLE NS_IMETHOD GetVerifiedAsOnlineFolder(PRBool *aVerifiedAsOnlineFolder) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetVerifiedAsOnlineFolder(PRBool aVerifiedAsOnlineFolder) = 0;

  /* attribute boolean explicitlyVerify; */
  NS_SCRIPTABLE NS_IMETHOD GetExplicitlyVerify(PRBool *aExplicitlyVerify) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetExplicitlyVerify(PRBool aExplicitlyVerify) = 0;

  /* attribute char hierarchyDelimiter; */
  NS_SCRIPTABLE NS_IMETHOD GetHierarchyDelimiter(char *aHierarchyDelimiter) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetHierarchyDelimiter(char aHierarchyDelimiter) = 0;

  /* attribute long boxFlags; */
  NS_SCRIPTABLE NS_IMETHOD GetBoxFlags(PRInt32 *aBoxFlags) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetBoxFlags(PRInt32 aBoxFlags) = 0;

  /* attribute ACString onlineName; */
  NS_SCRIPTABLE NS_IMETHOD GetOnlineName(nsACString & aOnlineName) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetOnlineName(const nsACString & aOnlineName) = 0;

  /* attribute boolean isNamespace; */
  NS_SCRIPTABLE NS_IMETHOD GetIsNamespace(PRBool *aIsNamespace) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetIsNamespace(PRBool aIsNamespace) = 0;

  /* readonly attribute boolean canOpenFolder; */
  NS_SCRIPTABLE NS_IMETHOD GetCanOpenFolder(PRBool *aCanOpenFolder) = 0;

  /* attribute ACString adminUrl; */
  NS_SCRIPTABLE NS_IMETHOD GetAdminUrl(nsACString & aAdminUrl) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetAdminUrl(const nsACString & aAdminUrl) = 0;

  /* readonly attribute boolean hasAdminUrl; */
  NS_SCRIPTABLE NS_IMETHOD GetHasAdminUrl(PRBool *aHasAdminUrl) = 0;

  /* attribute boolean performingBiff; */
  NS_SCRIPTABLE NS_IMETHOD GetPerformingBiff(PRBool *aPerformingBiff) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetPerformingBiff(PRBool aPerformingBiff) = 0;

  /* readonly attribute nsIMsgParseMailMsgState hdrParser; */
  NS_SCRIPTABLE NS_IMETHOD GetHdrParser(nsIMsgParseMailMsgState **aHdrParser) = 0;

  /* readonly attribute nsIImapIncomingServer imapIncomingServer; */
  NS_SCRIPTABLE NS_IMETHOD GetImapIncomingServer(nsIImapIncomingServer **aImapIncomingServer) = 0;

  /* readonly attribute nsIAutoSyncState autoSyncStateObj; */
  NS_SCRIPTABLE NS_IMETHOD GetAutoSyncStateObj(nsIAutoSyncState **aAutoSyncStateObj) = 0;

  /**
   * @{
   * These are used to access the response to the STATUS or SELECT command.
   * The counts include deleted messages, or headers we haven't downloaded yet.
   */
  /* readonly attribute long serverTotal; */
  NS_SCRIPTABLE NS_IMETHOD GetServerTotal(PRInt32 *aServerTotal) = 0;

  /* readonly attribute long serverUnseen; */
  NS_SCRIPTABLE NS_IMETHOD GetServerUnseen(PRInt32 *aServerUnseen) = 0;

  /* readonly attribute long serverRecent; */
  NS_SCRIPTABLE NS_IMETHOD GetServerRecent(PRInt32 *aServerRecent) = 0;

  /* readonly attribute long serverNextUID; */
  NS_SCRIPTABLE NS_IMETHOD GetServerNextUID(PRInt32 *aServerNextUID) = 0;

  /** @} */
/**
   * Quota
   * |valid| indicates whether the server has provided quota information on
   * this folder. This can be false
   * - if the server does not supports quotas,
   * - if there are no storage quotas on this folder, or
   * - if the folder has never been opened.
   * If it is true and maxKB > 0, the folder has a storage quota and
   * the usedKB and maxKB attributes are set to the values provided by
   * the server (in kilobytes), for this quota root.
   * Lotus Notes sends us maxKB = 0, usedKB > 0 for unlimited quota.
   */
  /* void getQuota (out boolean valid, out unsigned long usedKB, out unsigned long maxKB); */
  NS_SCRIPTABLE NS_IMETHOD GetQuota(PRBool *valid NS_OUTPARAM, PRUint32 *usedKB NS_OUTPARAM, PRUint32 *maxKB NS_OUTPARAM) = 0;

  /**
   * List all (human) users apart from the current user who have access to
   * this folder.
   *
   * You can find out which rights they have with getRightsForUser().
   */
  /* nsIUTF8StringEnumerator getOtherUsersWithAccess (); */
  NS_SCRIPTABLE NS_IMETHOD GetOtherUsersWithAccess(nsIUTF8StringEnumerator **_retval NS_OUTPARAM) = 0;

  /**
   * Which access rights a certain user has for this folder.
   *
   * @return list of flags
   * e.g. "lrswipcd" for write access and "lrs" for read only access.
   *
   * See RFC 2086 (e.g. Cyrus) and RFC 4314 (e.g. dovecot)
   *
   * l = locate = visible in folder list
   * r = read = list mails, get/read mail contents
   * s = set seen flag = mark read. Does not affect other users.
   * d (or t) = delete mails
   * w = write = change (other) flags of existing mails
   * i = insert = add mails to this folder
   * p = post = send mail directly to the submission address for folder
   * c (or k) = create subfolders
   * (e = expunge = compress)
   * (x = delete folder)
   * a = admin = change permissions
   */
  /* ACString getPermissionsForUser (in ACString username); */
  NS_SCRIPTABLE NS_IMETHOD GetPermissionsForUser(const nsACString & username, nsACString & _retval NS_OUTPARAM) = 0;

  /**
   * Change the number of "pending" messages in a folder,
   *  messages we know about, but don't have the headers for yet
   *
   * @param aDelta amount to change total by.
   */
  /* void changePendingTotal (in long aDelta); */
  NS_SCRIPTABLE NS_IMETHOD ChangePendingTotal(PRInt32 aDelta) = 0;

  /**
   * Change the number of "pending" unread messages in a folder,
   * unread messages we know about, but don't have the headers for yet
   *
   * @param aDelta amount to change the unread count by.
   */
  /* void changePendingUnread (in long aDelta); */
  NS_SCRIPTABLE NS_IMETHOD ChangePendingUnread(PRInt32 aDelta) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgImapMailFolder, NS_IMSGIMAPMAILFOLDER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGIMAPMAILFOLDER \
  NS_SCRIPTABLE NS_IMETHOD RemoveSubFolder(nsIMsgFolder *folder); \
  NS_SCRIPTABLE NS_IMETHOD CreateClientSubfolderInfo(const nsACString & folderName, char hierarchyDelimiter, PRInt32 flags, PRBool suppressNotification); \
  NS_SCRIPTABLE NS_IMETHOD List(void); \
  NS_SCRIPTABLE NS_IMETHOD RenameLocal(const nsACString & newname, nsIMsgFolder *parent); \
  NS_SCRIPTABLE NS_IMETHOD PrepareToRename(void); \
  NS_SCRIPTABLE NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow); \
  NS_SCRIPTABLE NS_IMETHOD RecursiveCloseActiveConnections(nsIImapIncomingServer *aImapServer); \
  NS_SCRIPTABLE NS_IMETHOD RenameClient(nsIMsgWindow *msgWindow, nsIMsgFolder *msgFolder, const nsACString & oldName, const nsACString & newName); \
  NS_SCRIPTABLE NS_IMETHOD StoreImapFlags(PRInt32 aFlags, PRBool aAddFlags, nsMsgKey *aKeysToFlag, PRUint32 aNumKeys, nsIUrlListener *aUrlListener); \
  NS_SCRIPTABLE NS_IMETHOD SetImapFlags(const char *uids, PRInt32 flags, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ReplayOfflineMoveCopy(nsMsgKey *keys, PRUint32 numKeys, PRBool isMove, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aWindow); \
  NS_SCRIPTABLE NS_IMETHOD PlaybackOfflineFolderCreate(const nsAString & folderName, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddMoveResultPseudoKey(nsMsgKey aMsgKey); \
  NS_SCRIPTABLE NS_IMETHOD LiteSelect(nsIUrlListener *aUrlListener, nsIMsgWindow *aWindow); \
  NS_SCRIPTABLE NS_IMETHOD FillInFolderProps(nsIMsgImapFolderProps *aFolderProps); \
  NS_SCRIPTABLE NS_IMETHOD ResetNamespaceReferences(void); \
  NS_SCRIPTABLE NS_IMETHOD FolderPrivileges(nsIMsgWindow *aWindow); \
  NS_SCRIPTABLE NS_IMETHOD FindOnlineSubFolder(const nsACString & onlineName, nsIMsgImapMailFolder **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddFolderRights(const nsACString & userName, const nsACString & rights); \
  NS_SCRIPTABLE NS_IMETHOD RefreshFolderRights(void); \
  NS_SCRIPTABLE NS_IMETHOD MarkPendingRemoval(nsIMsgDBHdr *aHdr, PRBool aMark); \
  NS_SCRIPTABLE NS_IMETHOD Expunge(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow); \
  NS_SCRIPTABLE NS_IMETHOD UpdateStatus(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow); \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolderWithListener(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener); \
  NS_SCRIPTABLE NS_IMETHOD IssueCommandOnMsgs(const nsACString & command, const char *uids, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD FetchCustomMsgAttribute(const nsACString & msgAttribute, const char *uids, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD StoreCustomKeywords(nsIMsgWindow *aMsgWindow, const nsACString & aFlagsToAdd, const nsACString & aFlagsToSubtract, nsMsgKey *aKeysToStore, PRUint32 aNumKeys, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD NotifyIfNewMail(void); \
  NS_SCRIPTABLE NS_IMETHOD InitiateAutoSync(nsIUrlListener *aUrlListener); \
  NS_SCRIPTABLE NS_IMETHOD GetVerifiedAsOnlineFolder(PRBool *aVerifiedAsOnlineFolder); \
  NS_SCRIPTABLE NS_IMETHOD SetVerifiedAsOnlineFolder(PRBool aVerifiedAsOnlineFolder); \
  NS_SCRIPTABLE NS_IMETHOD GetExplicitlyVerify(PRBool *aExplicitlyVerify); \
  NS_SCRIPTABLE NS_IMETHOD SetExplicitlyVerify(PRBool aExplicitlyVerify); \
  NS_SCRIPTABLE NS_IMETHOD GetHierarchyDelimiter(char *aHierarchyDelimiter); \
  NS_SCRIPTABLE NS_IMETHOD SetHierarchyDelimiter(char aHierarchyDelimiter); \
  NS_SCRIPTABLE NS_IMETHOD GetBoxFlags(PRInt32 *aBoxFlags); \
  NS_SCRIPTABLE NS_IMETHOD SetBoxFlags(PRInt32 aBoxFlags); \
  NS_SCRIPTABLE NS_IMETHOD GetOnlineName(nsACString & aOnlineName); \
  NS_SCRIPTABLE NS_IMETHOD SetOnlineName(const nsACString & aOnlineName); \
  NS_SCRIPTABLE NS_IMETHOD GetIsNamespace(PRBool *aIsNamespace); \
  NS_SCRIPTABLE NS_IMETHOD SetIsNamespace(PRBool aIsNamespace); \
  NS_SCRIPTABLE NS_IMETHOD GetCanOpenFolder(PRBool *aCanOpenFolder); \
  NS_SCRIPTABLE NS_IMETHOD GetAdminUrl(nsACString & aAdminUrl); \
  NS_SCRIPTABLE NS_IMETHOD SetAdminUrl(const nsACString & aAdminUrl); \
  NS_SCRIPTABLE NS_IMETHOD GetHasAdminUrl(PRBool *aHasAdminUrl); \
  NS_SCRIPTABLE NS_IMETHOD GetPerformingBiff(PRBool *aPerformingBiff); \
  NS_SCRIPTABLE NS_IMETHOD SetPerformingBiff(PRBool aPerformingBiff); \
  NS_SCRIPTABLE NS_IMETHOD GetHdrParser(nsIMsgParseMailMsgState **aHdrParser); \
  NS_SCRIPTABLE NS_IMETHOD GetImapIncomingServer(nsIImapIncomingServer **aImapIncomingServer); \
  NS_SCRIPTABLE NS_IMETHOD GetAutoSyncStateObj(nsIAutoSyncState **aAutoSyncStateObj); \
  NS_SCRIPTABLE NS_IMETHOD GetServerTotal(PRInt32 *aServerTotal); \
  NS_SCRIPTABLE NS_IMETHOD GetServerUnseen(PRInt32 *aServerUnseen); \
  NS_SCRIPTABLE NS_IMETHOD GetServerRecent(PRInt32 *aServerRecent); \
  NS_SCRIPTABLE NS_IMETHOD GetServerNextUID(PRInt32 *aServerNextUID); \
  NS_SCRIPTABLE NS_IMETHOD GetQuota(PRBool *valid NS_OUTPARAM, PRUint32 *usedKB NS_OUTPARAM, PRUint32 *maxKB NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetOtherUsersWithAccess(nsIUTF8StringEnumerator **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetPermissionsForUser(const nsACString & username, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ChangePendingTotal(PRInt32 aDelta); \
  NS_SCRIPTABLE NS_IMETHOD ChangePendingUnread(PRInt32 aDelta); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGIMAPMAILFOLDER(_to) \
  NS_SCRIPTABLE NS_IMETHOD RemoveSubFolder(nsIMsgFolder *folder) { return _to RemoveSubFolder(folder); } \
  NS_SCRIPTABLE NS_IMETHOD CreateClientSubfolderInfo(const nsACString & folderName, char hierarchyDelimiter, PRInt32 flags, PRBool suppressNotification) { return _to CreateClientSubfolderInfo(folderName, hierarchyDelimiter, flags, suppressNotification); } \
  NS_SCRIPTABLE NS_IMETHOD List(void) { return _to List(); } \
  NS_SCRIPTABLE NS_IMETHOD RenameLocal(const nsACString & newname, nsIMsgFolder *parent) { return _to RenameLocal(newname, parent); } \
  NS_SCRIPTABLE NS_IMETHOD PrepareToRename(void) { return _to PrepareToRename(); } \
  NS_SCRIPTABLE NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow) { return _to PerformExpand(aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD RecursiveCloseActiveConnections(nsIImapIncomingServer *aImapServer) { return _to RecursiveCloseActiveConnections(aImapServer); } \
  NS_SCRIPTABLE NS_IMETHOD RenameClient(nsIMsgWindow *msgWindow, nsIMsgFolder *msgFolder, const nsACString & oldName, const nsACString & newName) { return _to RenameClient(msgWindow, msgFolder, oldName, newName); } \
  NS_SCRIPTABLE NS_IMETHOD StoreImapFlags(PRInt32 aFlags, PRBool aAddFlags, nsMsgKey *aKeysToFlag, PRUint32 aNumKeys, nsIUrlListener *aUrlListener) { return _to StoreImapFlags(aFlags, aAddFlags, aKeysToFlag, aNumKeys, aUrlListener); } \
  NS_SCRIPTABLE NS_IMETHOD SetImapFlags(const char *uids, PRInt32 flags, nsIURI **_retval NS_OUTPARAM) { return _to SetImapFlags(uids, flags, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ReplayOfflineMoveCopy(nsMsgKey *keys, PRUint32 numKeys, PRBool isMove, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aWindow) { return _to ReplayOfflineMoveCopy(keys, numKeys, isMove, aDstFolder, aUrlListener, aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD PlaybackOfflineFolderCreate(const nsAString & folderName, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM) { return _to PlaybackOfflineFolderCreate(folderName, aWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddMoveResultPseudoKey(nsMsgKey aMsgKey) { return _to AddMoveResultPseudoKey(aMsgKey); } \
  NS_SCRIPTABLE NS_IMETHOD LiteSelect(nsIUrlListener *aUrlListener, nsIMsgWindow *aWindow) { return _to LiteSelect(aUrlListener, aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD FillInFolderProps(nsIMsgImapFolderProps *aFolderProps) { return _to FillInFolderProps(aFolderProps); } \
  NS_SCRIPTABLE NS_IMETHOD ResetNamespaceReferences(void) { return _to ResetNamespaceReferences(); } \
  NS_SCRIPTABLE NS_IMETHOD FolderPrivileges(nsIMsgWindow *aWindow) { return _to FolderPrivileges(aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD FindOnlineSubFolder(const nsACString & onlineName, nsIMsgImapMailFolder **_retval NS_OUTPARAM) { return _to FindOnlineSubFolder(onlineName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddFolderRights(const nsACString & userName, const nsACString & rights) { return _to AddFolderRights(userName, rights); } \
  NS_SCRIPTABLE NS_IMETHOD RefreshFolderRights(void) { return _to RefreshFolderRights(); } \
  NS_SCRIPTABLE NS_IMETHOD MarkPendingRemoval(nsIMsgDBHdr *aHdr, PRBool aMark) { return _to MarkPendingRemoval(aHdr, aMark); } \
  NS_SCRIPTABLE NS_IMETHOD Expunge(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) { return _to Expunge(aListener, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateStatus(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) { return _to UpdateStatus(aListener, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolderWithListener(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) { return _to UpdateFolderWithListener(aMsgWindow, aListener); } \
  NS_SCRIPTABLE NS_IMETHOD IssueCommandOnMsgs(const nsACString & command, const char *uids, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM) { return _to IssueCommandOnMsgs(command, uids, aWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FetchCustomMsgAttribute(const nsACString & msgAttribute, const char *uids, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM) { return _to FetchCustomMsgAttribute(msgAttribute, uids, aWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD StoreCustomKeywords(nsIMsgWindow *aMsgWindow, const nsACString & aFlagsToAdd, const nsACString & aFlagsToSubtract, nsMsgKey *aKeysToStore, PRUint32 aNumKeys, nsIURI **_retval NS_OUTPARAM) { return _to StoreCustomKeywords(aMsgWindow, aFlagsToAdd, aFlagsToSubtract, aKeysToStore, aNumKeys, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyIfNewMail(void) { return _to NotifyIfNewMail(); } \
  NS_SCRIPTABLE NS_IMETHOD InitiateAutoSync(nsIUrlListener *aUrlListener) { return _to InitiateAutoSync(aUrlListener); } \
  NS_SCRIPTABLE NS_IMETHOD GetVerifiedAsOnlineFolder(PRBool *aVerifiedAsOnlineFolder) { return _to GetVerifiedAsOnlineFolder(aVerifiedAsOnlineFolder); } \
  NS_SCRIPTABLE NS_IMETHOD SetVerifiedAsOnlineFolder(PRBool aVerifiedAsOnlineFolder) { return _to SetVerifiedAsOnlineFolder(aVerifiedAsOnlineFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetExplicitlyVerify(PRBool *aExplicitlyVerify) { return _to GetExplicitlyVerify(aExplicitlyVerify); } \
  NS_SCRIPTABLE NS_IMETHOD SetExplicitlyVerify(PRBool aExplicitlyVerify) { return _to SetExplicitlyVerify(aExplicitlyVerify); } \
  NS_SCRIPTABLE NS_IMETHOD GetHierarchyDelimiter(char *aHierarchyDelimiter) { return _to GetHierarchyDelimiter(aHierarchyDelimiter); } \
  NS_SCRIPTABLE NS_IMETHOD SetHierarchyDelimiter(char aHierarchyDelimiter) { return _to SetHierarchyDelimiter(aHierarchyDelimiter); } \
  NS_SCRIPTABLE NS_IMETHOD GetBoxFlags(PRInt32 *aBoxFlags) { return _to GetBoxFlags(aBoxFlags); } \
  NS_SCRIPTABLE NS_IMETHOD SetBoxFlags(PRInt32 aBoxFlags) { return _to SetBoxFlags(aBoxFlags); } \
  NS_SCRIPTABLE NS_IMETHOD GetOnlineName(nsACString & aOnlineName) { return _to GetOnlineName(aOnlineName); } \
  NS_SCRIPTABLE NS_IMETHOD SetOnlineName(const nsACString & aOnlineName) { return _to SetOnlineName(aOnlineName); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsNamespace(PRBool *aIsNamespace) { return _to GetIsNamespace(aIsNamespace); } \
  NS_SCRIPTABLE NS_IMETHOD SetIsNamespace(PRBool aIsNamespace) { return _to SetIsNamespace(aIsNamespace); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanOpenFolder(PRBool *aCanOpenFolder) { return _to GetCanOpenFolder(aCanOpenFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetAdminUrl(nsACString & aAdminUrl) { return _to GetAdminUrl(aAdminUrl); } \
  NS_SCRIPTABLE NS_IMETHOD SetAdminUrl(const nsACString & aAdminUrl) { return _to SetAdminUrl(aAdminUrl); } \
  NS_SCRIPTABLE NS_IMETHOD GetHasAdminUrl(PRBool *aHasAdminUrl) { return _to GetHasAdminUrl(aHasAdminUrl); } \
  NS_SCRIPTABLE NS_IMETHOD GetPerformingBiff(PRBool *aPerformingBiff) { return _to GetPerformingBiff(aPerformingBiff); } \
  NS_SCRIPTABLE NS_IMETHOD SetPerformingBiff(PRBool aPerformingBiff) { return _to SetPerformingBiff(aPerformingBiff); } \
  NS_SCRIPTABLE NS_IMETHOD GetHdrParser(nsIMsgParseMailMsgState **aHdrParser) { return _to GetHdrParser(aHdrParser); } \
  NS_SCRIPTABLE NS_IMETHOD GetImapIncomingServer(nsIImapIncomingServer **aImapIncomingServer) { return _to GetImapIncomingServer(aImapIncomingServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetAutoSyncStateObj(nsIAutoSyncState **aAutoSyncStateObj) { return _to GetAutoSyncStateObj(aAutoSyncStateObj); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerTotal(PRInt32 *aServerTotal) { return _to GetServerTotal(aServerTotal); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerUnseen(PRInt32 *aServerUnseen) { return _to GetServerUnseen(aServerUnseen); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerRecent(PRInt32 *aServerRecent) { return _to GetServerRecent(aServerRecent); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerNextUID(PRInt32 *aServerNextUID) { return _to GetServerNextUID(aServerNextUID); } \
  NS_SCRIPTABLE NS_IMETHOD GetQuota(PRBool *valid NS_OUTPARAM, PRUint32 *usedKB NS_OUTPARAM, PRUint32 *maxKB NS_OUTPARAM) { return _to GetQuota(valid, usedKB, maxKB); } \
  NS_SCRIPTABLE NS_IMETHOD GetOtherUsersWithAccess(nsIUTF8StringEnumerator **_retval NS_OUTPARAM) { return _to GetOtherUsersWithAccess(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetPermissionsForUser(const nsACString & username, nsACString & _retval NS_OUTPARAM) { return _to GetPermissionsForUser(username, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ChangePendingTotal(PRInt32 aDelta) { return _to ChangePendingTotal(aDelta); } \
  NS_SCRIPTABLE NS_IMETHOD ChangePendingUnread(PRInt32 aDelta) { return _to ChangePendingUnread(aDelta); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGIMAPMAILFOLDER(_to) \
  NS_SCRIPTABLE NS_IMETHOD RemoveSubFolder(nsIMsgFolder *folder) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveSubFolder(folder); } \
  NS_SCRIPTABLE NS_IMETHOD CreateClientSubfolderInfo(const nsACString & folderName, char hierarchyDelimiter, PRInt32 flags, PRBool suppressNotification) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateClientSubfolderInfo(folderName, hierarchyDelimiter, flags, suppressNotification); } \
  NS_SCRIPTABLE NS_IMETHOD List(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->List(); } \
  NS_SCRIPTABLE NS_IMETHOD RenameLocal(const nsACString & newname, nsIMsgFolder *parent) { return !_to ? NS_ERROR_NULL_POINTER : _to->RenameLocal(newname, parent); } \
  NS_SCRIPTABLE NS_IMETHOD PrepareToRename(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->PrepareToRename(); } \
  NS_SCRIPTABLE NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->PerformExpand(aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD RecursiveCloseActiveConnections(nsIImapIncomingServer *aImapServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->RecursiveCloseActiveConnections(aImapServer); } \
  NS_SCRIPTABLE NS_IMETHOD RenameClient(nsIMsgWindow *msgWindow, nsIMsgFolder *msgFolder, const nsACString & oldName, const nsACString & newName) { return !_to ? NS_ERROR_NULL_POINTER : _to->RenameClient(msgWindow, msgFolder, oldName, newName); } \
  NS_SCRIPTABLE NS_IMETHOD StoreImapFlags(PRInt32 aFlags, PRBool aAddFlags, nsMsgKey *aKeysToFlag, PRUint32 aNumKeys, nsIUrlListener *aUrlListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->StoreImapFlags(aFlags, aAddFlags, aKeysToFlag, aNumKeys, aUrlListener); } \
  NS_SCRIPTABLE NS_IMETHOD SetImapFlags(const char *uids, PRInt32 flags, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetImapFlags(uids, flags, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ReplayOfflineMoveCopy(nsMsgKey *keys, PRUint32 numKeys, PRBool isMove, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->ReplayOfflineMoveCopy(keys, numKeys, isMove, aDstFolder, aUrlListener, aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD PlaybackOfflineFolderCreate(const nsAString & folderName, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->PlaybackOfflineFolderCreate(folderName, aWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddMoveResultPseudoKey(nsMsgKey aMsgKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddMoveResultPseudoKey(aMsgKey); } \
  NS_SCRIPTABLE NS_IMETHOD LiteSelect(nsIUrlListener *aUrlListener, nsIMsgWindow *aWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->LiteSelect(aUrlListener, aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD FillInFolderProps(nsIMsgImapFolderProps *aFolderProps) { return !_to ? NS_ERROR_NULL_POINTER : _to->FillInFolderProps(aFolderProps); } \
  NS_SCRIPTABLE NS_IMETHOD ResetNamespaceReferences(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ResetNamespaceReferences(); } \
  NS_SCRIPTABLE NS_IMETHOD FolderPrivileges(nsIMsgWindow *aWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->FolderPrivileges(aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD FindOnlineSubFolder(const nsACString & onlineName, nsIMsgImapMailFolder **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FindOnlineSubFolder(onlineName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddFolderRights(const nsACString & userName, const nsACString & rights) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddFolderRights(userName, rights); } \
  NS_SCRIPTABLE NS_IMETHOD RefreshFolderRights(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RefreshFolderRights(); } \
  NS_SCRIPTABLE NS_IMETHOD MarkPendingRemoval(nsIMsgDBHdr *aHdr, PRBool aMark) { return !_to ? NS_ERROR_NULL_POINTER : _to->MarkPendingRemoval(aHdr, aMark); } \
  NS_SCRIPTABLE NS_IMETHOD Expunge(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->Expunge(aListener, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateStatus(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->UpdateStatus(aListener, aMsgWindow); } \
  NS_SCRIPTABLE NS_IMETHOD UpdateFolderWithListener(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->UpdateFolderWithListener(aMsgWindow, aListener); } \
  NS_SCRIPTABLE NS_IMETHOD IssueCommandOnMsgs(const nsACString & command, const char *uids, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->IssueCommandOnMsgs(command, uids, aWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD FetchCustomMsgAttribute(const nsACString & msgAttribute, const char *uids, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->FetchCustomMsgAttribute(msgAttribute, uids, aWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD StoreCustomKeywords(nsIMsgWindow *aMsgWindow, const nsACString & aFlagsToAdd, const nsACString & aFlagsToSubtract, nsMsgKey *aKeysToStore, PRUint32 aNumKeys, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->StoreCustomKeywords(aMsgWindow, aFlagsToAdd, aFlagsToSubtract, aKeysToStore, aNumKeys, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD NotifyIfNewMail(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyIfNewMail(); } \
  NS_SCRIPTABLE NS_IMETHOD InitiateAutoSync(nsIUrlListener *aUrlListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->InitiateAutoSync(aUrlListener); } \
  NS_SCRIPTABLE NS_IMETHOD GetVerifiedAsOnlineFolder(PRBool *aVerifiedAsOnlineFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetVerifiedAsOnlineFolder(aVerifiedAsOnlineFolder); } \
  NS_SCRIPTABLE NS_IMETHOD SetVerifiedAsOnlineFolder(PRBool aVerifiedAsOnlineFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetVerifiedAsOnlineFolder(aVerifiedAsOnlineFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetExplicitlyVerify(PRBool *aExplicitlyVerify) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetExplicitlyVerify(aExplicitlyVerify); } \
  NS_SCRIPTABLE NS_IMETHOD SetExplicitlyVerify(PRBool aExplicitlyVerify) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetExplicitlyVerify(aExplicitlyVerify); } \
  NS_SCRIPTABLE NS_IMETHOD GetHierarchyDelimiter(char *aHierarchyDelimiter) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHierarchyDelimiter(aHierarchyDelimiter); } \
  NS_SCRIPTABLE NS_IMETHOD SetHierarchyDelimiter(char aHierarchyDelimiter) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHierarchyDelimiter(aHierarchyDelimiter); } \
  NS_SCRIPTABLE NS_IMETHOD GetBoxFlags(PRInt32 *aBoxFlags) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBoxFlags(aBoxFlags); } \
  NS_SCRIPTABLE NS_IMETHOD SetBoxFlags(PRInt32 aBoxFlags) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBoxFlags(aBoxFlags); } \
  NS_SCRIPTABLE NS_IMETHOD GetOnlineName(nsACString & aOnlineName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOnlineName(aOnlineName); } \
  NS_SCRIPTABLE NS_IMETHOD SetOnlineName(const nsACString & aOnlineName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetOnlineName(aOnlineName); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsNamespace(PRBool *aIsNamespace) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsNamespace(aIsNamespace); } \
  NS_SCRIPTABLE NS_IMETHOD SetIsNamespace(PRBool aIsNamespace) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsNamespace(aIsNamespace); } \
  NS_SCRIPTABLE NS_IMETHOD GetCanOpenFolder(PRBool *aCanOpenFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanOpenFolder(aCanOpenFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetAdminUrl(nsACString & aAdminUrl) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAdminUrl(aAdminUrl); } \
  NS_SCRIPTABLE NS_IMETHOD SetAdminUrl(const nsACString & aAdminUrl) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAdminUrl(aAdminUrl); } \
  NS_SCRIPTABLE NS_IMETHOD GetHasAdminUrl(PRBool *aHasAdminUrl) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHasAdminUrl(aHasAdminUrl); } \
  NS_SCRIPTABLE NS_IMETHOD GetPerformingBiff(PRBool *aPerformingBiff) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPerformingBiff(aPerformingBiff); } \
  NS_SCRIPTABLE NS_IMETHOD SetPerformingBiff(PRBool aPerformingBiff) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPerformingBiff(aPerformingBiff); } \
  NS_SCRIPTABLE NS_IMETHOD GetHdrParser(nsIMsgParseMailMsgState **aHdrParser) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHdrParser(aHdrParser); } \
  NS_SCRIPTABLE NS_IMETHOD GetImapIncomingServer(nsIImapIncomingServer **aImapIncomingServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetImapIncomingServer(aImapIncomingServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetAutoSyncStateObj(nsIAutoSyncState **aAutoSyncStateObj) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAutoSyncStateObj(aAutoSyncStateObj); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerTotal(PRInt32 *aServerTotal) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServerTotal(aServerTotal); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerUnseen(PRInt32 *aServerUnseen) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServerUnseen(aServerUnseen); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerRecent(PRInt32 *aServerRecent) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServerRecent(aServerRecent); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerNextUID(PRInt32 *aServerNextUID) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServerNextUID(aServerNextUID); } \
  NS_SCRIPTABLE NS_IMETHOD GetQuota(PRBool *valid NS_OUTPARAM, PRUint32 *usedKB NS_OUTPARAM, PRUint32 *maxKB NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetQuota(valid, usedKB, maxKB); } \
  NS_SCRIPTABLE NS_IMETHOD GetOtherUsersWithAccess(nsIUTF8StringEnumerator **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOtherUsersWithAccess(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetPermissionsForUser(const nsACString & username, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPermissionsForUser(username, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ChangePendingTotal(PRInt32 aDelta) { return !_to ? NS_ERROR_NULL_POINTER : _to->ChangePendingTotal(aDelta); } \
  NS_SCRIPTABLE NS_IMETHOD ChangePendingUnread(PRInt32 aDelta) { return !_to ? NS_ERROR_NULL_POINTER : _to->ChangePendingUnread(aDelta); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgImapMailFolder : public nsIMsgImapMailFolder
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGIMAPMAILFOLDER

  nsMsgImapMailFolder();

private:
  ~nsMsgImapMailFolder();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgImapMailFolder, nsIMsgImapMailFolder)

nsMsgImapMailFolder::nsMsgImapMailFolder()
{
  /* member initializers and constructor code */
}

nsMsgImapMailFolder::~nsMsgImapMailFolder()
{
  /* destructor code */
}

/* void removeSubFolder (in nsIMsgFolder folder); */
NS_IMETHODIMP nsMsgImapMailFolder::RemoveSubFolder(nsIMsgFolder *folder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createClientSubfolderInfo (in ACString folderName, in char hierarchyDelimiter, in long flags, in boolean suppressNotification); */
NS_IMETHODIMP nsMsgImapMailFolder::CreateClientSubfolderInfo(const nsACString & folderName, char hierarchyDelimiter, PRInt32 flags, PRBool suppressNotification)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void list (); */
NS_IMETHODIMP nsMsgImapMailFolder::List()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void renameLocal (in ACString newname, in nsIMsgFolder parent); */
NS_IMETHODIMP nsMsgImapMailFolder::RenameLocal(const nsACString & newname, nsIMsgFolder *parent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void prepareToRename (); */
NS_IMETHODIMP nsMsgImapMailFolder::PrepareToRename()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void performExpand (in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgImapMailFolder::PerformExpand(nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void recursiveCloseActiveConnections (in nsIImapIncomingServer aImapServer); */
NS_IMETHODIMP nsMsgImapMailFolder::RecursiveCloseActiveConnections(nsIImapIncomingServer *aImapServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void renameClient (in nsIMsgWindow msgWindow, in nsIMsgFolder msgFolder, in ACString oldName, in ACString newName); */
NS_IMETHODIMP nsMsgImapMailFolder::RenameClient(nsIMsgWindow *msgWindow, nsIMsgFolder *msgFolder, const nsACString & oldName, const nsACString & newName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void storeImapFlags (in long aFlags, in boolean aAddFlags, [array, size_is (aNumKeys)] in nsMsgKey aKeysToFlag, in unsigned long aNumKeys, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsMsgImapMailFolder::StoreImapFlags(PRInt32 aFlags, PRBool aAddFlags, nsMsgKey *aKeysToFlag, PRUint32 aNumKeys, nsIUrlListener *aUrlListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI setImapFlags (in string uids, in long flags); */
NS_IMETHODIMP nsMsgImapMailFolder::SetImapFlags(const char *uids, PRInt32 flags, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void replayOfflineMoveCopy ([array, size_is (numKeys)] in nsMsgKey keys, in unsigned long numKeys, in boolean isMove, in nsIMsgFolder aDstFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aWindow); */
NS_IMETHODIMP nsMsgImapMailFolder::ReplayOfflineMoveCopy(nsMsgKey *keys, PRUint32 numKeys, PRBool isMove, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI playbackOfflineFolderCreate (in AString folderName, in nsIMsgWindow aWindow); */
NS_IMETHODIMP nsMsgImapMailFolder::PlaybackOfflineFolderCreate(const nsAString & folderName, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addMoveResultPseudoKey (in nsMsgKey aMsgKey); */
NS_IMETHODIMP nsMsgImapMailFolder::AddMoveResultPseudoKey(nsMsgKey aMsgKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void liteSelect (in nsIUrlListener aUrlListener, in nsIMsgWindow aWindow); */
NS_IMETHODIMP nsMsgImapMailFolder::LiteSelect(nsIUrlListener *aUrlListener, nsIMsgWindow *aWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void fillInFolderProps (in nsIMsgImapFolderProps aFolderProps); */
NS_IMETHODIMP nsMsgImapMailFolder::FillInFolderProps(nsIMsgImapFolderProps *aFolderProps)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void resetNamespaceReferences (); */
NS_IMETHODIMP nsMsgImapMailFolder::ResetNamespaceReferences()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void folderPrivileges (in nsIMsgWindow aWindow); */
NS_IMETHODIMP nsMsgImapMailFolder::FolderPrivileges(nsIMsgWindow *aWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgImapMailFolder findOnlineSubFolder (in ACString onlineName); */
NS_IMETHODIMP nsMsgImapMailFolder::FindOnlineSubFolder(const nsACString & onlineName, nsIMsgImapMailFolder **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addFolderRights (in ACString userName, in ACString rights); */
NS_IMETHODIMP nsMsgImapMailFolder::AddFolderRights(const nsACString & userName, const nsACString & rights)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void refreshFolderRights (); */
NS_IMETHODIMP nsMsgImapMailFolder::RefreshFolderRights()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void markPendingRemoval (in nsIMsgDBHdr aHdr, in boolean aMark); */
NS_IMETHODIMP nsMsgImapMailFolder::MarkPendingRemoval(nsIMsgDBHdr *aHdr, PRBool aMark)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void expunge (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgImapMailFolder::Expunge(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void updateStatus (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgImapMailFolder::UpdateStatus(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void updateFolderWithListener (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
NS_IMETHODIMP nsMsgImapMailFolder::UpdateFolderWithListener(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI issueCommandOnMsgs (in ACString command, in string uids, in nsIMsgWindow aWindow); */
NS_IMETHODIMP nsMsgImapMailFolder::IssueCommandOnMsgs(const nsACString & command, const char *uids, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI fetchCustomMsgAttribute (in ACString msgAttribute, in string uids, in nsIMsgWindow aWindow); */
NS_IMETHODIMP nsMsgImapMailFolder::FetchCustomMsgAttribute(const nsACString & msgAttribute, const char *uids, nsIMsgWindow *aWindow, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI storeCustomKeywords (in nsIMsgWindow aMsgWindow, in ACString aFlagsToAdd, in ACString aFlagsToSubtract, [array, size_is (aNumKeys)] in nsMsgKey aKeysToStore, in unsigned long aNumKeys); */
NS_IMETHODIMP nsMsgImapMailFolder::StoreCustomKeywords(nsIMsgWindow *aMsgWindow, const nsACString & aFlagsToAdd, const nsACString & aFlagsToSubtract, nsMsgKey *aKeysToStore, PRUint32 aNumKeys, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void notifyIfNewMail (); */
NS_IMETHODIMP nsMsgImapMailFolder::NotifyIfNewMail()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void initiateAutoSync (in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsMsgImapMailFolder::InitiateAutoSync(nsIUrlListener *aUrlListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean verifiedAsOnlineFolder; */
NS_IMETHODIMP nsMsgImapMailFolder::GetVerifiedAsOnlineFolder(PRBool *aVerifiedAsOnlineFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgImapMailFolder::SetVerifiedAsOnlineFolder(PRBool aVerifiedAsOnlineFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean explicitlyVerify; */
NS_IMETHODIMP nsMsgImapMailFolder::GetExplicitlyVerify(PRBool *aExplicitlyVerify)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgImapMailFolder::SetExplicitlyVerify(PRBool aExplicitlyVerify)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute char hierarchyDelimiter; */
NS_IMETHODIMP nsMsgImapMailFolder::GetHierarchyDelimiter(char *aHierarchyDelimiter)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgImapMailFolder::SetHierarchyDelimiter(char aHierarchyDelimiter)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long boxFlags; */
NS_IMETHODIMP nsMsgImapMailFolder::GetBoxFlags(PRInt32 *aBoxFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgImapMailFolder::SetBoxFlags(PRInt32 aBoxFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString onlineName; */
NS_IMETHODIMP nsMsgImapMailFolder::GetOnlineName(nsACString & aOnlineName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgImapMailFolder::SetOnlineName(const nsACString & aOnlineName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean isNamespace; */
NS_IMETHODIMP nsMsgImapMailFolder::GetIsNamespace(PRBool *aIsNamespace)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgImapMailFolder::SetIsNamespace(PRBool aIsNamespace)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canOpenFolder; */
NS_IMETHODIMP nsMsgImapMailFolder::GetCanOpenFolder(PRBool *aCanOpenFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString adminUrl; */
NS_IMETHODIMP nsMsgImapMailFolder::GetAdminUrl(nsACString & aAdminUrl)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgImapMailFolder::SetAdminUrl(const nsACString & aAdminUrl)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean hasAdminUrl; */
NS_IMETHODIMP nsMsgImapMailFolder::GetHasAdminUrl(PRBool *aHasAdminUrl)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean performingBiff; */
NS_IMETHODIMP nsMsgImapMailFolder::GetPerformingBiff(PRBool *aPerformingBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgImapMailFolder::SetPerformingBiff(PRBool aPerformingBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIMsgParseMailMsgState hdrParser; */
NS_IMETHODIMP nsMsgImapMailFolder::GetHdrParser(nsIMsgParseMailMsgState **aHdrParser)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIImapIncomingServer imapIncomingServer; */
NS_IMETHODIMP nsMsgImapMailFolder::GetImapIncomingServer(nsIImapIncomingServer **aImapIncomingServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAutoSyncState autoSyncStateObj; */
NS_IMETHODIMP nsMsgImapMailFolder::GetAutoSyncStateObj(nsIAutoSyncState **aAutoSyncStateObj)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long serverTotal; */
NS_IMETHODIMP nsMsgImapMailFolder::GetServerTotal(PRInt32 *aServerTotal)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long serverUnseen; */
NS_IMETHODIMP nsMsgImapMailFolder::GetServerUnseen(PRInt32 *aServerUnseen)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long serverRecent; */
NS_IMETHODIMP nsMsgImapMailFolder::GetServerRecent(PRInt32 *aServerRecent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long serverNextUID; */
NS_IMETHODIMP nsMsgImapMailFolder::GetServerNextUID(PRInt32 *aServerNextUID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getQuota (out boolean valid, out unsigned long usedKB, out unsigned long maxKB); */
NS_IMETHODIMP nsMsgImapMailFolder::GetQuota(PRBool *valid NS_OUTPARAM, PRUint32 *usedKB NS_OUTPARAM, PRUint32 *maxKB NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIUTF8StringEnumerator getOtherUsersWithAccess (); */
NS_IMETHODIMP nsMsgImapMailFolder::GetOtherUsersWithAccess(nsIUTF8StringEnumerator **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getPermissionsForUser (in ACString username); */
NS_IMETHODIMP nsMsgImapMailFolder::GetPermissionsForUser(const nsACString & username, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void changePendingTotal (in long aDelta); */
NS_IMETHODIMP nsMsgImapMailFolder::ChangePendingTotal(PRInt32 aDelta)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void changePendingUnread (in long aDelta); */
NS_IMETHODIMP nsMsgImapMailFolder::ChangePendingUnread(PRInt32 aDelta)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMsgImapMailFolder_h__ */
