/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsISmtpServer.idl
 */

#ifndef __gen_nsISmtpServer_h__
#define __gen_nsISmtpServer_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_MailNewsTypes2_h__
#include "MailNewsTypes2.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIAuthPrompt; /* forward declaration */

class nsIUrlListener; /* forward declaration */

class nsIURI; /* forward declaration */

class nsIMsgWindow; /* forward declaration */


/* starting interface:    nsISmtpServer */
#define NS_ISMTPSERVER_IID_STR "a53dce6c-cd81-495c-83bc-45a65df1f08e"

#define NS_ISMTPSERVER_IID \
  {0xa53dce6c, 0xcd81, 0x495c, \
    { 0x83, 0xbc, 0x45, 0xa6, 0x5d, 0xf1, 0xf0, 0x8e }}

/**
 * This interface represents a single SMTP Server. A SMTP server instance may be
 * created/obtained from nsIMsgAccountManager.
 *
 * Most of the attributes will set/get preferences from the main preferences
 * file.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsISmtpServer : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ISMTPSERVER_IID)

  /* attribute string key; */
  NS_SCRIPTABLE NS_IMETHOD GetKey(char **aKey) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetKey(const char *aKey) = 0;

  /* attribute AUTF8String description; */
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsACString & aDescription) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsACString & aDescription) = 0;

  /* attribute ACString hostname; */
  NS_SCRIPTABLE NS_IMETHOD GetHostname(nsACString & aHostname) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetHostname(const nsACString & aHostname) = 0;

  /* attribute PRInt32 port; */
  NS_SCRIPTABLE NS_IMETHOD GetPort(PRInt32 *aPort) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetPort(PRInt32 aPort) = 0;

  /* attribute ACString username; */
  NS_SCRIPTABLE NS_IMETHOD GetUsername(nsACString & aUsername) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetUsername(const nsACString & aUsername) = 0;

  /**
   * The password to access the server with (if required).
   *
   * @note this is stored within the server instance but not within preferences.
   * It can be specified/saved here to avoid prompting the user constantly for
   * the sending password.
   */
  /* attribute ACString password; */
  NS_SCRIPTABLE NS_IMETHOD GetPassword(nsACString & aPassword) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetPassword(const nsACString & aPassword) = 0;

  /* readonly attribute string displayname; */
  NS_SCRIPTABLE NS_IMETHOD GetDisplayname(char **aDisplayname) = 0;

  /**
   * Authentication mechanism.
   *
   * @see nsMsgAuthMethod (in MailNewsTypes2.idl)
   * Same as "mail.smtpserver...authMethod" pref
   *
   * Compatibility note: This attribute had a different meaning in TB < 3.1
   */
  /* attribute nsMsgAuthMethodValue authMethod; */
  NS_SCRIPTABLE NS_IMETHOD GetAuthMethod(nsMsgAuthMethodValue *aAuthMethod) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetAuthMethod(nsMsgAuthMethodValue aAuthMethod) = 0;

  /**
   * Whether to SSL or STARTTLS or not
   *
   * @see nsMsgSocketType (in MailNewsTypes2.idl)
   * Same as "mail.smtpserver...try_ssl" pref
   */
  /* attribute nsMsgSocketTypeValue socketType; */
  NS_SCRIPTABLE NS_IMETHOD GetSocketType(nsMsgSocketTypeValue *aSocketType) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetSocketType(nsMsgSocketTypeValue aSocketType) = 0;

  /**
   * May contain an alternative argument to EHLO or HELO to provide to the
   * server. Reflects the value of the mail.smtpserver.*.hello_argument pref.
   * This is mainly useful where ISPs don't bother providing PTR records for
   * their servers and therefore users get an error on sending. See bug 244030
   * for more discussion.
   */
  /* readonly attribute string helloArgument; */
  NS_SCRIPTABLE NS_IMETHOD GetHelloArgument(char **aHelloArgument) = 0;

  /* readonly attribute ACString serverURI; */
  NS_SCRIPTABLE NS_IMETHOD GetServerURI(nsACString & aServerURI) = 0;

  /**
   * Gets a password for this server, using a UI prompt if necessary.
   *
   * @param promptString  The string to prompt the user with when asking for
   *                      the password.
   * @param promptTitle   The title of the prompt.
   * @param netPrompt     An nsIAuthPrompt instance to use for the password
   *                      prompt.
   * @return              The password to use (may be null if no password was
   *                      obtained).
   */
  /* ACString getPasswordWithUI (in wstring promptString, in wstring promptTitle, in nsIAuthPrompt netPrompt); */
  NS_SCRIPTABLE NS_IMETHOD GetPasswordWithUI(const PRUnichar *promptString, const PRUnichar *promptTitle, nsIAuthPrompt *netPrompt, nsACString & _retval NS_OUTPARAM) = 0;

  /**
   * Gets a username and password for this server, using a UI prompt if
   * necessary.
   *
   * @param promptString  The string to prompt the user with when asking for
   *                      the password.
   * @param promptTitle   The title of the prompt.
   * @param netPrompt     An nsIAuthPrompt instance to use for the password
   *                      prompt.
   * @param userid        The username to use (may be null if no password was
   *                      obtained).
   * @param password      The password to use (may be empty if no password was
   *                      obtained).
   */
  /* void getUsernamePasswordWithUI (in wstring promptString, in wstring promptTitle, in nsIAuthPrompt netPrompt, out ACString userid, out ACString password); */
  NS_SCRIPTABLE NS_IMETHOD GetUsernamePasswordWithUI(const PRUnichar *promptString, const PRUnichar *promptTitle, nsIAuthPrompt *netPrompt, nsACString & userid NS_OUTPARAM, nsACString & password NS_OUTPARAM) = 0;

  /**
   * Calling this will *remove* the saved password for this server from the
   * password manager and from the stored value.
   */
  /* void forgetPassword (); */
  NS_SCRIPTABLE NS_IMETHOD ForgetPassword(void) = 0;

  /**
   * Verify that we can logon 
   * 
   * @param  aPassword - password to use
   * @param  aUrlListener - gets called back with success or failure.
   * @return - the url that we run.
   *
   */
  /* nsIURI verifyLogon (in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) = 0;

  /* void clearAllValues (); */
  NS_SCRIPTABLE NS_IMETHOD ClearAllValues(void) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsISmtpServer, NS_ISMTPSERVER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISMTPSERVER \
  NS_SCRIPTABLE NS_IMETHOD GetKey(char **aKey); \
  NS_SCRIPTABLE NS_IMETHOD SetKey(const char *aKey); \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsACString & aDescription); \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsACString & aDescription); \
  NS_SCRIPTABLE NS_IMETHOD GetHostname(nsACString & aHostname); \
  NS_SCRIPTABLE NS_IMETHOD SetHostname(const nsACString & aHostname); \
  NS_SCRIPTABLE NS_IMETHOD GetPort(PRInt32 *aPort); \
  NS_SCRIPTABLE NS_IMETHOD SetPort(PRInt32 aPort); \
  NS_SCRIPTABLE NS_IMETHOD GetUsername(nsACString & aUsername); \
  NS_SCRIPTABLE NS_IMETHOD SetUsername(const nsACString & aUsername); \
  NS_SCRIPTABLE NS_IMETHOD GetPassword(nsACString & aPassword); \
  NS_SCRIPTABLE NS_IMETHOD SetPassword(const nsACString & aPassword); \
  NS_SCRIPTABLE NS_IMETHOD GetDisplayname(char **aDisplayname); \
  NS_SCRIPTABLE NS_IMETHOD GetAuthMethod(nsMsgAuthMethodValue *aAuthMethod); \
  NS_SCRIPTABLE NS_IMETHOD SetAuthMethod(nsMsgAuthMethodValue aAuthMethod); \
  NS_SCRIPTABLE NS_IMETHOD GetSocketType(nsMsgSocketTypeValue *aSocketType); \
  NS_SCRIPTABLE NS_IMETHOD SetSocketType(nsMsgSocketTypeValue aSocketType); \
  NS_SCRIPTABLE NS_IMETHOD GetHelloArgument(char **aHelloArgument); \
  NS_SCRIPTABLE NS_IMETHOD GetServerURI(nsACString & aServerURI); \
  NS_SCRIPTABLE NS_IMETHOD GetPasswordWithUI(const PRUnichar *promptString, const PRUnichar *promptTitle, nsIAuthPrompt *netPrompt, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetUsernamePasswordWithUI(const PRUnichar *promptString, const PRUnichar *promptTitle, nsIAuthPrompt *netPrompt, nsACString & userid NS_OUTPARAM, nsACString & password NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ForgetPassword(void); \
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ClearAllValues(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISMTPSERVER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetKey(char **aKey) { return _to GetKey(aKey); } \
  NS_SCRIPTABLE NS_IMETHOD SetKey(const char *aKey) { return _to SetKey(aKey); } \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsACString & aDescription) { return _to GetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsACString & aDescription) { return _to SetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD GetHostname(nsACString & aHostname) { return _to GetHostname(aHostname); } \
  NS_SCRIPTABLE NS_IMETHOD SetHostname(const nsACString & aHostname) { return _to SetHostname(aHostname); } \
  NS_SCRIPTABLE NS_IMETHOD GetPort(PRInt32 *aPort) { return _to GetPort(aPort); } \
  NS_SCRIPTABLE NS_IMETHOD SetPort(PRInt32 aPort) { return _to SetPort(aPort); } \
  NS_SCRIPTABLE NS_IMETHOD GetUsername(nsACString & aUsername) { return _to GetUsername(aUsername); } \
  NS_SCRIPTABLE NS_IMETHOD SetUsername(const nsACString & aUsername) { return _to SetUsername(aUsername); } \
  NS_SCRIPTABLE NS_IMETHOD GetPassword(nsACString & aPassword) { return _to GetPassword(aPassword); } \
  NS_SCRIPTABLE NS_IMETHOD SetPassword(const nsACString & aPassword) { return _to SetPassword(aPassword); } \
  NS_SCRIPTABLE NS_IMETHOD GetDisplayname(char **aDisplayname) { return _to GetDisplayname(aDisplayname); } \
  NS_SCRIPTABLE NS_IMETHOD GetAuthMethod(nsMsgAuthMethodValue *aAuthMethod) { return _to GetAuthMethod(aAuthMethod); } \
  NS_SCRIPTABLE NS_IMETHOD SetAuthMethod(nsMsgAuthMethodValue aAuthMethod) { return _to SetAuthMethod(aAuthMethod); } \
  NS_SCRIPTABLE NS_IMETHOD GetSocketType(nsMsgSocketTypeValue *aSocketType) { return _to GetSocketType(aSocketType); } \
  NS_SCRIPTABLE NS_IMETHOD SetSocketType(nsMsgSocketTypeValue aSocketType) { return _to SetSocketType(aSocketType); } \
  NS_SCRIPTABLE NS_IMETHOD GetHelloArgument(char **aHelloArgument) { return _to GetHelloArgument(aHelloArgument); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerURI(nsACString & aServerURI) { return _to GetServerURI(aServerURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetPasswordWithUI(const PRUnichar *promptString, const PRUnichar *promptTitle, nsIAuthPrompt *netPrompt, nsACString & _retval NS_OUTPARAM) { return _to GetPasswordWithUI(promptString, promptTitle, netPrompt, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetUsernamePasswordWithUI(const PRUnichar *promptString, const PRUnichar *promptTitle, nsIAuthPrompt *netPrompt, nsACString & userid NS_OUTPARAM, nsACString & password NS_OUTPARAM) { return _to GetUsernamePasswordWithUI(promptString, promptTitle, netPrompt, userid, password); } \
  NS_SCRIPTABLE NS_IMETHOD ForgetPassword(void) { return _to ForgetPassword(); } \
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) { return _to VerifyLogon(aUrlListener, aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ClearAllValues(void) { return _to ClearAllValues(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISMTPSERVER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetKey(char **aKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetKey(aKey); } \
  NS_SCRIPTABLE NS_IMETHOD SetKey(const char *aKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetKey(aKey); } \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsACString & aDescription) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsACString & aDescription) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD GetHostname(nsACString & aHostname) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHostname(aHostname); } \
  NS_SCRIPTABLE NS_IMETHOD SetHostname(const nsACString & aHostname) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHostname(aHostname); } \
  NS_SCRIPTABLE NS_IMETHOD GetPort(PRInt32 *aPort) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPort(aPort); } \
  NS_SCRIPTABLE NS_IMETHOD SetPort(PRInt32 aPort) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPort(aPort); } \
  NS_SCRIPTABLE NS_IMETHOD GetUsername(nsACString & aUsername) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUsername(aUsername); } \
  NS_SCRIPTABLE NS_IMETHOD SetUsername(const nsACString & aUsername) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUsername(aUsername); } \
  NS_SCRIPTABLE NS_IMETHOD GetPassword(nsACString & aPassword) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPassword(aPassword); } \
  NS_SCRIPTABLE NS_IMETHOD SetPassword(const nsACString & aPassword) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPassword(aPassword); } \
  NS_SCRIPTABLE NS_IMETHOD GetDisplayname(char **aDisplayname) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDisplayname(aDisplayname); } \
  NS_SCRIPTABLE NS_IMETHOD GetAuthMethod(nsMsgAuthMethodValue *aAuthMethod) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAuthMethod(aAuthMethod); } \
  NS_SCRIPTABLE NS_IMETHOD SetAuthMethod(nsMsgAuthMethodValue aAuthMethod) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAuthMethod(aAuthMethod); } \
  NS_SCRIPTABLE NS_IMETHOD GetSocketType(nsMsgSocketTypeValue *aSocketType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSocketType(aSocketType); } \
  NS_SCRIPTABLE NS_IMETHOD SetSocketType(nsMsgSocketTypeValue aSocketType) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSocketType(aSocketType); } \
  NS_SCRIPTABLE NS_IMETHOD GetHelloArgument(char **aHelloArgument) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHelloArgument(aHelloArgument); } \
  NS_SCRIPTABLE NS_IMETHOD GetServerURI(nsACString & aServerURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServerURI(aServerURI); } \
  NS_SCRIPTABLE NS_IMETHOD GetPasswordWithUI(const PRUnichar *promptString, const PRUnichar *promptTitle, nsIAuthPrompt *netPrompt, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPasswordWithUI(promptString, promptTitle, netPrompt, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetUsernamePasswordWithUI(const PRUnichar *promptString, const PRUnichar *promptTitle, nsIAuthPrompt *netPrompt, nsACString & userid NS_OUTPARAM, nsACString & password NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUsernamePasswordWithUI(promptString, promptTitle, netPrompt, userid, password); } \
  NS_SCRIPTABLE NS_IMETHOD ForgetPassword(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ForgetPassword(); } \
  NS_SCRIPTABLE NS_IMETHOD VerifyLogon(nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->VerifyLogon(aUrlListener, aMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ClearAllValues(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearAllValues(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsSmtpServer : public nsISmtpServer
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISMTPSERVER

  nsSmtpServer();

private:
  ~nsSmtpServer();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsSmtpServer, nsISmtpServer)

nsSmtpServer::nsSmtpServer()
{
  /* member initializers and constructor code */
}

nsSmtpServer::~nsSmtpServer()
{
  /* destructor code */
}

/* attribute string key; */
NS_IMETHODIMP nsSmtpServer::GetKey(char **aKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSmtpServer::SetKey(const char *aKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AUTF8String description; */
NS_IMETHODIMP nsSmtpServer::GetDescription(nsACString & aDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSmtpServer::SetDescription(const nsACString & aDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString hostname; */
NS_IMETHODIMP nsSmtpServer::GetHostname(nsACString & aHostname)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSmtpServer::SetHostname(const nsACString & aHostname)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute PRInt32 port; */
NS_IMETHODIMP nsSmtpServer::GetPort(PRInt32 *aPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSmtpServer::SetPort(PRInt32 aPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString username; */
NS_IMETHODIMP nsSmtpServer::GetUsername(nsACString & aUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSmtpServer::SetUsername(const nsACString & aUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString password; */
NS_IMETHODIMP nsSmtpServer::GetPassword(nsACString & aPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSmtpServer::SetPassword(const nsACString & aPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string displayname; */
NS_IMETHODIMP nsSmtpServer::GetDisplayname(char **aDisplayname)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsMsgAuthMethodValue authMethod; */
NS_IMETHODIMP nsSmtpServer::GetAuthMethod(nsMsgAuthMethodValue *aAuthMethod)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSmtpServer::SetAuthMethod(nsMsgAuthMethodValue aAuthMethod)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsMsgSocketTypeValue socketType; */
NS_IMETHODIMP nsSmtpServer::GetSocketType(nsMsgSocketTypeValue *aSocketType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSmtpServer::SetSocketType(nsMsgSocketTypeValue aSocketType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string helloArgument; */
NS_IMETHODIMP nsSmtpServer::GetHelloArgument(char **aHelloArgument)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString serverURI; */
NS_IMETHODIMP nsSmtpServer::GetServerURI(nsACString & aServerURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getPasswordWithUI (in wstring promptString, in wstring promptTitle, in nsIAuthPrompt netPrompt); */
NS_IMETHODIMP nsSmtpServer::GetPasswordWithUI(const PRUnichar *promptString, const PRUnichar *promptTitle, nsIAuthPrompt *netPrompt, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getUsernamePasswordWithUI (in wstring promptString, in wstring promptTitle, in nsIAuthPrompt netPrompt, out ACString userid, out ACString password); */
NS_IMETHODIMP nsSmtpServer::GetUsernamePasswordWithUI(const PRUnichar *promptString, const PRUnichar *promptTitle, nsIAuthPrompt *netPrompt, nsACString & userid NS_OUTPARAM, nsACString & password NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void forgetPassword (); */
NS_IMETHODIMP nsSmtpServer::ForgetPassword()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI verifyLogon (in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsSmtpServer::VerifyLogon(nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void clearAllValues (); */
NS_IMETHODIMP nsSmtpServer::ClearAllValues()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsISmtpServer_h__ */
