/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsISuiteProfileMigrator.idl
 */

#ifndef __gen_nsISuiteProfileMigrator_h__
#define __gen_nsISuiteProfileMigrator_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIArray; /* forward declaration */

class nsIProfileStartup; /* forward declaration */


/* starting interface:    nsISuiteProfileMigrator */
#define NS_ISUITEPROFILEMIGRATOR_IID_STR "b6adb2b8-5e3b-4fdd-b085-d58998b5c21a"

#define NS_ISUITEPROFILEMIGRATOR_IID \
  {0xb6adb2b8, 0x5e3b, 0x4fdd, \
    { 0xb0, 0x85, 0xd5, 0x89, 0x98, 0xb5, 0xc2, 0x1a }}

class NS_NO_VTABLE NS_SCRIPTABLE nsISuiteProfileMigrator : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ISUITEPROFILEMIGRATOR_IID)

  /**
   * profile items to migrate. use with migrate().
   */
  enum { SETTINGS = 1U };

  enum { COOKIES = 2U };

  enum { HISTORY = 4U };

  enum { HOMEPAGEDATA = 8U };

  enum { PASSWORDS = 16U };

  enum { BOOKMARKS = 32U };

  enum { OTHERDATA = 64U };

  enum { ACCOUNT_SETTINGS = 128U };

  enum { ADDRESSBOOK_DATA = 256U };

  enum { JUNKTRAINING = 512U };

  enum { NEWSDATA = 1024U };

  enum { MAILDATA = 2048U };

  enum { ALL = 4095U };

  /**
   * Copy user profile information to the current active profile.
   *
   * @param aItems   list of data items to migrate. see above for values.
   * @param aReplace replace or append current data where applicable. 
   * @param aProfile profile to migrate from, if there is more than one.
   */
  /* void migrate (in unsigned short aItems, in nsIProfileStartup aStartup, in wstring aProfile); */
  NS_SCRIPTABLE NS_IMETHOD Migrate(PRUint16 aItems, nsIProfileStartup *aStartup, const PRUnichar *aProfile) = 0;

  /**
   * A bit field containing profile items that this migrator is able
   * to import for a specified source profile.
   *
   * @param   aProfile the profile that we are looking for available data
   *          to import
   * @param   aStarting "true" if the profile is not currently being used.
   * @returns bit field containing profile items (see above)
   */
  /* unsigned short getMigrateData (in wstring aProfile, in boolean aDoingStartup); */
  NS_SCRIPTABLE NS_IMETHOD GetMigrateData(const PRUnichar *aProfile, PRBool aDoingStartup, PRUint16 *_retval NS_OUTPARAM) = 0;

  /**
   * A bit field containing profile items that this migrator may be able
   * to import for any source profile of its type.
   */
  /* readonly attribute unsigned short supportedItems; */
  NS_SCRIPTABLE NS_IMETHOD GetSupportedItems(PRUint16 *aSupportedItems) = 0;

  /**
   * Whether or not there is any data that can be imported from this
   * browser (i.e. whether or not it is installed, and there exists
   * a user profile)
   */
  /* readonly attribute boolean sourceExists; */
  NS_SCRIPTABLE NS_IMETHOD GetSourceExists(PRBool *aSourceExists) = 0;

  /**
   * Whether or not the import source implementing this interface
   * has multiple user profiles configured.
   */
  /* readonly attribute boolean sourceHasMultipleProfiles; */
  NS_SCRIPTABLE NS_IMETHOD GetSourceHasMultipleProfiles(PRBool *aSourceHasMultipleProfiles) = 0;

  /**
   * An enumeration of available profiles. If the import source does
   * not support profiles, this attribute is null.
   */
  /* readonly attribute nsIArray sourceProfiles; */
  NS_SCRIPTABLE NS_IMETHOD GetSourceProfiles(nsIArray **aSourceProfiles) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsISuiteProfileMigrator, NS_ISUITEPROFILEMIGRATOR_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISUITEPROFILEMIGRATOR \
  NS_SCRIPTABLE NS_IMETHOD Migrate(PRUint16 aItems, nsIProfileStartup *aStartup, const PRUnichar *aProfile); \
  NS_SCRIPTABLE NS_IMETHOD GetMigrateData(const PRUnichar *aProfile, PRBool aDoingStartup, PRUint16 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetSupportedItems(PRUint16 *aSupportedItems); \
  NS_SCRIPTABLE NS_IMETHOD GetSourceExists(PRBool *aSourceExists); \
  NS_SCRIPTABLE NS_IMETHOD GetSourceHasMultipleProfiles(PRBool *aSourceHasMultipleProfiles); \
  NS_SCRIPTABLE NS_IMETHOD GetSourceProfiles(nsIArray **aSourceProfiles); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISUITEPROFILEMIGRATOR(_to) \
  NS_SCRIPTABLE NS_IMETHOD Migrate(PRUint16 aItems, nsIProfileStartup *aStartup, const PRUnichar *aProfile) { return _to Migrate(aItems, aStartup, aProfile); } \
  NS_SCRIPTABLE NS_IMETHOD GetMigrateData(const PRUnichar *aProfile, PRBool aDoingStartup, PRUint16 *_retval NS_OUTPARAM) { return _to GetMigrateData(aProfile, aDoingStartup, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSupportedItems(PRUint16 *aSupportedItems) { return _to GetSupportedItems(aSupportedItems); } \
  NS_SCRIPTABLE NS_IMETHOD GetSourceExists(PRBool *aSourceExists) { return _to GetSourceExists(aSourceExists); } \
  NS_SCRIPTABLE NS_IMETHOD GetSourceHasMultipleProfiles(PRBool *aSourceHasMultipleProfiles) { return _to GetSourceHasMultipleProfiles(aSourceHasMultipleProfiles); } \
  NS_SCRIPTABLE NS_IMETHOD GetSourceProfiles(nsIArray **aSourceProfiles) { return _to GetSourceProfiles(aSourceProfiles); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISUITEPROFILEMIGRATOR(_to) \
  NS_SCRIPTABLE NS_IMETHOD Migrate(PRUint16 aItems, nsIProfileStartup *aStartup, const PRUnichar *aProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->Migrate(aItems, aStartup, aProfile); } \
  NS_SCRIPTABLE NS_IMETHOD GetMigrateData(const PRUnichar *aProfile, PRBool aDoingStartup, PRUint16 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMigrateData(aProfile, aDoingStartup, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetSupportedItems(PRUint16 *aSupportedItems) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSupportedItems(aSupportedItems); } \
  NS_SCRIPTABLE NS_IMETHOD GetSourceExists(PRBool *aSourceExists) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSourceExists(aSourceExists); } \
  NS_SCRIPTABLE NS_IMETHOD GetSourceHasMultipleProfiles(PRBool *aSourceHasMultipleProfiles) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSourceHasMultipleProfiles(aSourceHasMultipleProfiles); } \
  NS_SCRIPTABLE NS_IMETHOD GetSourceProfiles(nsIArray **aSourceProfiles) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSourceProfiles(aSourceProfiles); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsSuiteProfileMigrator : public nsISuiteProfileMigrator
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISUITEPROFILEMIGRATOR

  nsSuiteProfileMigrator();

private:
  ~nsSuiteProfileMigrator();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsSuiteProfileMigrator, nsISuiteProfileMigrator)

nsSuiteProfileMigrator::nsSuiteProfileMigrator()
{
  /* member initializers and constructor code */
}

nsSuiteProfileMigrator::~nsSuiteProfileMigrator()
{
  /* destructor code */
}

/* void migrate (in unsigned short aItems, in nsIProfileStartup aStartup, in wstring aProfile); */
NS_IMETHODIMP nsSuiteProfileMigrator::Migrate(PRUint16 aItems, nsIProfileStartup *aStartup, const PRUnichar *aProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned short getMigrateData (in wstring aProfile, in boolean aDoingStartup); */
NS_IMETHODIMP nsSuiteProfileMigrator::GetMigrateData(const PRUnichar *aProfile, PRBool aDoingStartup, PRUint16 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned short supportedItems; */
NS_IMETHODIMP nsSuiteProfileMigrator::GetSupportedItems(PRUint16 *aSupportedItems)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean sourceExists; */
NS_IMETHODIMP nsSuiteProfileMigrator::GetSourceExists(PRBool *aSourceExists)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean sourceHasMultipleProfiles; */
NS_IMETHODIMP nsSuiteProfileMigrator::GetSourceHasMultipleProfiles(PRBool *aSourceHasMultipleProfiles)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIArray sourceProfiles; */
NS_IMETHODIMP nsSuiteProfileMigrator::GetSourceProfiles(nsIArray **aSourceProfiles)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsISuiteProfileMigrator_h__ */
