/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM smileIApplication.idl
 */

#ifndef __gen_smileIApplication_h__
#define __gen_smileIApplication_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_extIApplication_h__
#include "extIApplication.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIVariant; /* forward declaration */

class nsIURI; /* forward declaration */

class nsIDOMHTMLDocument; /* forward declaration */

class smileIBookmarkFolder; /* forward declaration */

class smileIBrowserTab; /* forward declaration */


/* starting interface:    smileIAnnotations */
#define SMILEIANNOTATIONS_IID_STR "335c9292-91a1-4ca0-ad0b-07d5f63ed6cd"

#define SMILEIANNOTATIONS_IID \
  {0x335c9292, 0x91a1, 0x4ca0, \
    { 0xad, 0x0b, 0x07, 0xd5, 0xf6, 0x3e, 0xd6, 0xcd }}

/**
 * Interface representing a collection of annotations associated
 * with a bookmark or bookmark folder.
 */
class NS_NO_VTABLE NS_SCRIPTABLE smileIAnnotations : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(SMILEIANNOTATIONS_IID)

  /**
   * Array of the annotation names associated with the owning item
   */
  /* readonly attribute nsIVariant names; */
  NS_SCRIPTABLE NS_IMETHOD GetNames(nsIVariant **aNames) = 0;

  /**
   * Determines if an annotation exists with the given name.
   * @param   aName
   *          The name of the annotation
   * @returns true if an annotation exists with the given name,
   *          false otherwise.
   */
  /* boolean has (in AString aName); */
  NS_SCRIPTABLE NS_IMETHOD Has(const nsAString & aName, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Gets the value of an annotation with the given name.
   * @param   aName
   *          The name of the annotation
   * @returns A variant containing the value of the annotation. Supports
   *          string, boolean and number.
   */
  /* nsIVariant get (in AString aName); */
  NS_SCRIPTABLE NS_IMETHOD Get(const nsAString & aName, nsIVariant **_retval NS_OUTPARAM) = 0;

  /**
   * Sets the value of an annotation with the given name.
   * @param   aName
   *          The name of the annotation
   * @param   aValue
   *          The new value of the annotation. Supports string, boolean
   *          and number
   * @param   aExpiration
   *          The expiration policy for the annotation.
   *          See nsIAnnotationService.
   */
  /* void set (in AString aName, in nsIVariant aValue, in PRInt32 aExpiration); */
  NS_SCRIPTABLE NS_IMETHOD Set(const nsAString & aName, nsIVariant *aValue, PRInt32 aExpiration) = 0;

  /**
   * Removes the named annotation from the owner item.
   * @param   aName
   *          The name of annotation.
   */
  /* void remove (in AString aName); */
  NS_SCRIPTABLE NS_IMETHOD Remove(const nsAString & aName) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(smileIAnnotations, SMILEIANNOTATIONS_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_SMILEIANNOTATIONS \
  NS_SCRIPTABLE NS_IMETHOD GetNames(nsIVariant **aNames); \
  NS_SCRIPTABLE NS_IMETHOD Has(const nsAString & aName, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD Get(const nsAString & aName, nsIVariant **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD Set(const nsAString & aName, nsIVariant *aValue, PRInt32 aExpiration); \
  NS_SCRIPTABLE NS_IMETHOD Remove(const nsAString & aName); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_SMILEIANNOTATIONS(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetNames(nsIVariant **aNames) { return _to GetNames(aNames); } \
  NS_SCRIPTABLE NS_IMETHOD Has(const nsAString & aName, PRBool *_retval NS_OUTPARAM) { return _to Has(aName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Get(const nsAString & aName, nsIVariant **_retval NS_OUTPARAM) { return _to Get(aName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Set(const nsAString & aName, nsIVariant *aValue, PRInt32 aExpiration) { return _to Set(aName, aValue, aExpiration); } \
  NS_SCRIPTABLE NS_IMETHOD Remove(const nsAString & aName) { return _to Remove(aName); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_SMILEIANNOTATIONS(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetNames(nsIVariant **aNames) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNames(aNames); } \
  NS_SCRIPTABLE NS_IMETHOD Has(const nsAString & aName, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->Has(aName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Get(const nsAString & aName, nsIVariant **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->Get(aName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Set(const nsAString & aName, nsIVariant *aValue, PRInt32 aExpiration) { return !_to ? NS_ERROR_NULL_POINTER : _to->Set(aName, aValue, aExpiration); } \
  NS_SCRIPTABLE NS_IMETHOD Remove(const nsAString & aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->Remove(aName); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public smileIAnnotations
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_SMILEIANNOTATIONS

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, smileIAnnotations)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* readonly attribute nsIVariant names; */
NS_IMETHODIMP _MYCLASS_::GetNames(nsIVariant **aNames)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean has (in AString aName); */
NS_IMETHODIMP _MYCLASS_::Has(const nsAString & aName, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIVariant get (in AString aName); */
NS_IMETHODIMP _MYCLASS_::Get(const nsAString & aName, nsIVariant **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void set (in AString aName, in nsIVariant aValue, in PRInt32 aExpiration); */
NS_IMETHODIMP _MYCLASS_::Set(const nsAString & aName, nsIVariant *aValue, PRInt32 aExpiration)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void remove (in AString aName); */
NS_IMETHODIMP _MYCLASS_::Remove(const nsAString & aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    smileIBookmark */
#define SMILEIBOOKMARK_IID_STR "a27f8945-9333-45d3-8ee1-24cbcb3366f9"

#define SMILEIBOOKMARK_IID \
  {0xa27f8945, 0x9333, 0x45d3, \
    { 0x8e, 0xe1, 0x24, 0xcb, 0xcb, 0x33, 0x66, 0xf9 }}

/**
 * Interface representing a bookmark item.
 */
class NS_NO_VTABLE NS_SCRIPTABLE smileIBookmark : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(SMILEIBOOKMARK_IID)

  /**
   * The id of the bookmark.
   */
  /* readonly attribute long long id; */
  NS_SCRIPTABLE NS_IMETHOD GetId(PRInt64 *aId) = 0;

  /**
   * The title of the bookmark.
   */
  /* attribute AString title; */
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle) = 0;

  /**
   * The uri of the bookmark.
   */
  /* attribute nsIURI uri; */
  NS_SCRIPTABLE NS_IMETHOD GetUri(nsIURI **aUri) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetUri(nsIURI *aUri) = 0;

  /**
   * The description of the bookmark.
   */
  /* attribute AString description; */
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription) = 0;

  /**
   * The keyword associated with the bookmark.
   */
  /* attribute AString keyword; */
  NS_SCRIPTABLE NS_IMETHOD GetKeyword(nsAString & aKeyword) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetKeyword(const nsAString & aKeyword) = 0;

  /**
   * The type of the bookmark.
   * values: "bookmark", "separator"
   */
  /* readonly attribute AString type; */
  NS_SCRIPTABLE NS_IMETHOD GetType(nsAString & aType) = 0;

  /**
   * The parent folder of the bookmark.
   */
  /* attribute smileIBookmarkFolder parent; */
  NS_SCRIPTABLE NS_IMETHOD GetParent(smileIBookmarkFolder **aParent) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetParent(smileIBookmarkFolder *aParent) = 0;

  /**
   * The annotations object for the bookmark.
   */
  /* readonly attribute smileIAnnotations annotations; */
  NS_SCRIPTABLE NS_IMETHOD GetAnnotations(smileIAnnotations **aAnnotations) = 0;

  /**
   * The events object for the bookmark.
   * supports: "remove", "change", "visit", "move"
   */
  /* readonly attribute extIEvents events; */
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) = 0;

  /**
   * Removes the item from the parent folder. Used to
   * delete a bookmark or separator
   */
  /* void remove (); */
  NS_SCRIPTABLE NS_IMETHOD Remove(void) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(smileIBookmark, SMILEIBOOKMARK_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_SMILEIBOOKMARK \
  NS_SCRIPTABLE NS_IMETHOD GetId(PRInt64 *aId); \
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle); \
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle); \
  NS_SCRIPTABLE NS_IMETHOD GetUri(nsIURI **aUri); \
  NS_SCRIPTABLE NS_IMETHOD SetUri(nsIURI *aUri); \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription); \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription); \
  NS_SCRIPTABLE NS_IMETHOD GetKeyword(nsAString & aKeyword); \
  NS_SCRIPTABLE NS_IMETHOD SetKeyword(const nsAString & aKeyword); \
  NS_SCRIPTABLE NS_IMETHOD GetType(nsAString & aType); \
  NS_SCRIPTABLE NS_IMETHOD GetParent(smileIBookmarkFolder **aParent); \
  NS_SCRIPTABLE NS_IMETHOD SetParent(smileIBookmarkFolder *aParent); \
  NS_SCRIPTABLE NS_IMETHOD GetAnnotations(smileIAnnotations **aAnnotations); \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents); \
  NS_SCRIPTABLE NS_IMETHOD Remove(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_SMILEIBOOKMARK(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetId(PRInt64 *aId) { return _to GetId(aId); } \
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle) { return _to GetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle) { return _to SetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD GetUri(nsIURI **aUri) { return _to GetUri(aUri); } \
  NS_SCRIPTABLE NS_IMETHOD SetUri(nsIURI *aUri) { return _to SetUri(aUri); } \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription) { return _to GetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription) { return _to SetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD GetKeyword(nsAString & aKeyword) { return _to GetKeyword(aKeyword); } \
  NS_SCRIPTABLE NS_IMETHOD SetKeyword(const nsAString & aKeyword) { return _to SetKeyword(aKeyword); } \
  NS_SCRIPTABLE NS_IMETHOD GetType(nsAString & aType) { return _to GetType(aType); } \
  NS_SCRIPTABLE NS_IMETHOD GetParent(smileIBookmarkFolder **aParent) { return _to GetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD SetParent(smileIBookmarkFolder *aParent) { return _to SetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD GetAnnotations(smileIAnnotations **aAnnotations) { return _to GetAnnotations(aAnnotations); } \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) { return _to GetEvents(aEvents); } \
  NS_SCRIPTABLE NS_IMETHOD Remove(void) { return _to Remove(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_SMILEIBOOKMARK(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetId(PRInt64 *aId) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetId(aId); } \
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD GetUri(nsIURI **aUri) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUri(aUri); } \
  NS_SCRIPTABLE NS_IMETHOD SetUri(nsIURI *aUri) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUri(aUri); } \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD GetKeyword(nsAString & aKeyword) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetKeyword(aKeyword); } \
  NS_SCRIPTABLE NS_IMETHOD SetKeyword(const nsAString & aKeyword) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetKeyword(aKeyword); } \
  NS_SCRIPTABLE NS_IMETHOD GetType(nsAString & aType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetType(aType); } \
  NS_SCRIPTABLE NS_IMETHOD GetParent(smileIBookmarkFolder **aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD SetParent(smileIBookmarkFolder *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD GetAnnotations(smileIAnnotations **aAnnotations) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAnnotations(aAnnotations); } \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEvents(aEvents); } \
  NS_SCRIPTABLE NS_IMETHOD Remove(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Remove(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public smileIBookmark
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_SMILEIBOOKMARK

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, smileIBookmark)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* readonly attribute long long id; */
NS_IMETHODIMP _MYCLASS_::GetId(PRInt64 *aId)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString title; */
NS_IMETHODIMP _MYCLASS_::GetTitle(nsAString & aTitle)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetTitle(const nsAString & aTitle)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIURI uri; */
NS_IMETHODIMP _MYCLASS_::GetUri(nsIURI **aUri)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetUri(nsIURI *aUri)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString description; */
NS_IMETHODIMP _MYCLASS_::GetDescription(nsAString & aDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetDescription(const nsAString & aDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString keyword; */
NS_IMETHODIMP _MYCLASS_::GetKeyword(nsAString & aKeyword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetKeyword(const nsAString & aKeyword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString type; */
NS_IMETHODIMP _MYCLASS_::GetType(nsAString & aType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute smileIBookmarkFolder parent; */
NS_IMETHODIMP _MYCLASS_::GetParent(smileIBookmarkFolder **aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetParent(smileIBookmarkFolder *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute smileIAnnotations annotations; */
NS_IMETHODIMP _MYCLASS_::GetAnnotations(smileIAnnotations **aAnnotations)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute extIEvents events; */
NS_IMETHODIMP _MYCLASS_::GetEvents(extIEvents **aEvents)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void remove (); */
NS_IMETHODIMP _MYCLASS_::Remove()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    smileIBookmarkFolder */
#define SMILEIBOOKMARKFOLDER_IID_STR "03227226-d6eb-4654-9578-710c2222eb81"

#define SMILEIBOOKMARKFOLDER_IID \
  {0x03227226, 0xd6eb, 0x4654, \
    { 0x95, 0x78, 0x71, 0x0c, 0x22, 0x22, 0xeb, 0x81 }}

class NS_NO_VTABLE NS_SCRIPTABLE smileIBookmarkFolder : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(SMILEIBOOKMARKFOLDER_IID)

  /**
 * Interface representing a bookmark folder. Folders
 * can hold bookmarks, separators and other folders.
 */
/**
   * The id of the folder.
   */
  /* readonly attribute long long id; */
  NS_SCRIPTABLE NS_IMETHOD GetId(PRInt64 *aId) = 0;

  /**
   * The title of the folder.
   */
  /* attribute AString title; */
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle) = 0;

  /**
   * The description of the folder.
   */
  /* attribute AString description; */
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription) = 0;

  /**
   * The type of the folder.
   * values: "folder"
   */
  /* readonly attribute AString type; */
  NS_SCRIPTABLE NS_IMETHOD GetType(nsAString & aType) = 0;

  /**
   * The parent folder of the folder.
   */
  /* attribute smileIBookmarkFolder parent; */
  NS_SCRIPTABLE NS_IMETHOD GetParent(smileIBookmarkFolder **aParent) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetParent(smileIBookmarkFolder *aParent) = 0;

  /**
   * The annotations object for the folder.
   */
  /* readonly attribute smileIAnnotations annotations; */
  NS_SCRIPTABLE NS_IMETHOD GetAnnotations(smileIAnnotations **aAnnotations) = 0;

  /**
   * The events object for the folder.
   * supports: "add", "addchild", "remove", "removechild", "change", "move"
   */
  /* readonly attribute extIEvents events; */
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) = 0;

  /**
   * Array of all bookmarks, separators and folders contained
   * in this folder.
   */
  /* readonly attribute nsIVariant children; */
  NS_SCRIPTABLE NS_IMETHOD GetChildren(nsIVariant **aChildren) = 0;

  /**
   * Adds a new child bookmark to this folder.
   * @param   aTitle
   *          The title of bookmark.
   * @param   aURI
   *          The uri of bookmark.
   */
  /* smileIBookmark addBookmark (in AString aTitle, in nsIURI aURI); */
  NS_SCRIPTABLE NS_IMETHOD AddBookmark(const nsAString & aTitle, nsIURI *aURI, smileIBookmark **_retval NS_OUTPARAM) = 0;

  /**
   * Adds a new child separator to this folder.
   */
  /* smileIBookmark addSeparator (); */
  NS_SCRIPTABLE NS_IMETHOD AddSeparator(smileIBookmark **_retval NS_OUTPARAM) = 0;

  /**
   * Adds a new child folder to this folder.
   * @param   aTitle
   *          The title of folder.
   */
  /* smileIBookmarkFolder addFolder (in AString aTitle); */
  NS_SCRIPTABLE NS_IMETHOD AddFolder(const nsAString & aTitle, smileIBookmarkFolder **_retval NS_OUTPARAM) = 0;

  /**
   * Removes the folder from the parent folder.
   */
  /* void remove (); */
  NS_SCRIPTABLE NS_IMETHOD Remove(void) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(smileIBookmarkFolder, SMILEIBOOKMARKFOLDER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_SMILEIBOOKMARKFOLDER \
  NS_SCRIPTABLE NS_IMETHOD GetId(PRInt64 *aId); \
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle); \
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle); \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription); \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription); \
  NS_SCRIPTABLE NS_IMETHOD GetType(nsAString & aType); \
  NS_SCRIPTABLE NS_IMETHOD GetParent(smileIBookmarkFolder **aParent); \
  NS_SCRIPTABLE NS_IMETHOD SetParent(smileIBookmarkFolder *aParent); \
  NS_SCRIPTABLE NS_IMETHOD GetAnnotations(smileIAnnotations **aAnnotations); \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents); \
  NS_SCRIPTABLE NS_IMETHOD GetChildren(nsIVariant **aChildren); \
  NS_SCRIPTABLE NS_IMETHOD AddBookmark(const nsAString & aTitle, nsIURI *aURI, smileIBookmark **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddSeparator(smileIBookmark **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddFolder(const nsAString & aTitle, smileIBookmarkFolder **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD Remove(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_SMILEIBOOKMARKFOLDER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetId(PRInt64 *aId) { return _to GetId(aId); } \
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle) { return _to GetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle) { return _to SetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription) { return _to GetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription) { return _to SetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD GetType(nsAString & aType) { return _to GetType(aType); } \
  NS_SCRIPTABLE NS_IMETHOD GetParent(smileIBookmarkFolder **aParent) { return _to GetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD SetParent(smileIBookmarkFolder *aParent) { return _to SetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD GetAnnotations(smileIAnnotations **aAnnotations) { return _to GetAnnotations(aAnnotations); } \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) { return _to GetEvents(aEvents); } \
  NS_SCRIPTABLE NS_IMETHOD GetChildren(nsIVariant **aChildren) { return _to GetChildren(aChildren); } \
  NS_SCRIPTABLE NS_IMETHOD AddBookmark(const nsAString & aTitle, nsIURI *aURI, smileIBookmark **_retval NS_OUTPARAM) { return _to AddBookmark(aTitle, aURI, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddSeparator(smileIBookmark **_retval NS_OUTPARAM) { return _to AddSeparator(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddFolder(const nsAString & aTitle, smileIBookmarkFolder **_retval NS_OUTPARAM) { return _to AddFolder(aTitle, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Remove(void) { return _to Remove(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_SMILEIBOOKMARKFOLDER(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetId(PRInt64 *aId) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetId(aId); } \
  NS_SCRIPTABLE NS_IMETHOD GetTitle(nsAString & aTitle) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD SetTitle(const nsAString & aTitle) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTitle(aTitle); } \
  NS_SCRIPTABLE NS_IMETHOD GetDescription(nsAString & aDescription) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD SetDescription(const nsAString & aDescription) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDescription(aDescription); } \
  NS_SCRIPTABLE NS_IMETHOD GetType(nsAString & aType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetType(aType); } \
  NS_SCRIPTABLE NS_IMETHOD GetParent(smileIBookmarkFolder **aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD SetParent(smileIBookmarkFolder *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetParent(aParent); } \
  NS_SCRIPTABLE NS_IMETHOD GetAnnotations(smileIAnnotations **aAnnotations) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAnnotations(aAnnotations); } \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEvents(aEvents); } \
  NS_SCRIPTABLE NS_IMETHOD GetChildren(nsIVariant **aChildren) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildren(aChildren); } \
  NS_SCRIPTABLE NS_IMETHOD AddBookmark(const nsAString & aTitle, nsIURI *aURI, smileIBookmark **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddBookmark(aTitle, aURI, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddSeparator(smileIBookmark **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddSeparator(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD AddFolder(const nsAString & aTitle, smileIBookmarkFolder **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddFolder(aTitle, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD Remove(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Remove(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public smileIBookmarkFolder
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_SMILEIBOOKMARKFOLDER

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, smileIBookmarkFolder)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* readonly attribute long long id; */
NS_IMETHODIMP _MYCLASS_::GetId(PRInt64 *aId)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString title; */
NS_IMETHODIMP _MYCLASS_::GetTitle(nsAString & aTitle)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetTitle(const nsAString & aTitle)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString description; */
NS_IMETHODIMP _MYCLASS_::GetDescription(nsAString & aDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetDescription(const nsAString & aDescription)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AString type; */
NS_IMETHODIMP _MYCLASS_::GetType(nsAString & aType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute smileIBookmarkFolder parent; */
NS_IMETHODIMP _MYCLASS_::GetParent(smileIBookmarkFolder **aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetParent(smileIBookmarkFolder *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute smileIAnnotations annotations; */
NS_IMETHODIMP _MYCLASS_::GetAnnotations(smileIAnnotations **aAnnotations)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute extIEvents events; */
NS_IMETHODIMP _MYCLASS_::GetEvents(extIEvents **aEvents)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIVariant children; */
NS_IMETHODIMP _MYCLASS_::GetChildren(nsIVariant **aChildren)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* smileIBookmark addBookmark (in AString aTitle, in nsIURI aURI); */
NS_IMETHODIMP _MYCLASS_::AddBookmark(const nsAString & aTitle, nsIURI *aURI, smileIBookmark **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* smileIBookmark addSeparator (); */
NS_IMETHODIMP _MYCLASS_::AddSeparator(smileIBookmark **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* smileIBookmarkFolder addFolder (in AString aTitle); */
NS_IMETHODIMP _MYCLASS_::AddFolder(const nsAString & aTitle, smileIBookmarkFolder **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void remove (); */
NS_IMETHODIMP _MYCLASS_::Remove()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    smileIBookmarkRoots */
#define SMILEIBOOKMARKROOTS_IID_STR "1102eec4-f66b-4082-abad-c967ad7d5f76"

#define SMILEIBOOKMARKROOTS_IID \
  {0x1102eec4, 0xf66b, 0x4082, \
    { 0xab, 0xad, 0xc9, 0x67, 0xad, 0x7d, 0x5f, 0x76 }}

/**
 * Interface representing a container for bookmark roots. Roots
 * are the top level parents for the various types of bookmarks in the system.
 */
class NS_NO_VTABLE NS_SCRIPTABLE smileIBookmarkRoots : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(SMILEIBOOKMARKROOTS_IID)

  /**
   * The folder for the 'bookmarks menu' root.
   */
  /* readonly attribute smileIBookmarkFolder menu; */
  NS_SCRIPTABLE NS_IMETHOD GetMenu(smileIBookmarkFolder **aMenu) = 0;

  /**
   * The folder for the 'personal toolbar' root.
   */
  /* readonly attribute smileIBookmarkFolder toolbar; */
  NS_SCRIPTABLE NS_IMETHOD GetToolbar(smileIBookmarkFolder **aToolbar) = 0;

  /**
   * The folder for the 'tags' root.
   */
  /* readonly attribute smileIBookmarkFolder tags; */
  NS_SCRIPTABLE NS_IMETHOD GetTags(smileIBookmarkFolder **aTags) = 0;

  /**
   * The folder for the 'unfiled bookmarks' root.
   */
  /* readonly attribute smileIBookmarkFolder unfiled; */
  NS_SCRIPTABLE NS_IMETHOD GetUnfiled(smileIBookmarkFolder **aUnfiled) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(smileIBookmarkRoots, SMILEIBOOKMARKROOTS_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_SMILEIBOOKMARKROOTS \
  NS_SCRIPTABLE NS_IMETHOD GetMenu(smileIBookmarkFolder **aMenu); \
  NS_SCRIPTABLE NS_IMETHOD GetToolbar(smileIBookmarkFolder **aToolbar); \
  NS_SCRIPTABLE NS_IMETHOD GetTags(smileIBookmarkFolder **aTags); \
  NS_SCRIPTABLE NS_IMETHOD GetUnfiled(smileIBookmarkFolder **aUnfiled); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_SMILEIBOOKMARKROOTS(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetMenu(smileIBookmarkFolder **aMenu) { return _to GetMenu(aMenu); } \
  NS_SCRIPTABLE NS_IMETHOD GetToolbar(smileIBookmarkFolder **aToolbar) { return _to GetToolbar(aToolbar); } \
  NS_SCRIPTABLE NS_IMETHOD GetTags(smileIBookmarkFolder **aTags) { return _to GetTags(aTags); } \
  NS_SCRIPTABLE NS_IMETHOD GetUnfiled(smileIBookmarkFolder **aUnfiled) { return _to GetUnfiled(aUnfiled); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_SMILEIBOOKMARKROOTS(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetMenu(smileIBookmarkFolder **aMenu) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMenu(aMenu); } \
  NS_SCRIPTABLE NS_IMETHOD GetToolbar(smileIBookmarkFolder **aToolbar) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetToolbar(aToolbar); } \
  NS_SCRIPTABLE NS_IMETHOD GetTags(smileIBookmarkFolder **aTags) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTags(aTags); } \
  NS_SCRIPTABLE NS_IMETHOD GetUnfiled(smileIBookmarkFolder **aUnfiled) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUnfiled(aUnfiled); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public smileIBookmarkRoots
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_SMILEIBOOKMARKROOTS

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, smileIBookmarkRoots)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* readonly attribute smileIBookmarkFolder menu; */
NS_IMETHODIMP _MYCLASS_::GetMenu(smileIBookmarkFolder **aMenu)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute smileIBookmarkFolder toolbar; */
NS_IMETHODIMP _MYCLASS_::GetToolbar(smileIBookmarkFolder **aToolbar)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute smileIBookmarkFolder tags; */
NS_IMETHODIMP _MYCLASS_::GetTags(smileIBookmarkFolder **aTags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute smileIBookmarkFolder unfiled; */
NS_IMETHODIMP _MYCLASS_::GetUnfiled(smileIBookmarkFolder **aUnfiled)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    smileIWindow */
#define SMILEIWINDOW_IID_STR "1c3002ec-5aaf-4232-ab7d-835a348133fd"

#define SMILEIWINDOW_IID \
  {0x1c3002ec, 0x5aaf, 0x4232, \
    { 0xab, 0x7d, 0x83, 0x5a, 0x34, 0x81, 0x33, 0xfd }}

/**
 * Interface representing a browser window.
 */
class NS_NO_VTABLE NS_SCRIPTABLE smileIWindow : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(SMILEIWINDOW_IID)

  /**
   * A collection of browser tabs within the browser window.
   */
  /* readonly attribute nsIVariant tabs; */
  NS_SCRIPTABLE NS_IMETHOD GetTabs(nsIVariant **aTabs) = 0;

  /**
   * The currently-active tab within the browser window.
   */
  /* readonly attribute smileIBrowserTab activeTab; */
  NS_SCRIPTABLE NS_IMETHOD GetActiveTab(smileIBrowserTab **aActiveTab) = 0;

  /**
   * Open a new browser tab, pointing to the specified URI.
   * @param   aURI
   *          The uri to open the browser tab to
   */
  /* smileIBrowserTab open (in nsIURI aURI); */
  NS_SCRIPTABLE NS_IMETHOD Open(nsIURI *aURI, smileIBrowserTab **_retval NS_OUTPARAM) = 0;

  /**
   * The events object for the browser window.
   * supports: "TabOpen", "TabClose", "TabMove", "TabSelect"
   */
  /* readonly attribute extIEvents events; */
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(smileIWindow, SMILEIWINDOW_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_SMILEIWINDOW \
  NS_SCRIPTABLE NS_IMETHOD GetTabs(nsIVariant **aTabs); \
  NS_SCRIPTABLE NS_IMETHOD GetActiveTab(smileIBrowserTab **aActiveTab); \
  NS_SCRIPTABLE NS_IMETHOD Open(nsIURI *aURI, smileIBrowserTab **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_SMILEIWINDOW(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetTabs(nsIVariant **aTabs) { return _to GetTabs(aTabs); } \
  NS_SCRIPTABLE NS_IMETHOD GetActiveTab(smileIBrowserTab **aActiveTab) { return _to GetActiveTab(aActiveTab); } \
  NS_SCRIPTABLE NS_IMETHOD Open(nsIURI *aURI, smileIBrowserTab **_retval NS_OUTPARAM) { return _to Open(aURI, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) { return _to GetEvents(aEvents); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_SMILEIWINDOW(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetTabs(nsIVariant **aTabs) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTabs(aTabs); } \
  NS_SCRIPTABLE NS_IMETHOD GetActiveTab(smileIBrowserTab **aActiveTab) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetActiveTab(aActiveTab); } \
  NS_SCRIPTABLE NS_IMETHOD Open(nsIURI *aURI, smileIBrowserTab **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->Open(aURI, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEvents(aEvents); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public smileIWindow
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_SMILEIWINDOW

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, smileIWindow)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* readonly attribute nsIVariant tabs; */
NS_IMETHODIMP _MYCLASS_::GetTabs(nsIVariant **aTabs)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute smileIBrowserTab activeTab; */
NS_IMETHODIMP _MYCLASS_::GetActiveTab(smileIBrowserTab **aActiveTab)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* smileIBrowserTab open (in nsIURI aURI); */
NS_IMETHODIMP _MYCLASS_::Open(nsIURI *aURI, smileIBrowserTab **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute extIEvents events; */
NS_IMETHODIMP _MYCLASS_::GetEvents(extIEvents **aEvents)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    smileIBrowserTab */
#define SMILEIBROWSERTAB_IID_STR "9b06c55e-5377-4c71-8bda-8e8750c5a02a"

#define SMILEIBROWSERTAB_IID \
  {0x9b06c55e, 0x5377, 0x4c71, \
    { 0x8b, 0xda, 0x8e, 0x87, 0x50, 0xc5, 0xa0, 0x2a }}

class NS_NO_VTABLE NS_SCRIPTABLE smileIBrowserTab : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(SMILEIBROWSERTAB_IID)

  /**
 * Interface representing a browser tab.
 */
/**
   * The current uri of this tab.
   */
  /* readonly attribute nsIURI uri; */
  NS_SCRIPTABLE NS_IMETHOD GetUri(nsIURI **aUri) = 0;

  /**
   * The current index of this tab in the browser window.
   */
  /* readonly attribute PRInt32 index; */
  NS_SCRIPTABLE NS_IMETHOD GetIndex(PRInt32 *aIndex) = 0;

  /**
   * The browser window that is holding the tab.
   */
  /* readonly attribute smileIWindow window; */
  NS_SCRIPTABLE NS_IMETHOD GetWindow(smileIWindow **aWindow) = 0;

  /**
   * The content document of the browser tab.
   */
  /* readonly attribute nsIDOMHTMLDocument document; */
  NS_SCRIPTABLE NS_IMETHOD GetDocument(nsIDOMHTMLDocument **aDocument) = 0;

  /**
   * The events object for the browser tab.
   * supports: "load"
   */
  /* readonly attribute extIEvents events; */
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) = 0;

  /**
   * Load a new URI into this browser tab.
   * @param   aURI
   *          The uri to load into the browser tab
   */
  /* void load (in nsIURI aURI); */
  NS_SCRIPTABLE NS_IMETHOD Load(nsIURI *aURI) = 0;

  /**
   * Give focus to this browser tab, and bring it to the front.
   */
  /* void focus (); */
  NS_SCRIPTABLE NS_IMETHOD Focus(void) = 0;

  /**
   * Close the browser tab. This may not actually close the tab
   * as script may abort the close operation.
   */
  /* void close (); */
  NS_SCRIPTABLE NS_IMETHOD Close(void) = 0;

  /**
   * Moves this browser tab before another browser tab within the window.
   * @param   aBefore
   *          The tab before which the target tab will be moved
   */
  /* void moveBefore (in smileIBrowserTab aBefore); */
  NS_SCRIPTABLE NS_IMETHOD MoveBefore(smileIBrowserTab *aBefore) = 0;

  /**
   * Move this browser tab to the last tab within the window.
   */
  /* void moveToEnd (); */
  NS_SCRIPTABLE NS_IMETHOD MoveToEnd(void) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(smileIBrowserTab, SMILEIBROWSERTAB_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_SMILEIBROWSERTAB \
  NS_SCRIPTABLE NS_IMETHOD GetUri(nsIURI **aUri); \
  NS_SCRIPTABLE NS_IMETHOD GetIndex(PRInt32 *aIndex); \
  NS_SCRIPTABLE NS_IMETHOD GetWindow(smileIWindow **aWindow); \
  NS_SCRIPTABLE NS_IMETHOD GetDocument(nsIDOMHTMLDocument **aDocument); \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents); \
  NS_SCRIPTABLE NS_IMETHOD Load(nsIURI *aURI); \
  NS_SCRIPTABLE NS_IMETHOD Focus(void); \
  NS_SCRIPTABLE NS_IMETHOD Close(void); \
  NS_SCRIPTABLE NS_IMETHOD MoveBefore(smileIBrowserTab *aBefore); \
  NS_SCRIPTABLE NS_IMETHOD MoveToEnd(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_SMILEIBROWSERTAB(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetUri(nsIURI **aUri) { return _to GetUri(aUri); } \
  NS_SCRIPTABLE NS_IMETHOD GetIndex(PRInt32 *aIndex) { return _to GetIndex(aIndex); } \
  NS_SCRIPTABLE NS_IMETHOD GetWindow(smileIWindow **aWindow) { return _to GetWindow(aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD GetDocument(nsIDOMHTMLDocument **aDocument) { return _to GetDocument(aDocument); } \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) { return _to GetEvents(aEvents); } \
  NS_SCRIPTABLE NS_IMETHOD Load(nsIURI *aURI) { return _to Load(aURI); } \
  NS_SCRIPTABLE NS_IMETHOD Focus(void) { return _to Focus(); } \
  NS_SCRIPTABLE NS_IMETHOD Close(void) { return _to Close(); } \
  NS_SCRIPTABLE NS_IMETHOD MoveBefore(smileIBrowserTab *aBefore) { return _to MoveBefore(aBefore); } \
  NS_SCRIPTABLE NS_IMETHOD MoveToEnd(void) { return _to MoveToEnd(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_SMILEIBROWSERTAB(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetUri(nsIURI **aUri) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUri(aUri); } \
  NS_SCRIPTABLE NS_IMETHOD GetIndex(PRInt32 *aIndex) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIndex(aIndex); } \
  NS_SCRIPTABLE NS_IMETHOD GetWindow(smileIWindow **aWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetWindow(aWindow); } \
  NS_SCRIPTABLE NS_IMETHOD GetDocument(nsIDOMHTMLDocument **aDocument) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocument(aDocument); } \
  NS_SCRIPTABLE NS_IMETHOD GetEvents(extIEvents **aEvents) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEvents(aEvents); } \
  NS_SCRIPTABLE NS_IMETHOD Load(nsIURI *aURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->Load(aURI); } \
  NS_SCRIPTABLE NS_IMETHOD Focus(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Focus(); } \
  NS_SCRIPTABLE NS_IMETHOD Close(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Close(); } \
  NS_SCRIPTABLE NS_IMETHOD MoveBefore(smileIBrowserTab *aBefore) { return !_to ? NS_ERROR_NULL_POINTER : _to->MoveBefore(aBefore); } \
  NS_SCRIPTABLE NS_IMETHOD MoveToEnd(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->MoveToEnd(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public smileIBrowserTab
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_SMILEIBROWSERTAB

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, smileIBrowserTab)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* readonly attribute nsIURI uri; */
NS_IMETHODIMP _MYCLASS_::GetUri(nsIURI **aUri)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute PRInt32 index; */
NS_IMETHODIMP _MYCLASS_::GetIndex(PRInt32 *aIndex)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute smileIWindow window; */
NS_IMETHODIMP _MYCLASS_::GetWindow(smileIWindow **aWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMHTMLDocument document; */
NS_IMETHODIMP _MYCLASS_::GetDocument(nsIDOMHTMLDocument **aDocument)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute extIEvents events; */
NS_IMETHODIMP _MYCLASS_::GetEvents(extIEvents **aEvents)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void load (in nsIURI aURI); */
NS_IMETHODIMP _MYCLASS_::Load(nsIURI *aURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void focus (); */
NS_IMETHODIMP _MYCLASS_::Focus()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void close (); */
NS_IMETHODIMP _MYCLASS_::Close()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void moveBefore (in smileIBrowserTab aBefore); */
NS_IMETHODIMP _MYCLASS_::MoveBefore(smileIBrowserTab *aBefore)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void moveToEnd (); */
NS_IMETHODIMP _MYCLASS_::MoveToEnd()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    smileIApplication */
#define SMILEIAPPLICATION_IID_STR "bedc9ea5-5673-44c7-a0af-49f1d37a2ca1"

#define SMILEIAPPLICATION_IID \
  {0xbedc9ea5, 0x5673, 0x44c7, \
    { 0xa0, 0xaf, 0x49, 0xf1, 0xd3, 0x7a, 0x2c, 0xa1 }}

/**
 * Interface for managing and accessing the applications systems
 */
class NS_NO_VTABLE NS_SCRIPTABLE smileIApplication : public extIApplication {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(SMILEIAPPLICATION_IID)

  /**
   * The root bookmarks object for the application.
   * Contains all the bookmark roots in the system.
   */
  /* readonly attribute smileIBookmarkRoots bookmarks; */
  NS_SCRIPTABLE NS_IMETHOD GetBookmarks(smileIBookmarkRoots **aBookmarks) = 0;

  /**
   * An array of browser windows within the application.
   */
  /* readonly attribute nsIVariant windows; */
  NS_SCRIPTABLE NS_IMETHOD GetWindows(nsIVariant **aWindows) = 0;

  /**
   * The currently active browser window.
   */
  /* readonly attribute smileIWindow activeWindow; */
  NS_SCRIPTABLE NS_IMETHOD GetActiveWindow(smileIWindow **aActiveWindow) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(smileIApplication, SMILEIAPPLICATION_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_SMILEIAPPLICATION \
  NS_SCRIPTABLE NS_IMETHOD GetBookmarks(smileIBookmarkRoots **aBookmarks); \
  NS_SCRIPTABLE NS_IMETHOD GetWindows(nsIVariant **aWindows); \
  NS_SCRIPTABLE NS_IMETHOD GetActiveWindow(smileIWindow **aActiveWindow); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_SMILEIAPPLICATION(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetBookmarks(smileIBookmarkRoots **aBookmarks) { return _to GetBookmarks(aBookmarks); } \
  NS_SCRIPTABLE NS_IMETHOD GetWindows(nsIVariant **aWindows) { return _to GetWindows(aWindows); } \
  NS_SCRIPTABLE NS_IMETHOD GetActiveWindow(smileIWindow **aActiveWindow) { return _to GetActiveWindow(aActiveWindow); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_SMILEIAPPLICATION(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetBookmarks(smileIBookmarkRoots **aBookmarks) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBookmarks(aBookmarks); } \
  NS_SCRIPTABLE NS_IMETHOD GetWindows(nsIVariant **aWindows) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetWindows(aWindows); } \
  NS_SCRIPTABLE NS_IMETHOD GetActiveWindow(smileIWindow **aActiveWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetActiveWindow(aActiveWindow); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public smileIApplication
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_SMILEIAPPLICATION

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, smileIApplication)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* readonly attribute smileIBookmarkRoots bookmarks; */
NS_IMETHODIMP _MYCLASS_::GetBookmarks(smileIBookmarkRoots **aBookmarks)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIVariant windows; */
NS_IMETHODIMP _MYCLASS_::GetWindows(nsIVariant **aWindows)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute smileIWindow activeWindow; */
NS_IMETHODIMP _MYCLASS_::GetActiveWindow(smileIWindow **aActiveWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_smileIApplication_h__ */
