/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Based in part on code from sash, Copyright (c) 1999 by David I. Bell 
 * Permission has been granted to redistribute this code under the GPL.
 *
 */
#ifndef	_INTERNAL_H_
#define	_INTERNAL_H_

#include "Config.h"
#include <stdlib.h>
#include "libbb.h"

#define BB_BANNER "Tinylogin v" CONFIG_VER " (" CONFIG_BT ")"


/* Some useful definitions */
#define FALSE   ((int) 0)
#define TRUE    ((int) 1)
#define MAYBE	((int) 2)
#define FAIL_DELAY 3
#define TIMEOUT 60

enum Location {
	_BB_DIR_ROOT = 0,
	_BB_DIR_BIN,
	_BB_DIR_SBIN,
	_BB_DIR_USR_BIN,
	_BB_DIR_USR_SBIN
};

enum SUIDRoot {
	_BB_SUID_NEVER = 0,
	_BB_SUID_MAYBE,
	_BB_SUID_ALWAYS
};

struct BB_applet {
	const	char*	name;
	int	(*main)(int argc, char** argv);
	enum	Location	location  : 4;
	enum 	SUIDRoot	need_suid : 4;
};
/* From busybox.c */
extern const struct BB_applet applets[];

/* Automagically pull in all the applet function prototypes and
 * applet usage strings.  These are all of the form:
 *		extern int foo_main(int argc, char **argv);
 *		extern const char foo_usage[];
 * These are all autogenerated from the set of currently defined applets. 
 */
#define PROTOTYPES
#include "applets.h"
#undef PROTOTYPES
extern const char *applet_name;


/* Utility routines */
extern void usage(const char *usage) __attribute__ ((noreturn));
#if 0
extern void error_msg(const char *s, ...) __attribute__ ((format(printf, 1, 2)));
extern void error_msg_and_die(const char *s, ...) __attribute__ ((noreturn, format(printf, 1, 2)));
extern void perror_msg(const char *s, ...) __attribute__ ((format(printf, 1, 2)));
extern void perror_msg_and_die(const char *s, ...) __attribute__ ((noreturn, format(printf, 1, 2)));

extern char *pw_encrypt(const char *clear, const char *salt);
extern void addenv(const char *string, const char *value);
extern void *xmalloc(size_t size);
extern char *xstrdup(const char *s);
extern void initenv();
extern void set_env(int argc, char *const *argv);
extern void setup_env(struct passwd *info);
extern int update_passwd(const struct passwd *pw, char *crypt_pw);
#endif

extern int obscure(const char *old, const char *new, const struct passwd *pwdp);

#include <strings.h>


#endif							/* _INTERNAL_H_ */
