/*
 * Copyright (c) 2019-2022, Intel Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef SOCFPGA_RESETMANAGER_H
#define SOCFPGA_RESETMANAGER_H

#include "socfpga_plat_def.h"


/* Register Mapping */

#define SOCFPGA_RSTMGR_STAT			0x000
#define SOCFPGA_RSTMGR_HDSKEN			0x010
#define SOCFPGA_RSTMGR_MPUMODRST		0x020
#define SOCFPGA_RSTMGR_PER0MODRST		0x024
#define SOCFPGA_RSTMGR_PER1MODRST		0x028
#define SOCFPGA_RSTMGR_BRGMODRST		0x02c
#define SOCFPGA_RSTMGR_COLDMODRST		0x034
#define SOCFPGA_RSTMGR_HDSKTIMEOUT		0x064

/* Field Mapping */

#define RSTMGR_PER0MODRST_EMAC0			0x00000001
#define RSTMGR_PER0MODRST_EMAC1			0x00000002
#define RSTMGR_PER0MODRST_EMAC2			0x00000004
#define RSTMGR_PER0MODRST_USB0			0x00000008
#define RSTMGR_PER0MODRST_USB1			0x00000010
#define RSTMGR_PER0MODRST_NAND			0x00000020
#define RSTMGR_PER0MODRST_SDMMC			0x00000080
#define RSTMGR_PER0MODRST_EMAC0OCP		0x00000100
#define RSTMGR_PER0MODRST_EMAC1OCP		0x00000200
#define RSTMGR_PER0MODRST_EMAC2OCP		0x00000400
#define RSTMGR_PER0MODRST_USB0OCP		0x00000800
#define RSTMGR_PER0MODRST_USB1OCP		0x00001000
#define RSTMGR_PER0MODRST_NANDOCP		0x00002000
#define RSTMGR_PER0MODRST_SDMMCOCP		0x00008000
#define RSTMGR_PER0MODRST_DMA			0x00010000
#define RSTMGR_PER0MODRST_SPIM0			0x00020000
#define RSTMGR_PER0MODRST_SPIM1			0x00040000
#define RSTMGR_PER0MODRST_SPIS0			0x00080000
#define RSTMGR_PER0MODRST_SPIS1			0x00100000
#define RSTMGR_PER0MODRST_DMAOCP		0x00200000
#define RSTMGR_PER0MODRST_EMACPTP		0x00400000
#define RSTMGR_PER0MODRST_DMAIF0		0x01000000
#define RSTMGR_PER0MODRST_DMAIF1		0x02000000
#define RSTMGR_PER0MODRST_DMAIF2		0x04000000
#define RSTMGR_PER0MODRST_DMAIF3		0x08000000
#define RSTMGR_PER0MODRST_DMAIF4		0x10000000
#define RSTMGR_PER0MODRST_DMAIF5		0x20000000
#define RSTMGR_PER0MODRST_DMAIF6		0x40000000
#define RSTMGR_PER0MODRST_DMAIF7		0x80000000

#define RSTMGR_PER1MODRST_WATCHDOG0		0x00000001
#define RSTMGR_PER1MODRST_WATCHDOG1		0x00000002
#define RSTMGR_PER1MODRST_WATCHDOG2		0x00000004
#define RSTMGR_PER1MODRST_WATCHDOG3		0x00000008
#define RSTMGR_PER1MODRST_L4SYSTIMER0		0x00000010
#define RSTMGR_PER1MODRST_L4SYSTIMER1		0x00000020
#define RSTMGR_PER1MODRST_SPTIMER0		0x00000040
#define RSTMGR_PER1MODRST_SPTIMER1		0x00000080
#define RSTMGR_PER1MODRST_I2C0			0x00000100
#define RSTMGR_PER1MODRST_I2C1			0x00000200
#define RSTMGR_PER1MODRST_I2C2			0x00000400
#define RSTMGR_PER1MODRST_I2C3			0x00000800
#define RSTMGR_PER1MODRST_I2C4			0x00001000
#define RSTMGR_PER1MODRST_UART0			0x00010000
#define RSTMGR_PER1MODRST_UART1			0x00020000
#define RSTMGR_PER1MODRST_GPIO0			0x01000000
#define RSTMGR_PER1MODRST_GPIO1			0x02000000

#define RSTMGR_HDSKEN_FPGAHSEN			0x00000004
#define RSTMGR_HDSKEN_ETRSTALLEN		0x00000008
#define RSTMGR_HDSKEN_L2FLUSHEN			0x00000100
#define RSTMGR_HDSKEN_L3NOC_DBG			0x00010000
#define RSTMGR_HDSKEN_DEBUG_L3NOC		0x00020000
#define RSTMGR_HDSKEN_SDRSELFREFEN		0x00000001

#define RSTMGR_BRGMODRST_SOC2FPGA		0x1
#define RSTMGR_BRGMODRST_LWHPS2FPGA		0x2
#define RSTMGR_BRGMODRST_FPGA2SOC		0x4
#define RSTMGR_BRGMODRST_F2SSDRAM1		0x10
#define RSTMGR_BRGMODRST_F2SSDRAM2		0x20
#define RSTMGR_BRGMODRST_MPFE			0x40
#define RSTMGR_BRGMODRST_DDRSCH			0x40

/* Definitions */

#define RSTMGR_L2_MODRST			0x0100
#define RSTMGR_HDSKEN_SET			0x010D

/* Macros */

#define SOCFPGA_RSTMGR(_reg)		(SOCFPGA_RSTMGR_REG_BASE \
						+ (SOCFPGA_RSTMGR_##_reg))
#define RSTMGR_FIELD(_reg, _field)	(RSTMGR_##_reg##MODRST_##_field)

/* Function Declarations */

void deassert_peripheral_reset(void);
void config_hps_hs_before_warm_reset(void);

int socfpga_bridges_enable(void);
int socfpga_bridges_disable(void);

#endif /* SOCFPGA_RESETMANAGER_H */
